/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A JSON object with the following properties:
 */
@JsonPropertyOrder({
  ExternalTaskQueryDto.JSON_PROPERTY_EXTERNAL_TASK_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_EXTERNAL_TASK_ID_IN,
  ExternalTaskQueryDto.JSON_PROPERTY_TOPIC_NAME,
  ExternalTaskQueryDto.JSON_PROPERTY_WORKER_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_LOCKED,
  ExternalTaskQueryDto.JSON_PROPERTY_NOT_LOCKED,
  ExternalTaskQueryDto.JSON_PROPERTY_WITH_RETRIES_LEFT,
  ExternalTaskQueryDto.JSON_PROPERTY_NO_RETRIES_LEFT,
  ExternalTaskQueryDto.JSON_PROPERTY_LOCK_EXPIRATION_AFTER,
  ExternalTaskQueryDto.JSON_PROPERTY_LOCK_EXPIRATION_BEFORE,
  ExternalTaskQueryDto.JSON_PROPERTY_ACTIVITY_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_ACTIVITY_ID_IN,
  ExternalTaskQueryDto.JSON_PROPERTY_EXECUTION_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID_IN,
  ExternalTaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ExternalTaskQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  ExternalTaskQueryDto.JSON_PROPERTY_ACTIVE,
  ExternalTaskQueryDto.JSON_PROPERTY_SUSPENDED,
  ExternalTaskQueryDto.JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS,
  ExternalTaskQueryDto.JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS,
  ExternalTaskQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ExternalTaskQueryDto {
  public static final String JSON_PROPERTY_EXTERNAL_TASK_ID = "externalTaskId";
  private JsonNullable<String> externalTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXTERNAL_TASK_ID_IN = "externalTaskIdIn";
  private JsonNullable<List<String>> externalTaskIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TOPIC_NAME = "topicName";
  private JsonNullable<String> topicName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private JsonNullable<String> workerId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LOCKED = "locked";
  private JsonNullable<Boolean> locked = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_NOT_LOCKED = "notLocked";
  private JsonNullable<Boolean> notLocked = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITH_RETRIES_LEFT = "withRetriesLeft";
  private JsonNullable<Boolean> withRetriesLeft = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_NO_RETRIES_LEFT = "noRetriesLeft";
  private JsonNullable<Boolean> noRetriesLeft = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_LOCK_EXPIRATION_AFTER = "lockExpirationAfter";
  private JsonNullable<OffsetDateTime> lockExpirationAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_LOCK_EXPIRATION_BEFORE = "lockExpirationBefore";
  private JsonNullable<OffsetDateTime> lockExpirationBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID_IN = "activityIdIn";
  private JsonNullable<List<String>> activityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
  private JsonNullable<List<String>> processInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
  private JsonNullable<Long> priorityHigherThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
  private JsonNullable<Long> priorityLowerThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<ExternalTaskQueryDtoSortingInner>> sorting = JsonNullable.<List<ExternalTaskQueryDtoSortingInner>>undefined();

  public ExternalTaskQueryDto() {
  }

  public ExternalTaskQueryDto externalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
    
    return this;
  }

   /**
   * Filter by an external task&#39;s id.
   * @return externalTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExternalTaskId() {
        return externalTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExternalTaskId_JsonNullable() {
    return externalTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  public void setExternalTaskId_JsonNullable(JsonNullable<String> externalTaskId) {
    this.externalTaskId = externalTaskId;
  }

  public void setExternalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
  }


  public ExternalTaskQueryDto externalTaskIdIn(List<String> externalTaskIdIn) {
    this.externalTaskIdIn = JsonNullable.<List<String>>of(externalTaskIdIn);
    
    return this;
  }

  public ExternalTaskQueryDto addExternalTaskIdInItem(String externalTaskIdInItem) {
    if (this.externalTaskIdIn == null || !this.externalTaskIdIn.isPresent()) {
      this.externalTaskIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.externalTaskIdIn.get().add(externalTaskIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by the comma-separated list of external task ids.
   * @return externalTaskIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getExternalTaskIdIn() {
        return externalTaskIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getExternalTaskIdIn_JsonNullable() {
    return externalTaskIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID_IN)
  public void setExternalTaskIdIn_JsonNullable(JsonNullable<List<String>> externalTaskIdIn) {
    this.externalTaskIdIn = externalTaskIdIn;
  }

  public void setExternalTaskIdIn(List<String> externalTaskIdIn) {
    this.externalTaskIdIn = JsonNullable.<List<String>>of(externalTaskIdIn);
  }


  public ExternalTaskQueryDto topicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
    
    return this;
  }

   /**
   * Filter by an external task topic.
   * @return topicName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTopicName() {
        return topicName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTopicName_JsonNullable() {
    return topicName;
  }
  
  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  public void setTopicName_JsonNullable(JsonNullable<String> topicName) {
    this.topicName = topicName;
  }

  public void setTopicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
  }


  public ExternalTaskQueryDto workerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
    
    return this;
  }

   /**
   * Filter by the id of the worker that the task was most recently locked by.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getWorkerId() {
        return workerId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getWorkerId_JsonNullable() {
    return workerId;
  }
  
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  public void setWorkerId_JsonNullable(JsonNullable<String> workerId) {
    this.workerId = workerId;
  }

  public void setWorkerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
  }


  public ExternalTaskQueryDto locked(Boolean locked) {
    this.locked = JsonNullable.<Boolean>of(locked);
    
    return this;
  }

   /**
   * Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return locked
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getLocked() {
        return locked.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getLocked_JsonNullable() {
    return locked;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCKED)
  public void setLocked_JsonNullable(JsonNullable<Boolean> locked) {
    this.locked = locked;
  }

  public void setLocked(Boolean locked) {
    this.locked = JsonNullable.<Boolean>of(locked);
  }


  public ExternalTaskQueryDto notLocked(Boolean notLocked) {
    this.notLocked = JsonNullable.<Boolean>of(notLocked);
    
    return this;
  }

   /**
   * Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return notLocked
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getNotLocked() {
        return notLocked.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NOT_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getNotLocked_JsonNullable() {
    return notLocked;
  }
  
  @JsonProperty(JSON_PROPERTY_NOT_LOCKED)
  public void setNotLocked_JsonNullable(JsonNullable<Boolean> notLocked) {
    this.notLocked = notLocked;
  }

  public void setNotLocked(Boolean notLocked) {
    this.notLocked = JsonNullable.<Boolean>of(notLocked);
  }


  public ExternalTaskQueryDto withRetriesLeft(Boolean withRetriesLeft) {
    this.withRetriesLeft = JsonNullable.<Boolean>of(withRetriesLeft);
    
    return this;
  }

   /**
   * Only include external tasks that have a positive (&amp;gt; 0) number of retries (or &#x60;null&#x60;). Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return withRetriesLeft
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithRetriesLeft() {
        return withRetriesLeft.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithRetriesLeft_JsonNullable() {
    return withRetriesLeft;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_RETRIES_LEFT)
  public void setWithRetriesLeft_JsonNullable(JsonNullable<Boolean> withRetriesLeft) {
    this.withRetriesLeft = withRetriesLeft;
  }

  public void setWithRetriesLeft(Boolean withRetriesLeft) {
    this.withRetriesLeft = JsonNullable.<Boolean>of(withRetriesLeft);
  }


  public ExternalTaskQueryDto noRetriesLeft(Boolean noRetriesLeft) {
    this.noRetriesLeft = JsonNullable.<Boolean>of(noRetriesLeft);
    
    return this;
  }

   /**
   * Only include external tasks that have 0 retries. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return noRetriesLeft
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getNoRetriesLeft() {
        return noRetriesLeft.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NO_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getNoRetriesLeft_JsonNullable() {
    return noRetriesLeft;
  }
  
  @JsonProperty(JSON_PROPERTY_NO_RETRIES_LEFT)
  public void setNoRetriesLeft_JsonNullable(JsonNullable<Boolean> noRetriesLeft) {
    this.noRetriesLeft = noRetriesLeft;
  }

  public void setNoRetriesLeft(Boolean noRetriesLeft) {
    this.noRetriesLeft = JsonNullable.<Boolean>of(noRetriesLeft);
  }


  public ExternalTaskQueryDto lockExpirationAfter(OffsetDateTime lockExpirationAfter) {
    this.lockExpirationAfter = JsonNullable.<OffsetDateTime>of(lockExpirationAfter);
    
    return this;
  }

   /**
   * Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return lockExpirationAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getLockExpirationAfter() {
        return lockExpirationAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getLockExpirationAfter_JsonNullable() {
    return lockExpirationAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_AFTER)
  public void setLockExpirationAfter_JsonNullable(JsonNullable<OffsetDateTime> lockExpirationAfter) {
    this.lockExpirationAfter = lockExpirationAfter;
  }

  public void setLockExpirationAfter(OffsetDateTime lockExpirationAfter) {
    this.lockExpirationAfter = JsonNullable.<OffsetDateTime>of(lockExpirationAfter);
  }


  public ExternalTaskQueryDto lockExpirationBefore(OffsetDateTime lockExpirationBefore) {
    this.lockExpirationBefore = JsonNullable.<OffsetDateTime>of(lockExpirationBefore);
    
    return this;
  }

   /**
   * Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return lockExpirationBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getLockExpirationBefore() {
        return lockExpirationBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getLockExpirationBefore_JsonNullable() {
    return lockExpirationBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_LOCK_EXPIRATION_BEFORE)
  public void setLockExpirationBefore_JsonNullable(JsonNullable<OffsetDateTime> lockExpirationBefore) {
    this.lockExpirationBefore = lockExpirationBefore;
  }

  public void setLockExpirationBefore(OffsetDateTime lockExpirationBefore) {
    this.lockExpirationBefore = JsonNullable.<OffsetDateTime>of(lockExpirationBefore);
  }


  public ExternalTaskQueryDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * Filter by the id of the activity that an external task is created for.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public ExternalTaskQueryDto activityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
    
    return this;
  }

  public ExternalTaskQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null || !this.activityIdIn.isPresent()) {
      this.activityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityIdIn.get().add(activityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by the comma-separated list of ids of the activities that an external task is created for.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityIdIn() {
        return activityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityIdIn_JsonNullable() {
    return activityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  public void setActivityIdIn_JsonNullable(JsonNullable<List<String>> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }

  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
  }


  public ExternalTaskQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Filter by the id of the execution that an external task belongs to.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public ExternalTaskQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by the id of the process instance that an external task belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public ExternalTaskQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
    
    return this;
  }

  public ExternalTaskQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
    if (this.processInstanceIdIn == null || !this.processInstanceIdIn.isPresent()) {
      this.processInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIdIn.get().add(processInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a comma-separated list of process instance ids that an external task may belong to.
   * @return processInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIdIn() {
        return processInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIdIn_JsonNullable() {
    return processInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  public void setProcessInstanceIdIn_JsonNullable(JsonNullable<List<String>> processInstanceIdIn) {
    this.processInstanceIdIn = processInstanceIdIn;
  }

  public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
  }


  public ExternalTaskQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by the id of the process definition that an external task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public ExternalTaskQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public ExternalTaskQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public ExternalTaskQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Only include active tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public ExternalTaskQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Only include suspended tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; matches any external task.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public ExternalTaskQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
    
    return this;
  }

   /**
   * Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityHigherThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityHigherThanOrEquals() {
        return priorityHigherThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityHigherThanOrEquals_JsonNullable() {
    return priorityHigherThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  public void setPriorityHigherThanOrEquals_JsonNullable(JsonNullable<Long> priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
  }

  public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
  }


  public ExternalTaskQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
    
    return this;
  }

   /**
   * Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityLowerThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityLowerThanOrEquals() {
        return priorityLowerThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityLowerThanOrEquals_JsonNullable() {
    return priorityLowerThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  public void setPriorityLowerThanOrEquals_JsonNullable(JsonNullable<Long> priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
  }

  public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
  }


  public ExternalTaskQueryDto sorting(List<ExternalTaskQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<ExternalTaskQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public ExternalTaskQueryDto addSortingItem(ExternalTaskQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<ExternalTaskQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of criteria to sort the result by. Each element of the array is a JSON object that                     specifies one ordering. The position in the array identifies the rank of an ordering, i.e., whether                     it is primary, secondary, etc. The ordering objects have the following properties:                      **Note:** The &#x60;sorting&#x60; properties will not be applied to the External Task count query.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<ExternalTaskQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<ExternalTaskQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<ExternalTaskQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<ExternalTaskQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<ExternalTaskQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExternalTaskQueryDto externalTaskQueryDto = (ExternalTaskQueryDto) o;
    return equalsNullable(this.externalTaskId, externalTaskQueryDto.externalTaskId) &&
        equalsNullable(this.externalTaskIdIn, externalTaskQueryDto.externalTaskIdIn) &&
        equalsNullable(this.topicName, externalTaskQueryDto.topicName) &&
        equalsNullable(this.workerId, externalTaskQueryDto.workerId) &&
        equalsNullable(this.locked, externalTaskQueryDto.locked) &&
        equalsNullable(this.notLocked, externalTaskQueryDto.notLocked) &&
        equalsNullable(this.withRetriesLeft, externalTaskQueryDto.withRetriesLeft) &&
        equalsNullable(this.noRetriesLeft, externalTaskQueryDto.noRetriesLeft) &&
        equalsNullable(this.lockExpirationAfter, externalTaskQueryDto.lockExpirationAfter) &&
        equalsNullable(this.lockExpirationBefore, externalTaskQueryDto.lockExpirationBefore) &&
        equalsNullable(this.activityId, externalTaskQueryDto.activityId) &&
        equalsNullable(this.activityIdIn, externalTaskQueryDto.activityIdIn) &&
        equalsNullable(this.executionId, externalTaskQueryDto.executionId) &&
        equalsNullable(this.processInstanceId, externalTaskQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIdIn, externalTaskQueryDto.processInstanceIdIn) &&
        equalsNullable(this.processDefinitionId, externalTaskQueryDto.processDefinitionId) &&
        equalsNullable(this.tenantIdIn, externalTaskQueryDto.tenantIdIn) &&
        equalsNullable(this.active, externalTaskQueryDto.active) &&
        equalsNullable(this.suspended, externalTaskQueryDto.suspended) &&
        equalsNullable(this.priorityHigherThanOrEquals, externalTaskQueryDto.priorityHigherThanOrEquals) &&
        equalsNullable(this.priorityLowerThanOrEquals, externalTaskQueryDto.priorityLowerThanOrEquals) &&
        equalsNullable(this.sorting, externalTaskQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(externalTaskId), hashCodeNullable(externalTaskIdIn), hashCodeNullable(topicName), hashCodeNullable(workerId), hashCodeNullable(locked), hashCodeNullable(notLocked), hashCodeNullable(withRetriesLeft), hashCodeNullable(noRetriesLeft), hashCodeNullable(lockExpirationAfter), hashCodeNullable(lockExpirationBefore), hashCodeNullable(activityId), hashCodeNullable(activityIdIn), hashCodeNullable(executionId), hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIdIn), hashCodeNullable(processDefinitionId), hashCodeNullable(tenantIdIn), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(priorityHigherThanOrEquals), hashCodeNullable(priorityLowerThanOrEquals), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExternalTaskQueryDto {\n");
    sb.append("    externalTaskId: ").append(toIndentedString(externalTaskId)).append("\n");
    sb.append("    externalTaskIdIn: ").append(toIndentedString(externalTaskIdIn)).append("\n");
    sb.append("    topicName: ").append(toIndentedString(topicName)).append("\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    locked: ").append(toIndentedString(locked)).append("\n");
    sb.append("    notLocked: ").append(toIndentedString(notLocked)).append("\n");
    sb.append("    withRetriesLeft: ").append(toIndentedString(withRetriesLeft)).append("\n");
    sb.append("    noRetriesLeft: ").append(toIndentedString(noRetriesLeft)).append("\n");
    sb.append("    lockExpirationAfter: ").append(toIndentedString(lockExpirationAfter)).append("\n");
    sb.append("    lockExpirationBefore: ").append(toIndentedString(lockExpirationBefore)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIdIn: ").append(toIndentedString(processInstanceIdIn)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    priorityHigherThanOrEquals: ").append(toIndentedString(priorityHigherThanOrEquals)).append("\n");
    sb.append("    priorityLowerThanOrEquals: ").append(toIndentedString(priorityLowerThanOrEquals)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `externalTaskId` to the URL query string
    if (getExternalTaskId() != null) {
      try {
        joiner.add(String.format("%sexternalTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExternalTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `externalTaskIdIn` to the URL query string
    if (getExternalTaskIdIn() != null) {
      for (int i = 0; i < getExternalTaskIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sexternalTaskIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getExternalTaskIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `topicName` to the URL query string
    if (getTopicName() != null) {
      try {
        joiner.add(String.format("%stopicName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTopicName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `locked` to the URL query string
    if (getLocked() != null) {
      try {
        joiner.add(String.format("%slocked%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLocked()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `notLocked` to the URL query string
    if (getNotLocked() != null) {
      try {
        joiner.add(String.format("%snotLocked%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNotLocked()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withRetriesLeft` to the URL query string
    if (getWithRetriesLeft() != null) {
      try {
        joiner.add(String.format("%swithRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `noRetriesLeft` to the URL query string
    if (getNoRetriesLeft() != null) {
      try {
        joiner.add(String.format("%snoRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNoRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `lockExpirationAfter` to the URL query string
    if (getLockExpirationAfter() != null) {
      try {
        joiner.add(String.format("%slockExpirationAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLockExpirationAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `lockExpirationBefore` to the URL query string
    if (getLockExpirationBefore() != null) {
      try {
        joiner.add(String.format("%slockExpirationBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLockExpirationBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityIdIn` to the URL query string
    if (getActivityIdIn() != null) {
      for (int i = 0; i < getActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIdIn` to the URL query string
    if (getProcessInstanceIdIn() != null) {
      for (int i = 0; i < getProcessInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityHigherThanOrEquals` to the URL query string
    if (getPriorityHigherThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityHigherThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityHigherThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityLowerThanOrEquals` to the URL query string
    if (getPriorityLowerThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityLowerThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityLowerThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

