/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.FetchExternalTaskTopicDto;
import org.camunda.community.rest.client.dto.FetchExternalTasksDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * FetchExternalTasksDto
 */
@JsonPropertyOrder({
  FetchExternalTasksDto.JSON_PROPERTY_WORKER_ID,
  FetchExternalTasksDto.JSON_PROPERTY_MAX_TASKS,
  FetchExternalTasksDto.JSON_PROPERTY_USE_PRIORITY,
  FetchExternalTasksDto.JSON_PROPERTY_ASYNC_RESPONSE_TIMEOUT,
  FetchExternalTasksDto.JSON_PROPERTY_TOPICS,
  FetchExternalTasksDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class FetchExternalTasksDto {
  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private String workerId;

  public static final String JSON_PROPERTY_MAX_TASKS = "maxTasks";
  private Integer maxTasks;

  public static final String JSON_PROPERTY_USE_PRIORITY = "usePriority";
  private JsonNullable<Boolean> usePriority = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_ASYNC_RESPONSE_TIMEOUT = "asyncResponseTimeout";
  private JsonNullable<Long> asyncResponseTimeout = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_TOPICS = "topics";
  private JsonNullable<List<FetchExternalTaskTopicDto>> topics = JsonNullable.<List<FetchExternalTaskTopicDto>>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<FetchExternalTasksDtoSortingInner>> sorting = JsonNullable.<List<FetchExternalTasksDtoSortingInner>>undefined();

  public FetchExternalTasksDto() {
  }

  public FetchExternalTasksDto workerId(String workerId) {
    
    this.workerId = workerId;
    return this;
  }

   /**
   * **Mandatory.** The id of the worker on which behalf tasks are fetched. The returned tasks are locked for that worker and can only be completed when providing the same worker id.
   * @return workerId
  **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWorkerId() {
    return workerId;
  }


  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWorkerId(String workerId) {
    this.workerId = workerId;
  }


  public FetchExternalTasksDto maxTasks(Integer maxTasks) {
    
    this.maxTasks = maxTasks;
    return this;
  }

   /**
   * **Mandatory.** The maximum number of tasks to return.
   * @return maxTasks
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_TASKS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxTasks() {
    return maxTasks;
  }


  @JsonProperty(JSON_PROPERTY_MAX_TASKS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxTasks(Integer maxTasks) {
    this.maxTasks = maxTasks;
  }


  public FetchExternalTasksDto usePriority(Boolean usePriority) {
    this.usePriority = JsonNullable.<Boolean>of(usePriority);
    
    return this;
  }

   /**
   * A &#x60;boolean&#x60; value, which indicates whether the task should be fetched based on its priority or arbitrarily.
   * @return usePriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUsePriority() {
        return usePriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_USE_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUsePriority_JsonNullable() {
    return usePriority;
  }
  
  @JsonProperty(JSON_PROPERTY_USE_PRIORITY)
  public void setUsePriority_JsonNullable(JsonNullable<Boolean> usePriority) {
    this.usePriority = usePriority;
  }

  public void setUsePriority(Boolean usePriority) {
    this.usePriority = JsonNullable.<Boolean>of(usePriority);
  }


  public FetchExternalTasksDto asyncResponseTimeout(Long asyncResponseTimeout) {
    this.asyncResponseTimeout = JsonNullable.<Long>of(asyncResponseTimeout);
    
    return this;
  }

   /**
   * The [Long Polling](https://docs.camunda.org/manual/7.21/user-guide/process-engine/external-tasks/#long-polling-to-fetch-and-lock-external-tasks) timeout in milliseconds.  **Note:** The value cannot be set larger than 1.800.000 milliseconds (corresponds to 30 minutes).
   * @return asyncResponseTimeout
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getAsyncResponseTimeout() {
        return asyncResponseTimeout.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASYNC_RESPONSE_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getAsyncResponseTimeout_JsonNullable() {
    return asyncResponseTimeout;
  }
  
  @JsonProperty(JSON_PROPERTY_ASYNC_RESPONSE_TIMEOUT)
  public void setAsyncResponseTimeout_JsonNullable(JsonNullable<Long> asyncResponseTimeout) {
    this.asyncResponseTimeout = asyncResponseTimeout;
  }

  public void setAsyncResponseTimeout(Long asyncResponseTimeout) {
    this.asyncResponseTimeout = JsonNullable.<Long>of(asyncResponseTimeout);
  }


  public FetchExternalTasksDto topics(List<FetchExternalTaskTopicDto> topics) {
    this.topics = JsonNullable.<List<FetchExternalTaskTopicDto>>of(topics);
    
    return this;
  }

  public FetchExternalTasksDto addTopicsItem(FetchExternalTaskTopicDto topicsItem) {
    if (this.topics == null || !this.topics.isPresent()) {
      this.topics = JsonNullable.<List<FetchExternalTaskTopicDto>>of(new ArrayList<>());
    }
    try {
      this.topics.get().add(topicsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of topic objects for which external tasks should be fetched. The returned tasks may be arbitrarily distributed among these topics. Each topic object has the following properties:
   * @return topics
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<FetchExternalTaskTopicDto> getTopics() {
        return topics.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TOPICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<FetchExternalTaskTopicDto>> getTopics_JsonNullable() {
    return topics;
  }
  
  @JsonProperty(JSON_PROPERTY_TOPICS)
  public void setTopics_JsonNullable(JsonNullable<List<FetchExternalTaskTopicDto>> topics) {
    this.topics = topics;
  }

  public void setTopics(List<FetchExternalTaskTopicDto> topics) {
    this.topics = JsonNullable.<List<FetchExternalTaskTopicDto>>of(topics);
  }


  public FetchExternalTasksDto sorting(List<FetchExternalTasksDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<FetchExternalTasksDtoSortingInner>>of(sorting);
    
    return this;
  }

  public FetchExternalTasksDto addSortingItem(FetchExternalTasksDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<FetchExternalTasksDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<FetchExternalTasksDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<FetchExternalTasksDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<FetchExternalTasksDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<FetchExternalTasksDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<FetchExternalTasksDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FetchExternalTasksDto fetchExternalTasksDto = (FetchExternalTasksDto) o;
    return Objects.equals(this.workerId, fetchExternalTasksDto.workerId) &&
        Objects.equals(this.maxTasks, fetchExternalTasksDto.maxTasks) &&
        equalsNullable(this.usePriority, fetchExternalTasksDto.usePriority) &&
        equalsNullable(this.asyncResponseTimeout, fetchExternalTasksDto.asyncResponseTimeout) &&
        equalsNullable(this.topics, fetchExternalTasksDto.topics) &&
        equalsNullable(this.sorting, fetchExternalTasksDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(workerId, maxTasks, hashCodeNullable(usePriority), hashCodeNullable(asyncResponseTimeout), hashCodeNullable(topics), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FetchExternalTasksDto {\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    maxTasks: ").append(toIndentedString(maxTasks)).append("\n");
    sb.append("    usePriority: ").append(toIndentedString(usePriority)).append("\n");
    sb.append("    asyncResponseTimeout: ").append(toIndentedString(asyncResponseTimeout)).append("\n");
    sb.append("    topics: ").append(toIndentedString(topics)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxTasks` to the URL query string
    if (getMaxTasks() != null) {
      try {
        joiner.add(String.format("%smaxTasks%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxTasks()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `usePriority` to the URL query string
    if (getUsePriority() != null) {
      try {
        joiner.add(String.format("%susePriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUsePriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `asyncResponseTimeout` to the URL query string
    if (getAsyncResponseTimeout() != null) {
      try {
        joiner.add(String.format("%sasyncResponseTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAsyncResponseTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `topics` to the URL query string
    if (getTopics() != null) {
      for (int i = 0; i < getTopics().size(); i++) {
        if (getTopics().get(i) != null) {
          joiner.add(getTopics().get(i).toUrlQueryString(String.format("%stopics%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

