/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * FilterDto
 */
@JsonPropertyOrder({
  FilterDto.JSON_PROPERTY_ID,
  FilterDto.JSON_PROPERTY_RESOURCE_TYPE,
  FilterDto.JSON_PROPERTY_NAME,
  FilterDto.JSON_PROPERTY_OWNER,
  FilterDto.JSON_PROPERTY_QUERY,
  FilterDto.JSON_PROPERTY_PROPERTIES,
  FilterDto.JSON_PROPERTY_ITEM_COUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class FilterDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  private JsonNullable<String> resourceType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OWNER = "owner";
  private JsonNullable<String> owner = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_QUERY = "query";
  private Object query;

  public static final String JSON_PROPERTY_PROPERTIES = "properties";
  private Object properties;

  public static final String JSON_PROPERTY_ITEM_COUNT = "itemCount";
  private JsonNullable<Long> itemCount = JsonNullable.<Long>undefined();

  public FilterDto() {
  }

  public FilterDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the filter.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public FilterDto resourceType(String resourceType) {
    this.resourceType = JsonNullable.<String>of(resourceType);
    
    return this;
  }

   /**
   * The resource type of the filter.
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResourceType() {
        return resourceType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResourceType_JsonNullable() {
    return resourceType;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  public void setResourceType_JsonNullable(JsonNullable<String> resourceType) {
    this.resourceType = resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = JsonNullable.<String>of(resourceType);
  }


  public FilterDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * The name of the filter.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public FilterDto owner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
    
    return this;
  }

   /**
   * The user id of the owner of the filter.
   * @return owner
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getOwner() {
        return owner.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOwner_JsonNullable() {
    return owner;
  }
  
  @JsonProperty(JSON_PROPERTY_OWNER)
  public void setOwner_JsonNullable(JsonNullable<String> owner) {
    this.owner = owner;
  }

  public void setOwner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
  }


  public FilterDto query(Object query) {
    
    this.query = query;
    return this;
  }

   /**
   * The query of the filter as a JSON object.
   * @return query
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getQuery() {
    return query;
  }


  @JsonProperty(JSON_PROPERTY_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuery(Object query) {
    this.query = query;
  }


  public FilterDto properties(Object properties) {
    
    this.properties = properties;
    return this;
  }

   /**
   * The properties of a filter as a JSON object.
   * @return properties
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getProperties() {
    return properties;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProperties(Object properties) {
    this.properties = properties;
  }


  public FilterDto itemCount(Long itemCount) {
    this.itemCount = JsonNullable.<Long>of(itemCount);
    
    return this;
  }

   /**
   *  The number of items matched by the filter itself. Note: Only exists if the query parameter &#x60;itemCount&#x60; was set to &#x60;true&#x60;
   * @return itemCount
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getItemCount() {
        return itemCount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ITEM_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getItemCount_JsonNullable() {
    return itemCount;
  }
  
  @JsonProperty(JSON_PROPERTY_ITEM_COUNT)
  public void setItemCount_JsonNullable(JsonNullable<Long> itemCount) {
    this.itemCount = itemCount;
  }

  public void setItemCount(Long itemCount) {
    this.itemCount = JsonNullable.<Long>of(itemCount);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterDto filterDto = (FilterDto) o;
    return equalsNullable(this.id, filterDto.id) &&
        equalsNullable(this.resourceType, filterDto.resourceType) &&
        equalsNullable(this.name, filterDto.name) &&
        equalsNullable(this.owner, filterDto.owner) &&
        Objects.equals(this.query, filterDto.query) &&
        Objects.equals(this.properties, filterDto.properties) &&
        equalsNullable(this.itemCount, filterDto.itemCount);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(resourceType), hashCodeNullable(name), hashCodeNullable(owner), query, properties, hashCodeNullable(itemCount));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    itemCount: ").append(toIndentedString(itemCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceType` to the URL query string
    if (getResourceType() != null) {
      try {
        joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `owner` to the URL query string
    if (getOwner() != null) {
      try {
        joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwner()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `query` to the URL query string
    if (getQuery() != null) {
      try {
        joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getQuery()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `properties` to the URL query string
    if (getProperties() != null) {
      try {
        joiner.add(String.format("%sproperties%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProperties()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `itemCount` to the URL query string
    if (getItemCount() != null) {
      try {
        joiner.add(String.format("%sitemCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getItemCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

