/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.camunda.community.rest.client.dto.CamundaFormRef;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * FormDto
 */
@JsonPropertyOrder({
  FormDto.JSON_PROPERTY_KEY,
  FormDto.JSON_PROPERTY_CAMUNDA_FORM_REF,
  FormDto.JSON_PROPERTY_CONTEXT_PATH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class FormDto {
  public static final String JSON_PROPERTY_KEY = "key";
  private JsonNullable<String> key = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CAMUNDA_FORM_REF = "camundaFormRef";
  private CamundaFormRef camundaFormRef;

  public static final String JSON_PROPERTY_CONTEXT_PATH = "contextPath";
  private JsonNullable<String> contextPath = JsonNullable.<String>undefined();

  public FormDto() {
  }

  public FormDto key(String key) {
    this.key = JsonNullable.<String>of(key);
    
    return this;
  }

   /**
   * The form key.
   * @return key
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getKey() {
        return key.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getKey_JsonNullable() {
    return key;
  }
  
  @JsonProperty(JSON_PROPERTY_KEY)
  public void setKey_JsonNullable(JsonNullable<String> key) {
    this.key = key;
  }

  public void setKey(String key) {
    this.key = JsonNullable.<String>of(key);
  }


  public FormDto camundaFormRef(CamundaFormRef camundaFormRef) {
    
    this.camundaFormRef = camundaFormRef;
    return this;
  }

   /**
   * Get camundaFormRef
   * @return camundaFormRef
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMUNDA_FORM_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CamundaFormRef getCamundaFormRef() {
    return camundaFormRef;
  }


  @JsonProperty(JSON_PROPERTY_CAMUNDA_FORM_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCamundaFormRef(CamundaFormRef camundaFormRef) {
    this.camundaFormRef = camundaFormRef;
  }


  public FormDto contextPath(String contextPath) {
    this.contextPath = JsonNullable.<String>of(contextPath);
    
    return this;
  }

   /**
   * The context path of the process application. If the task (or the process definition) does not belong to a process application deployment or a process definition at all, this property is not set.
   * @return contextPath
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getContextPath() {
        return contextPath.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CONTEXT_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getContextPath_JsonNullable() {
    return contextPath;
  }
  
  @JsonProperty(JSON_PROPERTY_CONTEXT_PATH)
  public void setContextPath_JsonNullable(JsonNullable<String> contextPath) {
    this.contextPath = contextPath;
  }

  public void setContextPath(String contextPath) {
    this.contextPath = JsonNullable.<String>of(contextPath);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormDto formDto = (FormDto) o;
    return equalsNullable(this.key, formDto.key) &&
        Objects.equals(this.camundaFormRef, formDto.camundaFormRef) &&
        equalsNullable(this.contextPath, formDto.contextPath);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(key), camundaFormRef, hashCodeNullable(contextPath));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormDto {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    camundaFormRef: ").append(toIndentedString(camundaFormRef)).append("\n");
    sb.append("    contextPath: ").append(toIndentedString(contextPath)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `key` to the URL query string
    if (getKey() != null) {
      try {
        joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `camundaFormRef` to the URL query string
    if (getCamundaFormRef() != null) {
      joiner.add(getCamundaFormRef().toUrlQueryString(prefix + "camundaFormRef" + suffix));
    }

    // add `contextPath` to the URL query string
    if (getContextPath() != null) {
      try {
        joiner.add(String.format("%scontextPath%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContextPath()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

