/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.GroupQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A group instance query which defines a list of group instances
 */
@JsonPropertyOrder({
  GroupQueryDto.JSON_PROPERTY_ID,
  GroupQueryDto.JSON_PROPERTY_ID_IN,
  GroupQueryDto.JSON_PROPERTY_NAME,
  GroupQueryDto.JSON_PROPERTY_NAME_LIKE,
  GroupQueryDto.JSON_PROPERTY_TYPE,
  GroupQueryDto.JSON_PROPERTY_MEMBER,
  GroupQueryDto.JSON_PROPERTY_MEMBER_OF_TENANT,
  GroupQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class GroupQueryDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID_IN = "idIn";
  private JsonNullable<List<String>> idIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME_LIKE = "nameLike";
  private JsonNullable<String> nameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<String> type = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MEMBER = "member";
  private JsonNullable<String> member = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MEMBER_OF_TENANT = "memberOfTenant";
  private JsonNullable<String> memberOfTenant = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<GroupQueryDtoSortingInner>> sorting = JsonNullable.<List<GroupQueryDtoSortingInner>>undefined();

  public GroupQueryDto() {
  }

  public GroupQueryDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * Filter by the id of the group.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public GroupQueryDto idIn(List<String> idIn) {
    this.idIn = JsonNullable.<List<String>>of(idIn);
    
    return this;
  }

  public GroupQueryDto addIdInItem(String idInItem) {
    if (this.idIn == null || !this.idIn.isPresent()) {
      this.idIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.idIn.get().add(idInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a JSON string array of group ids.
   * @return idIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getIdIn() {
        return idIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getIdIn_JsonNullable() {
    return idIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ID_IN)
  public void setIdIn_JsonNullable(JsonNullable<List<String>> idIn) {
    this.idIn = idIn;
  }

  public void setIdIn(List<String> idIn) {
    this.idIn = JsonNullable.<List<String>>of(idIn);
  }


  public GroupQueryDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * Filter by the name of the group.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public GroupQueryDto nameLike(String nameLike) {
    this.nameLike = JsonNullable.<String>of(nameLike);
    
    return this;
  }

   /**
   * Filter by the name that the parameter is a substring of.
   * @return nameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getNameLike() {
        return nameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNameLike_JsonNullable() {
    return nameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME_LIKE)
  public void setNameLike_JsonNullable(JsonNullable<String> nameLike) {
    this.nameLike = nameLike;
  }

  public void setNameLike(String nameLike) {
    this.nameLike = JsonNullable.<String>of(nameLike);
  }


  public GroupQueryDto type(String type) {
    this.type = JsonNullable.<String>of(type);
    
    return this;
  }

   /**
   * Filter by the type of the group.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<String> type) {
    this.type = type;
  }

  public void setType(String type) {
    this.type = JsonNullable.<String>of(type);
  }


  public GroupQueryDto member(String member) {
    this.member = JsonNullable.<String>of(member);
    
    return this;
  }

   /**
   * Only retrieve groups where the given user id is a member of.
   * @return member
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMember() {
        return member.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MEMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMember_JsonNullable() {
    return member;
  }
  
  @JsonProperty(JSON_PROPERTY_MEMBER)
  public void setMember_JsonNullable(JsonNullable<String> member) {
    this.member = member;
  }

  public void setMember(String member) {
    this.member = JsonNullable.<String>of(member);
  }


  public GroupQueryDto memberOfTenant(String memberOfTenant) {
    this.memberOfTenant = JsonNullable.<String>of(memberOfTenant);
    
    return this;
  }

   /**
   * Only retrieve groups which are members of the given tenant.
   * @return memberOfTenant
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMemberOfTenant() {
        return memberOfTenant.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MEMBER_OF_TENANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMemberOfTenant_JsonNullable() {
    return memberOfTenant;
  }
  
  @JsonProperty(JSON_PROPERTY_MEMBER_OF_TENANT)
  public void setMemberOfTenant_JsonNullable(JsonNullable<String> memberOfTenant) {
    this.memberOfTenant = memberOfTenant;
  }

  public void setMemberOfTenant(String memberOfTenant) {
    this.memberOfTenant = JsonNullable.<String>of(memberOfTenant);
  }


  public GroupQueryDto sorting(List<GroupQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<GroupQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public GroupQueryDto addSortingItem(GroupQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<GroupQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<GroupQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<GroupQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<GroupQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<GroupQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<GroupQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupQueryDto groupQueryDto = (GroupQueryDto) o;
    return equalsNullable(this.id, groupQueryDto.id) &&
        equalsNullable(this.idIn, groupQueryDto.idIn) &&
        equalsNullable(this.name, groupQueryDto.name) &&
        equalsNullable(this.nameLike, groupQueryDto.nameLike) &&
        equalsNullable(this.type, groupQueryDto.type) &&
        equalsNullable(this.member, groupQueryDto.member) &&
        equalsNullable(this.memberOfTenant, groupQueryDto.memberOfTenant) &&
        equalsNullable(this.sorting, groupQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(idIn), hashCodeNullable(name), hashCodeNullable(nameLike), hashCodeNullable(type), hashCodeNullable(member), hashCodeNullable(memberOfTenant), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupQueryDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    idIn: ").append(toIndentedString(idIn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nameLike: ").append(toIndentedString(nameLike)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    member: ").append(toIndentedString(member)).append("\n");
    sb.append("    memberOfTenant: ").append(toIndentedString(memberOfTenant)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `idIn` to the URL query string
    if (getIdIn() != null) {
      for (int i = 0; i < getIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sidIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `nameLike` to the URL query string
    if (getNameLike() != null) {
      try {
        joiner.add(String.format("%snameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `member` to the URL query string
    if (getMember() != null) {
      try {
        joiner.add(String.format("%smember%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMember()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `memberOfTenant` to the URL query string
    if (getMemberOfTenant() != null) {
      try {
        joiner.add(String.format("%smemberOfTenant%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMemberOfTenant()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

