/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricActivityInstanceDto
 */
@JsonPropertyOrder({
  HistoricActivityInstanceDto.JSON_PROPERTY_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_ACTIVITY_NAME,
  HistoricActivityInstanceDto.JSON_PROPERTY_ACTIVITY_TYPE,
  HistoricActivityInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricActivityInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_TASK_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_ASSIGNEE,
  HistoricActivityInstanceDto.JSON_PROPERTY_CALLED_PROCESS_INSTANCE_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_CALLED_CASE_INSTANCE_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_START_TIME,
  HistoricActivityInstanceDto.JSON_PROPERTY_END_TIME,
  HistoricActivityInstanceDto.JSON_PROPERTY_DURATION_IN_MILLIS,
  HistoricActivityInstanceDto.JSON_PROPERTY_CANCELED,
  HistoricActivityInstanceDto.JSON_PROPERTY_COMPLETE_SCOPE,
  HistoricActivityInstanceDto.JSON_PROPERTY_TENANT_ID,
  HistoricActivityInstanceDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricActivityInstanceDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricActivityInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
  private JsonNullable<String> parentActivityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_NAME = "activityName";
  private JsonNullable<String> activityName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_TYPE = "activityType";
  private JsonNullable<String> activityType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ID = "taskId";
  private JsonNullable<String> taskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private JsonNullable<String> assignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CALLED_PROCESS_INSTANCE_ID = "calledProcessInstanceId";
  private JsonNullable<String> calledProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CALLED_CASE_INSTANCE_ID = "calledCaseInstanceId";
  private JsonNullable<String> calledCaseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_START_TIME = "startTime";
  private JsonNullable<OffsetDateTime> startTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  private JsonNullable<OffsetDateTime> endTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DURATION_IN_MILLIS = "durationInMillis";
  private JsonNullable<Long> durationInMillis = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_CANCELED = "canceled";
  private JsonNullable<Boolean> canceled = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_COMPLETE_SCOPE = "completeScope";
  private JsonNullable<Boolean> completeScope = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public HistoricActivityInstanceDto() {
  }

  public HistoricActivityInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the activity instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricActivityInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
    this.parentActivityInstanceId = JsonNullable.<String>of(parentActivityInstanceId);
    
    return this;
  }

   /**
   * The id of the parent activity instance, for example a sub process instance.
   * @return parentActivityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getParentActivityInstanceId() {
        return parentActivityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getParentActivityInstanceId_JsonNullable() {
    return parentActivityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PARENT_ACTIVITY_INSTANCE_ID)
  public void setParentActivityInstanceId_JsonNullable(JsonNullable<String> parentActivityInstanceId) {
    this.parentActivityInstanceId = parentActivityInstanceId;
  }

  public void setParentActivityInstanceId(String parentActivityInstanceId) {
    this.parentActivityInstanceId = JsonNullable.<String>of(parentActivityInstanceId);
  }


  public HistoricActivityInstanceDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity that this object is an instance of.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricActivityInstanceDto activityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
    
    return this;
  }

   /**
   * The name of the activity that this object is an instance of.
   * @return activityName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityName() {
        return activityName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityName_JsonNullable() {
    return activityName;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  public void setActivityName_JsonNullable(JsonNullable<String> activityName) {
    this.activityName = activityName;
  }

  public void setActivityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
  }


  public HistoricActivityInstanceDto activityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
    
    return this;
  }

   /**
   * The type of the activity that this object is an instance of.
   * @return activityType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityType() {
        return activityType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityType_JsonNullable() {
    return activityType;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  public void setActivityType_JsonNullable(JsonNullable<String> activityType) {
    this.activityType = activityType;
  }

  public void setActivityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
  }


  public HistoricActivityInstanceDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition that this activity instance belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricActivityInstanceDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition that this activity instance belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricActivityInstanceDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance that this activity instance belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricActivityInstanceDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The id of the execution that executed this activity instance.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricActivityInstanceDto taskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
    
    return this;
  }

   /**
   * The id of the task that is associated to this activity instance. Is only set if the activity is a user task.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskId() {
        return taskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskId_JsonNullable() {
    return taskId;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID)
  public void setTaskId_JsonNullable(JsonNullable<String> taskId) {
    this.taskId = taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
  }


  public HistoricActivityInstanceDto assignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
    
    return this;
  }

   /**
   * The assignee of the task that is associated to this activity instance. Is only set if the activity is a user task.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssignee() {
        return assignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssignee_JsonNullable() {
    return assignee;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  public void setAssignee_JsonNullable(JsonNullable<String> assignee) {
    this.assignee = assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
  }


  public HistoricActivityInstanceDto calledProcessInstanceId(String calledProcessInstanceId) {
    this.calledProcessInstanceId = JsonNullable.<String>of(calledProcessInstanceId);
    
    return this;
  }

   /**
   * The id of the called process instance. Is only set if the activity is a call activity and the called instance a process instance.
   * @return calledProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCalledProcessInstanceId() {
        return calledProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CALLED_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCalledProcessInstanceId_JsonNullable() {
    return calledProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CALLED_PROCESS_INSTANCE_ID)
  public void setCalledProcessInstanceId_JsonNullable(JsonNullable<String> calledProcessInstanceId) {
    this.calledProcessInstanceId = calledProcessInstanceId;
  }

  public void setCalledProcessInstanceId(String calledProcessInstanceId) {
    this.calledProcessInstanceId = JsonNullable.<String>of(calledProcessInstanceId);
  }


  public HistoricActivityInstanceDto calledCaseInstanceId(String calledCaseInstanceId) {
    this.calledCaseInstanceId = JsonNullable.<String>of(calledCaseInstanceId);
    
    return this;
  }

   /**
   * The id of the called case instance. Is only set if the activity is a call activity and the called instance a case instance.
   * @return calledCaseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCalledCaseInstanceId() {
        return calledCaseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CALLED_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCalledCaseInstanceId_JsonNullable() {
    return calledCaseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CALLED_CASE_INSTANCE_ID)
  public void setCalledCaseInstanceId_JsonNullable(JsonNullable<String> calledCaseInstanceId) {
    this.calledCaseInstanceId = calledCaseInstanceId;
  }

  public void setCalledCaseInstanceId(String calledCaseInstanceId) {
    this.calledCaseInstanceId = JsonNullable.<String>of(calledCaseInstanceId);
  }


  public HistoricActivityInstanceDto startTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
    
    return this;
  }

   /**
   * The time the instance was started. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartTime() {
        return startTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartTime_JsonNullable() {
    return startTime;
  }
  
  @JsonProperty(JSON_PROPERTY_START_TIME)
  public void setStartTime_JsonNullable(JsonNullable<OffsetDateTime> startTime) {
    this.startTime = startTime;
  }

  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
  }


  public HistoricActivityInstanceDto endTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
    
    return this;
  }

   /**
   * The time the instance ended. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return endTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getEndTime() {
        return endTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getEndTime_JsonNullable() {
    return endTime;
  }
  
  @JsonProperty(JSON_PROPERTY_END_TIME)
  public void setEndTime_JsonNullable(JsonNullable<OffsetDateTime> endTime) {
    this.endTime = endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
  }


  public HistoricActivityInstanceDto durationInMillis(Long durationInMillis) {
    this.durationInMillis = JsonNullable.<Long>of(durationInMillis);
    
    return this;
  }

   /**
   * The time the instance took to finish (in milliseconds).
   * @return durationInMillis
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getDurationInMillis() {
        return durationInMillis.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION_IN_MILLIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getDurationInMillis_JsonNullable() {
    return durationInMillis;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION_IN_MILLIS)
  public void setDurationInMillis_JsonNullable(JsonNullable<Long> durationInMillis) {
    this.durationInMillis = durationInMillis;
  }

  public void setDurationInMillis(Long durationInMillis) {
    this.durationInMillis = JsonNullable.<Long>of(durationInMillis);
  }


  public HistoricActivityInstanceDto canceled(Boolean canceled) {
    this.canceled = JsonNullable.<Boolean>of(canceled);
    
    return this;
  }

   /**
   * If &#x60;true&#x60;, this activity instance is canceled.
   * @return canceled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCanceled() {
        return canceled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANCELED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCanceled_JsonNullable() {
    return canceled;
  }
  
  @JsonProperty(JSON_PROPERTY_CANCELED)
  public void setCanceled_JsonNullable(JsonNullable<Boolean> canceled) {
    this.canceled = canceled;
  }

  public void setCanceled(Boolean canceled) {
    this.canceled = JsonNullable.<Boolean>of(canceled);
  }


  public HistoricActivityInstanceDto completeScope(Boolean completeScope) {
    this.completeScope = JsonNullable.<Boolean>of(completeScope);
    
    return this;
  }

   /**
   * If &#x60;true&#x60;, this activity instance did complete a BPMN 2.0 scope.
   * @return completeScope
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCompleteScope() {
        return completeScope.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCompleteScope_JsonNullable() {
    return completeScope;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  public void setCompleteScope_JsonNullable(JsonNullable<Boolean> completeScope) {
    this.completeScope = completeScope;
  }

  public void setCompleteScope(Boolean completeScope) {
    this.completeScope = JsonNullable.<Boolean>of(completeScope);
  }


  public HistoricActivityInstanceDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the activity instance.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricActivityInstanceDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the activity instance should be removed by the History Cleanup job. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricActivityInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this activity instance.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricActivityInstanceDto historicActivityInstanceDto = (HistoricActivityInstanceDto) o;
    return equalsNullable(this.id, historicActivityInstanceDto.id) &&
        equalsNullable(this.parentActivityInstanceId, historicActivityInstanceDto.parentActivityInstanceId) &&
        equalsNullable(this.activityId, historicActivityInstanceDto.activityId) &&
        equalsNullable(this.activityName, historicActivityInstanceDto.activityName) &&
        equalsNullable(this.activityType, historicActivityInstanceDto.activityType) &&
        equalsNullable(this.processDefinitionKey, historicActivityInstanceDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionId, historicActivityInstanceDto.processDefinitionId) &&
        equalsNullable(this.processInstanceId, historicActivityInstanceDto.processInstanceId) &&
        equalsNullable(this.executionId, historicActivityInstanceDto.executionId) &&
        equalsNullable(this.taskId, historicActivityInstanceDto.taskId) &&
        equalsNullable(this.assignee, historicActivityInstanceDto.assignee) &&
        equalsNullable(this.calledProcessInstanceId, historicActivityInstanceDto.calledProcessInstanceId) &&
        equalsNullable(this.calledCaseInstanceId, historicActivityInstanceDto.calledCaseInstanceId) &&
        equalsNullable(this.startTime, historicActivityInstanceDto.startTime) &&
        equalsNullable(this.endTime, historicActivityInstanceDto.endTime) &&
        equalsNullable(this.durationInMillis, historicActivityInstanceDto.durationInMillis) &&
        equalsNullable(this.canceled, historicActivityInstanceDto.canceled) &&
        equalsNullable(this.completeScope, historicActivityInstanceDto.completeScope) &&
        equalsNullable(this.tenantId, historicActivityInstanceDto.tenantId) &&
        equalsNullable(this.removalTime, historicActivityInstanceDto.removalTime) &&
        equalsNullable(this.rootProcessInstanceId, historicActivityInstanceDto.rootProcessInstanceId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(parentActivityInstanceId), hashCodeNullable(activityId), hashCodeNullable(activityName), hashCodeNullable(activityType), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionId), hashCodeNullable(processInstanceId), hashCodeNullable(executionId), hashCodeNullable(taskId), hashCodeNullable(assignee), hashCodeNullable(calledProcessInstanceId), hashCodeNullable(calledCaseInstanceId), hashCodeNullable(startTime), hashCodeNullable(endTime), hashCodeNullable(durationInMillis), hashCodeNullable(canceled), hashCodeNullable(completeScope), hashCodeNullable(tenantId), hashCodeNullable(removalTime), hashCodeNullable(rootProcessInstanceId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricActivityInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    parentActivityInstanceId: ").append(toIndentedString(parentActivityInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    calledProcessInstanceId: ").append(toIndentedString(calledProcessInstanceId)).append("\n");
    sb.append("    calledCaseInstanceId: ").append(toIndentedString(calledCaseInstanceId)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    durationInMillis: ").append(toIndentedString(durationInMillis)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    completeScope: ").append(toIndentedString(completeScope)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentActivityInstanceId` to the URL query string
    if (getParentActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sparentActivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityName` to the URL query string
    if (getActivityName() != null) {
      try {
        joiner.add(String.format("%sactivityName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityType` to the URL query string
    if (getActivityType() != null) {
      try {
        joiner.add(String.format("%sactivityType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskId` to the URL query string
    if (getTaskId() != null) {
      try {
        joiner.add(String.format("%staskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `calledProcessInstanceId` to the URL query string
    if (getCalledProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%scalledProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCalledProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `calledCaseInstanceId` to the URL query string
    if (getCalledCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scalledCaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCalledCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startTime` to the URL query string
    if (getStartTime() != null) {
      try {
        joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endTime` to the URL query string
    if (getEndTime() != null) {
      try {
        joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `durationInMillis` to the URL query string
    if (getDurationInMillis() != null) {
      try {
        joiner.add(String.format("%sdurationInMillis%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDurationInMillis()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `canceled` to the URL query string
    if (getCanceled() != null) {
      try {
        joiner.add(String.format("%scanceled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCanceled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completeScope` to the URL query string
    if (getCompleteScope() != null) {
      try {
        joiner.add(String.format("%scompleteScope%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompleteScope()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

