/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A historic activity instance query which defines a group of historic activity instances
 */
@JsonPropertyOrder({
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_ACTIVITY_NAME,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_ACTIVITY_TYPE,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_TASK_ASSIGNEE,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_FINISHED,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_UNFINISHED,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_CANCELED,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_COMPLETE_SCOPE,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_STARTED_BEFORE,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_STARTED_AFTER,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_FINISHED_BEFORE,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_FINISHED_AFTER,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricActivityInstanceQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricActivityInstanceQueryDto {
  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_NAME = "activityName";
  private JsonNullable<String> activityName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_TYPE = "activityType";
  private JsonNullable<String> activityType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ASSIGNEE = "taskAssignee";
  private JsonNullable<String> taskAssignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FINISHED = "finished";
  private JsonNullable<Boolean> finished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UNFINISHED = "unfinished";
  private JsonNullable<Boolean> unfinished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_CANCELED = "canceled";
  private JsonNullable<Boolean> canceled = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_COMPLETE_SCOPE = "completeScope";
  private JsonNullable<Boolean> completeScope = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_STARTED_BEFORE = "startedBefore";
  private JsonNullable<OffsetDateTime> startedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_STARTED_AFTER = "startedAfter";
  private JsonNullable<OffsetDateTime> startedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_BEFORE = "finishedBefore";
  private JsonNullable<OffsetDateTime> finishedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_AFTER = "finishedAfter";
  private JsonNullable<OffsetDateTime> finishedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricActivityInstanceQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricActivityInstanceQueryDtoSortingInner>>undefined();

  public HistoricActivityInstanceQueryDto() {
  }

  public HistoricActivityInstanceQueryDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * Filter by activity instance id.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public HistoricActivityInstanceQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricActivityInstanceQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricActivityInstanceQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Filter by the id of the execution that executed the activity instance.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricActivityInstanceQueryDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * Filter by the activity id (according to BPMN 2.0 XML).
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricActivityInstanceQueryDto activityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
    
    return this;
  }

   /**
   * Filter by the activity name (according to BPMN 2.0 XML).
   * @return activityName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityName() {
        return activityName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityName_JsonNullable() {
    return activityName;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_NAME)
  public void setActivityName_JsonNullable(JsonNullable<String> activityName) {
    this.activityName = activityName;
  }

  public void setActivityName(String activityName) {
    this.activityName = JsonNullable.<String>of(activityName);
  }


  public HistoricActivityInstanceQueryDto activityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
    
    return this;
  }

   /**
   * Filter by activity type.
   * @return activityType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityType() {
        return activityType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityType_JsonNullable() {
    return activityType;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_TYPE)
  public void setActivityType_JsonNullable(JsonNullable<String> activityType) {
    this.activityType = activityType;
  }

  public void setActivityType(String activityType) {
    this.activityType = JsonNullable.<String>of(activityType);
  }


  public HistoricActivityInstanceQueryDto taskAssignee(String taskAssignee) {
    this.taskAssignee = JsonNullable.<String>of(taskAssignee);
    
    return this;
  }

   /**
   * Only include activity instances that are user tasks and assigned to a given user.
   * @return taskAssignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskAssignee() {
        return taskAssignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskAssignee_JsonNullable() {
    return taskAssignee;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE)
  public void setTaskAssignee_JsonNullable(JsonNullable<String> taskAssignee) {
    this.taskAssignee = taskAssignee;
  }

  public void setTaskAssignee(String taskAssignee) {
    this.taskAssignee = JsonNullable.<String>of(taskAssignee);
  }


  public HistoricActivityInstanceQueryDto finished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
    
    return this;
  }

   /**
   * Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return finished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFinished() {
        return finished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFinished_JsonNullable() {
    return finished;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED)
  public void setFinished_JsonNullable(JsonNullable<Boolean> finished) {
    this.finished = finished;
  }

  public void setFinished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
  }


  public HistoricActivityInstanceQueryDto unfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
    
    return this;
  }

   /**
   * Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnfinished() {
        return unfinished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnfinished_JsonNullable() {
    return unfinished;
  }
  
  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  public void setUnfinished_JsonNullable(JsonNullable<Boolean> unfinished) {
    this.unfinished = unfinished;
  }

  public void setUnfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
  }


  public HistoricActivityInstanceQueryDto canceled(Boolean canceled) {
    this.canceled = JsonNullable.<Boolean>of(canceled);
    
    return this;
  }

   /**
   * Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return canceled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCanceled() {
        return canceled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANCELED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCanceled_JsonNullable() {
    return canceled;
  }
  
  @JsonProperty(JSON_PROPERTY_CANCELED)
  public void setCanceled_JsonNullable(JsonNullable<Boolean> canceled) {
    this.canceled = canceled;
  }

  public void setCanceled(Boolean canceled) {
    this.canceled = JsonNullable.<Boolean>of(canceled);
  }


  public HistoricActivityInstanceQueryDto completeScope(Boolean completeScope) {
    this.completeScope = JsonNullable.<Boolean>of(completeScope);
    
    return this;
  }

   /**
   * Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return completeScope
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCompleteScope() {
        return completeScope.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCompleteScope_JsonNullable() {
    return completeScope;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  public void setCompleteScope_JsonNullable(JsonNullable<Boolean> completeScope) {
    this.completeScope = completeScope;
  }

  public void setCompleteScope(Boolean completeScope) {
    this.completeScope = JsonNullable.<Boolean>of(completeScope);
  }


  public HistoricActivityInstanceQueryDto startedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
    
    return this;
  }

   /**
   * Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedBefore() {
        return startedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedBefore_JsonNullable() {
    return startedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  public void setStartedBefore_JsonNullable(JsonNullable<OffsetDateTime> startedBefore) {
    this.startedBefore = startedBefore;
  }

  public void setStartedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
  }


  public HistoricActivityInstanceQueryDto startedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
    
    return this;
  }

   /**
   * Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedAfter() {
        return startedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedAfter_JsonNullable() {
    return startedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  public void setStartedAfter_JsonNullable(JsonNullable<OffsetDateTime> startedAfter) {
    this.startedAfter = startedAfter;
  }

  public void setStartedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
  }


  public HistoricActivityInstanceQueryDto finishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
    
    return this;
  }

   /**
   * Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedBefore() {
        return finishedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedBefore_JsonNullable() {
    return finishedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  public void setFinishedBefore_JsonNullable(JsonNullable<OffsetDateTime> finishedBefore) {
    this.finishedBefore = finishedBefore;
  }

  public void setFinishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
  }


  public HistoricActivityInstanceQueryDto finishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
    
    return this;
  }

   /**
   * Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedAfter() {
        return finishedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedAfter_JsonNullable() {
    return finishedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  public void setFinishedAfter_JsonNullable(JsonNullable<OffsetDateTime> finishedAfter) {
    this.finishedAfter = finishedAfter;
  }

  public void setFinishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
  }


  public HistoricActivityInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricActivityInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricActivityInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricActivityInstanceQueryDto sorting(List<HistoricActivityInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricActivityInstanceQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricActivityInstanceQueryDto addSortingItem(HistoricActivityInstanceQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricActivityInstanceQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricActivityInstanceQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricActivityInstanceQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricActivityInstanceQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricActivityInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricActivityInstanceQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto = (HistoricActivityInstanceQueryDto) o;
    return equalsNullable(this.activityInstanceId, historicActivityInstanceQueryDto.activityInstanceId) &&
        equalsNullable(this.processInstanceId, historicActivityInstanceQueryDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, historicActivityInstanceQueryDto.processDefinitionId) &&
        equalsNullable(this.executionId, historicActivityInstanceQueryDto.executionId) &&
        equalsNullable(this.activityId, historicActivityInstanceQueryDto.activityId) &&
        equalsNullable(this.activityName, historicActivityInstanceQueryDto.activityName) &&
        equalsNullable(this.activityType, historicActivityInstanceQueryDto.activityType) &&
        equalsNullable(this.taskAssignee, historicActivityInstanceQueryDto.taskAssignee) &&
        equalsNullable(this.finished, historicActivityInstanceQueryDto.finished) &&
        equalsNullable(this.unfinished, historicActivityInstanceQueryDto.unfinished) &&
        equalsNullable(this.canceled, historicActivityInstanceQueryDto.canceled) &&
        equalsNullable(this.completeScope, historicActivityInstanceQueryDto.completeScope) &&
        equalsNullable(this.startedBefore, historicActivityInstanceQueryDto.startedBefore) &&
        equalsNullable(this.startedAfter, historicActivityInstanceQueryDto.startedAfter) &&
        equalsNullable(this.finishedBefore, historicActivityInstanceQueryDto.finishedBefore) &&
        equalsNullable(this.finishedAfter, historicActivityInstanceQueryDto.finishedAfter) &&
        equalsNullable(this.tenantIdIn, historicActivityInstanceQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicActivityInstanceQueryDto.withoutTenantId) &&
        equalsNullable(this.sorting, historicActivityInstanceQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(activityInstanceId), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(executionId), hashCodeNullable(activityId), hashCodeNullable(activityName), hashCodeNullable(activityType), hashCodeNullable(taskAssignee), hashCodeNullable(finished), hashCodeNullable(unfinished), hashCodeNullable(canceled), hashCodeNullable(completeScope), hashCodeNullable(startedBefore), hashCodeNullable(startedAfter), hashCodeNullable(finishedBefore), hashCodeNullable(finishedAfter), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricActivityInstanceQueryDto {\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    taskAssignee: ").append(toIndentedString(taskAssignee)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    completeScope: ").append(toIndentedString(completeScope)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityName` to the URL query string
    if (getActivityName() != null) {
      try {
        joiner.add(String.format("%sactivityName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityType` to the URL query string
    if (getActivityType() != null) {
      try {
        joiner.add(String.format("%sactivityType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskAssignee` to the URL query string
    if (getTaskAssignee() != null) {
      try {
        joiner.add(String.format("%staskAssignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finished` to the URL query string
    if (getFinished() != null) {
      try {
        joiner.add(String.format("%sfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unfinished` to the URL query string
    if (getUnfinished() != null) {
      try {
        joiner.add(String.format("%sunfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnfinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `canceled` to the URL query string
    if (getCanceled() != null) {
      try {
        joiner.add(String.format("%scanceled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCanceled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completeScope` to the URL query string
    if (getCompleteScope() != null) {
      try {
        joiner.add(String.format("%scompleteScope%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompleteScope()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedBefore` to the URL query string
    if (getStartedBefore() != null) {
      try {
        joiner.add(String.format("%sstartedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedAfter` to the URL query string
    if (getStartedAfter() != null) {
      try {
        joiner.add(String.format("%sstartedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedBefore` to the URL query string
    if (getFinishedBefore() != null) {
      try {
        joiner.add(String.format("%sfinishedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedAfter` to the URL query string
    if (getFinishedAfter() != null) {
      try {
        joiner.add(String.format("%sfinishedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

