/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricActivityStatisticsDto
 */
@JsonPropertyOrder({
  HistoricActivityStatisticsDto.JSON_PROPERTY_ID,
  HistoricActivityStatisticsDto.JSON_PROPERTY_INSTANCES,
  HistoricActivityStatisticsDto.JSON_PROPERTY_CANCELED,
  HistoricActivityStatisticsDto.JSON_PROPERTY_FINISHED,
  HistoricActivityStatisticsDto.JSON_PROPERTY_COMPLETE_SCOPE,
  HistoricActivityStatisticsDto.JSON_PROPERTY_OPEN_INCIDENTS,
  HistoricActivityStatisticsDto.JSON_PROPERTY_RESOLVED_INCIDENTS,
  HistoricActivityStatisticsDto.JSON_PROPERTY_DELETED_INCIDENTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricActivityStatisticsDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INSTANCES = "instances";
  private JsonNullable<Long> instances = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_CANCELED = "canceled";
  private JsonNullable<Long> canceled = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_FINISHED = "finished";
  private JsonNullable<Long> finished = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_COMPLETE_SCOPE = "completeScope";
  private JsonNullable<Long> completeScope = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_OPEN_INCIDENTS = "openIncidents";
  private JsonNullable<Long> openIncidents = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_RESOLVED_INCIDENTS = "resolvedIncidents";
  private JsonNullable<Long> resolvedIncidents = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_DELETED_INCIDENTS = "deletedIncidents";
  private JsonNullable<Long> deletedIncidents = JsonNullable.<Long>undefined();

  public HistoricActivityStatisticsDto() {
  }

  public HistoricActivityStatisticsDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the activity the results are aggregated for.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricActivityStatisticsDto instances(Long instances) {
    this.instances = JsonNullable.<Long>of(instances);
    
    return this;
  }

   /**
   * The total number of all running instances of the activity.
   * @return instances
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getInstances() {
        return instances.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getInstances_JsonNullable() {
    return instances;
  }
  
  @JsonProperty(JSON_PROPERTY_INSTANCES)
  public void setInstances_JsonNullable(JsonNullable<Long> instances) {
    this.instances = instances;
  }

  public void setInstances(Long instances) {
    this.instances = JsonNullable.<Long>of(instances);
  }


  public HistoricActivityStatisticsDto canceled(Long canceled) {
    this.canceled = JsonNullable.<Long>of(canceled);
    
    return this;
  }

   /**
   * The total number of all canceled instances of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if canceled activity instances were excluded.
   * @return canceled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getCanceled() {
        return canceled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANCELED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getCanceled_JsonNullable() {
    return canceled;
  }
  
  @JsonProperty(JSON_PROPERTY_CANCELED)
  public void setCanceled_JsonNullable(JsonNullable<Long> canceled) {
    this.canceled = canceled;
  }

  public void setCanceled(Long canceled) {
    this.canceled = JsonNullable.<Long>of(canceled);
  }


  public HistoricActivityStatisticsDto finished(Long finished) {
    this.finished = JsonNullable.<Long>of(finished);
    
    return this;
  }

   /**
   * The total number of all finished instances of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if finished activity instances were excluded.
   * @return finished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getFinished() {
        return finished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getFinished_JsonNullable() {
    return finished;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED)
  public void setFinished_JsonNullable(JsonNullable<Long> finished) {
    this.finished = finished;
  }

  public void setFinished(Long finished) {
    this.finished = JsonNullable.<Long>of(finished);
  }


  public HistoricActivityStatisticsDto completeScope(Long completeScope) {
    this.completeScope = JsonNullable.<Long>of(completeScope);
    
    return this;
  }

   /**
   * The total number of all instances which completed a scope of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if activity instances which completed a scope were excluded.
   * @return completeScope
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getCompleteScope() {
        return completeScope.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getCompleteScope_JsonNullable() {
    return completeScope;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPLETE_SCOPE)
  public void setCompleteScope_JsonNullable(JsonNullable<Long> completeScope) {
    this.completeScope = completeScope;
  }

  public void setCompleteScope(Long completeScope) {
    this.completeScope = JsonNullable.<Long>of(completeScope);
  }


  public HistoricActivityStatisticsDto openIncidents(Long openIncidents) {
    this.openIncidents = JsonNullable.<Long>of(openIncidents);
    
    return this;
  }

   /**
   * The total number of open incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return openIncidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getOpenIncidents() {
        return openIncidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OPEN_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getOpenIncidents_JsonNullable() {
    return openIncidents;
  }
  
  @JsonProperty(JSON_PROPERTY_OPEN_INCIDENTS)
  public void setOpenIncidents_JsonNullable(JsonNullable<Long> openIncidents) {
    this.openIncidents = openIncidents;
  }

  public void setOpenIncidents(Long openIncidents) {
    this.openIncidents = JsonNullable.<Long>of(openIncidents);
  }


  public HistoricActivityStatisticsDto resolvedIncidents(Long resolvedIncidents) {
    this.resolvedIncidents = JsonNullable.<Long>of(resolvedIncidents);
    
    return this;
  }

   /**
   * The total number of resolved incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return resolvedIncidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getResolvedIncidents() {
        return resolvedIncidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOLVED_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getResolvedIncidents_JsonNullable() {
    return resolvedIncidents;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOLVED_INCIDENTS)
  public void setResolvedIncidents_JsonNullable(JsonNullable<Long> resolvedIncidents) {
    this.resolvedIncidents = resolvedIncidents;
  }

  public void setResolvedIncidents(Long resolvedIncidents) {
    this.resolvedIncidents = JsonNullable.<Long>of(resolvedIncidents);
  }


  public HistoricActivityStatisticsDto deletedIncidents(Long deletedIncidents) {
    this.deletedIncidents = JsonNullable.<Long>of(deletedIncidents);
    
    return this;
  }

   /**
   * The total number of deleted incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return deletedIncidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getDeletedIncidents() {
        return deletedIncidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETED_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getDeletedIncidents_JsonNullable() {
    return deletedIncidents;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETED_INCIDENTS)
  public void setDeletedIncidents_JsonNullable(JsonNullable<Long> deletedIncidents) {
    this.deletedIncidents = deletedIncidents;
  }

  public void setDeletedIncidents(Long deletedIncidents) {
    this.deletedIncidents = JsonNullable.<Long>of(deletedIncidents);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricActivityStatisticsDto historicActivityStatisticsDto = (HistoricActivityStatisticsDto) o;
    return equalsNullable(this.id, historicActivityStatisticsDto.id) &&
        equalsNullable(this.instances, historicActivityStatisticsDto.instances) &&
        equalsNullable(this.canceled, historicActivityStatisticsDto.canceled) &&
        equalsNullable(this.finished, historicActivityStatisticsDto.finished) &&
        equalsNullable(this.completeScope, historicActivityStatisticsDto.completeScope) &&
        equalsNullable(this.openIncidents, historicActivityStatisticsDto.openIncidents) &&
        equalsNullable(this.resolvedIncidents, historicActivityStatisticsDto.resolvedIncidents) &&
        equalsNullable(this.deletedIncidents, historicActivityStatisticsDto.deletedIncidents);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(instances), hashCodeNullable(canceled), hashCodeNullable(finished), hashCodeNullable(completeScope), hashCodeNullable(openIncidents), hashCodeNullable(resolvedIncidents), hashCodeNullable(deletedIncidents));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricActivityStatisticsDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    instances: ").append(toIndentedString(instances)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    completeScope: ").append(toIndentedString(completeScope)).append("\n");
    sb.append("    openIncidents: ").append(toIndentedString(openIncidents)).append("\n");
    sb.append("    resolvedIncidents: ").append(toIndentedString(resolvedIncidents)).append("\n");
    sb.append("    deletedIncidents: ").append(toIndentedString(deletedIncidents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `instances` to the URL query string
    if (getInstances() != null) {
      try {
        joiner.add(String.format("%sinstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `canceled` to the URL query string
    if (getCanceled() != null) {
      try {
        joiner.add(String.format("%scanceled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCanceled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finished` to the URL query string
    if (getFinished() != null) {
      try {
        joiner.add(String.format("%sfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completeScope` to the URL query string
    if (getCompleteScope() != null) {
      try {
        joiner.add(String.format("%scompleteScope%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompleteScope()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `openIncidents` to the URL query string
    if (getOpenIncidents() != null) {
      try {
        joiner.add(String.format("%sopenIncidents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOpenIncidents()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resolvedIncidents` to the URL query string
    if (getResolvedIncidents() != null) {
      try {
        joiner.add(String.format("%sresolvedIncidents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResolvedIncidents()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletedIncidents` to the URL query string
    if (getDeletedIncidents() != null) {
      try {
        joiner.add(String.format("%sdeletedIncidents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletedIncidents()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

