/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricBatchQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Query for the historic batches to set the removal time for.
 */
@JsonPropertyOrder({
  HistoricBatchQueryDto.JSON_PROPERTY_BATCH_ID,
  HistoricBatchQueryDto.JSON_PROPERTY_TYPE,
  HistoricBatchQueryDto.JSON_PROPERTY_COMPLETED,
  HistoricBatchQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricBatchQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricBatchQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricBatchQueryDto {
  public static final String JSON_PROPERTY_BATCH_ID = "batchId";
  private JsonNullable<String> batchId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<String> type = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_COMPLETED = "completed";
  private JsonNullable<Boolean> completed = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricBatchQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricBatchQueryDtoSortingInner>>undefined();

  public HistoricBatchQueryDto() {
  }

  public HistoricBatchQueryDto batchId(String batchId) {
    this.batchId = JsonNullable.<String>of(batchId);
    
    return this;
  }

   /**
   * Filter by batch id.
   * @return batchId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBatchId() {
        return batchId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BATCH_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBatchId_JsonNullable() {
    return batchId;
  }
  
  @JsonProperty(JSON_PROPERTY_BATCH_ID)
  public void setBatchId_JsonNullable(JsonNullable<String> batchId) {
    this.batchId = batchId;
  }

  public void setBatchId(String batchId) {
    this.batchId = JsonNullable.<String>of(batchId);
  }


  public HistoricBatchQueryDto type(String type) {
    this.type = JsonNullable.<String>of(type);
    
    return this;
  }

   /**
   * Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<String> type) {
    this.type = type;
  }

  public void setType(String type) {
    this.type = JsonNullable.<String>of(type);
  }


  public HistoricBatchQueryDto completed(Boolean completed) {
    this.completed = JsonNullable.<Boolean>of(completed);
    
    return this;
  }

   /**
   *  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned.
   * @return completed
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCompleted() {
        return completed.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCompleted_JsonNullable() {
    return completed;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPLETED)
  public void setCompleted_JsonNullable(JsonNullable<Boolean> completed) {
    this.completed = completed;
  }

  public void setCompleted(Boolean completed) {
    this.completed = JsonNullable.<Boolean>of(completed);
  }


  public HistoricBatchQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricBatchQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricBatchQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricBatchQueryDto sorting(List<HistoricBatchQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricBatchQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricBatchQueryDto addSortingItem(HistoricBatchQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricBatchQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the &#x60;/count&#x60; endpoint
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricBatchQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricBatchQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricBatchQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricBatchQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricBatchQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricBatchQueryDto historicBatchQueryDto = (HistoricBatchQueryDto) o;
    return equalsNullable(this.batchId, historicBatchQueryDto.batchId) &&
        equalsNullable(this.type, historicBatchQueryDto.type) &&
        equalsNullable(this.completed, historicBatchQueryDto.completed) &&
        equalsNullable(this.tenantIdIn, historicBatchQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicBatchQueryDto.withoutTenantId) &&
        equalsNullable(this.sorting, historicBatchQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(batchId), hashCodeNullable(type), hashCodeNullable(completed), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricBatchQueryDto {\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `batchId` to the URL query string
    if (getBatchId() != null) {
      try {
        joiner.add(String.format("%sbatchId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completed` to the URL query string
    if (getCompleted() != null) {
      try {
        joiner.add(String.format("%scompleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

