/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricDecisionInputInstanceDto;
import org.camunda.community.rest.client.dto.HistoricDecisionOutputInstanceDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricDecisionInstanceDto
 */
@JsonPropertyOrder({
  HistoricDecisionInstanceDto.JSON_PROPERTY_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_DECISION_DEFINITION_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_DECISION_DEFINITION_KEY,
  HistoricDecisionInstanceDto.JSON_PROPERTY_DECISION_DEFINITION_NAME,
  HistoricDecisionInstanceDto.JSON_PROPERTY_EVALUATION_TIME,
  HistoricDecisionInstanceDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricDecisionInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricDecisionInstanceDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_CASE_DEFINITION_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_CASE_DEFINITION_KEY,
  HistoricDecisionInstanceDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_TENANT_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_USER_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_INPUTS,
  HistoricDecisionInstanceDto.JSON_PROPERTY_OUPUTS,
  HistoricDecisionInstanceDto.JSON_PROPERTY_COLLECT_RESULT_VALUE,
  HistoricDecisionInstanceDto.JSON_PROPERTY_ROOT_DECISION_INSTANCE_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_ID,
  HistoricDecisionInstanceDto.JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_KEY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDecisionInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_DEFINITION_ID = "decisionDefinitionId";
  private JsonNullable<String> decisionDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
  private JsonNullable<String> decisionDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_DEFINITION_NAME = "decisionDefinitionName";
  private JsonNullable<String> decisionDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EVALUATION_TIME = "evaluationTime";
  private JsonNullable<OffsetDateTime> evaluationTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_ID = "caseDefinitionId";
  private JsonNullable<String> caseDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_KEY = "caseDefinitionKey";
  private JsonNullable<String> caseDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_USER_ID = "userId";
  private JsonNullable<String> userId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INPUTS = "inputs";
  private JsonNullable<List<HistoricDecisionInputInstanceDto>> inputs = JsonNullable.<List<HistoricDecisionInputInstanceDto>>undefined();

  public static final String JSON_PROPERTY_OUPUTS = "ouputs";
  private JsonNullable<List<HistoricDecisionOutputInstanceDto>> ouputs = JsonNullable.<List<HistoricDecisionOutputInstanceDto>>undefined();

  public static final String JSON_PROPERTY_COLLECT_RESULT_VALUE = "collectResultValue";
  private JsonNullable<Double> collectResultValue = JsonNullable.<Double>undefined();

  public static final String JSON_PROPERTY_ROOT_DECISION_INSTANCE_ID = "rootDecisionInstanceId";
  private JsonNullable<String> rootDecisionInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
  private JsonNullable<String> decisionRequirementsDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
  private JsonNullable<String> decisionRequirementsDefinitionKey = JsonNullable.<String>undefined();

  public HistoricDecisionInstanceDto() {
  }

  public HistoricDecisionInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the decision instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricDecisionInstanceDto decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = JsonNullable.<String>of(decisionDefinitionId);
    
    return this;
  }

   /**
   * The id of the decision definition that this decision instance belongs to.
   * @return decisionDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionDefinitionId() {
        return decisionDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionDefinitionId_JsonNullable() {
    return decisionDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_ID)
  public void setDecisionDefinitionId_JsonNullable(JsonNullable<String> decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = JsonNullable.<String>of(decisionDefinitionId);
  }


  public HistoricDecisionInstanceDto decisionDefinitionKey(String decisionDefinitionKey) {
    this.decisionDefinitionKey = JsonNullable.<String>of(decisionDefinitionKey);
    
    return this;
  }

   /**
   * The key of the decision definition that this decision instance belongs to.
   * @return decisionDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionDefinitionKey() {
        return decisionDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionDefinitionKey_JsonNullable() {
    return decisionDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_KEY)
  public void setDecisionDefinitionKey_JsonNullable(JsonNullable<String> decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(String decisionDefinitionKey) {
    this.decisionDefinitionKey = JsonNullable.<String>of(decisionDefinitionKey);
  }


  public HistoricDecisionInstanceDto decisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = JsonNullable.<String>of(decisionDefinitionName);
    
    return this;
  }

   /**
   * The name of the decision definition that this decision instance belongs to.
   * @return decisionDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionDefinitionName() {
        return decisionDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionDefinitionName_JsonNullable() {
    return decisionDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_DEFINITION_NAME)
  public void setDecisionDefinitionName_JsonNullable(JsonNullable<String> decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = JsonNullable.<String>of(decisionDefinitionName);
  }


  public HistoricDecisionInstanceDto evaluationTime(OffsetDateTime evaluationTime) {
    this.evaluationTime = JsonNullable.<OffsetDateTime>of(evaluationTime);
    
    return this;
  }

   /**
   * The time the instance was evaluated.  [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return evaluationTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getEvaluationTime() {
        return evaluationTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EVALUATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getEvaluationTime_JsonNullable() {
    return evaluationTime;
  }
  
  @JsonProperty(JSON_PROPERTY_EVALUATION_TIME)
  public void setEvaluationTime_JsonNullable(JsonNullable<OffsetDateTime> evaluationTime) {
    this.evaluationTime = evaluationTime;
  }

  public void setEvaluationTime(OffsetDateTime evaluationTime) {
    this.evaluationTime = JsonNullable.<OffsetDateTime>of(evaluationTime);
  }


  public HistoricDecisionInstanceDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the instance should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricDecisionInstanceDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition that this decision instance belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricDecisionInstanceDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition that this decision instance belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricDecisionInstanceDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance that this decision instance belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricDecisionInstanceDto caseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
    
    return this;
  }

   /**
   * The id of the case definition that this decision instance belongs to.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionId() {
        return caseDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionId_JsonNullable() {
    return caseDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  public void setCaseDefinitionId_JsonNullable(JsonNullable<String> caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }

  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
  }


  public HistoricDecisionInstanceDto caseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
    
    return this;
  }

   /**
   * The key of the case definition that this decision instance belongs to.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionKey() {
        return caseDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionKey_JsonNullable() {
    return caseDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  public void setCaseDefinitionKey_JsonNullable(JsonNullable<String> caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }

  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
  }


  public HistoricDecisionInstanceDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The id of the case instance that this decision instance belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricDecisionInstanceDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity that this decision instance belongs to.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricDecisionInstanceDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * The id of the activity instance that this decision instance belongs to.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public HistoricDecisionInstanceDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the historic decision instance.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricDecisionInstanceDto userId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
    
    return this;
  }

   /**
   * The id of the authenticated user that has evaluated this decision instance without a process or case instance.
   * @return userId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getUserId() {
        return userId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getUserId_JsonNullable() {
    return userId;
  }
  
  @JsonProperty(JSON_PROPERTY_USER_ID)
  public void setUserId_JsonNullable(JsonNullable<String> userId) {
    this.userId = userId;
  }

  public void setUserId(String userId) {
    this.userId = JsonNullable.<String>of(userId);
  }


  public HistoricDecisionInstanceDto inputs(List<HistoricDecisionInputInstanceDto> inputs) {
    this.inputs = JsonNullable.<List<HistoricDecisionInputInstanceDto>>of(inputs);
    
    return this;
  }

  public HistoricDecisionInstanceDto addInputsItem(HistoricDecisionInputInstanceDto inputsItem) {
    if (this.inputs == null || !this.inputs.isPresent()) {
      this.inputs = JsonNullable.<List<HistoricDecisionInputInstanceDto>>of(new ArrayList<>());
    }
    try {
      this.inputs.get().add(inputsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The list of decision input values. **Only exists** if &#x60;includeInputs&#x60; was set to &#x60;true&#x60; in the query.
   * @return inputs
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricDecisionInputInstanceDto> getInputs() {
        return inputs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricDecisionInputInstanceDto>> getInputs_JsonNullable() {
    return inputs;
  }
  
  @JsonProperty(JSON_PROPERTY_INPUTS)
  public void setInputs_JsonNullable(JsonNullable<List<HistoricDecisionInputInstanceDto>> inputs) {
    this.inputs = inputs;
  }

  public void setInputs(List<HistoricDecisionInputInstanceDto> inputs) {
    this.inputs = JsonNullable.<List<HistoricDecisionInputInstanceDto>>of(inputs);
  }


  public HistoricDecisionInstanceDto ouputs(List<HistoricDecisionOutputInstanceDto> ouputs) {
    this.ouputs = JsonNullable.<List<HistoricDecisionOutputInstanceDto>>of(ouputs);
    
    return this;
  }

  public HistoricDecisionInstanceDto addOuputsItem(HistoricDecisionOutputInstanceDto ouputsItem) {
    if (this.ouputs == null || !this.ouputs.isPresent()) {
      this.ouputs = JsonNullable.<List<HistoricDecisionOutputInstanceDto>>of(new ArrayList<>());
    }
    try {
      this.ouputs.get().add(ouputsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The list of decision output values. **Only exists** if &#x60;includeOutputs&#x60; was set to &#x60;true&#x60; in the query.
   * @return ouputs
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricDecisionOutputInstanceDto> getOuputs() {
        return ouputs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OUPUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricDecisionOutputInstanceDto>> getOuputs_JsonNullable() {
    return ouputs;
  }
  
  @JsonProperty(JSON_PROPERTY_OUPUTS)
  public void setOuputs_JsonNullable(JsonNullable<List<HistoricDecisionOutputInstanceDto>> ouputs) {
    this.ouputs = ouputs;
  }

  public void setOuputs(List<HistoricDecisionOutputInstanceDto> ouputs) {
    this.ouputs = JsonNullable.<List<HistoricDecisionOutputInstanceDto>>of(ouputs);
  }


  public HistoricDecisionInstanceDto collectResultValue(Double collectResultValue) {
    this.collectResultValue = JsonNullable.<Double>of(collectResultValue);
    
    return this;
  }

   /**
   * The result of the collect aggregation of the decision result if used. &#x60;null&#x60; if no aggregation was used.
   * @return collectResultValue
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Double getCollectResultValue() {
        return collectResultValue.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COLLECT_RESULT_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Double> getCollectResultValue_JsonNullable() {
    return collectResultValue;
  }
  
  @JsonProperty(JSON_PROPERTY_COLLECT_RESULT_VALUE)
  public void setCollectResultValue_JsonNullable(JsonNullable<Double> collectResultValue) {
    this.collectResultValue = collectResultValue;
  }

  public void setCollectResultValue(Double collectResultValue) {
    this.collectResultValue = JsonNullable.<Double>of(collectResultValue);
  }


  public HistoricDecisionInstanceDto rootDecisionInstanceId(String rootDecisionInstanceId) {
    this.rootDecisionInstanceId = JsonNullable.<String>of(rootDecisionInstanceId);
    
    return this;
  }

   /**
   * The decision instance id of the evaluated root decision. Can be &#x60;null&#x60; if this instance is the root decision instance of the evaluation.
   * @return rootDecisionInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootDecisionInstanceId() {
        return rootDecisionInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_DECISION_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootDecisionInstanceId_JsonNullable() {
    return rootDecisionInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_DECISION_INSTANCE_ID)
  public void setRootDecisionInstanceId_JsonNullable(JsonNullable<String> rootDecisionInstanceId) {
    this.rootDecisionInstanceId = rootDecisionInstanceId;
  }

  public void setRootDecisionInstanceId(String rootDecisionInstanceId) {
    this.rootDecisionInstanceId = JsonNullable.<String>of(rootDecisionInstanceId);
  }


  public HistoricDecisionInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the evaluation of this decision. Can be &#x60;null&#x60; if this decision instance is not evaluated as part of a BPMN process.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }


  public HistoricDecisionInstanceDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    this.decisionRequirementsDefinitionId = JsonNullable.<String>of(decisionRequirementsDefinitionId);
    
    return this;
  }

   /**
   * The id of the decision requirements definition that this decision instance belongs to.
   * @return decisionRequirementsDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionRequirementsDefinitionId() {
        return decisionRequirementsDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionRequirementsDefinitionId_JsonNullable() {
    return decisionRequirementsDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_ID)
  public void setDecisionRequirementsDefinitionId_JsonNullable(JsonNullable<String> decisionRequirementsDefinitionId) {
    this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
  }

  public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    this.decisionRequirementsDefinitionId = JsonNullable.<String>of(decisionRequirementsDefinitionId);
  }


  public HistoricDecisionInstanceDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    this.decisionRequirementsDefinitionKey = JsonNullable.<String>of(decisionRequirementsDefinitionKey);
    
    return this;
  }

   /**
   * The key of the decision requirements definition that this decision instance belongs to.
   * @return decisionRequirementsDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionRequirementsDefinitionKey() {
        return decisionRequirementsDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionRequirementsDefinitionKey_JsonNullable() {
    return decisionRequirementsDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_REQUIREMENTS_DEFINITION_KEY)
  public void setDecisionRequirementsDefinitionKey_JsonNullable(JsonNullable<String> decisionRequirementsDefinitionKey) {
    this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
  }

  public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    this.decisionRequirementsDefinitionKey = JsonNullable.<String>of(decisionRequirementsDefinitionKey);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricDecisionInstanceDto historicDecisionInstanceDto = (HistoricDecisionInstanceDto) o;
    return equalsNullable(this.id, historicDecisionInstanceDto.id) &&
        equalsNullable(this.decisionDefinitionId, historicDecisionInstanceDto.decisionDefinitionId) &&
        equalsNullable(this.decisionDefinitionKey, historicDecisionInstanceDto.decisionDefinitionKey) &&
        equalsNullable(this.decisionDefinitionName, historicDecisionInstanceDto.decisionDefinitionName) &&
        equalsNullable(this.evaluationTime, historicDecisionInstanceDto.evaluationTime) &&
        equalsNullable(this.removalTime, historicDecisionInstanceDto.removalTime) &&
        equalsNullable(this.processDefinitionId, historicDecisionInstanceDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicDecisionInstanceDto.processDefinitionKey) &&
        equalsNullable(this.processInstanceId, historicDecisionInstanceDto.processInstanceId) &&
        equalsNullable(this.caseDefinitionId, historicDecisionInstanceDto.caseDefinitionId) &&
        equalsNullable(this.caseDefinitionKey, historicDecisionInstanceDto.caseDefinitionKey) &&
        equalsNullable(this.caseInstanceId, historicDecisionInstanceDto.caseInstanceId) &&
        equalsNullable(this.activityId, historicDecisionInstanceDto.activityId) &&
        equalsNullable(this.activityInstanceId, historicDecisionInstanceDto.activityInstanceId) &&
        equalsNullable(this.tenantId, historicDecisionInstanceDto.tenantId) &&
        equalsNullable(this.userId, historicDecisionInstanceDto.userId) &&
        equalsNullable(this.inputs, historicDecisionInstanceDto.inputs) &&
        equalsNullable(this.ouputs, historicDecisionInstanceDto.ouputs) &&
        equalsNullable(this.collectResultValue, historicDecisionInstanceDto.collectResultValue) &&
        equalsNullable(this.rootDecisionInstanceId, historicDecisionInstanceDto.rootDecisionInstanceId) &&
        equalsNullable(this.rootProcessInstanceId, historicDecisionInstanceDto.rootProcessInstanceId) &&
        equalsNullable(this.decisionRequirementsDefinitionId, historicDecisionInstanceDto.decisionRequirementsDefinitionId) &&
        equalsNullable(this.decisionRequirementsDefinitionKey, historicDecisionInstanceDto.decisionRequirementsDefinitionKey);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(decisionDefinitionId), hashCodeNullable(decisionDefinitionKey), hashCodeNullable(decisionDefinitionName), hashCodeNullable(evaluationTime), hashCodeNullable(removalTime), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processInstanceId), hashCodeNullable(caseDefinitionId), hashCodeNullable(caseDefinitionKey), hashCodeNullable(caseInstanceId), hashCodeNullable(activityId), hashCodeNullable(activityInstanceId), hashCodeNullable(tenantId), hashCodeNullable(userId), hashCodeNullable(inputs), hashCodeNullable(ouputs), hashCodeNullable(collectResultValue), hashCodeNullable(rootDecisionInstanceId), hashCodeNullable(rootProcessInstanceId), hashCodeNullable(decisionRequirementsDefinitionId), hashCodeNullable(decisionRequirementsDefinitionKey));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricDecisionInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    evaluationTime: ").append(toIndentedString(evaluationTime)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    ouputs: ").append(toIndentedString(ouputs)).append("\n");
    sb.append("    collectResultValue: ").append(toIndentedString(collectResultValue)).append("\n");
    sb.append("    rootDecisionInstanceId: ").append(toIndentedString(rootDecisionInstanceId)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    decisionRequirementsDefinitionId: ").append(toIndentedString(decisionRequirementsDefinitionId)).append("\n");
    sb.append("    decisionRequirementsDefinitionKey: ").append(toIndentedString(decisionRequirementsDefinitionKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionId` to the URL query string
    if (getDecisionDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionKey` to the URL query string
    if (getDecisionDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionDefinitionName` to the URL query string
    if (getDecisionDefinitionName() != null) {
      try {
        joiner.add(String.format("%sdecisionDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `evaluationTime` to the URL query string
    if (getEvaluationTime() != null) {
      try {
        joiner.add(String.format("%sevaluationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvaluationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionId` to the URL query string
    if (getCaseDefinitionId() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionKey` to the URL query string
    if (getCaseDefinitionKey() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `userId` to the URL query string
    if (getUserId() != null) {
      try {
        joiner.add(String.format("%suserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUserId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `inputs` to the URL query string
    if (getInputs() != null) {
      for (int i = 0; i < getInputs().size(); i++) {
        if (getInputs().get(i) != null) {
          joiner.add(getInputs().get(i).toUrlQueryString(String.format("%sinputs%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `ouputs` to the URL query string
    if (getOuputs() != null) {
      for (int i = 0; i < getOuputs().size(); i++) {
        if (getOuputs().get(i) != null) {
          joiner.add(getOuputs().get(i).toUrlQueryString(String.format("%souputs%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `collectResultValue` to the URL query string
    if (getCollectResultValue() != null) {
      try {
        joiner.add(String.format("%scollectResultValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCollectResultValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootDecisionInstanceId` to the URL query string
    if (getRootDecisionInstanceId() != null) {
      try {
        joiner.add(String.format("%srootDecisionInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootDecisionInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsDefinitionId` to the URL query string
    if (getDecisionRequirementsDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionRequirementsDefinitionKey` to the URL query string
    if (getDecisionRequirementsDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sdecisionRequirementsDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionRequirementsDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

