/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricDecisionOutputInstanceDto
 */
@JsonPropertyOrder({
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_ID,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_DECISION_INSTANCE_ID,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_CLAUSE_ID,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_CLAUSE_NAME,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_RULE_ID,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_RULE_ORDER,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_ERROR_MESSAGE,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_VARIABLE_NAME,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_TYPE,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_CREATE_TIME,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_VALUE,
  HistoricDecisionOutputInstanceDto.JSON_PROPERTY_VALUE_INFO
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDecisionOutputInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DECISION_INSTANCE_ID = "decisionInstanceId";
  private JsonNullable<String> decisionInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CLAUSE_ID = "clauseId";
  private JsonNullable<String> clauseId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CLAUSE_NAME = "clauseName";
  private JsonNullable<String> clauseName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RULE_ID = "ruleId";
  private JsonNullable<String> ruleId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RULE_ORDER = "ruleOrder";
  private JsonNullable<Integer> ruleOrder = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private JsonNullable<String> errorMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAME = "variableName";
  private JsonNullable<String> variableName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TYPE = "type";
  private JsonNullable<String> type = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATE_TIME = "createTime";
  private JsonNullable<OffsetDateTime> createTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VALUE = "value";
  private Object value;

  public static final String JSON_PROPERTY_VALUE_INFO = "valueInfo";
  private Map<String, Object> valueInfo = new HashMap<>();

  public HistoricDecisionOutputInstanceDto() {
  }

  public HistoricDecisionOutputInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the decision output value.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricDecisionOutputInstanceDto decisionInstanceId(String decisionInstanceId) {
    this.decisionInstanceId = JsonNullable.<String>of(decisionInstanceId);
    
    return this;
  }

   /**
   * The id of the decision instance the output value belongs to.
   * @return decisionInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDecisionInstanceId() {
        return decisionInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDecisionInstanceId_JsonNullable() {
    return decisionInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_DECISION_INSTANCE_ID)
  public void setDecisionInstanceId_JsonNullable(JsonNullable<String> decisionInstanceId) {
    this.decisionInstanceId = decisionInstanceId;
  }

  public void setDecisionInstanceId(String decisionInstanceId) {
    this.decisionInstanceId = JsonNullable.<String>of(decisionInstanceId);
  }


  public HistoricDecisionOutputInstanceDto clauseId(String clauseId) {
    this.clauseId = JsonNullable.<String>of(clauseId);
    
    return this;
  }

   /**
   * The id of the clause the output value belongs to.
   * @return clauseId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getClauseId() {
        return clauseId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CLAUSE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getClauseId_JsonNullable() {
    return clauseId;
  }
  
  @JsonProperty(JSON_PROPERTY_CLAUSE_ID)
  public void setClauseId_JsonNullable(JsonNullable<String> clauseId) {
    this.clauseId = clauseId;
  }

  public void setClauseId(String clauseId) {
    this.clauseId = JsonNullable.<String>of(clauseId);
  }


  public HistoricDecisionOutputInstanceDto clauseName(String clauseName) {
    this.clauseName = JsonNullable.<String>of(clauseName);
    
    return this;
  }

   /**
   * The name of the clause the output value belongs to.
   * @return clauseName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getClauseName() {
        return clauseName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CLAUSE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getClauseName_JsonNullable() {
    return clauseName;
  }
  
  @JsonProperty(JSON_PROPERTY_CLAUSE_NAME)
  public void setClauseName_JsonNullable(JsonNullable<String> clauseName) {
    this.clauseName = clauseName;
  }

  public void setClauseName(String clauseName) {
    this.clauseName = JsonNullable.<String>of(clauseName);
  }


  public HistoricDecisionOutputInstanceDto ruleId(String ruleId) {
    this.ruleId = JsonNullable.<String>of(ruleId);
    
    return this;
  }

   /**
   * The id of the rule the output value belongs to.
   * @return ruleId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRuleId() {
        return ruleId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RULE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRuleId_JsonNullable() {
    return ruleId;
  }
  
  @JsonProperty(JSON_PROPERTY_RULE_ID)
  public void setRuleId_JsonNullable(JsonNullable<String> ruleId) {
    this.ruleId = ruleId;
  }

  public void setRuleId(String ruleId) {
    this.ruleId = JsonNullable.<String>of(ruleId);
  }


  public HistoricDecisionOutputInstanceDto ruleOrder(Integer ruleOrder) {
    this.ruleOrder = JsonNullable.<Integer>of(ruleOrder);
    
    return this;
  }

   /**
   * The order of the rule the output value belongs to.
   * @return ruleOrder
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getRuleOrder() {
        return ruleOrder.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RULE_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getRuleOrder_JsonNullable() {
    return ruleOrder;
  }
  
  @JsonProperty(JSON_PROPERTY_RULE_ORDER)
  public void setRuleOrder_JsonNullable(JsonNullable<Integer> ruleOrder) {
    this.ruleOrder = ruleOrder;
  }

  public void setRuleOrder(Integer ruleOrder) {
    this.ruleOrder = JsonNullable.<Integer>of(ruleOrder);
  }


  public HistoricDecisionOutputInstanceDto errorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
    
    return this;
  }

   /**
   * An error message in case a Java Serialized Object could not be de-serialized.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorMessage() {
        return errorMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorMessage_JsonNullable() {
    return errorMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
    this.errorMessage = errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
  }


  public HistoricDecisionOutputInstanceDto variableName(String variableName) {
    this.variableName = JsonNullable.<String>of(variableName);
    
    return this;
  }

   /**
   * The name of the output variable.
   * @return variableName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getVariableName() {
        return variableName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVariableName_JsonNullable() {
    return variableName;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
  public void setVariableName_JsonNullable(JsonNullable<String> variableName) {
    this.variableName = variableName;
  }

  public void setVariableName(String variableName) {
    this.variableName = JsonNullable.<String>of(variableName);
  }


  public HistoricDecisionOutputInstanceDto type(String type) {
    this.type = JsonNullable.<String>of(type);
    
    return this;
  }

   /**
   * The value type of the variable.
   * @return type
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getType() {
        return type.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getType_JsonNullable() {
    return type;
  }
  
  @JsonProperty(JSON_PROPERTY_TYPE)
  public void setType_JsonNullable(JsonNullable<String> type) {
    this.type = type;
  }

  public void setType(String type) {
    this.type = JsonNullable.<String>of(type);
  }


  public HistoricDecisionOutputInstanceDto createTime(OffsetDateTime createTime) {
    this.createTime = JsonNullable.<OffsetDateTime>of(createTime);
    
    return this;
  }

   /**
   * The time the variable was inserted.  [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return createTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreateTime() {
        return createTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreateTime_JsonNullable() {
    return createTime;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATE_TIME)
  public void setCreateTime_JsonNullable(JsonNullable<OffsetDateTime> createTime) {
    this.createTime = createTime;
  }

  public void setCreateTime(OffsetDateTime createTime) {
    this.createTime = JsonNullable.<OffsetDateTime>of(createTime);
  }


  public HistoricDecisionOutputInstanceDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the entry should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricDecisionOutputInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this entry.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }


  public HistoricDecisionOutputInstanceDto value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * The variable&#39;s value. Value differs depending on the variable&#39;s type and on the &#x60;disableCustomObjectDeserialization&#x60; parameter.
   * @return value
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(Object value) {
    this.value = value;
  }


  public HistoricDecisionOutputInstanceDto valueInfo(Map<String, Object> valueInfo) {
    
    this.valueInfo = valueInfo;
    return this;
  }

  public HistoricDecisionOutputInstanceDto putValueInfoItem(String key, Object valueInfoItem) {
    if (this.valueInfo == null) {
      this.valueInfo = new HashMap<>();
    }
    this.valueInfo.put(key, valueInfoItem);
    return this;
  }

   /**
   * A JSON object containing additional, value-type-dependent properties.  For variables of type &#x60;Object&#x60;, the following properties are returned:  * &#x60;objectTypeName&#x60;: A string representation of the object&#39;s type name.  * &#x60;serializationDataFormat&#x60;: The serialization format used to store the variable.
   * @return valueInfo
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE_INFO)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getValueInfo() {
    return valueInfo;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_INFO)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueInfo(Map<String, Object> valueInfo) {
    this.valueInfo = valueInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricDecisionOutputInstanceDto historicDecisionOutputInstanceDto = (HistoricDecisionOutputInstanceDto) o;
    return equalsNullable(this.id, historicDecisionOutputInstanceDto.id) &&
        equalsNullable(this.decisionInstanceId, historicDecisionOutputInstanceDto.decisionInstanceId) &&
        equalsNullable(this.clauseId, historicDecisionOutputInstanceDto.clauseId) &&
        equalsNullable(this.clauseName, historicDecisionOutputInstanceDto.clauseName) &&
        equalsNullable(this.ruleId, historicDecisionOutputInstanceDto.ruleId) &&
        equalsNullable(this.ruleOrder, historicDecisionOutputInstanceDto.ruleOrder) &&
        equalsNullable(this.errorMessage, historicDecisionOutputInstanceDto.errorMessage) &&
        equalsNullable(this.variableName, historicDecisionOutputInstanceDto.variableName) &&
        equalsNullable(this.type, historicDecisionOutputInstanceDto.type) &&
        equalsNullable(this.createTime, historicDecisionOutputInstanceDto.createTime) &&
        equalsNullable(this.removalTime, historicDecisionOutputInstanceDto.removalTime) &&
        equalsNullable(this.rootProcessInstanceId, historicDecisionOutputInstanceDto.rootProcessInstanceId) &&
        Objects.equals(this.value, historicDecisionOutputInstanceDto.value) &&
        Objects.equals(this.valueInfo, historicDecisionOutputInstanceDto.valueInfo);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(decisionInstanceId), hashCodeNullable(clauseId), hashCodeNullable(clauseName), hashCodeNullable(ruleId), hashCodeNullable(ruleOrder), hashCodeNullable(errorMessage), hashCodeNullable(variableName), hashCodeNullable(type), hashCodeNullable(createTime), hashCodeNullable(removalTime), hashCodeNullable(rootProcessInstanceId), value, valueInfo);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricDecisionOutputInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    decisionInstanceId: ").append(toIndentedString(decisionInstanceId)).append("\n");
    sb.append("    clauseId: ").append(toIndentedString(clauseId)).append("\n");
    sb.append("    clauseName: ").append(toIndentedString(clauseName)).append("\n");
    sb.append("    ruleId: ").append(toIndentedString(ruleId)).append("\n");
    sb.append("    ruleOrder: ").append(toIndentedString(ruleOrder)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    variableName: ").append(toIndentedString(variableName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    valueInfo: ").append(toIndentedString(valueInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `decisionInstanceId` to the URL query string
    if (getDecisionInstanceId() != null) {
      try {
        joiner.add(String.format("%sdecisionInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDecisionInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `clauseId` to the URL query string
    if (getClauseId() != null) {
      try {
        joiner.add(String.format("%sclauseId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getClauseId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `clauseName` to the URL query string
    if (getClauseName() != null) {
      try {
        joiner.add(String.format("%sclauseName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getClauseName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ruleId` to the URL query string
    if (getRuleId() != null) {
      try {
        joiner.add(String.format("%sruleId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRuleId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ruleOrder` to the URL query string
    if (getRuleOrder() != null) {
      try {
        joiner.add(String.format("%sruleOrder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRuleOrder()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableName` to the URL query string
    if (getVariableName() != null) {
      try {
        joiner.add(String.format("%svariableName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createTime` to the URL query string
    if (getCreateTime() != null) {
      try {
        joiner.add(String.format("%screateTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreateTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      try {
        joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `valueInfo` to the URL query string
    if (getValueInfo() != null) {
      for (String _key : getValueInfo().keySet()) {
        try {
          joiner.add(String.format("%svalueInfo%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getValueInfo().get(_key), URLEncoder.encode(String.valueOf(getValueInfo().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

