/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricDetailQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A historic detail query which defines a group of historic details.
 */
@JsonPropertyOrder({
  HistoricDetailQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID_IN,
  HistoricDetailQueryDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_TASK_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_CASE_EXECUTION_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_VARIABLE_INSTANCE_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_VARIABLE_TYPE_IN,
  HistoricDetailQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricDetailQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_USER_OPERATION_ID,
  HistoricDetailQueryDto.JSON_PROPERTY_FORM_FIELDS,
  HistoricDetailQueryDto.JSON_PROPERTY_VARIABLE_UPDATES,
  HistoricDetailQueryDto.JSON_PROPERTY_EXCLUDE_TASK_DETAILS,
  HistoricDetailQueryDto.JSON_PROPERTY_INITIAL,
  HistoricDetailQueryDto.JSON_PROPERTY_OCCURRED_BEFORE,
  HistoricDetailQueryDto.JSON_PROPERTY_OCCURRED_AFTER,
  HistoricDetailQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricDetailQueryDto {
  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
  private JsonNullable<List<String>> processInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ID = "taskId";
  private JsonNullable<String> taskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID = "caseExecutionId";
  private JsonNullable<String> caseExecutionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLE_INSTANCE_ID = "variableInstanceId";
  private JsonNullable<String> variableInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLE_TYPE_IN = "variableTypeIn";
  private JsonNullable<List<String>> variableTypeIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_USER_OPERATION_ID = "userOperationId";
  private JsonNullable<String> userOperationId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FORM_FIELDS = "formFields";
  private JsonNullable<Boolean> formFields = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_UPDATES = "variableUpdates";
  private JsonNullable<Boolean> variableUpdates = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXCLUDE_TASK_DETAILS = "excludeTaskDetails";
  private JsonNullable<Boolean> excludeTaskDetails = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INITIAL = "initial";
  private JsonNullable<Boolean> initial = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_OCCURRED_BEFORE = "occurredBefore";
  private JsonNullable<OffsetDateTime> occurredBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_OCCURRED_AFTER = "occurredAfter";
  private JsonNullable<OffsetDateTime> occurredAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricDetailQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricDetailQueryDtoSortingInner>>undefined();

  public HistoricDetailQueryDto() {
  }

  public HistoricDetailQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricDetailQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
    
    return this;
  }

  public HistoricDetailQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
    if (this.processInstanceIdIn == null || !this.processInstanceIdIn.isPresent()) {
      this.processInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIdIn.get().add(processInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic details which belong to one of the passed  process instance ids.
   * @return processInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIdIn() {
        return processInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIdIn_JsonNullable() {
    return processInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  public void setProcessInstanceIdIn_JsonNullable(JsonNullable<List<String>> processInstanceIdIn) {
    this.processInstanceIdIn = processInstanceIdIn;
  }

  public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
  }


  public HistoricDetailQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Filter by execution id.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricDetailQueryDto taskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
    
    return this;
  }

   /**
   * Filter by task id.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskId() {
        return taskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskId_JsonNullable() {
    return taskId;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID)
  public void setTaskId_JsonNullable(JsonNullable<String> taskId) {
    this.taskId = taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
  }


  public HistoricDetailQueryDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * Filter by activity instance id.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public HistoricDetailQueryDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * Filter by case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricDetailQueryDto caseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
    
    return this;
  }

   /**
   * Filter by case execution id.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseExecutionId() {
        return caseExecutionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseExecutionId_JsonNullable() {
    return caseExecutionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  public void setCaseExecutionId_JsonNullable(JsonNullable<String> caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }

  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
  }


  public HistoricDetailQueryDto variableInstanceId(String variableInstanceId) {
    this.variableInstanceId = JsonNullable.<String>of(variableInstanceId);
    
    return this;
  }

   /**
   * Filter by variable instance id.
   * @return variableInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getVariableInstanceId() {
        return variableInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVariableInstanceId_JsonNullable() {
    return variableInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_INSTANCE_ID)
  public void setVariableInstanceId_JsonNullable(JsonNullable<String> variableInstanceId) {
    this.variableInstanceId = variableInstanceId;
  }

  public void setVariableInstanceId(String variableInstanceId) {
    this.variableInstanceId = JsonNullable.<String>of(variableInstanceId);
  }


  public HistoricDetailQueryDto variableTypeIn(List<String> variableTypeIn) {
    this.variableTypeIn = JsonNullable.<List<String>>of(variableTypeIn);
    
    return this;
  }

  public HistoricDetailQueryDto addVariableTypeInItem(String variableTypeInItem) {
    if (this.variableTypeIn == null || !this.variableTypeIn.isPresent()) {
      this.variableTypeIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.variableTypeIn.get().add(variableTypeInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;.
   * @return variableTypeIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getVariableTypeIn() {
        return variableTypeIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_TYPE_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getVariableTypeIn_JsonNullable() {
    return variableTypeIn;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_TYPE_IN)
  public void setVariableTypeIn_JsonNullable(JsonNullable<List<String>> variableTypeIn) {
    this.variableTypeIn = variableTypeIn;
  }

  public void setVariableTypeIn(List<String> variableTypeIn) {
    this.variableTypeIn = JsonNullable.<List<String>>of(variableTypeIn);
  }


  public HistoricDetailQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricDetailQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a  list of tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricDetailQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricDetailQueryDto userOperationId(String userOperationId) {
    this.userOperationId = JsonNullable.<String>of(userOperationId);
    
    return this;
  }

   /**
   * Filter by a user operation id.
   * @return userOperationId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getUserOperationId() {
        return userOperationId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_USER_OPERATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getUserOperationId_JsonNullable() {
    return userOperationId;
  }
  
  @JsonProperty(JSON_PROPERTY_USER_OPERATION_ID)
  public void setUserOperationId_JsonNullable(JsonNullable<String> userOperationId) {
    this.userOperationId = userOperationId;
  }

  public void setUserOperationId(String userOperationId) {
    this.userOperationId = JsonNullable.<String>of(userOperationId);
  }


  public HistoricDetailQueryDto formFields(Boolean formFields) {
    this.formFields = JsonNullable.<Boolean>of(formFields);
    
    return this;
  }

   /**
   * Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return formFields
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFormFields() {
        return formFields.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FORM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFormFields_JsonNullable() {
    return formFields;
  }
  
  @JsonProperty(JSON_PROPERTY_FORM_FIELDS)
  public void setFormFields_JsonNullable(JsonNullable<Boolean> formFields) {
    this.formFields = formFields;
  }

  public void setFormFields(Boolean formFields) {
    this.formFields = JsonNullable.<Boolean>of(formFields);
  }


  public HistoricDetailQueryDto variableUpdates(Boolean variableUpdates) {
    this.variableUpdates = JsonNullable.<Boolean>of(variableUpdates);
    
    return this;
  }

   /**
   * Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return variableUpdates
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableUpdates() {
        return variableUpdates.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_UPDATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableUpdates_JsonNullable() {
    return variableUpdates;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_UPDATES)
  public void setVariableUpdates_JsonNullable(JsonNullable<Boolean> variableUpdates) {
    this.variableUpdates = variableUpdates;
  }

  public void setVariableUpdates(Boolean variableUpdates) {
    this.variableUpdates = JsonNullable.<Boolean>of(variableUpdates);
  }


  public HistoricDetailQueryDto excludeTaskDetails(Boolean excludeTaskDetails) {
    this.excludeTaskDetails = JsonNullable.<Boolean>of(excludeTaskDetails);
    
    return this;
  }

   /**
   * Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return excludeTaskDetails
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getExcludeTaskDetails() {
        return excludeTaskDetails.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXCLUDE_TASK_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getExcludeTaskDetails_JsonNullable() {
    return excludeTaskDetails;
  }
  
  @JsonProperty(JSON_PROPERTY_EXCLUDE_TASK_DETAILS)
  public void setExcludeTaskDetails_JsonNullable(JsonNullable<Boolean> excludeTaskDetails) {
    this.excludeTaskDetails = excludeTaskDetails;
  }

  public void setExcludeTaskDetails(Boolean excludeTaskDetails) {
    this.excludeTaskDetails = JsonNullable.<Boolean>of(excludeTaskDetails);
  }


  public HistoricDetailQueryDto initial(Boolean initial) {
    this.initial = JsonNullable.<Boolean>of(initial);
    
    return this;
  }

   /**
   * Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return initial
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getInitial() {
        return initial.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INITIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getInitial_JsonNullable() {
    return initial;
  }
  
  @JsonProperty(JSON_PROPERTY_INITIAL)
  public void setInitial_JsonNullable(JsonNullable<Boolean> initial) {
    this.initial = initial;
  }

  public void setInitial(Boolean initial) {
    this.initial = JsonNullable.<Boolean>of(initial);
  }


  public HistoricDetailQueryDto occurredBefore(OffsetDateTime occurredBefore) {
    this.occurredBefore = JsonNullable.<OffsetDateTime>of(occurredBefore);
    
    return this;
  }

   /**
   * Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200.
   * @return occurredBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getOccurredBefore() {
        return occurredBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OCCURRED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getOccurredBefore_JsonNullable() {
    return occurredBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_OCCURRED_BEFORE)
  public void setOccurredBefore_JsonNullable(JsonNullable<OffsetDateTime> occurredBefore) {
    this.occurredBefore = occurredBefore;
  }

  public void setOccurredBefore(OffsetDateTime occurredBefore) {
    this.occurredBefore = JsonNullable.<OffsetDateTime>of(occurredBefore);
  }


  public HistoricDetailQueryDto occurredAfter(OffsetDateTime occurredAfter) {
    this.occurredAfter = JsonNullable.<OffsetDateTime>of(occurredAfter);
    
    return this;
  }

   /**
   * Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200.
   * @return occurredAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getOccurredAfter() {
        return occurredAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OCCURRED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getOccurredAfter_JsonNullable() {
    return occurredAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_OCCURRED_AFTER)
  public void setOccurredAfter_JsonNullable(JsonNullable<OffsetDateTime> occurredAfter) {
    this.occurredAfter = occurredAfter;
  }

  public void setOccurredAfter(OffsetDateTime occurredAfter) {
    this.occurredAfter = JsonNullable.<OffsetDateTime>of(occurredAfter);
  }


  public HistoricDetailQueryDto sorting(List<HistoricDetailQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricDetailQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricDetailQueryDto addSortingItem(HistoricDetailQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricDetailQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the &#x60;count&#x60; endpoint.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricDetailQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricDetailQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricDetailQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricDetailQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricDetailQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricDetailQueryDto historicDetailQueryDto = (HistoricDetailQueryDto) o;
    return equalsNullable(this.processInstanceId, historicDetailQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIdIn, historicDetailQueryDto.processInstanceIdIn) &&
        equalsNullable(this.executionId, historicDetailQueryDto.executionId) &&
        equalsNullable(this.taskId, historicDetailQueryDto.taskId) &&
        equalsNullable(this.activityInstanceId, historicDetailQueryDto.activityInstanceId) &&
        equalsNullable(this.caseInstanceId, historicDetailQueryDto.caseInstanceId) &&
        equalsNullable(this.caseExecutionId, historicDetailQueryDto.caseExecutionId) &&
        equalsNullable(this.variableInstanceId, historicDetailQueryDto.variableInstanceId) &&
        equalsNullable(this.variableTypeIn, historicDetailQueryDto.variableTypeIn) &&
        equalsNullable(this.tenantIdIn, historicDetailQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicDetailQueryDto.withoutTenantId) &&
        equalsNullable(this.userOperationId, historicDetailQueryDto.userOperationId) &&
        equalsNullable(this.formFields, historicDetailQueryDto.formFields) &&
        equalsNullable(this.variableUpdates, historicDetailQueryDto.variableUpdates) &&
        equalsNullable(this.excludeTaskDetails, historicDetailQueryDto.excludeTaskDetails) &&
        equalsNullable(this.initial, historicDetailQueryDto.initial) &&
        equalsNullable(this.occurredBefore, historicDetailQueryDto.occurredBefore) &&
        equalsNullable(this.occurredAfter, historicDetailQueryDto.occurredAfter) &&
        equalsNullable(this.sorting, historicDetailQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIdIn), hashCodeNullable(executionId), hashCodeNullable(taskId), hashCodeNullable(activityInstanceId), hashCodeNullable(caseInstanceId), hashCodeNullable(caseExecutionId), hashCodeNullable(variableInstanceId), hashCodeNullable(variableTypeIn), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(userOperationId), hashCodeNullable(formFields), hashCodeNullable(variableUpdates), hashCodeNullable(excludeTaskDetails), hashCodeNullable(initial), hashCodeNullable(occurredBefore), hashCodeNullable(occurredAfter), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricDetailQueryDto {\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIdIn: ").append(toIndentedString(processInstanceIdIn)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    variableInstanceId: ").append(toIndentedString(variableInstanceId)).append("\n");
    sb.append("    variableTypeIn: ").append(toIndentedString(variableTypeIn)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    userOperationId: ").append(toIndentedString(userOperationId)).append("\n");
    sb.append("    formFields: ").append(toIndentedString(formFields)).append("\n");
    sb.append("    variableUpdates: ").append(toIndentedString(variableUpdates)).append("\n");
    sb.append("    excludeTaskDetails: ").append(toIndentedString(excludeTaskDetails)).append("\n");
    sb.append("    initial: ").append(toIndentedString(initial)).append("\n");
    sb.append("    occurredBefore: ").append(toIndentedString(occurredBefore)).append("\n");
    sb.append("    occurredAfter: ").append(toIndentedString(occurredAfter)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIdIn` to the URL query string
    if (getProcessInstanceIdIn() != null) {
      for (int i = 0; i < getProcessInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskId` to the URL query string
    if (getTaskId() != null) {
      try {
        joiner.add(String.format("%staskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionId` to the URL query string
    if (getCaseExecutionId() != null) {
      try {
        joiner.add(String.format("%scaseExecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableInstanceId` to the URL query string
    if (getVariableInstanceId() != null) {
      try {
        joiner.add(String.format("%svariableInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableTypeIn` to the URL query string
    if (getVariableTypeIn() != null) {
      for (int i = 0; i < getVariableTypeIn().size(); i++) {
        try {
          joiner.add(String.format("%svariableTypeIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getVariableTypeIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `userOperationId` to the URL query string
    if (getUserOperationId() != null) {
      try {
        joiner.add(String.format("%suserOperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUserOperationId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `formFields` to the URL query string
    if (getFormFields() != null) {
      try {
        joiner.add(String.format("%sformFields%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFormFields()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableUpdates` to the URL query string
    if (getVariableUpdates() != null) {
      try {
        joiner.add(String.format("%svariableUpdates%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableUpdates()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `excludeTaskDetails` to the URL query string
    if (getExcludeTaskDetails() != null) {
      try {
        joiner.add(String.format("%sexcludeTaskDetails%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExcludeTaskDetails()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `initial` to the URL query string
    if (getInitial() != null) {
      try {
        joiner.add(String.format("%sinitial%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInitial()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `occurredBefore` to the URL query string
    if (getOccurredBefore() != null) {
      try {
        joiner.add(String.format("%soccurredBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOccurredBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `occurredAfter` to the URL query string
    if (getOccurredAfter() != null) {
      try {
        joiner.add(String.format("%soccurredAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOccurredAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

