/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricExternalTaskLogDto
 */
@JsonPropertyOrder({
  HistoricExternalTaskLogDto.JSON_PROPERTY_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_EXTERNAL_TASK_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_TIMESTAMP,
  HistoricExternalTaskLogDto.JSON_PROPERTY_TOPIC_NAME,
  HistoricExternalTaskLogDto.JSON_PROPERTY_WORKER_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_RETRIES,
  HistoricExternalTaskLogDto.JSON_PROPERTY_PRIORITY,
  HistoricExternalTaskLogDto.JSON_PROPERTY_ERROR_MESSAGE,
  HistoricExternalTaskLogDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricExternalTaskLogDto.JSON_PROPERTY_TENANT_ID,
  HistoricExternalTaskLogDto.JSON_PROPERTY_CREATION_LOG,
  HistoricExternalTaskLogDto.JSON_PROPERTY_FAILURE_LOG,
  HistoricExternalTaskLogDto.JSON_PROPERTY_SUCCESS_LOG,
  HistoricExternalTaskLogDto.JSON_PROPERTY_DELETION_LOG,
  HistoricExternalTaskLogDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricExternalTaskLogDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricExternalTaskLogDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXTERNAL_TASK_ID = "externalTaskId";
  private JsonNullable<String> externalTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private JsonNullable<OffsetDateTime> timestamp = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TOPIC_NAME = "topicName";
  private JsonNullable<String> topicName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private JsonNullable<String> workerId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private JsonNullable<Integer> retries = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Long> priority = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private JsonNullable<String> errorMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATION_LOG = "creationLog";
  private JsonNullable<Boolean> creationLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FAILURE_LOG = "failureLog";
  private JsonNullable<Boolean> failureLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUCCESS_LOG = "successLog";
  private JsonNullable<Boolean> successLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DELETION_LOG = "deletionLog";
  private JsonNullable<Boolean> deletionLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public HistoricExternalTaskLogDto() {
  }

  public HistoricExternalTaskLogDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the log entry.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricExternalTaskLogDto externalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
    
    return this;
  }

   /**
   * The id of the external task.
   * @return externalTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExternalTaskId() {
        return externalTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExternalTaskId_JsonNullable() {
    return externalTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  public void setExternalTaskId_JsonNullable(JsonNullable<String> externalTaskId) {
    this.externalTaskId = externalTaskId;
  }

  public void setExternalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
  }


  public HistoricExternalTaskLogDto timestamp(OffsetDateTime timestamp) {
    this.timestamp = JsonNullable.<OffsetDateTime>of(timestamp);
    
    return this;
  }

   /**
   * The time when the log entry has been written.
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTimestamp() {
        return timestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTimestamp_JsonNullable() {
    return timestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  public void setTimestamp_JsonNullable(JsonNullable<OffsetDateTime> timestamp) {
    this.timestamp = timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = JsonNullable.<OffsetDateTime>of(timestamp);
  }


  public HistoricExternalTaskLogDto topicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
    
    return this;
  }

   /**
   * The topic name of the associated external task.
   * @return topicName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTopicName() {
        return topicName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTopicName_JsonNullable() {
    return topicName;
  }
  
  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  public void setTopicName_JsonNullable(JsonNullable<String> topicName) {
    this.topicName = topicName;
  }

  public void setTopicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
  }


  public HistoricExternalTaskLogDto workerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
    
    return this;
  }

   /**
   * The id of the worker that posessed the most recent lock.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getWorkerId() {
        return workerId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getWorkerId_JsonNullable() {
    return workerId;
  }
  
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  public void setWorkerId_JsonNullable(JsonNullable<String> workerId) {
    this.workerId = workerId;
  }

  public void setWorkerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
  }


  public HistoricExternalTaskLogDto retries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
    
    return this;
  }

   /**
   * The number of retries the associated external task has left.
   * @return retries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getRetries() {
        return retries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getRetries_JsonNullable() {
    return retries;
  }
  
  @JsonProperty(JSON_PROPERTY_RETRIES)
  public void setRetries_JsonNullable(JsonNullable<Integer> retries) {
    this.retries = retries;
  }

  public void setRetries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
  }


  public HistoricExternalTaskLogDto priority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
    
    return this;
  }

   /**
   * The execution priority the external task had when the log entry was created.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Long> priority) {
    this.priority = priority;
  }

  public void setPriority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
  }


  public HistoricExternalTaskLogDto errorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
    
    return this;
  }

   /**
   * The message of the error that occurred by executing the associated external task.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorMessage() {
        return errorMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorMessage_JsonNullable() {
    return errorMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
    this.errorMessage = errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
  }


  public HistoricExternalTaskLogDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity on which the associated external task was created.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricExternalTaskLogDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * The id of the activity instance on which the associated external task was created.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public HistoricExternalTaskLogDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The execution id on which the associated external task was created.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricExternalTaskLogDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance on which the associated external task was created.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricExternalTaskLogDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition which the associated external task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricExternalTaskLogDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition which the associated external task belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricExternalTaskLogDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant that this historic external task log entry belongs to.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricExternalTaskLogDto creationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the creation of the associated external task.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCreationLog() {
        return creationLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCreationLog_JsonNullable() {
    return creationLog;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  public void setCreationLog_JsonNullable(JsonNullable<Boolean> creationLog) {
    this.creationLog = creationLog;
  }

  public void setCreationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
  }


  public HistoricExternalTaskLogDto failureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the failed execution of the associated external task.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFailureLog() {
        return failureLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFailureLog_JsonNullable() {
    return failureLog;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  public void setFailureLog_JsonNullable(JsonNullable<Boolean> failureLog) {
    this.failureLog = failureLog;
  }

  public void setFailureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
  }


  public HistoricExternalTaskLogDto successLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the successful execution of the associated external task.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuccessLog() {
        return successLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuccessLog_JsonNullable() {
    return successLog;
  }
  
  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  public void setSuccessLog_JsonNullable(JsonNullable<Boolean> successLog) {
    this.successLog = successLog;
  }

  public void setSuccessLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
  }


  public HistoricExternalTaskLogDto deletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the deletion of the associated external task.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getDeletionLog() {
        return deletionLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getDeletionLog_JsonNullable() {
    return deletionLog;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  public void setDeletionLog_JsonNullable(JsonNullable<Boolean> deletionLog) {
    this.deletionLog = deletionLog;
  }

  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
  }


  public HistoricExternalTaskLogDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which this log should be removed by the History Cleanup job. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.  For further information, please see the [documentation](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/)
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricExternalTaskLogDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this log.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricExternalTaskLogDto historicExternalTaskLogDto = (HistoricExternalTaskLogDto) o;
    return equalsNullable(this.id, historicExternalTaskLogDto.id) &&
        equalsNullable(this.externalTaskId, historicExternalTaskLogDto.externalTaskId) &&
        equalsNullable(this.timestamp, historicExternalTaskLogDto.timestamp) &&
        equalsNullable(this.topicName, historicExternalTaskLogDto.topicName) &&
        equalsNullable(this.workerId, historicExternalTaskLogDto.workerId) &&
        equalsNullable(this.retries, historicExternalTaskLogDto.retries) &&
        equalsNullable(this.priority, historicExternalTaskLogDto.priority) &&
        equalsNullable(this.errorMessage, historicExternalTaskLogDto.errorMessage) &&
        equalsNullable(this.activityId, historicExternalTaskLogDto.activityId) &&
        equalsNullable(this.activityInstanceId, historicExternalTaskLogDto.activityInstanceId) &&
        equalsNullable(this.executionId, historicExternalTaskLogDto.executionId) &&
        equalsNullable(this.processInstanceId, historicExternalTaskLogDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, historicExternalTaskLogDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicExternalTaskLogDto.processDefinitionKey) &&
        equalsNullable(this.tenantId, historicExternalTaskLogDto.tenantId) &&
        equalsNullable(this.creationLog, historicExternalTaskLogDto.creationLog) &&
        equalsNullable(this.failureLog, historicExternalTaskLogDto.failureLog) &&
        equalsNullable(this.successLog, historicExternalTaskLogDto.successLog) &&
        equalsNullable(this.deletionLog, historicExternalTaskLogDto.deletionLog) &&
        equalsNullable(this.removalTime, historicExternalTaskLogDto.removalTime) &&
        equalsNullable(this.rootProcessInstanceId, historicExternalTaskLogDto.rootProcessInstanceId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(externalTaskId), hashCodeNullable(timestamp), hashCodeNullable(topicName), hashCodeNullable(workerId), hashCodeNullable(retries), hashCodeNullable(priority), hashCodeNullable(errorMessage), hashCodeNullable(activityId), hashCodeNullable(activityInstanceId), hashCodeNullable(executionId), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(tenantId), hashCodeNullable(creationLog), hashCodeNullable(failureLog), hashCodeNullable(successLog), hashCodeNullable(deletionLog), hashCodeNullable(removalTime), hashCodeNullable(rootProcessInstanceId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricExternalTaskLogDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalTaskId: ").append(toIndentedString(externalTaskId)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    topicName: ").append(toIndentedString(topicName)).append("\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `externalTaskId` to the URL query string
    if (getExternalTaskId() != null) {
      try {
        joiner.add(String.format("%sexternalTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExternalTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timestamp` to the URL query string
    if (getTimestamp() != null) {
      try {
        joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimestamp()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `topicName` to the URL query string
    if (getTopicName() != null) {
      try {
        joiner.add(String.format("%stopicName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTopicName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationLog` to the URL query string
    if (getCreationLog() != null) {
      try {
        joiner.add(String.format("%screationLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failureLog` to the URL query string
    if (getFailureLog() != null) {
      try {
        joiner.add(String.format("%sfailureLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailureLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `successLog` to the URL query string
    if (getSuccessLog() != null) {
      try {
        joiner.add(String.format("%ssuccessLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuccessLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletionLog` to the URL query string
    if (getDeletionLog() != null) {
      try {
        joiner.add(String.format("%sdeletionLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletionLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

