/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Historic External Task Log instance query which defines a list of Historic External Task Log instances
 */
@JsonPropertyOrder({
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_LOG_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_EXTERNAL_TASK_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_TOPIC_NAME,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_WORKER_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_ERROR_MESSAGE,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_ACTIVITY_ID_IN,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_EXECUTION_ID_IN,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_CREATION_LOG,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_FAILURE_LOG,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_SUCCESS_LOG,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_DELETION_LOG,
  HistoricExternalTaskLogQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricExternalTaskLogQueryDto {
  public static final String JSON_PROPERTY_LOG_ID = "logId";
  private JsonNullable<String> logId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXTERNAL_TASK_ID = "externalTaskId";
  private JsonNullable<String> externalTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TOPIC_NAME = "topicName";
  private JsonNullable<String> topicName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WORKER_ID = "workerId";
  private JsonNullable<String> workerId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  private JsonNullable<String> errorMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID_IN = "activityIdIn";
  private JsonNullable<List<String>> activityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  private JsonNullable<List<String>> activityInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID_IN = "executionIdIn";
  private JsonNullable<List<String>> executionIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
  private JsonNullable<Long> priorityLowerThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
  private JsonNullable<Long> priorityHigherThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_CREATION_LOG = "creationLog";
  private JsonNullable<Boolean> creationLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FAILURE_LOG = "failureLog";
  private JsonNullable<Boolean> failureLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUCCESS_LOG = "successLog";
  private JsonNullable<Boolean> successLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DELETION_LOG = "deletionLog";
  private JsonNullable<Boolean> deletionLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricExternalTaskLogQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricExternalTaskLogQueryDtoSortingInner>>undefined();

  public HistoricExternalTaskLogQueryDto() {
  }

  public HistoricExternalTaskLogQueryDto logId(String logId) {
    this.logId = JsonNullable.<String>of(logId);
    
    return this;
  }

   /**
   * Filter by historic external task log id.
   * @return logId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getLogId() {
        return logId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOG_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLogId_JsonNullable() {
    return logId;
  }
  
  @JsonProperty(JSON_PROPERTY_LOG_ID)
  public void setLogId_JsonNullable(JsonNullable<String> logId) {
    this.logId = logId;
  }

  public void setLogId(String logId) {
    this.logId = JsonNullable.<String>of(logId);
  }


  public HistoricExternalTaskLogQueryDto externalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
    
    return this;
  }

   /**
   * Filter by external task id.
   * @return externalTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExternalTaskId() {
        return externalTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExternalTaskId_JsonNullable() {
    return externalTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TASK_ID)
  public void setExternalTaskId_JsonNullable(JsonNullable<String> externalTaskId) {
    this.externalTaskId = externalTaskId;
  }

  public void setExternalTaskId(String externalTaskId) {
    this.externalTaskId = JsonNullable.<String>of(externalTaskId);
  }


  public HistoricExternalTaskLogQueryDto topicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
    
    return this;
  }

   /**
   * Filter by an external task topic.
   * @return topicName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTopicName() {
        return topicName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTopicName_JsonNullable() {
    return topicName;
  }
  
  @JsonProperty(JSON_PROPERTY_TOPIC_NAME)
  public void setTopicName_JsonNullable(JsonNullable<String> topicName) {
    this.topicName = topicName;
  }

  public void setTopicName(String topicName) {
    this.topicName = JsonNullable.<String>of(topicName);
  }


  public HistoricExternalTaskLogQueryDto workerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
    
    return this;
  }

   /**
   * Filter by the id of the worker that the task was most recently locked by.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getWorkerId() {
        return workerId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getWorkerId_JsonNullable() {
    return workerId;
  }
  
  @JsonProperty(JSON_PROPERTY_WORKER_ID)
  public void setWorkerId_JsonNullable(JsonNullable<String> workerId) {
    this.workerId = workerId;
  }

  public void setWorkerId(String workerId) {
    this.workerId = JsonNullable.<String>of(workerId);
  }


  public HistoricExternalTaskLogQueryDto errorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
    
    return this;
  }

   /**
   * Filter by external task exception message.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getErrorMessage() {
        return errorMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getErrorMessage_JsonNullable() {
    return errorMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
    this.errorMessage = errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = JsonNullable.<String>of(errorMessage);
  }


  public HistoricExternalTaskLogQueryDto activityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
    
    return this;
  }

  public HistoricExternalTaskLogQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null || !this.activityIdIn.isPresent()) {
      this.activityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityIdIn.get().add(activityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic external task logs which belong to one of the passed activity ids.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityIdIn() {
        return activityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityIdIn_JsonNullable() {
    return activityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  public void setActivityIdIn_JsonNullable(JsonNullable<List<String>> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }

  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
  }


  public HistoricExternalTaskLogQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
    
    return this;
  }

  public HistoricExternalTaskLogQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null || !this.activityInstanceIdIn.isPresent()) {
      this.activityInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityInstanceIdIn.get().add(activityInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic external task logs which belong to one of the passed activity instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityInstanceIdIn() {
        return activityInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityInstanceIdIn_JsonNullable() {
    return activityInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  public void setActivityInstanceIdIn_JsonNullable(JsonNullable<List<String>> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }

  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
  }


  public HistoricExternalTaskLogQueryDto executionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
    
    return this;
  }

  public HistoricExternalTaskLogQueryDto addExecutionIdInItem(String executionIdInItem) {
    if (this.executionIdIn == null || !this.executionIdIn.isPresent()) {
      this.executionIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.executionIdIn.get().add(executionIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic external task logs which belong to one of the passed execution ids.
   * @return executionIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getExecutionIdIn() {
        return executionIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getExecutionIdIn_JsonNullable() {
    return executionIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  public void setExecutionIdIn_JsonNullable(JsonNullable<List<String>> executionIdIn) {
    this.executionIdIn = executionIdIn;
  }

  public void setExecutionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
  }


  public HistoricExternalTaskLogQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricExternalTaskLogQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricExternalTaskLogQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by process definition key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricExternalTaskLogQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricExternalTaskLogQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricExternalTaskLogQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricExternalTaskLogQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
    
    return this;
  }

   /**
   * Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityLowerThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityLowerThanOrEquals() {
        return priorityLowerThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityLowerThanOrEquals_JsonNullable() {
    return priorityLowerThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  public void setPriorityLowerThanOrEquals_JsonNullable(JsonNullable<Long> priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
  }

  public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
  }


  public HistoricExternalTaskLogQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
    
    return this;
  }

   /**
   * Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityHigherThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityHigherThanOrEquals() {
        return priorityHigherThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityHigherThanOrEquals_JsonNullable() {
    return priorityHigherThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  public void setPriorityHigherThanOrEquals_JsonNullable(JsonNullable<Long> priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
  }

  public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
  }


  public HistoricExternalTaskLogQueryDto creationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
    
    return this;
  }

   /**
   * Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCreationLog() {
        return creationLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCreationLog_JsonNullable() {
    return creationLog;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  public void setCreationLog_JsonNullable(JsonNullable<Boolean> creationLog) {
    this.creationLog = creationLog;
  }

  public void setCreationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
  }


  public HistoricExternalTaskLogQueryDto failureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
    
    return this;
  }

   /**
   * Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFailureLog() {
        return failureLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFailureLog_JsonNullable() {
    return failureLog;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  public void setFailureLog_JsonNullable(JsonNullable<Boolean> failureLog) {
    this.failureLog = failureLog;
  }

  public void setFailureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
  }


  public HistoricExternalTaskLogQueryDto successLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
    
    return this;
  }

   /**
   * Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuccessLog() {
        return successLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuccessLog_JsonNullable() {
    return successLog;
  }
  
  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  public void setSuccessLog_JsonNullable(JsonNullable<Boolean> successLog) {
    this.successLog = successLog;
  }

  public void setSuccessLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
  }


  public HistoricExternalTaskLogQueryDto deletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
    
    return this;
  }

   /**
   * Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getDeletionLog() {
        return deletionLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getDeletionLog_JsonNullable() {
    return deletionLog;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  public void setDeletionLog_JsonNullable(JsonNullable<Boolean> deletionLog) {
    this.deletionLog = deletionLog;
  }

  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
  }


  public HistoricExternalTaskLogQueryDto sorting(List<HistoricExternalTaskLogQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricExternalTaskLogQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricExternalTaskLogQueryDto addSortingItem(HistoricExternalTaskLogQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricExternalTaskLogQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for &#x60;count&#x60; endpoints.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricExternalTaskLogQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricExternalTaskLogQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricExternalTaskLogQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricExternalTaskLogQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricExternalTaskLogQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto = (HistoricExternalTaskLogQueryDto) o;
    return equalsNullable(this.logId, historicExternalTaskLogQueryDto.logId) &&
        equalsNullable(this.externalTaskId, historicExternalTaskLogQueryDto.externalTaskId) &&
        equalsNullable(this.topicName, historicExternalTaskLogQueryDto.topicName) &&
        equalsNullable(this.workerId, historicExternalTaskLogQueryDto.workerId) &&
        equalsNullable(this.errorMessage, historicExternalTaskLogQueryDto.errorMessage) &&
        equalsNullable(this.activityIdIn, historicExternalTaskLogQueryDto.activityIdIn) &&
        equalsNullable(this.activityInstanceIdIn, historicExternalTaskLogQueryDto.activityInstanceIdIn) &&
        equalsNullable(this.executionIdIn, historicExternalTaskLogQueryDto.executionIdIn) &&
        equalsNullable(this.processInstanceId, historicExternalTaskLogQueryDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, historicExternalTaskLogQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicExternalTaskLogQueryDto.processDefinitionKey) &&
        equalsNullable(this.tenantIdIn, historicExternalTaskLogQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicExternalTaskLogQueryDto.withoutTenantId) &&
        equalsNullable(this.priorityLowerThanOrEquals, historicExternalTaskLogQueryDto.priorityLowerThanOrEquals) &&
        equalsNullable(this.priorityHigherThanOrEquals, historicExternalTaskLogQueryDto.priorityHigherThanOrEquals) &&
        equalsNullable(this.creationLog, historicExternalTaskLogQueryDto.creationLog) &&
        equalsNullable(this.failureLog, historicExternalTaskLogQueryDto.failureLog) &&
        equalsNullable(this.successLog, historicExternalTaskLogQueryDto.successLog) &&
        equalsNullable(this.deletionLog, historicExternalTaskLogQueryDto.deletionLog) &&
        equalsNullable(this.sorting, historicExternalTaskLogQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(logId), hashCodeNullable(externalTaskId), hashCodeNullable(topicName), hashCodeNullable(workerId), hashCodeNullable(errorMessage), hashCodeNullable(activityIdIn), hashCodeNullable(activityInstanceIdIn), hashCodeNullable(executionIdIn), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(priorityLowerThanOrEquals), hashCodeNullable(priorityHigherThanOrEquals), hashCodeNullable(creationLog), hashCodeNullable(failureLog), hashCodeNullable(successLog), hashCodeNullable(deletionLog), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricExternalTaskLogQueryDto {\n");
    sb.append("    logId: ").append(toIndentedString(logId)).append("\n");
    sb.append("    externalTaskId: ").append(toIndentedString(externalTaskId)).append("\n");
    sb.append("    topicName: ").append(toIndentedString(topicName)).append("\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    executionIdIn: ").append(toIndentedString(executionIdIn)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    priorityLowerThanOrEquals: ").append(toIndentedString(priorityLowerThanOrEquals)).append("\n");
    sb.append("    priorityHigherThanOrEquals: ").append(toIndentedString(priorityHigherThanOrEquals)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `logId` to the URL query string
    if (getLogId() != null) {
      try {
        joiner.add(String.format("%slogId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLogId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `externalTaskId` to the URL query string
    if (getExternalTaskId() != null) {
      try {
        joiner.add(String.format("%sexternalTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExternalTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `topicName` to the URL query string
    if (getTopicName() != null) {
      try {
        joiner.add(String.format("%stopicName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTopicName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `workerId` to the URL query string
    if (getWorkerId() != null) {
      try {
        joiner.add(String.format("%sworkerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWorkerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityIdIn` to the URL query string
    if (getActivityIdIn() != null) {
      for (int i = 0; i < getActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `activityInstanceIdIn` to the URL query string
    if (getActivityInstanceIdIn() != null) {
      for (int i = 0; i < getActivityInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `executionIdIn` to the URL query string
    if (getExecutionIdIn() != null) {
      for (int i = 0; i < getExecutionIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sexecutionIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getExecutionIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityLowerThanOrEquals` to the URL query string
    if (getPriorityLowerThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityLowerThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityLowerThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityHigherThanOrEquals` to the URL query string
    if (getPriorityHigherThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityHigherThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityHigherThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationLog` to the URL query string
    if (getCreationLog() != null) {
      try {
        joiner.add(String.format("%screationLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failureLog` to the URL query string
    if (getFailureLog() != null) {
      try {
        joiner.add(String.format("%sfailureLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailureLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `successLog` to the URL query string
    if (getSuccessLog() != null) {
      try {
        joiner.add(String.format("%ssuccessLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuccessLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletionLog` to the URL query string
    if (getDeletionLog() != null) {
      try {
        joiner.add(String.format("%sdeletionLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletionLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

