/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricIncidentDto
 */
@JsonPropertyOrder({
  HistoricIncidentDto.JSON_PROPERTY_ID,
  HistoricIncidentDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricIncidentDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricIncidentDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricIncidentDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricIncidentDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID,
  HistoricIncidentDto.JSON_PROPERTY_CREATE_TIME,
  HistoricIncidentDto.JSON_PROPERTY_END_TIME,
  HistoricIncidentDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricIncidentDto.JSON_PROPERTY_INCIDENT_TYPE,
  HistoricIncidentDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricIncidentDto.JSON_PROPERTY_FAILED_ACTIVITY_ID,
  HistoricIncidentDto.JSON_PROPERTY_CAUSE_INCIDENT_ID,
  HistoricIncidentDto.JSON_PROPERTY_ROOT_CAUSE_INCIDENT_ID,
  HistoricIncidentDto.JSON_PROPERTY_CONFIGURATION,
  HistoricIncidentDto.JSON_PROPERTY_HISTORY_CONFIGURATION,
  HistoricIncidentDto.JSON_PROPERTY_INCIDENT_MESSAGE,
  HistoricIncidentDto.JSON_PROPERTY_TENANT_ID,
  HistoricIncidentDto.JSON_PROPERTY_JOB_DEFINITION_ID,
  HistoricIncidentDto.JSON_PROPERTY_OPEN,
  HistoricIncidentDto.JSON_PROPERTY_DELETED,
  HistoricIncidentDto.JSON_PROPERTY_RESOLVED,
  HistoricIncidentDto.JSON_PROPERTY_ANNOTATION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricIncidentDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATE_TIME = "createTime";
  private JsonNullable<OffsetDateTime> createTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  private JsonNullable<OffsetDateTime> endTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_INCIDENT_TYPE = "incidentType";
  private JsonNullable<String> incidentType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FAILED_ACTIVITY_ID = "failedActivityId";
  private JsonNullable<String> failedActivityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CAUSE_INCIDENT_ID = "causeIncidentId";
  private JsonNullable<String> causeIncidentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
  private JsonNullable<String> rootCauseIncidentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private JsonNullable<String> _configuration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_HISTORY_CONFIGURATION = "historyConfiguration";
  private JsonNullable<String> historyConfiguration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_MESSAGE = "incidentMessage";
  private JsonNullable<String> incidentMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_ID = "jobDefinitionId";
  private JsonNullable<String> jobDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OPEN = "open";
  private JsonNullable<Boolean> open = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private JsonNullable<Boolean> deleted = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_RESOLVED = "resolved";
  private JsonNullable<Boolean> resolved = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_ANNOTATION = "annotation";
  private JsonNullable<String> annotation = JsonNullable.<String>undefined();

  public HistoricIncidentDto() {
  }

  public HistoricIncidentDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the incident.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricIncidentDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition this incident is associated with.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricIncidentDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition this incident is associated with.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricIncidentDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The key of the process definition this incident is associated with.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricIncidentDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The id of the execution this incident is associated with.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricIncidentDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this incident.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }


  public HistoricIncidentDto createTime(OffsetDateTime createTime) {
    this.createTime = JsonNullable.<OffsetDateTime>of(createTime);
    
    return this;
  }

   /**
   * The time this incident happened.  [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return createTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreateTime() {
        return createTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreateTime_JsonNullable() {
    return createTime;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATE_TIME)
  public void setCreateTime_JsonNullable(JsonNullable<OffsetDateTime> createTime) {
    this.createTime = createTime;
  }

  public void setCreateTime(OffsetDateTime createTime) {
    this.createTime = JsonNullable.<OffsetDateTime>of(createTime);
  }


  public HistoricIncidentDto endTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
    
    return this;
  }

   /**
   * The time this incident has been deleted or resolved.  [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return endTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getEndTime() {
        return endTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getEndTime_JsonNullable() {
    return endTime;
  }
  
  @JsonProperty(JSON_PROPERTY_END_TIME)
  public void setEndTime_JsonNullable(JsonNullable<OffsetDateTime> endTime) {
    this.endTime = endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
  }


  public HistoricIncidentDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the incident should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricIncidentDto incidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
    
    return this;
  }

   /**
   * The type of incident, for example: &#x60;failedJobs&#x60; will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](/manual/develop/user- guide/process-engine/incidents/#incident-types) for a list of incident types.
   * @return incidentType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentType() {
        return incidentType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentType_JsonNullable() {
    return incidentType;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  public void setIncidentType_JsonNullable(JsonNullable<String> incidentType) {
    this.incidentType = incidentType;
  }

  public void setIncidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
  }


  public HistoricIncidentDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity this incident is associated with.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricIncidentDto failedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
    
    return this;
  }

   /**
   * The id of the activity on which the last exception occurred.
   * @return failedActivityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFailedActivityId() {
        return failedActivityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFailedActivityId_JsonNullable() {
    return failedActivityId;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  public void setFailedActivityId_JsonNullable(JsonNullable<String> failedActivityId) {
    this.failedActivityId = failedActivityId;
  }

  public void setFailedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
  }


  public HistoricIncidentDto causeIncidentId(String causeIncidentId) {
    this.causeIncidentId = JsonNullable.<String>of(causeIncidentId);
    
    return this;
  }

   /**
   * The id of the associated cause incident which has been triggered.
   * @return causeIncidentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCauseIncidentId() {
        return causeIncidentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CAUSE_INCIDENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCauseIncidentId_JsonNullable() {
    return causeIncidentId;
  }
  
  @JsonProperty(JSON_PROPERTY_CAUSE_INCIDENT_ID)
  public void setCauseIncidentId_JsonNullable(JsonNullable<String> causeIncidentId) {
    this.causeIncidentId = causeIncidentId;
  }

  public void setCauseIncidentId(String causeIncidentId) {
    this.causeIncidentId = JsonNullable.<String>of(causeIncidentId);
  }


  public HistoricIncidentDto rootCauseIncidentId(String rootCauseIncidentId) {
    this.rootCauseIncidentId = JsonNullable.<String>of(rootCauseIncidentId);
    
    return this;
  }

   /**
   * The id of the associated root cause incident which has been triggered.
   * @return rootCauseIncidentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootCauseIncidentId() {
        return rootCauseIncidentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_CAUSE_INCIDENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootCauseIncidentId_JsonNullable() {
    return rootCauseIncidentId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_CAUSE_INCIDENT_ID)
  public void setRootCauseIncidentId_JsonNullable(JsonNullable<String> rootCauseIncidentId) {
    this.rootCauseIncidentId = rootCauseIncidentId;
  }

  public void setRootCauseIncidentId(String rootCauseIncidentId) {
    this.rootCauseIncidentId = JsonNullable.<String>of(rootCauseIncidentId);
  }


  public HistoricIncidentDto _configuration(String _configuration) {
    this._configuration = JsonNullable.<String>of(_configuration);
    
    return this;
  }

   /**
   * The payload of this incident.
   * @return _configuration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getConfiguration() {
        return _configuration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getConfiguration_JsonNullable() {
    return _configuration;
  }
  
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  public void setConfiguration_JsonNullable(JsonNullable<String> _configuration) {
    this._configuration = _configuration;
  }

  public void setConfiguration(String _configuration) {
    this._configuration = JsonNullable.<String>of(_configuration);
  }


  public HistoricIncidentDto historyConfiguration(String historyConfiguration) {
    this.historyConfiguration = JsonNullable.<String>of(historyConfiguration);
    
    return this;
  }

   /**
   * The payload of this incident at the time when it occurred.
   * @return historyConfiguration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getHistoryConfiguration() {
        return historyConfiguration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HISTORY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getHistoryConfiguration_JsonNullable() {
    return historyConfiguration;
  }
  
  @JsonProperty(JSON_PROPERTY_HISTORY_CONFIGURATION)
  public void setHistoryConfiguration_JsonNullable(JsonNullable<String> historyConfiguration) {
    this.historyConfiguration = historyConfiguration;
  }

  public void setHistoryConfiguration(String historyConfiguration) {
    this.historyConfiguration = JsonNullable.<String>of(historyConfiguration);
  }


  public HistoricIncidentDto incidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
    
    return this;
  }

   /**
   * The message of this incident.
   * @return incidentMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentMessage() {
        return incidentMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentMessage_JsonNullable() {
    return incidentMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  public void setIncidentMessage_JsonNullable(JsonNullable<String> incidentMessage) {
    this.incidentMessage = incidentMessage;
  }

  public void setIncidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
  }


  public HistoricIncidentDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant this incident is associated with.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricIncidentDto jobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
    
    return this;
  }

   /**
   * The job definition id the incident is associated with.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionId() {
        return jobDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionId_JsonNullable() {
    return jobDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  public void setJobDefinitionId_JsonNullable(JsonNullable<String> jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }

  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
  }


  public HistoricIncidentDto open(Boolean open) {
    this.open = JsonNullable.<Boolean>of(open);
    
    return this;
  }

   /**
   * If true, this incident is open.
   * @return open
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getOpen() {
        return open.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getOpen_JsonNullable() {
    return open;
  }
  
  @JsonProperty(JSON_PROPERTY_OPEN)
  public void setOpen_JsonNullable(JsonNullable<Boolean> open) {
    this.open = open;
  }

  public void setOpen(Boolean open) {
    this.open = JsonNullable.<Boolean>of(open);
  }


  public HistoricIncidentDto deleted(Boolean deleted) {
    this.deleted = JsonNullable.<Boolean>of(deleted);
    
    return this;
  }

   /**
   * If true, this incident has been deleted.
   * @return deleted
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getDeleted() {
        return deleted.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getDeleted_JsonNullable() {
    return deleted;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETED)
  public void setDeleted_JsonNullable(JsonNullable<Boolean> deleted) {
    this.deleted = deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = JsonNullable.<Boolean>of(deleted);
  }


  public HistoricIncidentDto resolved(Boolean resolved) {
    this.resolved = JsonNullable.<Boolean>of(resolved);
    
    return this;
  }

   /**
   * If true, this incident has been resolved.
   * @return resolved
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getResolved() {
        return resolved.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOLVED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getResolved_JsonNullable() {
    return resolved;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOLVED)
  public void setResolved_JsonNullable(JsonNullable<Boolean> resolved) {
    this.resolved = resolved;
  }

  public void setResolved(Boolean resolved) {
    this.resolved = JsonNullable.<Boolean>of(resolved);
  }


  public HistoricIncidentDto annotation(String annotation) {
    this.annotation = JsonNullable.<String>of(annotation);
    
    return this;
  }

   /**
   * The annotation set to the incident.
   * @return annotation
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAnnotation() {
        return annotation.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAnnotation_JsonNullable() {
    return annotation;
  }
  
  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  public void setAnnotation_JsonNullable(JsonNullable<String> annotation) {
    this.annotation = annotation;
  }

  public void setAnnotation(String annotation) {
    this.annotation = JsonNullable.<String>of(annotation);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricIncidentDto historicIncidentDto = (HistoricIncidentDto) o;
    return equalsNullable(this.id, historicIncidentDto.id) &&
        equalsNullable(this.processDefinitionKey, historicIncidentDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionId, historicIncidentDto.processDefinitionId) &&
        equalsNullable(this.processInstanceId, historicIncidentDto.processInstanceId) &&
        equalsNullable(this.executionId, historicIncidentDto.executionId) &&
        equalsNullable(this.rootProcessInstanceId, historicIncidentDto.rootProcessInstanceId) &&
        equalsNullable(this.createTime, historicIncidentDto.createTime) &&
        equalsNullable(this.endTime, historicIncidentDto.endTime) &&
        equalsNullable(this.removalTime, historicIncidentDto.removalTime) &&
        equalsNullable(this.incidentType, historicIncidentDto.incidentType) &&
        equalsNullable(this.activityId, historicIncidentDto.activityId) &&
        equalsNullable(this.failedActivityId, historicIncidentDto.failedActivityId) &&
        equalsNullable(this.causeIncidentId, historicIncidentDto.causeIncidentId) &&
        equalsNullable(this.rootCauseIncidentId, historicIncidentDto.rootCauseIncidentId) &&
        equalsNullable(this._configuration, historicIncidentDto._configuration) &&
        equalsNullable(this.historyConfiguration, historicIncidentDto.historyConfiguration) &&
        equalsNullable(this.incidentMessage, historicIncidentDto.incidentMessage) &&
        equalsNullable(this.tenantId, historicIncidentDto.tenantId) &&
        equalsNullable(this.jobDefinitionId, historicIncidentDto.jobDefinitionId) &&
        equalsNullable(this.open, historicIncidentDto.open) &&
        equalsNullable(this.deleted, historicIncidentDto.deleted) &&
        equalsNullable(this.resolved, historicIncidentDto.resolved) &&
        equalsNullable(this.annotation, historicIncidentDto.annotation);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionId), hashCodeNullable(processInstanceId), hashCodeNullable(executionId), hashCodeNullable(rootProcessInstanceId), hashCodeNullable(createTime), hashCodeNullable(endTime), hashCodeNullable(removalTime), hashCodeNullable(incidentType), hashCodeNullable(activityId), hashCodeNullable(failedActivityId), hashCodeNullable(causeIncidentId), hashCodeNullable(rootCauseIncidentId), hashCodeNullable(_configuration), hashCodeNullable(historyConfiguration), hashCodeNullable(incidentMessage), hashCodeNullable(tenantId), hashCodeNullable(jobDefinitionId), hashCodeNullable(open), hashCodeNullable(deleted), hashCodeNullable(resolved), hashCodeNullable(annotation));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricIncidentDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    incidentType: ").append(toIndentedString(incidentType)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    failedActivityId: ").append(toIndentedString(failedActivityId)).append("\n");
    sb.append("    causeIncidentId: ").append(toIndentedString(causeIncidentId)).append("\n");
    sb.append("    rootCauseIncidentId: ").append(toIndentedString(rootCauseIncidentId)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    historyConfiguration: ").append(toIndentedString(historyConfiguration)).append("\n");
    sb.append("    incidentMessage: ").append(toIndentedString(incidentMessage)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    open: ").append(toIndentedString(open)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    resolved: ").append(toIndentedString(resolved)).append("\n");
    sb.append("    annotation: ").append(toIndentedString(annotation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createTime` to the URL query string
    if (getCreateTime() != null) {
      try {
        joiner.add(String.format("%screateTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreateTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endTime` to the URL query string
    if (getEndTime() != null) {
      try {
        joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentType` to the URL query string
    if (getIncidentType() != null) {
      try {
        joiner.add(String.format("%sincidentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failedActivityId` to the URL query string
    if (getFailedActivityId() != null) {
      try {
        joiner.add(String.format("%sfailedActivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailedActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `causeIncidentId` to the URL query string
    if (getCauseIncidentId() != null) {
      try {
        joiner.add(String.format("%scauseIncidentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCauseIncidentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootCauseIncidentId` to the URL query string
    if (getRootCauseIncidentId() != null) {
      try {
        joiner.add(String.format("%srootCauseIncidentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootCauseIncidentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `configuration` to the URL query string
    if (getConfiguration() != null) {
      try {
        joiner.add(String.format("%sconfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `historyConfiguration` to the URL query string
    if (getHistoryConfiguration() != null) {
      try {
        joiner.add(String.format("%shistoryConfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHistoryConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentMessage` to the URL query string
    if (getIncidentMessage() != null) {
      try {
        joiner.add(String.format("%sincidentMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionId` to the URL query string
    if (getJobDefinitionId() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `open` to the URL query string
    if (getOpen() != null) {
      try {
        joiner.add(String.format("%sopen%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOpen()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deleted` to the URL query string
    if (getDeleted() != null) {
      try {
        joiner.add(String.format("%sdeleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resolved` to the URL query string
    if (getResolved() != null) {
      try {
        joiner.add(String.format("%sresolved%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResolved()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `annotation` to the URL query string
    if (getAnnotation() != null) {
      try {
        joiner.add(String.format("%sannotation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAnnotation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

