/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricJobLogDto
 */
@JsonPropertyOrder({
  HistoricJobLogDto.JSON_PROPERTY_ID,
  HistoricJobLogDto.JSON_PROPERTY_TIMESTAMP,
  HistoricJobLogDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricJobLogDto.JSON_PROPERTY_JOB_ID,
  HistoricJobLogDto.JSON_PROPERTY_JOB_DUE_DATE,
  HistoricJobLogDto.JSON_PROPERTY_JOB_RETRIES,
  HistoricJobLogDto.JSON_PROPERTY_JOB_PRIORITY,
  HistoricJobLogDto.JSON_PROPERTY_JOB_EXCEPTION_MESSAGE,
  HistoricJobLogDto.JSON_PROPERTY_FAILED_ACTIVITY_ID,
  HistoricJobLogDto.JSON_PROPERTY_JOB_DEFINITION_ID,
  HistoricJobLogDto.JSON_PROPERTY_JOB_DEFINITION_TYPE,
  HistoricJobLogDto.JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION,
  HistoricJobLogDto.JSON_PROPERTY_ACTIVITY_ID,
  HistoricJobLogDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricJobLogDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricJobLogDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricJobLogDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricJobLogDto.JSON_PROPERTY_DEPLOYMENT_ID,
  HistoricJobLogDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID,
  HistoricJobLogDto.JSON_PROPERTY_TENANT_ID,
  HistoricJobLogDto.JSON_PROPERTY_HOSTNAME,
  HistoricJobLogDto.JSON_PROPERTY_CREATION_LOG,
  HistoricJobLogDto.JSON_PROPERTY_FAILURE_LOG,
  HistoricJobLogDto.JSON_PROPERTY_SUCCESS_LOG,
  HistoricJobLogDto.JSON_PROPERTY_DELETION_LOG
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricJobLogDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private JsonNullable<OffsetDateTime> timestamp = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  private JsonNullable<String> jobId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DUE_DATE = "jobDueDate";
  private JsonNullable<OffsetDateTime> jobDueDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_JOB_RETRIES = "jobRetries";
  private JsonNullable<Integer> jobRetries = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_JOB_PRIORITY = "jobPriority";
  private JsonNullable<Long> jobPriority = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_JOB_EXCEPTION_MESSAGE = "jobExceptionMessage";
  private JsonNullable<String> jobExceptionMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FAILED_ACTIVITY_ID = "failedActivityId";
  private JsonNullable<String> failedActivityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_ID = "jobDefinitionId";
  private JsonNullable<String> jobDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_TYPE = "jobDefinitionType";
  private JsonNullable<String> jobDefinitionType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION = "jobDefinitionConfiguration";
  private JsonNullable<String> jobDefinitionConfiguration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEPLOYMENT_ID = "deploymentId";
  private JsonNullable<String> deploymentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_HOSTNAME = "hostname";
  private JsonNullable<String> hostname = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATION_LOG = "creationLog";
  private JsonNullable<Boolean> creationLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FAILURE_LOG = "failureLog";
  private JsonNullable<Boolean> failureLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUCCESS_LOG = "successLog";
  private JsonNullable<Boolean> successLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DELETION_LOG = "deletionLog";
  private JsonNullable<Boolean> deletionLog = JsonNullable.<Boolean>undefined();

  public HistoricJobLogDto() {
  }

  public HistoricJobLogDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the log entry.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricJobLogDto timestamp(OffsetDateTime timestamp) {
    this.timestamp = JsonNullable.<OffsetDateTime>of(timestamp);
    
    return this;
  }

   /**
   * The time when the log entry has been written.
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTimestamp() {
        return timestamp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTimestamp_JsonNullable() {
    return timestamp;
  }
  
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  public void setTimestamp_JsonNullable(JsonNullable<OffsetDateTime> timestamp) {
    this.timestamp = timestamp;
  }

  public void setTimestamp(OffsetDateTime timestamp) {
    this.timestamp = JsonNullable.<OffsetDateTime>of(timestamp);
  }


  public HistoricJobLogDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the log entry should be removed by the History Cleanup job. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. For further info see the [docs](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/)
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricJobLogDto jobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
    
    return this;
  }

   /**
   * The id of the associated job.
   * @return jobId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobId() {
        return jobId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobId_JsonNullable() {
    return jobId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_ID)
  public void setJobId_JsonNullable(JsonNullable<String> jobId) {
    this.jobId = jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
  }


  public HistoricJobLogDto jobDueDate(OffsetDateTime jobDueDate) {
    this.jobDueDate = JsonNullable.<OffsetDateTime>of(jobDueDate);
    
    return this;
  }

   /**
   * The date on which the associated job is supposed to be processed.
   * @return jobDueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getJobDueDate() {
        return jobDueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getJobDueDate_JsonNullable() {
    return jobDueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DUE_DATE)
  public void setJobDueDate_JsonNullable(JsonNullable<OffsetDateTime> jobDueDate) {
    this.jobDueDate = jobDueDate;
  }

  public void setJobDueDate(OffsetDateTime jobDueDate) {
    this.jobDueDate = JsonNullable.<OffsetDateTime>of(jobDueDate);
  }


  public HistoricJobLogDto jobRetries(Integer jobRetries) {
    this.jobRetries = JsonNullable.<Integer>of(jobRetries);
    
    return this;
  }

   /**
   * The number of retries the associated job has left.
   * @return jobRetries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getJobRetries() {
        return jobRetries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getJobRetries_JsonNullable() {
    return jobRetries;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_RETRIES)
  public void setJobRetries_JsonNullable(JsonNullable<Integer> jobRetries) {
    this.jobRetries = jobRetries;
  }

  public void setJobRetries(Integer jobRetries) {
    this.jobRetries = JsonNullable.<Integer>of(jobRetries);
  }


  public HistoricJobLogDto jobPriority(Long jobPriority) {
    this.jobPriority = JsonNullable.<Long>of(jobPriority);
    
    return this;
  }

   /**
   * The execution priority the job had when the log entry was created.
   * @return jobPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getJobPriority() {
        return jobPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getJobPriority_JsonNullable() {
    return jobPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY)
  public void setJobPriority_JsonNullable(JsonNullable<Long> jobPriority) {
    this.jobPriority = jobPriority;
  }

  public void setJobPriority(Long jobPriority) {
    this.jobPriority = JsonNullable.<Long>of(jobPriority);
  }


  public HistoricJobLogDto jobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = JsonNullable.<String>of(jobExceptionMessage);
    
    return this;
  }

   /**
   * The message of the exception that occurred by executing the associated job.
   * @return jobExceptionMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobExceptionMessage() {
        return jobExceptionMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_EXCEPTION_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobExceptionMessage_JsonNullable() {
    return jobExceptionMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_EXCEPTION_MESSAGE)
  public void setJobExceptionMessage_JsonNullable(JsonNullable<String> jobExceptionMessage) {
    this.jobExceptionMessage = jobExceptionMessage;
  }

  public void setJobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = JsonNullable.<String>of(jobExceptionMessage);
  }


  public HistoricJobLogDto failedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
    
    return this;
  }

   /**
   * The id of the activity on which the last exception occurred by executing the associated job.
   * @return failedActivityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFailedActivityId() {
        return failedActivityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFailedActivityId_JsonNullable() {
    return failedActivityId;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  public void setFailedActivityId_JsonNullable(JsonNullable<String> failedActivityId) {
    this.failedActivityId = failedActivityId;
  }

  public void setFailedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
  }


  public HistoricJobLogDto jobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
    
    return this;
  }

   /**
   * The id of the job definition on which the associated job was created.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionId() {
        return jobDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionId_JsonNullable() {
    return jobDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  public void setJobDefinitionId_JsonNullable(JsonNullable<String> jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }

  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
  }


  public HistoricJobLogDto jobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = JsonNullable.<String>of(jobDefinitionType);
    
    return this;
  }

   /**
   * The job definition type of the associated job. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
   * @return jobDefinitionType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionType() {
        return jobDefinitionType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionType_JsonNullable() {
    return jobDefinitionType;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_TYPE)
  public void setJobDefinitionType_JsonNullable(JsonNullable<String> jobDefinitionType) {
    this.jobDefinitionType = jobDefinitionType;
  }

  public void setJobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = JsonNullable.<String>of(jobDefinitionType);
  }


  public HistoricJobLogDto jobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = JsonNullable.<String>of(jobDefinitionConfiguration);
    
    return this;
  }

   /**
   * The job definition configuration type of the associated job.
   * @return jobDefinitionConfiguration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionConfiguration() {
        return jobDefinitionConfiguration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionConfiguration_JsonNullable() {
    return jobDefinitionConfiguration;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION)
  public void setJobDefinitionConfiguration_JsonNullable(JsonNullable<String> jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
  }

  public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = JsonNullable.<String>of(jobDefinitionConfiguration);
  }


  public HistoricJobLogDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity on which the associated job was created.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public HistoricJobLogDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The execution id on which the associated job was created.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricJobLogDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance on which the associated job was created.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricJobLogDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition which the associated job belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricJobLogDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition which the associated job belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricJobLogDto deploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
    
    return this;
  }

   /**
   * The id of the deployment which the associated job belongs to.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeploymentId() {
        return deploymentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeploymentId_JsonNullable() {
    return deploymentId;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  public void setDeploymentId_JsonNullable(JsonNullable<String> deploymentId) {
    this.deploymentId = deploymentId;
  }

  public void setDeploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
  }


  public HistoricJobLogDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process which the associated job belongs to.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }


  public HistoricJobLogDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant that this historic job log entry belongs to.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricJobLogDto hostname(String hostname) {
    this.hostname = JsonNullable.<String>of(hostname);
    
    return this;
  }

   /**
   *  The name of the host of the Process Engine where the job of this historic job log entry was executed.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getHostname() {
        return hostname.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getHostname_JsonNullable() {
    return hostname;
  }
  
  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  public void setHostname_JsonNullable(JsonNullable<String> hostname) {
    this.hostname = hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = JsonNullable.<String>of(hostname);
  }


  public HistoricJobLogDto creationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the creation of the associated job.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCreationLog() {
        return creationLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCreationLog_JsonNullable() {
    return creationLog;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  public void setCreationLog_JsonNullable(JsonNullable<Boolean> creationLog) {
    this.creationLog = creationLog;
  }

  public void setCreationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
  }


  public HistoricJobLogDto failureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the failed execution of the associated job.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFailureLog() {
        return failureLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFailureLog_JsonNullable() {
    return failureLog;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  public void setFailureLog_JsonNullable(JsonNullable<Boolean> failureLog) {
    this.failureLog = failureLog;
  }

  public void setFailureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
  }


  public HistoricJobLogDto successLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the successful execution of the associated job.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuccessLog() {
        return successLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuccessLog_JsonNullable() {
    return successLog;
  }
  
  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  public void setSuccessLog_JsonNullable(JsonNullable<Boolean> successLog) {
    this.successLog = successLog;
  }

  public void setSuccessLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
  }


  public HistoricJobLogDto deletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
    
    return this;
  }

   /**
   * A flag indicating whether this log represents the deletion of the associated job.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getDeletionLog() {
        return deletionLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getDeletionLog_JsonNullable() {
    return deletionLog;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  public void setDeletionLog_JsonNullable(JsonNullable<Boolean> deletionLog) {
    this.deletionLog = deletionLog;
  }

  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricJobLogDto historicJobLogDto = (HistoricJobLogDto) o;
    return equalsNullable(this.id, historicJobLogDto.id) &&
        equalsNullable(this.timestamp, historicJobLogDto.timestamp) &&
        equalsNullable(this.removalTime, historicJobLogDto.removalTime) &&
        equalsNullable(this.jobId, historicJobLogDto.jobId) &&
        equalsNullable(this.jobDueDate, historicJobLogDto.jobDueDate) &&
        equalsNullable(this.jobRetries, historicJobLogDto.jobRetries) &&
        equalsNullable(this.jobPriority, historicJobLogDto.jobPriority) &&
        equalsNullable(this.jobExceptionMessage, historicJobLogDto.jobExceptionMessage) &&
        equalsNullable(this.failedActivityId, historicJobLogDto.failedActivityId) &&
        equalsNullable(this.jobDefinitionId, historicJobLogDto.jobDefinitionId) &&
        equalsNullable(this.jobDefinitionType, historicJobLogDto.jobDefinitionType) &&
        equalsNullable(this.jobDefinitionConfiguration, historicJobLogDto.jobDefinitionConfiguration) &&
        equalsNullable(this.activityId, historicJobLogDto.activityId) &&
        equalsNullable(this.executionId, historicJobLogDto.executionId) &&
        equalsNullable(this.processInstanceId, historicJobLogDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, historicJobLogDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicJobLogDto.processDefinitionKey) &&
        equalsNullable(this.deploymentId, historicJobLogDto.deploymentId) &&
        equalsNullable(this.rootProcessInstanceId, historicJobLogDto.rootProcessInstanceId) &&
        equalsNullable(this.tenantId, historicJobLogDto.tenantId) &&
        equalsNullable(this.hostname, historicJobLogDto.hostname) &&
        equalsNullable(this.creationLog, historicJobLogDto.creationLog) &&
        equalsNullable(this.failureLog, historicJobLogDto.failureLog) &&
        equalsNullable(this.successLog, historicJobLogDto.successLog) &&
        equalsNullable(this.deletionLog, historicJobLogDto.deletionLog);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(timestamp), hashCodeNullable(removalTime), hashCodeNullable(jobId), hashCodeNullable(jobDueDate), hashCodeNullable(jobRetries), hashCodeNullable(jobPriority), hashCodeNullable(jobExceptionMessage), hashCodeNullable(failedActivityId), hashCodeNullable(jobDefinitionId), hashCodeNullable(jobDefinitionType), hashCodeNullable(jobDefinitionConfiguration), hashCodeNullable(activityId), hashCodeNullable(executionId), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(deploymentId), hashCodeNullable(rootProcessInstanceId), hashCodeNullable(tenantId), hashCodeNullable(hostname), hashCodeNullable(creationLog), hashCodeNullable(failureLog), hashCodeNullable(successLog), hashCodeNullable(deletionLog));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricJobLogDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobDueDate: ").append(toIndentedString(jobDueDate)).append("\n");
    sb.append("    jobRetries: ").append(toIndentedString(jobRetries)).append("\n");
    sb.append("    jobPriority: ").append(toIndentedString(jobPriority)).append("\n");
    sb.append("    jobExceptionMessage: ").append(toIndentedString(jobExceptionMessage)).append("\n");
    sb.append("    failedActivityId: ").append(toIndentedString(failedActivityId)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    jobDefinitionType: ").append(toIndentedString(jobDefinitionType)).append("\n");
    sb.append("    jobDefinitionConfiguration: ").append(toIndentedString(jobDefinitionConfiguration)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timestamp` to the URL query string
    if (getTimestamp() != null) {
      try {
        joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimestamp()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobId` to the URL query string
    if (getJobId() != null) {
      try {
        joiner.add(String.format("%sjobId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDueDate` to the URL query string
    if (getJobDueDate() != null) {
      try {
        joiner.add(String.format("%sjobDueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobRetries` to the URL query string
    if (getJobRetries() != null) {
      try {
        joiner.add(String.format("%sjobRetries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobPriority` to the URL query string
    if (getJobPriority() != null) {
      try {
        joiner.add(String.format("%sjobPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobExceptionMessage` to the URL query string
    if (getJobExceptionMessage() != null) {
      try {
        joiner.add(String.format("%sjobExceptionMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobExceptionMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failedActivityId` to the URL query string
    if (getFailedActivityId() != null) {
      try {
        joiner.add(String.format("%sfailedActivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailedActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionId` to the URL query string
    if (getJobDefinitionId() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionType` to the URL query string
    if (getJobDefinitionType() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionConfiguration` to the URL query string
    if (getJobDefinitionConfiguration() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionConfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deploymentId` to the URL query string
    if (getDeploymentId() != null) {
      try {
        joiner.add(String.format("%sdeploymentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeploymentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hostname` to the URL query string
    if (getHostname() != null) {
      try {
        joiner.add(String.format("%shostname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHostname()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationLog` to the URL query string
    if (getCreationLog() != null) {
      try {
        joiner.add(String.format("%screationLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failureLog` to the URL query string
    if (getFailureLog() != null) {
      try {
        joiner.add(String.format("%sfailureLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailureLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `successLog` to the URL query string
    if (getSuccessLog() != null) {
      try {
        joiner.add(String.format("%ssuccessLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuccessLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletionLog` to the URL query string
    if (getDeletionLog() != null) {
      try {
        joiner.add(String.format("%sdeletionLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletionLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

