/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricJobLogQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Historic Job Log instance query which defines a list of Historic Job Log instances
 */
@JsonPropertyOrder({
  HistoricJobLogQueryDto.JSON_PROPERTY_LOG_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_EXCEPTION_MESSAGE,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_DEFINITION_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_DEFINITION_TYPE,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION,
  HistoricJobLogQueryDto.JSON_PROPERTY_ACTIVITY_ID_IN,
  HistoricJobLogQueryDto.JSON_PROPERTY_FAILED_ACTIVITY_ID_IN,
  HistoricJobLogQueryDto.JSON_PROPERTY_EXECUTION_ID_IN,
  HistoricJobLogQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricJobLogQueryDto.JSON_PROPERTY_DEPLOYMENT_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricJobLogQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricJobLogQueryDto.JSON_PROPERTY_HOSTNAME,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_PRIORITY_LOWER_THAN_OR_EQUALS,
  HistoricJobLogQueryDto.JSON_PROPERTY_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS,
  HistoricJobLogQueryDto.JSON_PROPERTY_CREATION_LOG,
  HistoricJobLogQueryDto.JSON_PROPERTY_FAILURE_LOG,
  HistoricJobLogQueryDto.JSON_PROPERTY_SUCCESS_LOG,
  HistoricJobLogQueryDto.JSON_PROPERTY_DELETION_LOG,
  HistoricJobLogQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricJobLogQueryDto {
  public static final String JSON_PROPERTY_LOG_ID = "logId";
  private JsonNullable<String> logId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  private JsonNullable<String> jobId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_EXCEPTION_MESSAGE = "jobExceptionMessage";
  private JsonNullable<String> jobExceptionMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_ID = "jobDefinitionId";
  private JsonNullable<String> jobDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_TYPE = "jobDefinitionType";
  private JsonNullable<String> jobDefinitionType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION = "jobDefinitionConfiguration";
  private JsonNullable<String> jobDefinitionConfiguration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID_IN = "activityIdIn";
  private JsonNullable<List<String>> activityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_FAILED_ACTIVITY_ID_IN = "failedActivityIdIn";
  private JsonNullable<List<String>> failedActivityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID_IN = "executionIdIn";
  private JsonNullable<List<String>> executionIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEPLOYMENT_ID = "deploymentId";
  private JsonNullable<String> deploymentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_HOSTNAME = "hostname";
  private JsonNullable<String> hostname = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_PRIORITY_LOWER_THAN_OR_EQUALS = "jobPriorityLowerThanOrEquals";
  private JsonNullable<Long> jobPriorityLowerThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS = "jobPriorityHigherThanOrEquals";
  private JsonNullable<Long> jobPriorityHigherThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_CREATION_LOG = "creationLog";
  private JsonNullable<Boolean> creationLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FAILURE_LOG = "failureLog";
  private JsonNullable<Boolean> failureLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUCCESS_LOG = "successLog";
  private JsonNullable<Boolean> successLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DELETION_LOG = "deletionLog";
  private JsonNullable<Boolean> deletionLog = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricJobLogQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricJobLogQueryDtoSortingInner>>undefined();

  public HistoricJobLogQueryDto() {
  }

  public HistoricJobLogQueryDto logId(String logId) {
    this.logId = JsonNullable.<String>of(logId);
    
    return this;
  }

   /**
   * Filter by historic job log id.
   * @return logId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getLogId() {
        return logId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LOG_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLogId_JsonNullable() {
    return logId;
  }
  
  @JsonProperty(JSON_PROPERTY_LOG_ID)
  public void setLogId_JsonNullable(JsonNullable<String> logId) {
    this.logId = logId;
  }

  public void setLogId(String logId) {
    this.logId = JsonNullable.<String>of(logId);
  }


  public HistoricJobLogQueryDto jobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
    
    return this;
  }

   /**
   * Filter by job id.
   * @return jobId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobId() {
        return jobId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobId_JsonNullable() {
    return jobId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_ID)
  public void setJobId_JsonNullable(JsonNullable<String> jobId) {
    this.jobId = jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
  }


  public HistoricJobLogQueryDto jobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = JsonNullable.<String>of(jobExceptionMessage);
    
    return this;
  }

   /**
   * Filter by job exception message.
   * @return jobExceptionMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobExceptionMessage() {
        return jobExceptionMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_EXCEPTION_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobExceptionMessage_JsonNullable() {
    return jobExceptionMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_EXCEPTION_MESSAGE)
  public void setJobExceptionMessage_JsonNullable(JsonNullable<String> jobExceptionMessage) {
    this.jobExceptionMessage = jobExceptionMessage;
  }

  public void setJobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = JsonNullable.<String>of(jobExceptionMessage);
  }


  public HistoricJobLogQueryDto jobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
    
    return this;
  }

   /**
   * Filter by job definition id.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionId() {
        return jobDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionId_JsonNullable() {
    return jobDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  public void setJobDefinitionId_JsonNullable(JsonNullable<String> jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }

  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
  }


  public HistoricJobLogQueryDto jobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = JsonNullable.<String>of(jobDefinitionType);
    
    return this;
  }

   /**
   * Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
   * @return jobDefinitionType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionType() {
        return jobDefinitionType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionType_JsonNullable() {
    return jobDefinitionType;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_TYPE)
  public void setJobDefinitionType_JsonNullable(JsonNullable<String> jobDefinitionType) {
    this.jobDefinitionType = jobDefinitionType;
  }

  public void setJobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = JsonNullable.<String>of(jobDefinitionType);
  }


  public HistoricJobLogQueryDto jobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = JsonNullable.<String>of(jobDefinitionConfiguration);
    
    return this;
  }

   /**
   * Filter by job definition configuration.
   * @return jobDefinitionConfiguration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionConfiguration() {
        return jobDefinitionConfiguration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionConfiguration_JsonNullable() {
    return jobDefinitionConfiguration;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_CONFIGURATION)
  public void setJobDefinitionConfiguration_JsonNullable(JsonNullable<String> jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
  }

  public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = JsonNullable.<String>of(jobDefinitionConfiguration);
  }


  public HistoricJobLogQueryDto activityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
    
    return this;
  }

  public HistoricJobLogQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null || !this.activityIdIn.isPresent()) {
      this.activityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityIdIn.get().add(activityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic job logs which belong to one of the passed activity ids.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityIdIn() {
        return activityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityIdIn_JsonNullable() {
    return activityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  public void setActivityIdIn_JsonNullable(JsonNullable<List<String>> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }

  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
  }


  public HistoricJobLogQueryDto failedActivityIdIn(List<String> failedActivityIdIn) {
    this.failedActivityIdIn = JsonNullable.<List<String>>of(failedActivityIdIn);
    
    return this;
  }

  public HistoricJobLogQueryDto addFailedActivityIdInItem(String failedActivityIdInItem) {
    if (this.failedActivityIdIn == null || !this.failedActivityIdIn.isPresent()) {
      this.failedActivityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.failedActivityIdIn.get().add(failedActivityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic job logs which belong to failures of one of the passed activity ids.
   * @return failedActivityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getFailedActivityIdIn() {
        return failedActivityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getFailedActivityIdIn_JsonNullable() {
    return failedActivityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID_IN)
  public void setFailedActivityIdIn_JsonNullable(JsonNullable<List<String>> failedActivityIdIn) {
    this.failedActivityIdIn = failedActivityIdIn;
  }

  public void setFailedActivityIdIn(List<String> failedActivityIdIn) {
    this.failedActivityIdIn = JsonNullable.<List<String>>of(failedActivityIdIn);
  }


  public HistoricJobLogQueryDto executionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
    
    return this;
  }

  public HistoricJobLogQueryDto addExecutionIdInItem(String executionIdInItem) {
    if (this.executionIdIn == null || !this.executionIdIn.isPresent()) {
      this.executionIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.executionIdIn.get().add(executionIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic job logs which belong to one of the passed execution ids.
   * @return executionIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getExecutionIdIn() {
        return executionIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getExecutionIdIn_JsonNullable() {
    return executionIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  public void setExecutionIdIn_JsonNullable(JsonNullable<List<String>> executionIdIn) {
    this.executionIdIn = executionIdIn;
  }

  public void setExecutionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
  }


  public HistoricJobLogQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricJobLogQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricJobLogQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by process definition key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricJobLogQueryDto deploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
    
    return this;
  }

   /**
   * Filter by deployment id.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeploymentId() {
        return deploymentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeploymentId_JsonNullable() {
    return deploymentId;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  public void setDeploymentId_JsonNullable(JsonNullable<String> deploymentId) {
    this.deploymentId = deploymentId;
  }

  public void setDeploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
  }


  public HistoricJobLogQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricJobLogQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricJobLogQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricJobLogQueryDto hostname(String hostname) {
    this.hostname = JsonNullable.<String>of(hostname);
    
    return this;
  }

   /**
   * Filter by hostname.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getHostname() {
        return hostname.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getHostname_JsonNullable() {
    return hostname;
  }
  
  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  public void setHostname_JsonNullable(JsonNullable<String> hostname) {
    this.hostname = hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = JsonNullable.<String>of(hostname);
  }


  public HistoricJobLogQueryDto jobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
    this.jobPriorityLowerThanOrEquals = JsonNullable.<Long>of(jobPriorityLowerThanOrEquals);
    
    return this;
  }

   /**
   * Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return jobPriorityLowerThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getJobPriorityLowerThanOrEquals() {
        return jobPriorityLowerThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY_LOWER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getJobPriorityLowerThanOrEquals_JsonNullable() {
    return jobPriorityLowerThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY_LOWER_THAN_OR_EQUALS)
  public void setJobPriorityLowerThanOrEquals_JsonNullable(JsonNullable<Long> jobPriorityLowerThanOrEquals) {
    this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
  }

  public void setJobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
    this.jobPriorityLowerThanOrEquals = JsonNullable.<Long>of(jobPriorityLowerThanOrEquals);
  }


  public HistoricJobLogQueryDto jobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
    this.jobPriorityHigherThanOrEquals = JsonNullable.<Long>of(jobPriorityHigherThanOrEquals);
    
    return this;
  }

   /**
   * Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return jobPriorityHigherThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getJobPriorityHigherThanOrEquals() {
        return jobPriorityHigherThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getJobPriorityHigherThanOrEquals_JsonNullable() {
    return jobPriorityHigherThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS)
  public void setJobPriorityHigherThanOrEquals_JsonNullable(JsonNullable<Long> jobPriorityHigherThanOrEquals) {
    this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
  }

  public void setJobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
    this.jobPriorityHigherThanOrEquals = JsonNullable.<Long>of(jobPriorityHigherThanOrEquals);
  }


  public HistoricJobLogQueryDto creationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
    
    return this;
  }

   /**
   * Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCreationLog() {
        return creationLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCreationLog_JsonNullable() {
    return creationLog;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATION_LOG)
  public void setCreationLog_JsonNullable(JsonNullable<Boolean> creationLog) {
    this.creationLog = creationLog;
  }

  public void setCreationLog(Boolean creationLog) {
    this.creationLog = JsonNullable.<Boolean>of(creationLog);
  }


  public HistoricJobLogQueryDto failureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
    
    return this;
  }

   /**
   * Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFailureLog() {
        return failureLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFailureLog_JsonNullable() {
    return failureLog;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILURE_LOG)
  public void setFailureLog_JsonNullable(JsonNullable<Boolean> failureLog) {
    this.failureLog = failureLog;
  }

  public void setFailureLog(Boolean failureLog) {
    this.failureLog = JsonNullable.<Boolean>of(failureLog);
  }


  public HistoricJobLogQueryDto successLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
    
    return this;
  }

   /**
   * Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuccessLog() {
        return successLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuccessLog_JsonNullable() {
    return successLog;
  }
  
  @JsonProperty(JSON_PROPERTY_SUCCESS_LOG)
  public void setSuccessLog_JsonNullable(JsonNullable<Boolean> successLog) {
    this.successLog = successLog;
  }

  public void setSuccessLog(Boolean successLog) {
    this.successLog = JsonNullable.<Boolean>of(successLog);
  }


  public HistoricJobLogQueryDto deletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
    
    return this;
  }

   /**
   * Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getDeletionLog() {
        return deletionLog.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getDeletionLog_JsonNullable() {
    return deletionLog;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETION_LOG)
  public void setDeletionLog_JsonNullable(JsonNullable<Boolean> deletionLog) {
    this.deletionLog = deletionLog;
  }

  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = JsonNullable.<Boolean>of(deletionLog);
  }


  public HistoricJobLogQueryDto sorting(List<HistoricJobLogQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricJobLogQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricJobLogQueryDto addSortingItem(HistoricJobLogQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricJobLogQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for &#x60;count&#x60; endpoints
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricJobLogQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricJobLogQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricJobLogQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricJobLogQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricJobLogQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricJobLogQueryDto historicJobLogQueryDto = (HistoricJobLogQueryDto) o;
    return equalsNullable(this.logId, historicJobLogQueryDto.logId) &&
        equalsNullable(this.jobId, historicJobLogQueryDto.jobId) &&
        equalsNullable(this.jobExceptionMessage, historicJobLogQueryDto.jobExceptionMessage) &&
        equalsNullable(this.jobDefinitionId, historicJobLogQueryDto.jobDefinitionId) &&
        equalsNullable(this.jobDefinitionType, historicJobLogQueryDto.jobDefinitionType) &&
        equalsNullable(this.jobDefinitionConfiguration, historicJobLogQueryDto.jobDefinitionConfiguration) &&
        equalsNullable(this.activityIdIn, historicJobLogQueryDto.activityIdIn) &&
        equalsNullable(this.failedActivityIdIn, historicJobLogQueryDto.failedActivityIdIn) &&
        equalsNullable(this.executionIdIn, historicJobLogQueryDto.executionIdIn) &&
        equalsNullable(this.processInstanceId, historicJobLogQueryDto.processInstanceId) &&
        equalsNullable(this.processDefinitionId, historicJobLogQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicJobLogQueryDto.processDefinitionKey) &&
        equalsNullable(this.deploymentId, historicJobLogQueryDto.deploymentId) &&
        equalsNullable(this.tenantIdIn, historicJobLogQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicJobLogQueryDto.withoutTenantId) &&
        equalsNullable(this.hostname, historicJobLogQueryDto.hostname) &&
        equalsNullable(this.jobPriorityLowerThanOrEquals, historicJobLogQueryDto.jobPriorityLowerThanOrEquals) &&
        equalsNullable(this.jobPriorityHigherThanOrEquals, historicJobLogQueryDto.jobPriorityHigherThanOrEquals) &&
        equalsNullable(this.creationLog, historicJobLogQueryDto.creationLog) &&
        equalsNullable(this.failureLog, historicJobLogQueryDto.failureLog) &&
        equalsNullable(this.successLog, historicJobLogQueryDto.successLog) &&
        equalsNullable(this.deletionLog, historicJobLogQueryDto.deletionLog) &&
        equalsNullable(this.sorting, historicJobLogQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(logId), hashCodeNullable(jobId), hashCodeNullable(jobExceptionMessage), hashCodeNullable(jobDefinitionId), hashCodeNullable(jobDefinitionType), hashCodeNullable(jobDefinitionConfiguration), hashCodeNullable(activityIdIn), hashCodeNullable(failedActivityIdIn), hashCodeNullable(executionIdIn), hashCodeNullable(processInstanceId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(deploymentId), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(hostname), hashCodeNullable(jobPriorityLowerThanOrEquals), hashCodeNullable(jobPriorityHigherThanOrEquals), hashCodeNullable(creationLog), hashCodeNullable(failureLog), hashCodeNullable(successLog), hashCodeNullable(deletionLog), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricJobLogQueryDto {\n");
    sb.append("    logId: ").append(toIndentedString(logId)).append("\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobExceptionMessage: ").append(toIndentedString(jobExceptionMessage)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    jobDefinitionType: ").append(toIndentedString(jobDefinitionType)).append("\n");
    sb.append("    jobDefinitionConfiguration: ").append(toIndentedString(jobDefinitionConfiguration)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    failedActivityIdIn: ").append(toIndentedString(failedActivityIdIn)).append("\n");
    sb.append("    executionIdIn: ").append(toIndentedString(executionIdIn)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    jobPriorityLowerThanOrEquals: ").append(toIndentedString(jobPriorityLowerThanOrEquals)).append("\n");
    sb.append("    jobPriorityHigherThanOrEquals: ").append(toIndentedString(jobPriorityHigherThanOrEquals)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `logId` to the URL query string
    if (getLogId() != null) {
      try {
        joiner.add(String.format("%slogId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLogId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobId` to the URL query string
    if (getJobId() != null) {
      try {
        joiner.add(String.format("%sjobId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobExceptionMessage` to the URL query string
    if (getJobExceptionMessage() != null) {
      try {
        joiner.add(String.format("%sjobExceptionMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobExceptionMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionId` to the URL query string
    if (getJobDefinitionId() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionType` to the URL query string
    if (getJobDefinitionType() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobDefinitionConfiguration` to the URL query string
    if (getJobDefinitionConfiguration() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionConfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityIdIn` to the URL query string
    if (getActivityIdIn() != null) {
      for (int i = 0; i < getActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `failedActivityIdIn` to the URL query string
    if (getFailedActivityIdIn() != null) {
      for (int i = 0; i < getFailedActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sfailedActivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getFailedActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `executionIdIn` to the URL query string
    if (getExecutionIdIn() != null) {
      for (int i = 0; i < getExecutionIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sexecutionIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getExecutionIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deploymentId` to the URL query string
    if (getDeploymentId() != null) {
      try {
        joiner.add(String.format("%sdeploymentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeploymentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hostname` to the URL query string
    if (getHostname() != null) {
      try {
        joiner.add(String.format("%shostname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHostname()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobPriorityLowerThanOrEquals` to the URL query string
    if (getJobPriorityLowerThanOrEquals() != null) {
      try {
        joiner.add(String.format("%sjobPriorityLowerThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobPriorityLowerThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobPriorityHigherThanOrEquals` to the URL query string
    if (getJobPriorityHigherThanOrEquals() != null) {
      try {
        joiner.add(String.format("%sjobPriorityHigherThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobPriorityHigherThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationLog` to the URL query string
    if (getCreationLog() != null) {
      try {
        joiner.add(String.format("%screationLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failureLog` to the URL query string
    if (getFailureLog() != null) {
      try {
        joiner.add(String.format("%sfailureLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailureLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `successLog` to the URL query string
    if (getSuccessLog() != null) {
      try {
        joiner.add(String.format("%ssuccessLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuccessLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletionLog` to the URL query string
    if (getDeletionLog() != null) {
      try {
        joiner.add(String.format("%sdeletionLog%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletionLog()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

