/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricProcessInstanceDto
 */
@JsonPropertyOrder({
  HistoricProcessInstanceDto.JSON_PROPERTY_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_SUPER_CASE_INSTANCE_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  HistoricProcessInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricProcessInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  HistoricProcessInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_BUSINESS_KEY,
  HistoricProcessInstanceDto.JSON_PROPERTY_START_TIME,
  HistoricProcessInstanceDto.JSON_PROPERTY_END_TIME,
  HistoricProcessInstanceDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricProcessInstanceDto.JSON_PROPERTY_DURATION_IN_MILLIS,
  HistoricProcessInstanceDto.JSON_PROPERTY_START_USER_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_START_ACTIVITY_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_DELETE_REASON,
  HistoricProcessInstanceDto.JSON_PROPERTY_TENANT_ID,
  HistoricProcessInstanceDto.JSON_PROPERTY_STATE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricProcessInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID = "superProcessInstanceId";
  private JsonNullable<String> superProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUPER_CASE_INSTANCE_ID = "superCaseInstanceId";
  private JsonNullable<String> superCaseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private JsonNullable<String> processDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  private JsonNullable<Integer> processDefinitionVersion = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_START_TIME = "startTime";
  private JsonNullable<OffsetDateTime> startTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  private JsonNullable<OffsetDateTime> endTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DURATION_IN_MILLIS = "durationInMillis";
  private JsonNullable<Long> durationInMillis = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_START_USER_ID = "startUserId";
  private JsonNullable<String> startUserId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_START_ACTIVITY_ID = "startActivityId";
  private JsonNullable<String> startActivityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DELETE_REASON = "deleteReason";
  private JsonNullable<String> deleteReason = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  /**
   * Last state of the process instance, possible values are:  &#x60;ACTIVE&#x60; - running process instance  &#x60;SUSPENDED&#x60; - suspended process instances  &#x60;COMPLETED&#x60; - completed through normal end event  &#x60;EXTERNALLY_TERMINATED&#x60; - terminated externally, for instance through REST API  &#x60;INTERNALLY_TERMINATED&#x60; - terminated internally, for instance by terminating boundary event
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    SUSPENDED("SUSPENDED"),
    
    COMPLETED("COMPLETED"),
    
    EXTERNALLY_TERMINATED("EXTERNALLY_TERMINATED"),
    
    INTERNALLY_TERMINATED("INTERNALLY_TERMINATED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private JsonNullable<StateEnum> state = JsonNullable.<StateEnum>undefined();

  public HistoricProcessInstanceDto() {
  }

  public HistoricProcessInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the process instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricProcessInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }


  public HistoricProcessInstanceDto superProcessInstanceId(String superProcessInstanceId) {
    this.superProcessInstanceId = JsonNullable.<String>of(superProcessInstanceId);
    
    return this;
  }

   /**
   * The id of the parent process instance, if it exists.
   * @return superProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSuperProcessInstanceId() {
        return superProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSuperProcessInstanceId_JsonNullable() {
    return superProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID)
  public void setSuperProcessInstanceId_JsonNullable(JsonNullable<String> superProcessInstanceId) {
    this.superProcessInstanceId = superProcessInstanceId;
  }

  public void setSuperProcessInstanceId(String superProcessInstanceId) {
    this.superProcessInstanceId = JsonNullable.<String>of(superProcessInstanceId);
  }


  public HistoricProcessInstanceDto superCaseInstanceId(String superCaseInstanceId) {
    this.superCaseInstanceId = JsonNullable.<String>of(superCaseInstanceId);
    
    return this;
  }

   /**
   * The id of the parent case instance, if it exists.
   * @return superCaseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSuperCaseInstanceId() {
        return superCaseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUPER_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSuperCaseInstanceId_JsonNullable() {
    return superCaseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUPER_CASE_INSTANCE_ID)
  public void setSuperCaseInstanceId_JsonNullable(JsonNullable<String> superCaseInstanceId) {
    this.superCaseInstanceId = superCaseInstanceId;
  }

  public void setSuperCaseInstanceId(String superCaseInstanceId) {
    this.superCaseInstanceId = JsonNullable.<String>of(superCaseInstanceId);
  }


  public HistoricProcessInstanceDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The id of the parent case instance, if it exists.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricProcessInstanceDto processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
    
    return this;
  }

   /**
   * The name of the process definition that this process instance belongs to.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionName() {
        return processDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionName_JsonNullable() {
    return processDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  public void setProcessDefinitionName_JsonNullable(JsonNullable<String> processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
  }


  public HistoricProcessInstanceDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition that this process instance belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricProcessInstanceDto processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = JsonNullable.<Integer>of(processDefinitionVersion);
    
    return this;
  }

   /**
   * The version of the process definition that this process instance belongs to.
   * @return processDefinitionVersion
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getProcessDefinitionVersion() {
        return processDefinitionVersion.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getProcessDefinitionVersion_JsonNullable() {
    return processDefinitionVersion;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  public void setProcessDefinitionVersion_JsonNullable(JsonNullable<Integer> processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = JsonNullable.<Integer>of(processDefinitionVersion);
  }


  public HistoricProcessInstanceDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition that this process instance belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricProcessInstanceDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * The business key of the process instance.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public HistoricProcessInstanceDto startTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
    
    return this;
  }

   /**
   * The time the instance was started. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return startTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartTime() {
        return startTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartTime_JsonNullable() {
    return startTime;
  }
  
  @JsonProperty(JSON_PROPERTY_START_TIME)
  public void setStartTime_JsonNullable(JsonNullable<OffsetDateTime> startTime) {
    this.startTime = startTime;
  }

  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
  }


  public HistoricProcessInstanceDto endTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
    
    return this;
  }

   /**
   * The time the instance ended. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return endTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getEndTime() {
        return endTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getEndTime_JsonNullable() {
    return endTime;
  }
  
  @JsonProperty(JSON_PROPERTY_END_TIME)
  public void setEndTime_JsonNullable(JsonNullable<OffsetDateTime> endTime) {
    this.endTime = endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
  }


  public HistoricProcessInstanceDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the instance should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricProcessInstanceDto durationInMillis(Long durationInMillis) {
    this.durationInMillis = JsonNullable.<Long>of(durationInMillis);
    
    return this;
  }

   /**
   * The time the instance took to finish (in milliseconds).
   * @return durationInMillis
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getDurationInMillis() {
        return durationInMillis.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION_IN_MILLIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getDurationInMillis_JsonNullable() {
    return durationInMillis;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION_IN_MILLIS)
  public void setDurationInMillis_JsonNullable(JsonNullable<Long> durationInMillis) {
    this.durationInMillis = durationInMillis;
  }

  public void setDurationInMillis(Long durationInMillis) {
    this.durationInMillis = JsonNullable.<Long>of(durationInMillis);
  }


  public HistoricProcessInstanceDto startUserId(String startUserId) {
    this.startUserId = JsonNullable.<String>of(startUserId);
    
    return this;
  }

   /**
   * The id of the user who started the process instance.
   * @return startUserId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getStartUserId() {
        return startUserId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getStartUserId_JsonNullable() {
    return startUserId;
  }
  
  @JsonProperty(JSON_PROPERTY_START_USER_ID)
  public void setStartUserId_JsonNullable(JsonNullable<String> startUserId) {
    this.startUserId = startUserId;
  }

  public void setStartUserId(String startUserId) {
    this.startUserId = JsonNullable.<String>of(startUserId);
  }


  public HistoricProcessInstanceDto startActivityId(String startActivityId) {
    this.startActivityId = JsonNullable.<String>of(startActivityId);
    
    return this;
  }

   /**
   * The id of the initial activity that was executed (e.g., a start event).
   * @return startActivityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getStartActivityId() {
        return startActivityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getStartActivityId_JsonNullable() {
    return startActivityId;
  }
  
  @JsonProperty(JSON_PROPERTY_START_ACTIVITY_ID)
  public void setStartActivityId_JsonNullable(JsonNullable<String> startActivityId) {
    this.startActivityId = startActivityId;
  }

  public void setStartActivityId(String startActivityId) {
    this.startActivityId = JsonNullable.<String>of(startActivityId);
  }


  public HistoricProcessInstanceDto deleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
    
    return this;
  }

   /**
   * The provided delete reason in case the process instance was canceled during execution.
   * @return deleteReason
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeleteReason() {
        return deleteReason.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeleteReason_JsonNullable() {
    return deleteReason;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  public void setDeleteReason_JsonNullable(JsonNullable<String> deleteReason) {
    this.deleteReason = deleteReason;
  }

  public void setDeleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
  }


  public HistoricProcessInstanceDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the process instance.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricProcessInstanceDto state(StateEnum state) {
    this.state = JsonNullable.<StateEnum>of(state);
    
    return this;
  }

   /**
   * Last state of the process instance, possible values are:  &#x60;ACTIVE&#x60; - running process instance  &#x60;SUSPENDED&#x60; - suspended process instances  &#x60;COMPLETED&#x60; - completed through normal end event  &#x60;EXTERNALLY_TERMINATED&#x60; - terminated externally, for instance through REST API  &#x60;INTERNALLY_TERMINATED&#x60; - terminated internally, for instance by terminating boundary event
   * @return state
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public StateEnum getState() {
        return state.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<StateEnum> getState_JsonNullable() {
    return state;
  }
  
  @JsonProperty(JSON_PROPERTY_STATE)
  public void setState_JsonNullable(JsonNullable<StateEnum> state) {
    this.state = state;
  }

  public void setState(StateEnum state) {
    this.state = JsonNullable.<StateEnum>of(state);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricProcessInstanceDto historicProcessInstanceDto = (HistoricProcessInstanceDto) o;
    return equalsNullable(this.id, historicProcessInstanceDto.id) &&
        equalsNullable(this.rootProcessInstanceId, historicProcessInstanceDto.rootProcessInstanceId) &&
        equalsNullable(this.superProcessInstanceId, historicProcessInstanceDto.superProcessInstanceId) &&
        equalsNullable(this.superCaseInstanceId, historicProcessInstanceDto.superCaseInstanceId) &&
        equalsNullable(this.caseInstanceId, historicProcessInstanceDto.caseInstanceId) &&
        equalsNullable(this.processDefinitionName, historicProcessInstanceDto.processDefinitionName) &&
        equalsNullable(this.processDefinitionKey, historicProcessInstanceDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionVersion, historicProcessInstanceDto.processDefinitionVersion) &&
        equalsNullable(this.processDefinitionId, historicProcessInstanceDto.processDefinitionId) &&
        equalsNullable(this.businessKey, historicProcessInstanceDto.businessKey) &&
        equalsNullable(this.startTime, historicProcessInstanceDto.startTime) &&
        equalsNullable(this.endTime, historicProcessInstanceDto.endTime) &&
        equalsNullable(this.removalTime, historicProcessInstanceDto.removalTime) &&
        equalsNullable(this.durationInMillis, historicProcessInstanceDto.durationInMillis) &&
        equalsNullable(this.startUserId, historicProcessInstanceDto.startUserId) &&
        equalsNullable(this.startActivityId, historicProcessInstanceDto.startActivityId) &&
        equalsNullable(this.deleteReason, historicProcessInstanceDto.deleteReason) &&
        equalsNullable(this.tenantId, historicProcessInstanceDto.tenantId) &&
        equalsNullable(this.state, historicProcessInstanceDto.state);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(rootProcessInstanceId), hashCodeNullable(superProcessInstanceId), hashCodeNullable(superCaseInstanceId), hashCodeNullable(caseInstanceId), hashCodeNullable(processDefinitionName), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionVersion), hashCodeNullable(processDefinitionId), hashCodeNullable(businessKey), hashCodeNullable(startTime), hashCodeNullable(endTime), hashCodeNullable(removalTime), hashCodeNullable(durationInMillis), hashCodeNullable(startUserId), hashCodeNullable(startActivityId), hashCodeNullable(deleteReason), hashCodeNullable(tenantId), hashCodeNullable(state));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricProcessInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    superProcessInstanceId: ").append(toIndentedString(superProcessInstanceId)).append("\n");
    sb.append("    superCaseInstanceId: ").append(toIndentedString(superCaseInstanceId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    durationInMillis: ").append(toIndentedString(durationInMillis)).append("\n");
    sb.append("    startUserId: ").append(toIndentedString(startUserId)).append("\n");
    sb.append("    startActivityId: ").append(toIndentedString(startActivityId)).append("\n");
    sb.append("    deleteReason: ").append(toIndentedString(deleteReason)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `superProcessInstanceId` to the URL query string
    if (getSuperProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%ssuperProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuperProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `superCaseInstanceId` to the URL query string
    if (getSuperCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%ssuperCaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuperCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startTime` to the URL query string
    if (getStartTime() != null) {
      try {
        joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endTime` to the URL query string
    if (getEndTime() != null) {
      try {
        joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `durationInMillis` to the URL query string
    if (getDurationInMillis() != null) {
      try {
        joiner.add(String.format("%sdurationInMillis%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDurationInMillis()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startUserId` to the URL query string
    if (getStartUserId() != null) {
      try {
        joiner.add(String.format("%sstartUserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartUserId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startActivityId` to the URL query string
    if (getStartActivityId() != null) {
      try {
        joiner.add(String.format("%sstartActivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deleteReason` to the URL query string
    if (getDeleteReason() != null) {
      try {
        joiner.add(String.format("%sdeleteReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeleteReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

