/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDtoSortingInner;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A historic process instance query which defines a group of historic process instances
 */
@JsonPropertyOrder({
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_IDS,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY_NOT_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCES,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_FINISHED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_UNFINISHED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_WITH_INCIDENTS,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_WITH_ROOT_INCIDENTS,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_INCIDENT_TYPE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_INCIDENT_STATUS,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_INCIDENT_MESSAGE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_INCIDENT_MESSAGE_LIKE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_STARTED_BEFORE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_STARTED_AFTER,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_FINISHED_BEFORE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_FINISHED_AFTER,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXECUTED_ACTIVITY_AFTER,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXECUTED_ACTIVITY_BEFORE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXECUTED_JOB_AFTER,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXECUTED_JOB_BEFORE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_STARTED_BY,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SUB_PROCESS_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SUPER_CASE_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SUB_CASE_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXECUTED_ACTIVITY_ID_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_ACTIVE_ACTIVITY_ID_IN,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_ACTIVE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SUSPENDED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_COMPLETED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_EXTERNALLY_TERMINATED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_INTERNALLY_TERMINATED,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_VARIABLES,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_OR_QUERIES,
  HistoricProcessInstanceQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricProcessInstanceQueryDto {
  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_IDS = "processInstanceIds";
  private JsonNullable<List<String>> processInstanceIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
  private JsonNullable<List<String>> processDefinitionKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private JsonNullable<String> processDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE = "processDefinitionNameLike";
  private JsonNullable<String> processDefinitionNameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY_NOT_IN = "processDefinitionKeyNotIn";
  private JsonNullable<List<String>> processDefinitionKeyNotIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
  private JsonNullable<String> processInstanceBusinessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
  private JsonNullable<List<String>> processInstanceBusinessKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
  private JsonNullable<String> processInstanceBusinessKeyLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCES = "rootProcessInstances";
  private JsonNullable<Boolean> rootProcessInstances = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FINISHED = "finished";
  private JsonNullable<Boolean> finished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UNFINISHED = "unfinished";
  private JsonNullable<Boolean> unfinished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITH_INCIDENTS = "withIncidents";
  private JsonNullable<Boolean> withIncidents = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITH_ROOT_INCIDENTS = "withRootIncidents";
  private JsonNullable<Boolean> withRootIncidents = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INCIDENT_TYPE = "incidentType";
  private JsonNullable<String> incidentType = JsonNullable.<String>undefined();

  /**
   * Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
   */
  public enum IncidentStatusEnum {
    OPEN("open"),
    
    RESOLVED("resolved");

    private String value;

    IncidentStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IncidentStatusEnum fromValue(String value) {
      for (IncidentStatusEnum b : IncidentStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_INCIDENT_STATUS = "incidentStatus";
  private JsonNullable<IncidentStatusEnum> incidentStatus = JsonNullable.<IncidentStatusEnum>undefined();

  public static final String JSON_PROPERTY_INCIDENT_MESSAGE = "incidentMessage";
  private JsonNullable<String> incidentMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
  private JsonNullable<String> incidentMessageLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_STARTED_BEFORE = "startedBefore";
  private JsonNullable<OffsetDateTime> startedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_STARTED_AFTER = "startedAfter";
  private JsonNullable<OffsetDateTime> startedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_BEFORE = "finishedBefore";
  private JsonNullable<OffsetDateTime> finishedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_AFTER = "finishedAfter";
  private JsonNullable<OffsetDateTime> finishedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_EXECUTED_ACTIVITY_AFTER = "executedActivityAfter";
  private JsonNullable<OffsetDateTime> executedActivityAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_EXECUTED_ACTIVITY_BEFORE = "executedActivityBefore";
  private JsonNullable<OffsetDateTime> executedActivityBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_EXECUTED_JOB_AFTER = "executedJobAfter";
  private JsonNullable<OffsetDateTime> executedJobAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_EXECUTED_JOB_BEFORE = "executedJobBefore";
  private JsonNullable<OffsetDateTime> executedJobBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_STARTED_BY = "startedBy";
  private JsonNullable<String> startedBy = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID = "superProcessInstanceId";
  private JsonNullable<String> superProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUB_PROCESS_INSTANCE_ID = "subProcessInstanceId";
  private JsonNullable<String> subProcessInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUPER_CASE_INSTANCE_ID = "superCaseInstanceId";
  private JsonNullable<String> superCaseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUB_CASE_INSTANCE_ID = "subCaseInstanceId";
  private JsonNullable<String> subCaseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXECUTED_ACTIVITY_ID_IN = "executedActivityIdIn";
  private JsonNullable<List<String>> executedActivityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ACTIVE_ACTIVITY_ID_IN = "activeActivityIdIn";
  private JsonNullable<List<String>> activeActivityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_COMPLETED = "completed";
  private JsonNullable<Boolean> completed = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXTERNALLY_TERMINATED = "externallyTerminated";
  private JsonNullable<Boolean> externallyTerminated = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INTERNALLY_TERMINATED = "internallyTerminated";
  private JsonNullable<Boolean> internallyTerminated = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<List<VariableQueryParameterDto>> variables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  private JsonNullable<Boolean> variableNamesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  private JsonNullable<Boolean> variableValuesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_OR_QUERIES = "orQueries";
  private JsonNullable<List<HistoricProcessInstanceQueryDto>> orQueries = JsonNullable.<List<HistoricProcessInstanceQueryDto>>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricProcessInstanceQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricProcessInstanceQueryDtoSortingInner>>undefined();

  public HistoricProcessInstanceQueryDto() {
  }

  public HistoricProcessInstanceQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricProcessInstanceQueryDto processInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
    if (this.processInstanceIds == null || !this.processInstanceIds.isPresent()) {
      this.processInstanceIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIds.get().add(processInstanceIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by process instance ids. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processInstanceIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIds() {
        return processInstanceIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIds_JsonNullable() {
    return processInstanceIds;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  public void setProcessInstanceIds_JsonNullable(JsonNullable<List<String>> processInstanceIds) {
    this.processInstanceIds = processInstanceIds;
  }

  public void setProcessInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
  }


  public HistoricProcessInstanceQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by the process definition the instances run on.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricProcessInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by the key of the process definition the instances run on.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricProcessInstanceQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = JsonNullable.<List<String>>of(processDefinitionKeyIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
    if (this.processDefinitionKeyIn == null || !this.processDefinitionKeyIn.isPresent()) {
      this.processDefinitionKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processDefinitionKeyIn.get().add(processDefinitionKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessDefinitionKeyIn() {
        return processDefinitionKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessDefinitionKeyIn_JsonNullable() {
    return processDefinitionKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN)
  public void setProcessDefinitionKeyIn_JsonNullable(JsonNullable<List<String>> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = processDefinitionKeyIn;
  }

  public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = JsonNullable.<List<String>>of(processDefinitionKeyIn);
  }


  public HistoricProcessInstanceQueryDto processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
    
    return this;
  }

   /**
   * Filter by the name of the process definition the instances run on.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionName() {
        return processDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionName_JsonNullable() {
    return processDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  public void setProcessDefinitionName_JsonNullable(JsonNullable<String> processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
  }


  public HistoricProcessInstanceQueryDto processDefinitionNameLike(String processDefinitionNameLike) {
    this.processDefinitionNameLike = JsonNullable.<String>of(processDefinitionNameLike);
    
    return this;
  }

   /**
   * Filter by process definition names that the parameter is a substring of.
   * @return processDefinitionNameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionNameLike() {
        return processDefinitionNameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionNameLike_JsonNullable() {
    return processDefinitionNameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE)
  public void setProcessDefinitionNameLike_JsonNullable(JsonNullable<String> processDefinitionNameLike) {
    this.processDefinitionNameLike = processDefinitionNameLike;
  }

  public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
    this.processDefinitionNameLike = JsonNullable.<String>of(processDefinitionNameLike);
  }


  public HistoricProcessInstanceQueryDto processDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
    this.processDefinitionKeyNotIn = JsonNullable.<List<String>>of(processDefinitionKeyNotIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessDefinitionKeyNotInItem(String processDefinitionKeyNotInItem) {
    if (this.processDefinitionKeyNotIn == null || !this.processDefinitionKeyNotIn.isPresent()) {
      this.processDefinitionKeyNotIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processDefinitionKeyNotIn.get().add(processDefinitionKeyNotInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Exclude instances that belong to a set of process definitions. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processDefinitionKeyNotIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessDefinitionKeyNotIn() {
        return processDefinitionKeyNotIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_NOT_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessDefinitionKeyNotIn_JsonNullable() {
    return processDefinitionKeyNotIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_NOT_IN)
  public void setProcessDefinitionKeyNotIn_JsonNullable(JsonNullable<List<String>> processDefinitionKeyNotIn) {
    this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
  }

  public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
    this.processDefinitionKeyNotIn = JsonNullable.<List<String>>of(processDefinitionKeyNotIn);
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
    
    return this;
  }

   /**
   * Filter by process instance business key.
   * @return processInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKey() {
        return processInstanceBusinessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKey_JsonNullable() {
    return processInstanceBusinessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  public void setProcessInstanceBusinessKey_JsonNullable(JsonNullable<String> processInstanceBusinessKey) {
    this.processInstanceBusinessKey = processInstanceBusinessKey;
  }

  public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
    if (this.processInstanceBusinessKeyIn == null || !this.processInstanceBusinessKeyIn.isPresent()) {
      this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceBusinessKeyIn.get().add(processInstanceBusinessKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a list of business keys. A process instance must have one of the given business keys. Must be a JSON array of &#x60;Strings&#x60;
   * @return processInstanceBusinessKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceBusinessKeyIn() {
        return processInstanceBusinessKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceBusinessKeyIn_JsonNullable() {
    return processInstanceBusinessKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  public void setProcessInstanceBusinessKeyIn_JsonNullable(JsonNullable<List<String>> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
  }

  public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
    
    return this;
  }

   /**
   * Filter by process instance business key that the parameter is a substring of.
   * @return processInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKeyLike() {
        return processInstanceBusinessKeyLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKeyLike_JsonNullable() {
    return processInstanceBusinessKeyLike;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  public void setProcessInstanceBusinessKeyLike_JsonNullable(JsonNullable<String> processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
  }

  public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
  }


  public HistoricProcessInstanceQueryDto rootProcessInstances(Boolean rootProcessInstances) {
    this.rootProcessInstances = JsonNullable.<Boolean>of(rootProcessInstances);
    
    return this;
  }

   /**
   * Restrict the query to all process instances that are top level process instances.
   * @return rootProcessInstances
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getRootProcessInstances() {
        return rootProcessInstances.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getRootProcessInstances_JsonNullable() {
    return rootProcessInstances;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCES)
  public void setRootProcessInstances_JsonNullable(JsonNullable<Boolean> rootProcessInstances) {
    this.rootProcessInstances = rootProcessInstances;
  }

  public void setRootProcessInstances(Boolean rootProcessInstances) {
    this.rootProcessInstances = JsonNullable.<Boolean>of(rootProcessInstances);
  }


  public HistoricProcessInstanceQueryDto finished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
    
    return this;
  }

   /**
   * Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return finished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFinished() {
        return finished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFinished_JsonNullable() {
    return finished;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED)
  public void setFinished_JsonNullable(JsonNullable<Boolean> finished) {
    this.finished = finished;
  }

  public void setFinished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
  }


  public HistoricProcessInstanceQueryDto unfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
    
    return this;
  }

   /**
   * Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnfinished() {
        return unfinished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnfinished_JsonNullable() {
    return unfinished;
  }
  
  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  public void setUnfinished_JsonNullable(JsonNullable<Boolean> unfinished) {
    this.unfinished = unfinished;
  }

  public void setUnfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
  }


  public HistoricProcessInstanceQueryDto withIncidents(Boolean withIncidents) {
    this.withIncidents = JsonNullable.<Boolean>of(withIncidents);
    
    return this;
  }

   /**
   * Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withIncidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithIncidents() {
        return withIncidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithIncidents_JsonNullable() {
    return withIncidents;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_INCIDENTS)
  public void setWithIncidents_JsonNullable(JsonNullable<Boolean> withIncidents) {
    this.withIncidents = withIncidents;
  }

  public void setWithIncidents(Boolean withIncidents) {
    this.withIncidents = JsonNullable.<Boolean>of(withIncidents);
  }


  public HistoricProcessInstanceQueryDto withRootIncidents(Boolean withRootIncidents) {
    this.withRootIncidents = JsonNullable.<Boolean>of(withRootIncidents);
    
    return this;
  }

   /**
   * Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withRootIncidents
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithRootIncidents() {
        return withRootIncidents.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_ROOT_INCIDENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithRootIncidents_JsonNullable() {
    return withRootIncidents;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_ROOT_INCIDENTS)
  public void setWithRootIncidents_JsonNullable(JsonNullable<Boolean> withRootIncidents) {
    this.withRootIncidents = withRootIncidents;
  }

  public void setWithRootIncidents(Boolean withRootIncidents) {
    this.withRootIncidents = JsonNullable.<Boolean>of(withRootIncidents);
  }


  public HistoricProcessInstanceQueryDto incidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
    
    return this;
  }

   /**
   * Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
   * @return incidentType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentType() {
        return incidentType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentType_JsonNullable() {
    return incidentType;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_TYPE)
  public void setIncidentType_JsonNullable(JsonNullable<String> incidentType) {
    this.incidentType = incidentType;
  }

  public void setIncidentType(String incidentType) {
    this.incidentType = JsonNullable.<String>of(incidentType);
  }


  public HistoricProcessInstanceQueryDto incidentStatus(IncidentStatusEnum incidentStatus) {
    this.incidentStatus = JsonNullable.<IncidentStatusEnum>of(incidentStatus);
    
    return this;
  }

   /**
   * Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
   * @return incidentStatus
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public IncidentStatusEnum getIncidentStatus() {
        return incidentStatus.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<IncidentStatusEnum> getIncidentStatus_JsonNullable() {
    return incidentStatus;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_STATUS)
  public void setIncidentStatus_JsonNullable(JsonNullable<IncidentStatusEnum> incidentStatus) {
    this.incidentStatus = incidentStatus;
  }

  public void setIncidentStatus(IncidentStatusEnum incidentStatus) {
    this.incidentStatus = JsonNullable.<IncidentStatusEnum>of(incidentStatus);
  }


  public HistoricProcessInstanceQueryDto incidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
    
    return this;
  }

   /**
   * Filter by the incident message. Exact match.
   * @return incidentMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentMessage() {
        return incidentMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentMessage_JsonNullable() {
    return incidentMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE)
  public void setIncidentMessage_JsonNullable(JsonNullable<String> incidentMessage) {
    this.incidentMessage = incidentMessage;
  }

  public void setIncidentMessage(String incidentMessage) {
    this.incidentMessage = JsonNullable.<String>of(incidentMessage);
  }


  public HistoricProcessInstanceQueryDto incidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = JsonNullable.<String>of(incidentMessageLike);
    
    return this;
  }

   /**
   * Filter by the incident message that the parameter is a substring of.
   * @return incidentMessageLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getIncidentMessageLike() {
        return incidentMessageLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getIncidentMessageLike_JsonNullable() {
    return incidentMessageLike;
  }
  
  @JsonProperty(JSON_PROPERTY_INCIDENT_MESSAGE_LIKE)
  public void setIncidentMessageLike_JsonNullable(JsonNullable<String> incidentMessageLike) {
    this.incidentMessageLike = incidentMessageLike;
  }

  public void setIncidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = JsonNullable.<String>of(incidentMessageLike);
  }


  public HistoricProcessInstanceQueryDto startedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
    
    return this;
  }

   /**
   * Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedBefore() {
        return startedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedBefore_JsonNullable() {
    return startedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  public void setStartedBefore_JsonNullable(JsonNullable<OffsetDateTime> startedBefore) {
    this.startedBefore = startedBefore;
  }

  public void setStartedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
  }


  public HistoricProcessInstanceQueryDto startedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
    
    return this;
  }

   /**
   * Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedAfter() {
        return startedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedAfter_JsonNullable() {
    return startedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  public void setStartedAfter_JsonNullable(JsonNullable<OffsetDateTime> startedAfter) {
    this.startedAfter = startedAfter;
  }

  public void setStartedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
  }


  public HistoricProcessInstanceQueryDto finishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
    
    return this;
  }

   /**
   * Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedBefore() {
        return finishedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedBefore_JsonNullable() {
    return finishedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  public void setFinishedBefore_JsonNullable(JsonNullable<OffsetDateTime> finishedBefore) {
    this.finishedBefore = finishedBefore;
  }

  public void setFinishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
  }


  public HistoricProcessInstanceQueryDto finishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
    
    return this;
  }

   /**
   * Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedAfter() {
        return finishedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedAfter_JsonNullable() {
    return finishedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  public void setFinishedAfter_JsonNullable(JsonNullable<OffsetDateTime> finishedAfter) {
    this.finishedAfter = finishedAfter;
  }

  public void setFinishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
  }


  public HistoricProcessInstanceQueryDto executedActivityAfter(OffsetDateTime executedActivityAfter) {
    this.executedActivityAfter = JsonNullable.<OffsetDateTime>of(executedActivityAfter);
    
    return this;
  }

   /**
   * Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedActivityAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getExecutedActivityAfter() {
        return executedActivityAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getExecutedActivityAfter_JsonNullable() {
    return executedActivityAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_AFTER)
  public void setExecutedActivityAfter_JsonNullable(JsonNullable<OffsetDateTime> executedActivityAfter) {
    this.executedActivityAfter = executedActivityAfter;
  }

  public void setExecutedActivityAfter(OffsetDateTime executedActivityAfter) {
    this.executedActivityAfter = JsonNullable.<OffsetDateTime>of(executedActivityAfter);
  }


  public HistoricProcessInstanceQueryDto executedActivityBefore(OffsetDateTime executedActivityBefore) {
    this.executedActivityBefore = JsonNullable.<OffsetDateTime>of(executedActivityBefore);
    
    return this;
  }

   /**
   * Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedActivityBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getExecutedActivityBefore() {
        return executedActivityBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getExecutedActivityBefore_JsonNullable() {
    return executedActivityBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_BEFORE)
  public void setExecutedActivityBefore_JsonNullable(JsonNullable<OffsetDateTime> executedActivityBefore) {
    this.executedActivityBefore = executedActivityBefore;
  }

  public void setExecutedActivityBefore(OffsetDateTime executedActivityBefore) {
    this.executedActivityBefore = JsonNullable.<OffsetDateTime>of(executedActivityBefore);
  }


  public HistoricProcessInstanceQueryDto executedJobAfter(OffsetDateTime executedJobAfter) {
    this.executedJobAfter = JsonNullable.<OffsetDateTime>of(executedJobAfter);
    
    return this;
  }

   /**
   * Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedJobAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getExecutedJobAfter() {
        return executedJobAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTED_JOB_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getExecutedJobAfter_JsonNullable() {
    return executedJobAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTED_JOB_AFTER)
  public void setExecutedJobAfter_JsonNullable(JsonNullable<OffsetDateTime> executedJobAfter) {
    this.executedJobAfter = executedJobAfter;
  }

  public void setExecutedJobAfter(OffsetDateTime executedJobAfter) {
    this.executedJobAfter = JsonNullable.<OffsetDateTime>of(executedJobAfter);
  }


  public HistoricProcessInstanceQueryDto executedJobBefore(OffsetDateTime executedJobBefore) {
    this.executedJobBefore = JsonNullable.<OffsetDateTime>of(executedJobBefore);
    
    return this;
  }

   /**
   * Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedJobBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getExecutedJobBefore() {
        return executedJobBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTED_JOB_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getExecutedJobBefore_JsonNullable() {
    return executedJobBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTED_JOB_BEFORE)
  public void setExecutedJobBefore_JsonNullable(JsonNullable<OffsetDateTime> executedJobBefore) {
    this.executedJobBefore = executedJobBefore;
  }

  public void setExecutedJobBefore(OffsetDateTime executedJobBefore) {
    this.executedJobBefore = JsonNullable.<OffsetDateTime>of(executedJobBefore);
  }


  public HistoricProcessInstanceQueryDto startedBy(String startedBy) {
    this.startedBy = JsonNullable.<String>of(startedBy);
    
    return this;
  }

   /**
   * Only include process instances that were started by the given user.
   * @return startedBy
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getStartedBy() {
        return startedBy.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getStartedBy_JsonNullable() {
    return startedBy;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_BY)
  public void setStartedBy_JsonNullable(JsonNullable<String> startedBy) {
    this.startedBy = startedBy;
  }

  public void setStartedBy(String startedBy) {
    this.startedBy = JsonNullable.<String>of(startedBy);
  }


  public HistoricProcessInstanceQueryDto superProcessInstanceId(String superProcessInstanceId) {
    this.superProcessInstanceId = JsonNullable.<String>of(superProcessInstanceId);
    
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
   * @return superProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSuperProcessInstanceId() {
        return superProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSuperProcessInstanceId_JsonNullable() {
    return superProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUPER_PROCESS_INSTANCE_ID)
  public void setSuperProcessInstanceId_JsonNullable(JsonNullable<String> superProcessInstanceId) {
    this.superProcessInstanceId = superProcessInstanceId;
  }

  public void setSuperProcessInstanceId(String superProcessInstanceId) {
    this.superProcessInstanceId = JsonNullable.<String>of(superProcessInstanceId);
  }


  public HistoricProcessInstanceQueryDto subProcessInstanceId(String subProcessInstanceId) {
    this.subProcessInstanceId = JsonNullable.<String>of(subProcessInstanceId);
    
    return this;
  }

   /**
   * Restrict query to one process instance that has a sub process instance with the given id.
   * @return subProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSubProcessInstanceId() {
        return subProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUB_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSubProcessInstanceId_JsonNullable() {
    return subProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUB_PROCESS_INSTANCE_ID)
  public void setSubProcessInstanceId_JsonNullable(JsonNullable<String> subProcessInstanceId) {
    this.subProcessInstanceId = subProcessInstanceId;
  }

  public void setSubProcessInstanceId(String subProcessInstanceId) {
    this.subProcessInstanceId = JsonNullable.<String>of(subProcessInstanceId);
  }


  public HistoricProcessInstanceQueryDto superCaseInstanceId(String superCaseInstanceId) {
    this.superCaseInstanceId = JsonNullable.<String>of(superCaseInstanceId);
    
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
   * @return superCaseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSuperCaseInstanceId() {
        return superCaseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUPER_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSuperCaseInstanceId_JsonNullable() {
    return superCaseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUPER_CASE_INSTANCE_ID)
  public void setSuperCaseInstanceId_JsonNullable(JsonNullable<String> superCaseInstanceId) {
    this.superCaseInstanceId = superCaseInstanceId;
  }

  public void setSuperCaseInstanceId(String superCaseInstanceId) {
    this.superCaseInstanceId = JsonNullable.<String>of(superCaseInstanceId);
  }


  public HistoricProcessInstanceQueryDto subCaseInstanceId(String subCaseInstanceId) {
    this.subCaseInstanceId = JsonNullable.<String>of(subCaseInstanceId);
    
    return this;
  }

   /**
   * Restrict query to one process instance that has a sub case instance with the given id.
   * @return subCaseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSubCaseInstanceId() {
        return subCaseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUB_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSubCaseInstanceId_JsonNullable() {
    return subCaseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_SUB_CASE_INSTANCE_ID)
  public void setSubCaseInstanceId_JsonNullable(JsonNullable<String> subCaseInstanceId) {
    this.subCaseInstanceId = subCaseInstanceId;
  }

  public void setSubCaseInstanceId(String subCaseInstanceId) {
    this.subCaseInstanceId = JsonNullable.<String>of(subCaseInstanceId);
  }


  public HistoricProcessInstanceQueryDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricProcessInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricProcessInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricProcessInstanceQueryDto executedActivityIdIn(List<String> executedActivityIdIn) {
    this.executedActivityIdIn = JsonNullable.<List<String>>of(executedActivityIdIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addExecutedActivityIdInItem(String executedActivityIdInItem) {
    if (this.executedActivityIdIn == null || !this.executedActivityIdIn.isPresent()) {
      this.executedActivityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.executedActivityIdIn.get().add(executedActivityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to instances that executed an activity with one of given ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return executedActivityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getExecutedActivityIdIn() {
        return executedActivityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getExecutedActivityIdIn_JsonNullable() {
    return executedActivityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTED_ACTIVITY_ID_IN)
  public void setExecutedActivityIdIn_JsonNullable(JsonNullable<List<String>> executedActivityIdIn) {
    this.executedActivityIdIn = executedActivityIdIn;
  }

  public void setExecutedActivityIdIn(List<String> executedActivityIdIn) {
    this.executedActivityIdIn = JsonNullable.<List<String>>of(executedActivityIdIn);
  }


  public HistoricProcessInstanceQueryDto activeActivityIdIn(List<String> activeActivityIdIn) {
    this.activeActivityIdIn = JsonNullable.<List<String>>of(activeActivityIdIn);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addActiveActivityIdInItem(String activeActivityIdInItem) {
    if (this.activeActivityIdIn == null || !this.activeActivityIdIn.isPresent()) {
      this.activeActivityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activeActivityIdIn.get().add(activeActivityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to instances that have an active activity with one of given ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return activeActivityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActiveActivityIdIn() {
        return activeActivityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActiveActivityIdIn_JsonNullable() {
    return activeActivityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE_ACTIVITY_ID_IN)
  public void setActiveActivityIdIn_JsonNullable(JsonNullable<List<String>> activeActivityIdIn) {
    this.activeActivityIdIn = activeActivityIdIn;
  }

  public void setActiveActivityIdIn(List<String> activeActivityIdIn) {
    this.activeActivityIdIn = JsonNullable.<List<String>>of(activeActivityIdIn);
  }


  public HistoricProcessInstanceQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Restrict to instances that are active.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public HistoricProcessInstanceQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Restrict to instances that are suspended.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public HistoricProcessInstanceQueryDto completed(Boolean completed) {
    this.completed = JsonNullable.<Boolean>of(completed);
    
    return this;
  }

   /**
   * Restrict to instances that are completed.
   * @return completed
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCompleted() {
        return completed.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COMPLETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCompleted_JsonNullable() {
    return completed;
  }
  
  @JsonProperty(JSON_PROPERTY_COMPLETED)
  public void setCompleted_JsonNullable(JsonNullable<Boolean> completed) {
    this.completed = completed;
  }

  public void setCompleted(Boolean completed) {
    this.completed = JsonNullable.<Boolean>of(completed);
  }


  public HistoricProcessInstanceQueryDto externallyTerminated(Boolean externallyTerminated) {
    this.externallyTerminated = JsonNullable.<Boolean>of(externallyTerminated);
    
    return this;
  }

   /**
   * Restrict to instances that are externallyTerminated.
   * @return externallyTerminated
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getExternallyTerminated() {
        return externallyTerminated.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXTERNALLY_TERMINATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getExternallyTerminated_JsonNullable() {
    return externallyTerminated;
  }
  
  @JsonProperty(JSON_PROPERTY_EXTERNALLY_TERMINATED)
  public void setExternallyTerminated_JsonNullable(JsonNullable<Boolean> externallyTerminated) {
    this.externallyTerminated = externallyTerminated;
  }

  public void setExternallyTerminated(Boolean externallyTerminated) {
    this.externallyTerminated = JsonNullable.<Boolean>of(externallyTerminated);
  }


  public HistoricProcessInstanceQueryDto internallyTerminated(Boolean internallyTerminated) {
    this.internallyTerminated = JsonNullable.<Boolean>of(internallyTerminated);
    
    return this;
  }

   /**
   * Restrict to instances that are internallyTerminated.
   * @return internallyTerminated
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getInternallyTerminated() {
        return internallyTerminated.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INTERNALLY_TERMINATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getInternallyTerminated_JsonNullable() {
    return internallyTerminated;
  }
  
  @JsonProperty(JSON_PROPERTY_INTERNALLY_TERMINATED)
  public void setInternallyTerminated_JsonNullable(JsonNullable<Boolean> internallyTerminated) {
    this.internallyTerminated = internallyTerminated;
  }

  public void setInternallyTerminated(Boolean internallyTerminated) {
    this.internallyTerminated = JsonNullable.<Boolean>of(internallyTerminated);
  }


  public HistoricProcessInstanceQueryDto variables(List<VariableQueryParameterDto> variables) {
    this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(variables);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.variables.get().add(variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name&#x60; (&#x60;String&#x60;) is the variable name, &#x60;operator&#x60; (&#x60;String&#x60;) is the comparison operator to be used and &#x60;value&#x60; the variable value.  Value may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. 
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(List<VariableQueryParameterDto> variables) {
    this.variables = JsonNullable.<List<VariableQueryParameterDto>>of(variables);
  }


  public HistoricProcessInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableNamesIgnoreCase() {
        return variableNamesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableNamesIgnoreCase_JsonNullable() {
    return variableNamesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  public void setVariableNamesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }

  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
  }


  public HistoricProcessInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableValuesIgnoreCase() {
        return variableValuesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableValuesIgnoreCase_JsonNullable() {
    return variableValuesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  public void setVariableValuesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }

  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
  }


  public HistoricProcessInstanceQueryDto orQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<HistoricProcessInstanceQueryDto>>of(orQueries);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addOrQueriesItem(HistoricProcessInstanceQueryDto orQueriesItem) {
    if (this.orQueries == null || !this.orQueries.isPresent()) {
      this.orQueries = JsonNullable.<List<HistoricProcessInstanceQueryDto>>of(new ArrayList<>());
    }
    try {
      this.orQueries.get().add(orQueriesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query&#39;s predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: &#x60;sorting&#x60;  See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.
   * @return orQueries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricProcessInstanceQueryDto> getOrQueries() {
        return orQueries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricProcessInstanceQueryDto>> getOrQueries_JsonNullable() {
    return orQueries;
  }
  
  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  public void setOrQueries_JsonNullable(JsonNullable<List<HistoricProcessInstanceQueryDto>> orQueries) {
    this.orQueries = orQueries;
  }

  public void setOrQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<HistoricProcessInstanceQueryDto>>of(orQueries);
  }


  public HistoricProcessInstanceQueryDto sorting(List<HistoricProcessInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricProcessInstanceQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricProcessInstanceQueryDto addSortingItem(HistoricProcessInstanceQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricProcessInstanceQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricProcessInstanceQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricProcessInstanceQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricProcessInstanceQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricProcessInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricProcessInstanceQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto = (HistoricProcessInstanceQueryDto) o;
    return equalsNullable(this.processInstanceId, historicProcessInstanceQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIds, historicProcessInstanceQueryDto.processInstanceIds) &&
        equalsNullable(this.processDefinitionId, historicProcessInstanceQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicProcessInstanceQueryDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionKeyIn, historicProcessInstanceQueryDto.processDefinitionKeyIn) &&
        equalsNullable(this.processDefinitionName, historicProcessInstanceQueryDto.processDefinitionName) &&
        equalsNullable(this.processDefinitionNameLike, historicProcessInstanceQueryDto.processDefinitionNameLike) &&
        equalsNullable(this.processDefinitionKeyNotIn, historicProcessInstanceQueryDto.processDefinitionKeyNotIn) &&
        equalsNullable(this.processInstanceBusinessKey, historicProcessInstanceQueryDto.processInstanceBusinessKey) &&
        equalsNullable(this.processInstanceBusinessKeyIn, historicProcessInstanceQueryDto.processInstanceBusinessKeyIn) &&
        equalsNullable(this.processInstanceBusinessKeyLike, historicProcessInstanceQueryDto.processInstanceBusinessKeyLike) &&
        equalsNullable(this.rootProcessInstances, historicProcessInstanceQueryDto.rootProcessInstances) &&
        equalsNullable(this.finished, historicProcessInstanceQueryDto.finished) &&
        equalsNullable(this.unfinished, historicProcessInstanceQueryDto.unfinished) &&
        equalsNullable(this.withIncidents, historicProcessInstanceQueryDto.withIncidents) &&
        equalsNullable(this.withRootIncidents, historicProcessInstanceQueryDto.withRootIncidents) &&
        equalsNullable(this.incidentType, historicProcessInstanceQueryDto.incidentType) &&
        equalsNullable(this.incidentStatus, historicProcessInstanceQueryDto.incidentStatus) &&
        equalsNullable(this.incidentMessage, historicProcessInstanceQueryDto.incidentMessage) &&
        equalsNullable(this.incidentMessageLike, historicProcessInstanceQueryDto.incidentMessageLike) &&
        equalsNullable(this.startedBefore, historicProcessInstanceQueryDto.startedBefore) &&
        equalsNullable(this.startedAfter, historicProcessInstanceQueryDto.startedAfter) &&
        equalsNullable(this.finishedBefore, historicProcessInstanceQueryDto.finishedBefore) &&
        equalsNullable(this.finishedAfter, historicProcessInstanceQueryDto.finishedAfter) &&
        equalsNullable(this.executedActivityAfter, historicProcessInstanceQueryDto.executedActivityAfter) &&
        equalsNullable(this.executedActivityBefore, historicProcessInstanceQueryDto.executedActivityBefore) &&
        equalsNullable(this.executedJobAfter, historicProcessInstanceQueryDto.executedJobAfter) &&
        equalsNullable(this.executedJobBefore, historicProcessInstanceQueryDto.executedJobBefore) &&
        equalsNullable(this.startedBy, historicProcessInstanceQueryDto.startedBy) &&
        equalsNullable(this.superProcessInstanceId, historicProcessInstanceQueryDto.superProcessInstanceId) &&
        equalsNullable(this.subProcessInstanceId, historicProcessInstanceQueryDto.subProcessInstanceId) &&
        equalsNullable(this.superCaseInstanceId, historicProcessInstanceQueryDto.superCaseInstanceId) &&
        equalsNullable(this.subCaseInstanceId, historicProcessInstanceQueryDto.subCaseInstanceId) &&
        equalsNullable(this.caseInstanceId, historicProcessInstanceQueryDto.caseInstanceId) &&
        equalsNullable(this.tenantIdIn, historicProcessInstanceQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicProcessInstanceQueryDto.withoutTenantId) &&
        equalsNullable(this.executedActivityIdIn, historicProcessInstanceQueryDto.executedActivityIdIn) &&
        equalsNullable(this.activeActivityIdIn, historicProcessInstanceQueryDto.activeActivityIdIn) &&
        equalsNullable(this.active, historicProcessInstanceQueryDto.active) &&
        equalsNullable(this.suspended, historicProcessInstanceQueryDto.suspended) &&
        equalsNullable(this.completed, historicProcessInstanceQueryDto.completed) &&
        equalsNullable(this.externallyTerminated, historicProcessInstanceQueryDto.externallyTerminated) &&
        equalsNullable(this.internallyTerminated, historicProcessInstanceQueryDto.internallyTerminated) &&
        equalsNullable(this.variables, historicProcessInstanceQueryDto.variables) &&
        equalsNullable(this.variableNamesIgnoreCase, historicProcessInstanceQueryDto.variableNamesIgnoreCase) &&
        equalsNullable(this.variableValuesIgnoreCase, historicProcessInstanceQueryDto.variableValuesIgnoreCase) &&
        equalsNullable(this.orQueries, historicProcessInstanceQueryDto.orQueries) &&
        equalsNullable(this.sorting, historicProcessInstanceQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIds), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionKeyIn), hashCodeNullable(processDefinitionName), hashCodeNullable(processDefinitionNameLike), hashCodeNullable(processDefinitionKeyNotIn), hashCodeNullable(processInstanceBusinessKey), hashCodeNullable(processInstanceBusinessKeyIn), hashCodeNullable(processInstanceBusinessKeyLike), hashCodeNullable(rootProcessInstances), hashCodeNullable(finished), hashCodeNullable(unfinished), hashCodeNullable(withIncidents), hashCodeNullable(withRootIncidents), hashCodeNullable(incidentType), hashCodeNullable(incidentStatus), hashCodeNullable(incidentMessage), hashCodeNullable(incidentMessageLike), hashCodeNullable(startedBefore), hashCodeNullable(startedAfter), hashCodeNullable(finishedBefore), hashCodeNullable(finishedAfter), hashCodeNullable(executedActivityAfter), hashCodeNullable(executedActivityBefore), hashCodeNullable(executedJobAfter), hashCodeNullable(executedJobBefore), hashCodeNullable(startedBy), hashCodeNullable(superProcessInstanceId), hashCodeNullable(subProcessInstanceId), hashCodeNullable(superCaseInstanceId), hashCodeNullable(subCaseInstanceId), hashCodeNullable(caseInstanceId), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(executedActivityIdIn), hashCodeNullable(activeActivityIdIn), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(completed), hashCodeNullable(externallyTerminated), hashCodeNullable(internallyTerminated), hashCodeNullable(variables), hashCodeNullable(variableNamesIgnoreCase), hashCodeNullable(variableValuesIgnoreCase), hashCodeNullable(orQueries), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricProcessInstanceQueryDto {\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIds: ").append(toIndentedString(processInstanceIds)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionKeyIn: ").append(toIndentedString(processDefinitionKeyIn)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionNameLike: ").append(toIndentedString(processDefinitionNameLike)).append("\n");
    sb.append("    processDefinitionKeyNotIn: ").append(toIndentedString(processDefinitionKeyNotIn)).append("\n");
    sb.append("    processInstanceBusinessKey: ").append(toIndentedString(processInstanceBusinessKey)).append("\n");
    sb.append("    processInstanceBusinessKeyIn: ").append(toIndentedString(processInstanceBusinessKeyIn)).append("\n");
    sb.append("    processInstanceBusinessKeyLike: ").append(toIndentedString(processInstanceBusinessKeyLike)).append("\n");
    sb.append("    rootProcessInstances: ").append(toIndentedString(rootProcessInstances)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    withIncidents: ").append(toIndentedString(withIncidents)).append("\n");
    sb.append("    withRootIncidents: ").append(toIndentedString(withRootIncidents)).append("\n");
    sb.append("    incidentType: ").append(toIndentedString(incidentType)).append("\n");
    sb.append("    incidentStatus: ").append(toIndentedString(incidentStatus)).append("\n");
    sb.append("    incidentMessage: ").append(toIndentedString(incidentMessage)).append("\n");
    sb.append("    incidentMessageLike: ").append(toIndentedString(incidentMessageLike)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    executedActivityAfter: ").append(toIndentedString(executedActivityAfter)).append("\n");
    sb.append("    executedActivityBefore: ").append(toIndentedString(executedActivityBefore)).append("\n");
    sb.append("    executedJobAfter: ").append(toIndentedString(executedJobAfter)).append("\n");
    sb.append("    executedJobBefore: ").append(toIndentedString(executedJobBefore)).append("\n");
    sb.append("    startedBy: ").append(toIndentedString(startedBy)).append("\n");
    sb.append("    superProcessInstanceId: ").append(toIndentedString(superProcessInstanceId)).append("\n");
    sb.append("    subProcessInstanceId: ").append(toIndentedString(subProcessInstanceId)).append("\n");
    sb.append("    superCaseInstanceId: ").append(toIndentedString(superCaseInstanceId)).append("\n");
    sb.append("    subCaseInstanceId: ").append(toIndentedString(subCaseInstanceId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    executedActivityIdIn: ").append(toIndentedString(executedActivityIdIn)).append("\n");
    sb.append("    activeActivityIdIn: ").append(toIndentedString(activeActivityIdIn)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    externallyTerminated: ").append(toIndentedString(externallyTerminated)).append("\n");
    sb.append("    internallyTerminated: ").append(toIndentedString(internallyTerminated)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    orQueries: ").append(toIndentedString(orQueries)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIds` to the URL query string
    if (getProcessInstanceIds() != null) {
      for (int i = 0; i < getProcessInstanceIds().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKeyIn` to the URL query string
    if (getProcessDefinitionKeyIn() != null) {
      for (int i = 0; i < getProcessDefinitionKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessDefinitionKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessDefinitionKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionNameLike` to the URL query string
    if (getProcessDefinitionNameLike() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionNameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKeyNotIn` to the URL query string
    if (getProcessDefinitionKeyNotIn() != null) {
      for (int i = 0; i < getProcessDefinitionKeyNotIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessDefinitionKeyNotIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessDefinitionKeyNotIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceBusinessKey` to the URL query string
    if (getProcessInstanceBusinessKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKeyIn` to the URL query string
    if (getProcessInstanceBusinessKeyIn() != null) {
      for (int i = 0; i < getProcessInstanceBusinessKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceBusinessKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceBusinessKeyLike` to the URL query string
    if (getProcessInstanceBusinessKeyLike() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKeyLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstances` to the URL query string
    if (getRootProcessInstances() != null) {
      try {
        joiner.add(String.format("%srootProcessInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finished` to the URL query string
    if (getFinished() != null) {
      try {
        joiner.add(String.format("%sfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unfinished` to the URL query string
    if (getUnfinished() != null) {
      try {
        joiner.add(String.format("%sunfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnfinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withIncidents` to the URL query string
    if (getWithIncidents() != null) {
      try {
        joiner.add(String.format("%swithIncidents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithIncidents()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withRootIncidents` to the URL query string
    if (getWithRootIncidents() != null) {
      try {
        joiner.add(String.format("%swithRootIncidents%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithRootIncidents()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentType` to the URL query string
    if (getIncidentType() != null) {
      try {
        joiner.add(String.format("%sincidentType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentStatus` to the URL query string
    if (getIncidentStatus() != null) {
      try {
        joiner.add(String.format("%sincidentStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentMessage` to the URL query string
    if (getIncidentMessage() != null) {
      try {
        joiner.add(String.format("%sincidentMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentMessageLike` to the URL query string
    if (getIncidentMessageLike() != null) {
      try {
        joiner.add(String.format("%sincidentMessageLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentMessageLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedBefore` to the URL query string
    if (getStartedBefore() != null) {
      try {
        joiner.add(String.format("%sstartedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedAfter` to the URL query string
    if (getStartedAfter() != null) {
      try {
        joiner.add(String.format("%sstartedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedBefore` to the URL query string
    if (getFinishedBefore() != null) {
      try {
        joiner.add(String.format("%sfinishedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedAfter` to the URL query string
    if (getFinishedAfter() != null) {
      try {
        joiner.add(String.format("%sfinishedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executedActivityAfter` to the URL query string
    if (getExecutedActivityAfter() != null) {
      try {
        joiner.add(String.format("%sexecutedActivityAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutedActivityAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executedActivityBefore` to the URL query string
    if (getExecutedActivityBefore() != null) {
      try {
        joiner.add(String.format("%sexecutedActivityBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutedActivityBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executedJobAfter` to the URL query string
    if (getExecutedJobAfter() != null) {
      try {
        joiner.add(String.format("%sexecutedJobAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutedJobAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executedJobBefore` to the URL query string
    if (getExecutedJobBefore() != null) {
      try {
        joiner.add(String.format("%sexecutedJobBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutedJobBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedBy` to the URL query string
    if (getStartedBy() != null) {
      try {
        joiner.add(String.format("%sstartedBy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedBy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `superProcessInstanceId` to the URL query string
    if (getSuperProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%ssuperProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuperProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subProcessInstanceId` to the URL query string
    if (getSubProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%ssubProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `superCaseInstanceId` to the URL query string
    if (getSuperCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%ssuperCaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuperCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subCaseInstanceId` to the URL query string
    if (getSubCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%ssubCaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executedActivityIdIn` to the URL query string
    if (getExecutedActivityIdIn() != null) {
      for (int i = 0; i < getExecutedActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sexecutedActivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getExecutedActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `activeActivityIdIn` to the URL query string
    if (getActiveActivityIdIn() != null) {
      for (int i = 0; i < getActiveActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactiveActivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActiveActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completed` to the URL query string
    if (getCompleted() != null) {
      try {
        joiner.add(String.format("%scompleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `externallyTerminated` to the URL query string
    if (getExternallyTerminated() != null) {
      try {
        joiner.add(String.format("%sexternallyTerminated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExternallyTerminated()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `internallyTerminated` to the URL query string
    if (getInternallyTerminated() != null) {
      try {
        joiner.add(String.format("%sinternallyTerminated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInternallyTerminated()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (int i = 0; i < getVariables().size(); i++) {
        if (getVariables().get(i) != null) {
          joiner.add(getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variableNamesIgnoreCase` to the URL query string
    if (getVariableNamesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableNamesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNamesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValuesIgnoreCase` to the URL query string
    if (getVariableValuesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableValuesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValuesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `orQueries` to the URL query string
    if (getOrQueries() != null) {
      for (int i = 0; i < getOrQueries().size(); i++) {
        if (getOrQueries().get(i) != null) {
          joiner.add(getOrQueries().get(i).toUrlQueryString(String.format("%sorQueries%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

