/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricTaskInstanceDto
 */
@JsonPropertyOrder({
  HistoricTaskInstanceDto.JSON_PROPERTY_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricTaskInstanceDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_CASE_DEFINITION_KEY,
  HistoricTaskInstanceDto.JSON_PROPERTY_CASE_DEFINITION_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_CASE_EXECUTION_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_NAME,
  HistoricTaskInstanceDto.JSON_PROPERTY_DESCRIPTION,
  HistoricTaskInstanceDto.JSON_PROPERTY_DELETE_REASON,
  HistoricTaskInstanceDto.JSON_PROPERTY_OWNER,
  HistoricTaskInstanceDto.JSON_PROPERTY_ASSIGNEE,
  HistoricTaskInstanceDto.JSON_PROPERTY_START_TIME,
  HistoricTaskInstanceDto.JSON_PROPERTY_END_TIME,
  HistoricTaskInstanceDto.JSON_PROPERTY_DURATION,
  HistoricTaskInstanceDto.JSON_PROPERTY_TASK_DEFINITION_KEY,
  HistoricTaskInstanceDto.JSON_PROPERTY_PRIORITY,
  HistoricTaskInstanceDto.JSON_PROPERTY_DUE,
  HistoricTaskInstanceDto.JSON_PROPERTY_PARENT_TASK_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_FOLLOW_UP,
  HistoricTaskInstanceDto.JSON_PROPERTY_TENANT_ID,
  HistoricTaskInstanceDto.JSON_PROPERTY_REMOVAL_TIME,
  HistoricTaskInstanceDto.JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricTaskInstanceDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_KEY = "caseDefinitionKey";
  private JsonNullable<String> caseDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_ID = "caseDefinitionId";
  private JsonNullable<String> caseDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID = "caseExecutionId";
  private JsonNullable<String> caseExecutionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private JsonNullable<String> description = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DELETE_REASON = "deleteReason";
  private JsonNullable<String> deleteReason = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OWNER = "owner";
  private JsonNullable<String> owner = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private JsonNullable<String> assignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_START_TIME = "startTime";
  private JsonNullable<OffsetDateTime> startTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  private JsonNullable<OffsetDateTime> endTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DURATION = "duration";
  private JsonNullable<Long> duration = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY = "taskDefinitionKey";
  private JsonNullable<String> taskDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Integer> priority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_DUE = "due";
  private JsonNullable<OffsetDateTime> due = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_PARENT_TASK_ID = "parentTaskId";
  private JsonNullable<String> parentTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP = "followUp";
  private JsonNullable<OffsetDateTime> followUp = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_REMOVAL_TIME = "removalTime";
  private JsonNullable<OffsetDateTime> removalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  private JsonNullable<String> rootProcessInstanceId = JsonNullable.<String>undefined();

  public HistoricTaskInstanceDto() {
  }

  public HistoricTaskInstanceDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The task id.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public HistoricTaskInstanceDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition the task belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricTaskInstanceDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition the task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricTaskInstanceDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance the task belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricTaskInstanceDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The id of the execution the task belongs to.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricTaskInstanceDto caseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
    
    return this;
  }

   /**
   * The key of the case definition the task belongs to.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionKey() {
        return caseDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionKey_JsonNullable() {
    return caseDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  public void setCaseDefinitionKey_JsonNullable(JsonNullable<String> caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }

  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
  }


  public HistoricTaskInstanceDto caseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
    
    return this;
  }

   /**
   * The id of the case definition the task belongs to.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionId() {
        return caseDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionId_JsonNullable() {
    return caseDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  public void setCaseDefinitionId_JsonNullable(JsonNullable<String> caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }

  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
  }


  public HistoricTaskInstanceDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The id of the case instance the task belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricTaskInstanceDto caseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
    
    return this;
  }

   /**
   * The id of the case execution the task belongs to.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseExecutionId() {
        return caseExecutionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseExecutionId_JsonNullable() {
    return caseExecutionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  public void setCaseExecutionId_JsonNullable(JsonNullable<String> caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }

  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
  }


  public HistoricTaskInstanceDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * The id of the activity that this object is an instance of.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public HistoricTaskInstanceDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * The task name.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public HistoricTaskInstanceDto description(String description) {
    this.description = JsonNullable.<String>of(description);
    
    return this;
  }

   /**
   * The task&#39;s description.
   * @return description
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDescription() {
        return description.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDescription_JsonNullable() {
    return description;
  }
  
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  public void setDescription_JsonNullable(JsonNullable<String> description) {
    this.description = description;
  }

  public void setDescription(String description) {
    this.description = JsonNullable.<String>of(description);
  }


  public HistoricTaskInstanceDto deleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
    
    return this;
  }

   /**
   * The task&#39;s delete reason.
   * @return deleteReason
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeleteReason() {
        return deleteReason.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeleteReason_JsonNullable() {
    return deleteReason;
  }
  
  @JsonProperty(JSON_PROPERTY_DELETE_REASON)
  public void setDeleteReason_JsonNullable(JsonNullable<String> deleteReason) {
    this.deleteReason = deleteReason;
  }

  public void setDeleteReason(String deleteReason) {
    this.deleteReason = JsonNullable.<String>of(deleteReason);
  }


  public HistoricTaskInstanceDto owner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
    
    return this;
  }

   /**
   * The owner&#39;s id.
   * @return owner
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getOwner() {
        return owner.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOwner_JsonNullable() {
    return owner;
  }
  
  @JsonProperty(JSON_PROPERTY_OWNER)
  public void setOwner_JsonNullable(JsonNullable<String> owner) {
    this.owner = owner;
  }

  public void setOwner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
  }


  public HistoricTaskInstanceDto assignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
    
    return this;
  }

   /**
   * The assignee&#39;s id.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssignee() {
        return assignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssignee_JsonNullable() {
    return assignee;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  public void setAssignee_JsonNullable(JsonNullable<String> assignee) {
    this.assignee = assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
  }


  public HistoricTaskInstanceDto startTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
    
    return this;
  }

   /**
   * The time the task was started. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return startTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartTime() {
        return startTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartTime_JsonNullable() {
    return startTime;
  }
  
  @JsonProperty(JSON_PROPERTY_START_TIME)
  public void setStartTime_JsonNullable(JsonNullable<OffsetDateTime> startTime) {
    this.startTime = startTime;
  }

  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = JsonNullable.<OffsetDateTime>of(startTime);
  }


  public HistoricTaskInstanceDto endTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
    
    return this;
  }

   /**
   * The time the task ended. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return endTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getEndTime() {
        return endTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getEndTime_JsonNullable() {
    return endTime;
  }
  
  @JsonProperty(JSON_PROPERTY_END_TIME)
  public void setEndTime_JsonNullable(JsonNullable<OffsetDateTime> endTime) {
    this.endTime = endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = JsonNullable.<OffsetDateTime>of(endTime);
  }


  public HistoricTaskInstanceDto duration(Long duration) {
    this.duration = JsonNullable.<Long>of(duration);
    
    return this;
  }

   /**
   * The time the task took to finish (in milliseconds).
   * @return duration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getDuration() {
        return duration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getDuration_JsonNullable() {
    return duration;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION)
  public void setDuration_JsonNullable(JsonNullable<Long> duration) {
    this.duration = duration;
  }

  public void setDuration(Long duration) {
    this.duration = JsonNullable.<Long>of(duration);
  }


  public HistoricTaskInstanceDto taskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
    
    return this;
  }

   /**
   * The task&#39;s key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDefinitionKey() {
        return taskDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDefinitionKey_JsonNullable() {
    return taskDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  public void setTaskDefinitionKey_JsonNullable(JsonNullable<String> taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }

  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
  }


  public HistoricTaskInstanceDto priority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
    
    return this;
  }

   /**
   * The task&#39;s priority.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Integer> priority) {
    this.priority = priority;
  }

  public void setPriority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
  }


  public HistoricTaskInstanceDto due(OffsetDateTime due) {
    this.due = JsonNullable.<OffsetDateTime>of(due);
    
    return this;
  }

   /**
   * The task&#39;s due date. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return due
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDue() {
        return due.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDue_JsonNullable() {
    return due;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE)
  public void setDue_JsonNullable(JsonNullable<OffsetDateTime> due) {
    this.due = due;
  }

  public void setDue(OffsetDateTime due) {
    this.due = JsonNullable.<OffsetDateTime>of(due);
  }


  public HistoricTaskInstanceDto parentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
    
    return this;
  }

   /**
   * The id of the parent task, if this task is a subtask.
   * @return parentTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getParentTaskId() {
        return parentTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getParentTaskId_JsonNullable() {
    return parentTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  public void setParentTaskId_JsonNullable(JsonNullable<String> parentTaskId) {
    this.parentTaskId = parentTaskId;
  }

  public void setParentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
  }


  public HistoricTaskInstanceDto followUp(OffsetDateTime followUp) {
    this.followUp = JsonNullable.<OffsetDateTime>of(followUp);
    
    return this;
  }

   /**
   * The follow-up date for the task. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return followUp
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFollowUp() {
        return followUp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFollowUp_JsonNullable() {
    return followUp;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP)
  public void setFollowUp_JsonNullable(JsonNullable<OffsetDateTime> followUp) {
    this.followUp = followUp;
  }

  public void setFollowUp(OffsetDateTime followUp) {
    this.followUp = JsonNullable.<OffsetDateTime>of(followUp);
  }


  public HistoricTaskInstanceDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the task instance.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public HistoricTaskInstanceDto removalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
    
    return this;
  }

   /**
   * The time after which the task should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getRemovalTime() {
        return removalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getRemovalTime_JsonNullable() {
    return removalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_REMOVAL_TIME)
  public void setRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> removalTime) {
    this.removalTime = removalTime;
  }

  public void setRemovalTime(OffsetDateTime removalTime) {
    this.removalTime = JsonNullable.<OffsetDateTime>of(removalTime);
  }


  public HistoricTaskInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
    
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this task.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getRootProcessInstanceId() {
        return rootProcessInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getRootProcessInstanceId_JsonNullable() {
    return rootProcessInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOT_PROCESS_INSTANCE_ID)
  public void setRootProcessInstanceId_JsonNullable(JsonNullable<String> rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }

  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = JsonNullable.<String>of(rootProcessInstanceId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricTaskInstanceDto historicTaskInstanceDto = (HistoricTaskInstanceDto) o;
    return equalsNullable(this.id, historicTaskInstanceDto.id) &&
        equalsNullable(this.processDefinitionKey, historicTaskInstanceDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionId, historicTaskInstanceDto.processDefinitionId) &&
        equalsNullable(this.processInstanceId, historicTaskInstanceDto.processInstanceId) &&
        equalsNullable(this.executionId, historicTaskInstanceDto.executionId) &&
        equalsNullable(this.caseDefinitionKey, historicTaskInstanceDto.caseDefinitionKey) &&
        equalsNullable(this.caseDefinitionId, historicTaskInstanceDto.caseDefinitionId) &&
        equalsNullable(this.caseInstanceId, historicTaskInstanceDto.caseInstanceId) &&
        equalsNullable(this.caseExecutionId, historicTaskInstanceDto.caseExecutionId) &&
        equalsNullable(this.activityInstanceId, historicTaskInstanceDto.activityInstanceId) &&
        equalsNullable(this.name, historicTaskInstanceDto.name) &&
        equalsNullable(this.description, historicTaskInstanceDto.description) &&
        equalsNullable(this.deleteReason, historicTaskInstanceDto.deleteReason) &&
        equalsNullable(this.owner, historicTaskInstanceDto.owner) &&
        equalsNullable(this.assignee, historicTaskInstanceDto.assignee) &&
        equalsNullable(this.startTime, historicTaskInstanceDto.startTime) &&
        equalsNullable(this.endTime, historicTaskInstanceDto.endTime) &&
        equalsNullable(this.duration, historicTaskInstanceDto.duration) &&
        equalsNullable(this.taskDefinitionKey, historicTaskInstanceDto.taskDefinitionKey) &&
        equalsNullable(this.priority, historicTaskInstanceDto.priority) &&
        equalsNullable(this.due, historicTaskInstanceDto.due) &&
        equalsNullable(this.parentTaskId, historicTaskInstanceDto.parentTaskId) &&
        equalsNullable(this.followUp, historicTaskInstanceDto.followUp) &&
        equalsNullable(this.tenantId, historicTaskInstanceDto.tenantId) &&
        equalsNullable(this.removalTime, historicTaskInstanceDto.removalTime) &&
        equalsNullable(this.rootProcessInstanceId, historicTaskInstanceDto.rootProcessInstanceId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionId), hashCodeNullable(processInstanceId), hashCodeNullable(executionId), hashCodeNullable(caseDefinitionKey), hashCodeNullable(caseDefinitionId), hashCodeNullable(caseInstanceId), hashCodeNullable(caseExecutionId), hashCodeNullable(activityInstanceId), hashCodeNullable(name), hashCodeNullable(description), hashCodeNullable(deleteReason), hashCodeNullable(owner), hashCodeNullable(assignee), hashCodeNullable(startTime), hashCodeNullable(endTime), hashCodeNullable(duration), hashCodeNullable(taskDefinitionKey), hashCodeNullable(priority), hashCodeNullable(due), hashCodeNullable(parentTaskId), hashCodeNullable(followUp), hashCodeNullable(tenantId), hashCodeNullable(removalTime), hashCodeNullable(rootProcessInstanceId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricTaskInstanceDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    deleteReason: ").append(toIndentedString(deleteReason)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    due: ").append(toIndentedString(due)).append("\n");
    sb.append("    parentTaskId: ").append(toIndentedString(parentTaskId)).append("\n");
    sb.append("    followUp: ").append(toIndentedString(followUp)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionKey` to the URL query string
    if (getCaseDefinitionKey() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionId` to the URL query string
    if (getCaseDefinitionId() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionId` to the URL query string
    if (getCaseExecutionId() != null) {
      try {
        joiner.add(String.format("%scaseExecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deleteReason` to the URL query string
    if (getDeleteReason() != null) {
      try {
        joiner.add(String.format("%sdeleteReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeleteReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `owner` to the URL query string
    if (getOwner() != null) {
      try {
        joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwner()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startTime` to the URL query string
    if (getStartTime() != null) {
      try {
        joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endTime` to the URL query string
    if (getEndTime() != null) {
      try {
        joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `duration` to the URL query string
    if (getDuration() != null) {
      try {
        joiner.add(String.format("%sduration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDuration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKey` to the URL query string
    if (getTaskDefinitionKey() != null) {
      try {
        joiner.add(String.format("%staskDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `due` to the URL query string
    if (getDue() != null) {
      try {
        joiner.add(String.format("%sdue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentTaskId` to the URL query string
    if (getParentTaskId() != null) {
      try {
        joiner.add(String.format("%sparentTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUp` to the URL query string
    if (getFollowUp() != null) {
      try {
        joiner.add(String.format("%sfollowUp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUp()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `removalTime` to the URL query string
    if (getRemovalTime() != null) {
      try {
        joiner.add(String.format("%sremovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rootProcessInstanceId` to the URL query string
    if (getRootProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%srootProcessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRootProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

