/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceQueryDtoSortingInner;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Historic Task instance query which defines a list of Historic Task instances
 */
@JsonPropertyOrder({
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_PARENT_TASK_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_EXECUTION_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_CASE_EXECUTION_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_CASE_DEFINITION_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_CASE_DEFINITION_KEY,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_CASE_DEFINITION_NAME,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_NAME,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_NAME_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DESCRIPTION,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DESCRIPTION_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DEFINITION_KEY,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DEFINITION_KEY_IN,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DELETE_REASON,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DELETE_REASON_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_ASSIGNEE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_ASSIGNEE_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_OWNER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_OWNER_LIKE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_PRIORITY,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_ASSIGNED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_UNASSIGNED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_FINISHED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_UNFINISHED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_FINISHED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_UNFINISHED,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DUE_DATE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DUE_DATE_BEFORE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_DUE_DATE_AFTER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_WITHOUT_TASK_DUE_DATE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_FOLLOW_UP_DATE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_FOLLOW_UP_DATE_BEFORE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_FOLLOW_UP_DATE_AFTER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_STARTED_BEFORE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_STARTED_AFTER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_FINISHED_BEFORE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_FINISHED_AFTER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_VARIABLES,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_PROCESS_VARIABLES,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_INVOLVED_USER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_INVOLVED_GROUP,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_HAD_CANDIDATE_USER,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_TASK_HAD_CANDIDATE_GROUP,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_WITH_CANDIDATE_GROUPS,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_OR_QUERIES,
  HistoricTaskInstanceQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricTaskInstanceQueryDto {
  public static final String JSON_PROPERTY_TASK_ID = "taskId";
  private JsonNullable<String> taskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_PARENT_TASK_ID = "taskParentTaskId";
  private JsonNullable<String> taskParentTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
  private JsonNullable<String> processInstanceBusinessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
  private JsonNullable<List<String>> processInstanceBusinessKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
  private JsonNullable<String> processInstanceBusinessKeyLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private JsonNullable<String> processDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID = "caseExecutionId";
  private JsonNullable<String> caseExecutionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_ID = "caseDefinitionId";
  private JsonNullable<String> caseDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_KEY = "caseDefinitionKey";
  private JsonNullable<String> caseDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_NAME = "caseDefinitionName";
  private JsonNullable<String> caseDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  private JsonNullable<List<String>> activityInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TASK_NAME = "taskName";
  private JsonNullable<String> taskName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_NAME_LIKE = "taskNameLike";
  private JsonNullable<String> taskNameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DESCRIPTION = "taskDescription";
  private JsonNullable<String> taskDescription = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DESCRIPTION_LIKE = "taskDescriptionLike";
  private JsonNullable<String> taskDescriptionLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY = "taskDefinitionKey";
  private JsonNullable<String> taskDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY_IN = "taskDefinitionKeyIn";
  private JsonNullable<List<String>> taskDefinitionKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TASK_DELETE_REASON = "taskDeleteReason";
  private JsonNullable<String> taskDeleteReason = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DELETE_REASON_LIKE = "taskDeleteReasonLike";
  private JsonNullable<String> taskDeleteReasonLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ASSIGNEE = "taskAssignee";
  private JsonNullable<String> taskAssignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ASSIGNEE_LIKE = "taskAssigneeLike";
  private JsonNullable<String> taskAssigneeLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_OWNER = "taskOwner";
  private JsonNullable<String> taskOwner = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_OWNER_LIKE = "taskOwnerLike";
  private JsonNullable<String> taskOwnerLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_PRIORITY = "taskPriority";
  private JsonNullable<Integer> taskPriority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_ASSIGNED = "assigned";
  private JsonNullable<Boolean> assigned = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UNASSIGNED = "unassigned";
  private JsonNullable<Boolean> unassigned = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FINISHED = "finished";
  private JsonNullable<Boolean> finished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UNFINISHED = "unfinished";
  private JsonNullable<Boolean> unfinished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_FINISHED = "processFinished";
  private JsonNullable<Boolean> processFinished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_UNFINISHED = "processUnfinished";
  private JsonNullable<Boolean> processUnfinished = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TASK_DUE_DATE = "taskDueDate";
  private JsonNullable<OffsetDateTime> taskDueDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TASK_DUE_DATE_BEFORE = "taskDueDateBefore";
  private JsonNullable<OffsetDateTime> taskDueDateBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TASK_DUE_DATE_AFTER = "taskDueDateAfter";
  private JsonNullable<OffsetDateTime> taskDueDateAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TASK_DUE_DATE = "withoutTaskDueDate";
  private JsonNullable<Boolean> withoutTaskDueDate = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TASK_FOLLOW_UP_DATE = "taskFollowUpDate";
  private JsonNullable<OffsetDateTime> taskFollowUpDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TASK_FOLLOW_UP_DATE_BEFORE = "taskFollowUpDateBefore";
  private JsonNullable<OffsetDateTime> taskFollowUpDateBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TASK_FOLLOW_UP_DATE_AFTER = "taskFollowUpDateAfter";
  private JsonNullable<OffsetDateTime> taskFollowUpDateAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_STARTED_BEFORE = "startedBefore";
  private JsonNullable<OffsetDateTime> startedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_STARTED_AFTER = "startedAfter";
  private JsonNullable<OffsetDateTime> startedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_BEFORE = "finishedBefore";
  private JsonNullable<OffsetDateTime> finishedBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FINISHED_AFTER = "finishedAfter";
  private JsonNullable<OffsetDateTime> finishedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TASK_VARIABLES = "taskVariables";
  private JsonNullable<List<VariableQueryParameterDto>> taskVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES = "processVariables";
  private JsonNullable<List<VariableQueryParameterDto>> processVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  private JsonNullable<Boolean> variableNamesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  private JsonNullable<Boolean> variableValuesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TASK_INVOLVED_USER = "taskInvolvedUser";
  private JsonNullable<String> taskInvolvedUser = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_INVOLVED_GROUP = "taskInvolvedGroup";
  private JsonNullable<String> taskInvolvedGroup = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_HAD_CANDIDATE_USER = "taskHadCandidateUser";
  private JsonNullable<String> taskHadCandidateUser = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_HAD_CANDIDATE_GROUP = "taskHadCandidateGroup";
  private JsonNullable<String> taskHadCandidateGroup = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITH_CANDIDATE_GROUPS = "withCandidateGroups";
  private JsonNullable<Boolean> withCandidateGroups = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS = "withoutCandidateGroups";
  private JsonNullable<Boolean> withoutCandidateGroups = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_OR_QUERIES = "orQueries";
  private JsonNullable<List<HistoricTaskInstanceQueryDto>> orQueries = JsonNullable.<List<HistoricTaskInstanceQueryDto>>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricTaskInstanceQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricTaskInstanceQueryDtoSortingInner>>undefined();

  public HistoricTaskInstanceQueryDto() {
  }

  public HistoricTaskInstanceQueryDto taskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
    
    return this;
  }

   /**
   * Filter by task id.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskId() {
        return taskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskId_JsonNullable() {
    return taskId;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID)
  public void setTaskId_JsonNullable(JsonNullable<String> taskId) {
    this.taskId = taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
  }


  public HistoricTaskInstanceQueryDto taskParentTaskId(String taskParentTaskId) {
    this.taskParentTaskId = JsonNullable.<String>of(taskParentTaskId);
    
    return this;
  }

   /**
   * Filter by parent task id.
   * @return taskParentTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskParentTaskId() {
        return taskParentTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_PARENT_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskParentTaskId_JsonNullable() {
    return taskParentTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_PARENT_TASK_ID)
  public void setTaskParentTaskId_JsonNullable(JsonNullable<String> taskParentTaskId) {
    this.taskParentTaskId = taskParentTaskId;
  }

  public void setTaskParentTaskId(String taskParentTaskId) {
    this.taskParentTaskId = JsonNullable.<String>of(taskParentTaskId);
  }


  public HistoricTaskInstanceQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
    
    return this;
  }

   /**
   * Filter by process instance business key.
   * @return processInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKey() {
        return processInstanceBusinessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKey_JsonNullable() {
    return processInstanceBusinessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  public void setProcessInstanceBusinessKey_JsonNullable(JsonNullable<String> processInstanceBusinessKey) {
    this.processInstanceBusinessKey = processInstanceBusinessKey;
  }

  public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
    if (this.processInstanceBusinessKeyIn == null || !this.processInstanceBusinessKeyIn.isPresent()) {
      this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceBusinessKeyIn.get().add(processInstanceBusinessKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
   * @return processInstanceBusinessKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceBusinessKeyIn() {
        return processInstanceBusinessKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceBusinessKeyIn_JsonNullable() {
    return processInstanceBusinessKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  public void setProcessInstanceBusinessKeyIn_JsonNullable(JsonNullable<List<String>> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
  }

  public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
    
    return this;
  }

   /**
   * Filter by  process instance business key that has the parameter value as a substring.
   * @return processInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKeyLike() {
        return processInstanceBusinessKeyLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKeyLike_JsonNullable() {
    return processInstanceBusinessKeyLike;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  public void setProcessInstanceBusinessKeyLike_JsonNullable(JsonNullable<String> processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
  }

  public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
  }


  public HistoricTaskInstanceQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Filter by the id of the execution that executed the task.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public HistoricTaskInstanceQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricTaskInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricTaskInstanceQueryDto processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given name.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionName() {
        return processDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionName_JsonNullable() {
    return processDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  public void setProcessDefinitionName_JsonNullable(JsonNullable<String> processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
  }


  public HistoricTaskInstanceQueryDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * Filter by case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricTaskInstanceQueryDto caseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
    
    return this;
  }

   /**
   * Filter by the id of the case execution that executed the task.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseExecutionId() {
        return caseExecutionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseExecutionId_JsonNullable() {
    return caseExecutionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  public void setCaseExecutionId_JsonNullable(JsonNullable<String> caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }

  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
  }


  public HistoricTaskInstanceQueryDto caseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
    
    return this;
  }

   /**
   * Filter by case definition id.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionId() {
        return caseDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionId_JsonNullable() {
    return caseDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  public void setCaseDefinitionId_JsonNullable(JsonNullable<String> caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }

  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
  }


  public HistoricTaskInstanceQueryDto caseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given key.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionKey() {
        return caseDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionKey_JsonNullable() {
    return caseDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  public void setCaseDefinitionKey_JsonNullable(JsonNullable<String> caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }

  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
  }


  public HistoricTaskInstanceQueryDto caseDefinitionName(String caseDefinitionName) {
    this.caseDefinitionName = JsonNullable.<String>of(caseDefinitionName);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given name.
   * @return caseDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionName() {
        return caseDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionName_JsonNullable() {
    return caseDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME)
  public void setCaseDefinitionName_JsonNullable(JsonNullable<String> caseDefinitionName) {
    this.caseDefinitionName = caseDefinitionName;
  }

  public void setCaseDefinitionName(String caseDefinitionName) {
    this.caseDefinitionName = JsonNullable.<String>of(caseDefinitionName);
  }


  public HistoricTaskInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null || !this.activityInstanceIdIn.isPresent()) {
      this.activityInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityInstanceIdIn.get().add(activityInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks which belong to one of the passed  activity instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityInstanceIdIn() {
        return activityInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityInstanceIdIn_JsonNullable() {
    return activityInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  public void setActivityInstanceIdIn_JsonNullable(JsonNullable<List<String>> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }

  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
  }


  public HistoricTaskInstanceQueryDto taskName(String taskName) {
    this.taskName = JsonNullable.<String>of(taskName);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given name.
   * @return taskName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskName() {
        return taskName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskName_JsonNullable() {
    return taskName;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_NAME)
  public void setTaskName_JsonNullable(JsonNullable<String> taskName) {
    this.taskName = taskName;
  }

  public void setTaskName(String taskName) {
    this.taskName = JsonNullable.<String>of(taskName);
  }


  public HistoricTaskInstanceQueryDto taskNameLike(String taskNameLike) {
    this.taskNameLike = JsonNullable.<String>of(taskNameLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a name with the given parameter value as substring.
   * @return taskNameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskNameLike() {
        return taskNameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskNameLike_JsonNullable() {
    return taskNameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_NAME_LIKE)
  public void setTaskNameLike_JsonNullable(JsonNullable<String> taskNameLike) {
    this.taskNameLike = taskNameLike;
  }

  public void setTaskNameLike(String taskNameLike) {
    this.taskNameLike = JsonNullable.<String>of(taskNameLike);
  }


  public HistoricTaskInstanceQueryDto taskDescription(String taskDescription) {
    this.taskDescription = JsonNullable.<String>of(taskDescription);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given description.
   * @return taskDescription
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDescription() {
        return taskDescription.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDescription_JsonNullable() {
    return taskDescription;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DESCRIPTION)
  public void setTaskDescription_JsonNullable(JsonNullable<String> taskDescription) {
    this.taskDescription = taskDescription;
  }

  public void setTaskDescription(String taskDescription) {
    this.taskDescription = JsonNullable.<String>of(taskDescription);
  }


  public HistoricTaskInstanceQueryDto taskDescriptionLike(String taskDescriptionLike) {
    this.taskDescriptionLike = JsonNullable.<String>of(taskDescriptionLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a description that has the parameter value as a substring.
   * @return taskDescriptionLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDescriptionLike() {
        return taskDescriptionLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DESCRIPTION_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDescriptionLike_JsonNullable() {
    return taskDescriptionLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DESCRIPTION_LIKE)
  public void setTaskDescriptionLike_JsonNullable(JsonNullable<String> taskDescriptionLike) {
    this.taskDescriptionLike = taskDescriptionLike;
  }

  public void setTaskDescriptionLike(String taskDescriptionLike) {
    this.taskDescriptionLike = JsonNullable.<String>of(taskDescriptionLike);
  }


  public HistoricTaskInstanceQueryDto taskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDefinitionKey() {
        return taskDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDefinitionKey_JsonNullable() {
    return taskDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  public void setTaskDefinitionKey_JsonNullable(JsonNullable<String> taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }

  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
  }


  public HistoricTaskInstanceQueryDto taskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(taskDefinitionKeyIn);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addTaskDefinitionKeyInItem(String taskDefinitionKeyInItem) {
    if (this.taskDefinitionKeyIn == null || !this.taskDefinitionKeyIn.isPresent()) {
      this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.taskDefinitionKeyIn.get().add(taskDefinitionKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that have one of the passed  task definition keys.
   * @return taskDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTaskDefinitionKeyIn() {
        return taskDefinitionKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTaskDefinitionKeyIn_JsonNullable() {
    return taskDefinitionKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_IN)
  public void setTaskDefinitionKeyIn_JsonNullable(JsonNullable<List<String>> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = taskDefinitionKeyIn;
  }

  public void setTaskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(taskDefinitionKeyIn);
  }


  public HistoricTaskInstanceQueryDto taskDeleteReason(String taskDeleteReason) {
    this.taskDeleteReason = JsonNullable.<String>of(taskDeleteReason);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given delete reason.
   * @return taskDeleteReason
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDeleteReason() {
        return taskDeleteReason.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DELETE_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDeleteReason_JsonNullable() {
    return taskDeleteReason;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DELETE_REASON)
  public void setTaskDeleteReason_JsonNullable(JsonNullable<String> taskDeleteReason) {
    this.taskDeleteReason = taskDeleteReason;
  }

  public void setTaskDeleteReason(String taskDeleteReason) {
    this.taskDeleteReason = JsonNullable.<String>of(taskDeleteReason);
  }


  public HistoricTaskInstanceQueryDto taskDeleteReasonLike(String taskDeleteReasonLike) {
    this.taskDeleteReasonLike = JsonNullable.<String>of(taskDeleteReasonLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a delete reason that has the parameter value as a substring.
   * @return taskDeleteReasonLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDeleteReasonLike() {
        return taskDeleteReasonLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DELETE_REASON_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDeleteReasonLike_JsonNullable() {
    return taskDeleteReasonLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DELETE_REASON_LIKE)
  public void setTaskDeleteReasonLike_JsonNullable(JsonNullable<String> taskDeleteReasonLike) {
    this.taskDeleteReasonLike = taskDeleteReasonLike;
  }

  public void setTaskDeleteReasonLike(String taskDeleteReasonLike) {
    this.taskDeleteReasonLike = JsonNullable.<String>of(taskDeleteReasonLike);
  }


  public HistoricTaskInstanceQueryDto taskAssignee(String taskAssignee) {
    this.taskAssignee = JsonNullable.<String>of(taskAssignee);
    
    return this;
  }

   /**
   * Restrict to tasks that the given user is assigned to.
   * @return taskAssignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskAssignee() {
        return taskAssignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskAssignee_JsonNullable() {
    return taskAssignee;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE)
  public void setTaskAssignee_JsonNullable(JsonNullable<String> taskAssignee) {
    this.taskAssignee = taskAssignee;
  }

  public void setTaskAssignee(String taskAssignee) {
    this.taskAssignee = JsonNullable.<String>of(taskAssignee);
  }


  public HistoricTaskInstanceQueryDto taskAssigneeLike(String taskAssigneeLike) {
    this.taskAssigneeLike = JsonNullable.<String>of(taskAssigneeLike);
    
    return this;
  }

   /**
   * Restrict to tasks that are assigned to users with the parameter value as a substring.
   * @return taskAssigneeLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskAssigneeLike() {
        return taskAssigneeLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskAssigneeLike_JsonNullable() {
    return taskAssigneeLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ASSIGNEE_LIKE)
  public void setTaskAssigneeLike_JsonNullable(JsonNullable<String> taskAssigneeLike) {
    this.taskAssigneeLike = taskAssigneeLike;
  }

  public void setTaskAssigneeLike(String taskAssigneeLike) {
    this.taskAssigneeLike = JsonNullable.<String>of(taskAssigneeLike);
  }


  public HistoricTaskInstanceQueryDto taskOwner(String taskOwner) {
    this.taskOwner = JsonNullable.<String>of(taskOwner);
    
    return this;
  }

   /**
   * Restrict to tasks that the given user owns.
   * @return taskOwner
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskOwner() {
        return taskOwner.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskOwner_JsonNullable() {
    return taskOwner;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_OWNER)
  public void setTaskOwner_JsonNullable(JsonNullable<String> taskOwner) {
    this.taskOwner = taskOwner;
  }

  public void setTaskOwner(String taskOwner) {
    this.taskOwner = JsonNullable.<String>of(taskOwner);
  }


  public HistoricTaskInstanceQueryDto taskOwnerLike(String taskOwnerLike) {
    this.taskOwnerLike = JsonNullable.<String>of(taskOwnerLike);
    
    return this;
  }

   /**
   * Restrict to tasks that are owned by users with the parameter value as a substring.
   * @return taskOwnerLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskOwnerLike() {
        return taskOwnerLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_OWNER_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskOwnerLike_JsonNullable() {
    return taskOwnerLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_OWNER_LIKE)
  public void setTaskOwnerLike_JsonNullable(JsonNullable<String> taskOwnerLike) {
    this.taskOwnerLike = taskOwnerLike;
  }

  public void setTaskOwnerLike(String taskOwnerLike) {
    this.taskOwnerLike = JsonNullable.<String>of(taskOwnerLike);
  }


  public HistoricTaskInstanceQueryDto taskPriority(Integer taskPriority) {
    this.taskPriority = JsonNullable.<Integer>of(taskPriority);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given priority.
   * @return taskPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getTaskPriority() {
        return taskPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getTaskPriority_JsonNullable() {
    return taskPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_PRIORITY)
  public void setTaskPriority_JsonNullable(JsonNullable<Integer> taskPriority) {
    this.taskPriority = taskPriority;
  }

  public void setTaskPriority(Integer taskPriority) {
    this.taskPriority = JsonNullable.<Integer>of(taskPriority);
  }


  public HistoricTaskInstanceQueryDto assigned(Boolean assigned) {
    this.assigned = JsonNullable.<Boolean>of(assigned);
    
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned.
   * @return assigned
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getAssigned() {
        return assigned.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getAssigned_JsonNullable() {
    return assigned;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  public void setAssigned_JsonNullable(JsonNullable<Boolean> assigned) {
    this.assigned = assigned;
  }

  public void setAssigned(Boolean assigned) {
    this.assigned = JsonNullable.<Boolean>of(assigned);
  }


  public HistoricTaskInstanceQueryDto unassigned(Boolean unassigned) {
    this.unassigned = JsonNullable.<Boolean>of(unassigned);
    
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned.
   * @return unassigned
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnassigned() {
        return unassigned.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnassigned_JsonNullable() {
    return unassigned;
  }
  
  @JsonProperty(JSON_PROPERTY_UNASSIGNED)
  public void setUnassigned_JsonNullable(JsonNullable<Boolean> unassigned) {
    this.unassigned = unassigned;
  }

  public void setUnassigned(Boolean unassigned) {
    this.unassigned = JsonNullable.<Boolean>of(unassigned);
  }


  public HistoricTaskInstanceQueryDto finished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
    
    return this;
  }

   /**
   * Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return finished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getFinished() {
        return finished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getFinished_JsonNullable() {
    return finished;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED)
  public void setFinished_JsonNullable(JsonNullable<Boolean> finished) {
    this.finished = finished;
  }

  public void setFinished(Boolean finished) {
    this.finished = JsonNullable.<Boolean>of(finished);
  }


  public HistoricTaskInstanceQueryDto unfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
    
    return this;
  }

   /**
   * Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnfinished() {
        return unfinished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnfinished_JsonNullable() {
    return unfinished;
  }
  
  @JsonProperty(JSON_PROPERTY_UNFINISHED)
  public void setUnfinished_JsonNullable(JsonNullable<Boolean> unfinished) {
    this.unfinished = unfinished;
  }

  public void setUnfinished(Boolean unfinished) {
    this.unfinished = JsonNullable.<Boolean>of(unfinished);
  }


  public HistoricTaskInstanceQueryDto processFinished(Boolean processFinished) {
    this.processFinished = JsonNullable.<Boolean>of(processFinished);
    
    return this;
  }

   /**
   * Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return processFinished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getProcessFinished() {
        return processFinished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_FINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getProcessFinished_JsonNullable() {
    return processFinished;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_FINISHED)
  public void setProcessFinished_JsonNullable(JsonNullable<Boolean> processFinished) {
    this.processFinished = processFinished;
  }

  public void setProcessFinished(Boolean processFinished) {
    this.processFinished = JsonNullable.<Boolean>of(processFinished);
  }


  public HistoricTaskInstanceQueryDto processUnfinished(Boolean processUnfinished) {
    this.processUnfinished = JsonNullable.<Boolean>of(processUnfinished);
    
    return this;
  }

   /**
   * Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return processUnfinished
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getProcessUnfinished() {
        return processUnfinished.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_UNFINISHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getProcessUnfinished_JsonNullable() {
    return processUnfinished;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_UNFINISHED)
  public void setProcessUnfinished_JsonNullable(JsonNullable<Boolean> processUnfinished) {
    this.processUnfinished = processUnfinished;
  }

  public void setProcessUnfinished(Boolean processUnfinished) {
    this.processUnfinished = JsonNullable.<Boolean>of(processUnfinished);
  }


  public HistoricTaskInstanceQueryDto taskDueDate(OffsetDateTime taskDueDate) {
    this.taskDueDate = JsonNullable.<OffsetDateTime>of(taskDueDate);
    
    return this;
  }

   /**
   * Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskDueDate() {
        return taskDueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskDueDate_JsonNullable() {
    return taskDueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE)
  public void setTaskDueDate_JsonNullable(JsonNullable<OffsetDateTime> taskDueDate) {
    this.taskDueDate = taskDueDate;
  }

  public void setTaskDueDate(OffsetDateTime taskDueDate) {
    this.taskDueDate = JsonNullable.<OffsetDateTime>of(taskDueDate);
  }


  public HistoricTaskInstanceQueryDto taskDueDateBefore(OffsetDateTime taskDueDateBefore) {
    this.taskDueDateBefore = JsonNullable.<OffsetDateTime>of(taskDueDateBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDateBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskDueDateBefore() {
        return taskDueDateBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskDueDateBefore_JsonNullable() {
    return taskDueDateBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE_BEFORE)
  public void setTaskDueDateBefore_JsonNullable(JsonNullable<OffsetDateTime> taskDueDateBefore) {
    this.taskDueDateBefore = taskDueDateBefore;
  }

  public void setTaskDueDateBefore(OffsetDateTime taskDueDateBefore) {
    this.taskDueDateBefore = JsonNullable.<OffsetDateTime>of(taskDueDateBefore);
  }


  public HistoricTaskInstanceQueryDto taskDueDateAfter(OffsetDateTime taskDueDateAfter) {
    this.taskDueDateAfter = JsonNullable.<OffsetDateTime>of(taskDueDateAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDateAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskDueDateAfter() {
        return taskDueDateAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskDueDateAfter_JsonNullable() {
    return taskDueDateAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DUE_DATE_AFTER)
  public void setTaskDueDateAfter_JsonNullable(JsonNullable<OffsetDateTime> taskDueDateAfter) {
    this.taskDueDateAfter = taskDueDateAfter;
  }

  public void setTaskDueDateAfter(OffsetDateTime taskDueDateAfter) {
    this.taskDueDateAfter = JsonNullable.<OffsetDateTime>of(taskDueDateAfter);
  }


  public HistoricTaskInstanceQueryDto withoutTaskDueDate(Boolean withoutTaskDueDate) {
    this.withoutTaskDueDate = JsonNullable.<Boolean>of(withoutTaskDueDate);
    
    return this;
  }

   /**
   * Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTaskDueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTaskDueDate() {
        return withoutTaskDueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TASK_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTaskDueDate_JsonNullable() {
    return withoutTaskDueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TASK_DUE_DATE)
  public void setWithoutTaskDueDate_JsonNullable(JsonNullable<Boolean> withoutTaskDueDate) {
    this.withoutTaskDueDate = withoutTaskDueDate;
  }

  public void setWithoutTaskDueDate(Boolean withoutTaskDueDate) {
    this.withoutTaskDueDate = JsonNullable.<Boolean>of(withoutTaskDueDate);
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDate(OffsetDateTime taskFollowUpDate) {
    this.taskFollowUpDate = JsonNullable.<OffsetDateTime>of(taskFollowUpDate);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskFollowUpDate() {
        return taskFollowUpDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskFollowUpDate_JsonNullable() {
    return taskFollowUpDate;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE)
  public void setTaskFollowUpDate_JsonNullable(JsonNullable<OffsetDateTime> taskFollowUpDate) {
    this.taskFollowUpDate = taskFollowUpDate;
  }

  public void setTaskFollowUpDate(OffsetDateTime taskFollowUpDate) {
    this.taskFollowUpDate = JsonNullable.<OffsetDateTime>of(taskFollowUpDate);
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDateBefore(OffsetDateTime taskFollowUpDateBefore) {
    this.taskFollowUpDateBefore = JsonNullable.<OffsetDateTime>of(taskFollowUpDateBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDateBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskFollowUpDateBefore() {
        return taskFollowUpDateBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskFollowUpDateBefore_JsonNullable() {
    return taskFollowUpDateBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE_BEFORE)
  public void setTaskFollowUpDateBefore_JsonNullable(JsonNullable<OffsetDateTime> taskFollowUpDateBefore) {
    this.taskFollowUpDateBefore = taskFollowUpDateBefore;
  }

  public void setTaskFollowUpDateBefore(OffsetDateTime taskFollowUpDateBefore) {
    this.taskFollowUpDateBefore = JsonNullable.<OffsetDateTime>of(taskFollowUpDateBefore);
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDateAfter(OffsetDateTime taskFollowUpDateAfter) {
    this.taskFollowUpDateAfter = JsonNullable.<OffsetDateTime>of(taskFollowUpDateAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDateAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getTaskFollowUpDateAfter() {
        return taskFollowUpDateAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getTaskFollowUpDateAfter_JsonNullable() {
    return taskFollowUpDateAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_FOLLOW_UP_DATE_AFTER)
  public void setTaskFollowUpDateAfter_JsonNullable(JsonNullable<OffsetDateTime> taskFollowUpDateAfter) {
    this.taskFollowUpDateAfter = taskFollowUpDateAfter;
  }

  public void setTaskFollowUpDateAfter(OffsetDateTime taskFollowUpDateAfter) {
    this.taskFollowUpDateAfter = JsonNullable.<OffsetDateTime>of(taskFollowUpDateAfter);
  }


  public HistoricTaskInstanceQueryDto startedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedBefore() {
        return startedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedBefore_JsonNullable() {
    return startedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_BEFORE)
  public void setStartedBefore_JsonNullable(JsonNullable<OffsetDateTime> startedBefore) {
    this.startedBefore = startedBefore;
  }

  public void setStartedBefore(OffsetDateTime startedBefore) {
    this.startedBefore = JsonNullable.<OffsetDateTime>of(startedBefore);
  }


  public HistoricTaskInstanceQueryDto startedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getStartedAfter() {
        return startedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getStartedAfter_JsonNullable() {
    return startedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTED_AFTER)
  public void setStartedAfter_JsonNullable(JsonNullable<OffsetDateTime> startedAfter) {
    this.startedAfter = startedAfter;
  }

  public void setStartedAfter(OffsetDateTime startedAfter) {
    this.startedAfter = JsonNullable.<OffsetDateTime>of(startedAfter);
  }


  public HistoricTaskInstanceQueryDto finishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedBefore() {
        return finishedBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedBefore_JsonNullable() {
    return finishedBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_BEFORE)
  public void setFinishedBefore_JsonNullable(JsonNullable<OffsetDateTime> finishedBefore) {
    this.finishedBefore = finishedBefore;
  }

  public void setFinishedBefore(OffsetDateTime finishedBefore) {
    this.finishedBefore = JsonNullable.<OffsetDateTime>of(finishedBefore);
  }


  public HistoricTaskInstanceQueryDto finishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFinishedAfter() {
        return finishedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFinishedAfter_JsonNullable() {
    return finishedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_FINISHED_AFTER)
  public void setFinishedAfter_JsonNullable(JsonNullable<OffsetDateTime> finishedAfter) {
    this.finishedAfter = finishedAfter;
  }

  public void setFinishedAfter(OffsetDateTime finishedAfter) {
    this.finishedAfter = JsonNullable.<OffsetDateTime>of(finishedAfter);
  }


  public HistoricTaskInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricTaskInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricTaskInstanceQueryDto taskVariables(List<VariableQueryParameterDto> taskVariables) {
    this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(taskVariables);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addTaskVariablesItem(VariableQueryParameterDto taskVariablesItem) {
    if (this.taskVariables == null || !this.taskVariables.isPresent()) {
      this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.taskVariables.get().add(taskVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return taskVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getTaskVariables() {
        return taskVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getTaskVariables_JsonNullable() {
    return taskVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  public void setTaskVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> taskVariables) {
    this.taskVariables = taskVariables;
  }

  public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
    this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(taskVariables);
  }


  public HistoricTaskInstanceQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
    if (this.processVariables == null || !this.processVariables.isPresent()) {
      this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.processVariables.get().add(processVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getProcessVariables() {
        return processVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getProcessVariables_JsonNullable() {
    return processVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  public void setProcessVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> processVariables) {
    this.processVariables = processVariables;
  }

  public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
  }


  public HistoricTaskInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
    
    return this;
  }

   /**
   * Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableNamesIgnoreCase() {
        return variableNamesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableNamesIgnoreCase_JsonNullable() {
    return variableNamesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  public void setVariableNamesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }

  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
  }


  public HistoricTaskInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
    
    return this;
  }

   /**
   * Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableValuesIgnoreCase() {
        return variableValuesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableValuesIgnoreCase_JsonNullable() {
    return variableValuesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  public void setVariableValuesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }

  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
  }


  public HistoricTaskInstanceQueryDto taskInvolvedUser(String taskInvolvedUser) {
    this.taskInvolvedUser = JsonNullable.<String>of(taskInvolvedUser);
    
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given user.
   * @return taskInvolvedUser
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskInvolvedUser() {
        return taskInvolvedUser.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_INVOLVED_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskInvolvedUser_JsonNullable() {
    return taskInvolvedUser;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_INVOLVED_USER)
  public void setTaskInvolvedUser_JsonNullable(JsonNullable<String> taskInvolvedUser) {
    this.taskInvolvedUser = taskInvolvedUser;
  }

  public void setTaskInvolvedUser(String taskInvolvedUser) {
    this.taskInvolvedUser = JsonNullable.<String>of(taskInvolvedUser);
  }


  public HistoricTaskInstanceQueryDto taskInvolvedGroup(String taskInvolvedGroup) {
    this.taskInvolvedGroup = JsonNullable.<String>of(taskInvolvedGroup);
    
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given group.
   * @return taskInvolvedGroup
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskInvolvedGroup() {
        return taskInvolvedGroup.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_INVOLVED_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskInvolvedGroup_JsonNullable() {
    return taskInvolvedGroup;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_INVOLVED_GROUP)
  public void setTaskInvolvedGroup_JsonNullable(JsonNullable<String> taskInvolvedGroup) {
    this.taskInvolvedGroup = taskInvolvedGroup;
  }

  public void setTaskInvolvedGroup(String taskInvolvedGroup) {
    this.taskInvolvedGroup = JsonNullable.<String>of(taskInvolvedGroup);
  }


  public HistoricTaskInstanceQueryDto taskHadCandidateUser(String taskHadCandidateUser) {
    this.taskHadCandidateUser = JsonNullable.<String>of(taskHadCandidateUser);
    
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given candidate user.
   * @return taskHadCandidateUser
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskHadCandidateUser() {
        return taskHadCandidateUser.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_HAD_CANDIDATE_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskHadCandidateUser_JsonNullable() {
    return taskHadCandidateUser;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_HAD_CANDIDATE_USER)
  public void setTaskHadCandidateUser_JsonNullable(JsonNullable<String> taskHadCandidateUser) {
    this.taskHadCandidateUser = taskHadCandidateUser;
  }

  public void setTaskHadCandidateUser(String taskHadCandidateUser) {
    this.taskHadCandidateUser = JsonNullable.<String>of(taskHadCandidateUser);
  }


  public HistoricTaskInstanceQueryDto taskHadCandidateGroup(String taskHadCandidateGroup) {
    this.taskHadCandidateGroup = JsonNullable.<String>of(taskHadCandidateGroup);
    
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given candidate group.
   * @return taskHadCandidateGroup
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskHadCandidateGroup() {
        return taskHadCandidateGroup.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_HAD_CANDIDATE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskHadCandidateGroup_JsonNullable() {
    return taskHadCandidateGroup;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_HAD_CANDIDATE_GROUP)
  public void setTaskHadCandidateGroup_JsonNullable(JsonNullable<String> taskHadCandidateGroup) {
    this.taskHadCandidateGroup = taskHadCandidateGroup;
  }

  public void setTaskHadCandidateGroup(String taskHadCandidateGroup) {
    this.taskHadCandidateGroup = JsonNullable.<String>of(taskHadCandidateGroup);
  }


  public HistoricTaskInstanceQueryDto withCandidateGroups(Boolean withCandidateGroups) {
    this.withCandidateGroups = JsonNullable.<Boolean>of(withCandidateGroups);
    
    return this;
  }

   /**
   * Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withCandidateGroups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithCandidateGroups() {
        return withCandidateGroups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithCandidateGroups_JsonNullable() {
    return withCandidateGroups;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_GROUPS)
  public void setWithCandidateGroups_JsonNullable(JsonNullable<Boolean> withCandidateGroups) {
    this.withCandidateGroups = withCandidateGroups;
  }

  public void setWithCandidateGroups(Boolean withCandidateGroups) {
    this.withCandidateGroups = JsonNullable.<Boolean>of(withCandidateGroups);
  }


  public HistoricTaskInstanceQueryDto withoutCandidateGroups(Boolean withoutCandidateGroups) {
    this.withoutCandidateGroups = JsonNullable.<Boolean>of(withoutCandidateGroups);
    
    return this;
  }

   /**
   * Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutCandidateGroups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutCandidateGroups() {
        return withoutCandidateGroups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutCandidateGroups_JsonNullable() {
    return withoutCandidateGroups;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS)
  public void setWithoutCandidateGroups_JsonNullable(JsonNullable<Boolean> withoutCandidateGroups) {
    this.withoutCandidateGroups = withoutCandidateGroups;
  }

  public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
    this.withoutCandidateGroups = JsonNullable.<Boolean>of(withoutCandidateGroups);
  }


  public HistoricTaskInstanceQueryDto orQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<HistoricTaskInstanceQueryDto>>of(orQueries);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addOrQueriesItem(HistoricTaskInstanceQueryDto orQueriesItem) {
    if (this.orQueries == null || !this.orQueries.isPresent()) {
      this.orQueries = JsonNullable.<List<HistoricTaskInstanceQueryDto>>of(new ArrayList<>());
    }
    try {
      this.orQueries.get().add(orQueriesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query&#39;s predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: &#x60;sorting&#x60;, &#x60;withCandidateGroups&#x60;, &#x60; withoutCandidateGroups&#x60;.  See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.
   * @return orQueries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricTaskInstanceQueryDto> getOrQueries() {
        return orQueries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricTaskInstanceQueryDto>> getOrQueries_JsonNullable() {
    return orQueries;
  }
  
  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  public void setOrQueries_JsonNullable(JsonNullable<List<HistoricTaskInstanceQueryDto>> orQueries) {
    this.orQueries = orQueries;
  }

  public void setOrQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<HistoricTaskInstanceQueryDto>>of(orQueries);
  }


  public HistoricTaskInstanceQueryDto sorting(List<HistoricTaskInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricTaskInstanceQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricTaskInstanceQueryDto addSortingItem(HistoricTaskInstanceQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricTaskInstanceQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for &#x60;count&#x60; endpoints
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricTaskInstanceQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricTaskInstanceQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricTaskInstanceQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricTaskInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricTaskInstanceQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto = (HistoricTaskInstanceQueryDto) o;
    return equalsNullable(this.taskId, historicTaskInstanceQueryDto.taskId) &&
        equalsNullable(this.taskParentTaskId, historicTaskInstanceQueryDto.taskParentTaskId) &&
        equalsNullable(this.processInstanceId, historicTaskInstanceQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceBusinessKey, historicTaskInstanceQueryDto.processInstanceBusinessKey) &&
        equalsNullable(this.processInstanceBusinessKeyIn, historicTaskInstanceQueryDto.processInstanceBusinessKeyIn) &&
        equalsNullable(this.processInstanceBusinessKeyLike, historicTaskInstanceQueryDto.processInstanceBusinessKeyLike) &&
        equalsNullable(this.executionId, historicTaskInstanceQueryDto.executionId) &&
        equalsNullable(this.processDefinitionId, historicTaskInstanceQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicTaskInstanceQueryDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionName, historicTaskInstanceQueryDto.processDefinitionName) &&
        equalsNullable(this.caseInstanceId, historicTaskInstanceQueryDto.caseInstanceId) &&
        equalsNullable(this.caseExecutionId, historicTaskInstanceQueryDto.caseExecutionId) &&
        equalsNullable(this.caseDefinitionId, historicTaskInstanceQueryDto.caseDefinitionId) &&
        equalsNullable(this.caseDefinitionKey, historicTaskInstanceQueryDto.caseDefinitionKey) &&
        equalsNullable(this.caseDefinitionName, historicTaskInstanceQueryDto.caseDefinitionName) &&
        equalsNullable(this.activityInstanceIdIn, historicTaskInstanceQueryDto.activityInstanceIdIn) &&
        equalsNullable(this.taskName, historicTaskInstanceQueryDto.taskName) &&
        equalsNullable(this.taskNameLike, historicTaskInstanceQueryDto.taskNameLike) &&
        equalsNullable(this.taskDescription, historicTaskInstanceQueryDto.taskDescription) &&
        equalsNullable(this.taskDescriptionLike, historicTaskInstanceQueryDto.taskDescriptionLike) &&
        equalsNullable(this.taskDefinitionKey, historicTaskInstanceQueryDto.taskDefinitionKey) &&
        equalsNullable(this.taskDefinitionKeyIn, historicTaskInstanceQueryDto.taskDefinitionKeyIn) &&
        equalsNullable(this.taskDeleteReason, historicTaskInstanceQueryDto.taskDeleteReason) &&
        equalsNullable(this.taskDeleteReasonLike, historicTaskInstanceQueryDto.taskDeleteReasonLike) &&
        equalsNullable(this.taskAssignee, historicTaskInstanceQueryDto.taskAssignee) &&
        equalsNullable(this.taskAssigneeLike, historicTaskInstanceQueryDto.taskAssigneeLike) &&
        equalsNullable(this.taskOwner, historicTaskInstanceQueryDto.taskOwner) &&
        equalsNullable(this.taskOwnerLike, historicTaskInstanceQueryDto.taskOwnerLike) &&
        equalsNullable(this.taskPriority, historicTaskInstanceQueryDto.taskPriority) &&
        equalsNullable(this.assigned, historicTaskInstanceQueryDto.assigned) &&
        equalsNullable(this.unassigned, historicTaskInstanceQueryDto.unassigned) &&
        equalsNullable(this.finished, historicTaskInstanceQueryDto.finished) &&
        equalsNullable(this.unfinished, historicTaskInstanceQueryDto.unfinished) &&
        equalsNullable(this.processFinished, historicTaskInstanceQueryDto.processFinished) &&
        equalsNullable(this.processUnfinished, historicTaskInstanceQueryDto.processUnfinished) &&
        equalsNullable(this.taskDueDate, historicTaskInstanceQueryDto.taskDueDate) &&
        equalsNullable(this.taskDueDateBefore, historicTaskInstanceQueryDto.taskDueDateBefore) &&
        equalsNullable(this.taskDueDateAfter, historicTaskInstanceQueryDto.taskDueDateAfter) &&
        equalsNullable(this.withoutTaskDueDate, historicTaskInstanceQueryDto.withoutTaskDueDate) &&
        equalsNullable(this.taskFollowUpDate, historicTaskInstanceQueryDto.taskFollowUpDate) &&
        equalsNullable(this.taskFollowUpDateBefore, historicTaskInstanceQueryDto.taskFollowUpDateBefore) &&
        equalsNullable(this.taskFollowUpDateAfter, historicTaskInstanceQueryDto.taskFollowUpDateAfter) &&
        equalsNullable(this.startedBefore, historicTaskInstanceQueryDto.startedBefore) &&
        equalsNullable(this.startedAfter, historicTaskInstanceQueryDto.startedAfter) &&
        equalsNullable(this.finishedBefore, historicTaskInstanceQueryDto.finishedBefore) &&
        equalsNullable(this.finishedAfter, historicTaskInstanceQueryDto.finishedAfter) &&
        equalsNullable(this.tenantIdIn, historicTaskInstanceQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicTaskInstanceQueryDto.withoutTenantId) &&
        equalsNullable(this.taskVariables, historicTaskInstanceQueryDto.taskVariables) &&
        equalsNullable(this.processVariables, historicTaskInstanceQueryDto.processVariables) &&
        equalsNullable(this.variableNamesIgnoreCase, historicTaskInstanceQueryDto.variableNamesIgnoreCase) &&
        equalsNullable(this.variableValuesIgnoreCase, historicTaskInstanceQueryDto.variableValuesIgnoreCase) &&
        equalsNullable(this.taskInvolvedUser, historicTaskInstanceQueryDto.taskInvolvedUser) &&
        equalsNullable(this.taskInvolvedGroup, historicTaskInstanceQueryDto.taskInvolvedGroup) &&
        equalsNullable(this.taskHadCandidateUser, historicTaskInstanceQueryDto.taskHadCandidateUser) &&
        equalsNullable(this.taskHadCandidateGroup, historicTaskInstanceQueryDto.taskHadCandidateGroup) &&
        equalsNullable(this.withCandidateGroups, historicTaskInstanceQueryDto.withCandidateGroups) &&
        equalsNullable(this.withoutCandidateGroups, historicTaskInstanceQueryDto.withoutCandidateGroups) &&
        equalsNullable(this.orQueries, historicTaskInstanceQueryDto.orQueries) &&
        equalsNullable(this.sorting, historicTaskInstanceQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(taskId), hashCodeNullable(taskParentTaskId), hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceBusinessKey), hashCodeNullable(processInstanceBusinessKeyIn), hashCodeNullable(processInstanceBusinessKeyLike), hashCodeNullable(executionId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionName), hashCodeNullable(caseInstanceId), hashCodeNullable(caseExecutionId), hashCodeNullable(caseDefinitionId), hashCodeNullable(caseDefinitionKey), hashCodeNullable(caseDefinitionName), hashCodeNullable(activityInstanceIdIn), hashCodeNullable(taskName), hashCodeNullable(taskNameLike), hashCodeNullable(taskDescription), hashCodeNullable(taskDescriptionLike), hashCodeNullable(taskDefinitionKey), hashCodeNullable(taskDefinitionKeyIn), hashCodeNullable(taskDeleteReason), hashCodeNullable(taskDeleteReasonLike), hashCodeNullable(taskAssignee), hashCodeNullable(taskAssigneeLike), hashCodeNullable(taskOwner), hashCodeNullable(taskOwnerLike), hashCodeNullable(taskPriority), hashCodeNullable(assigned), hashCodeNullable(unassigned), hashCodeNullable(finished), hashCodeNullable(unfinished), hashCodeNullable(processFinished), hashCodeNullable(processUnfinished), hashCodeNullable(taskDueDate), hashCodeNullable(taskDueDateBefore), hashCodeNullable(taskDueDateAfter), hashCodeNullable(withoutTaskDueDate), hashCodeNullable(taskFollowUpDate), hashCodeNullable(taskFollowUpDateBefore), hashCodeNullable(taskFollowUpDateAfter), hashCodeNullable(startedBefore), hashCodeNullable(startedAfter), hashCodeNullable(finishedBefore), hashCodeNullable(finishedAfter), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(taskVariables), hashCodeNullable(processVariables), hashCodeNullable(variableNamesIgnoreCase), hashCodeNullable(variableValuesIgnoreCase), hashCodeNullable(taskInvolvedUser), hashCodeNullable(taskInvolvedGroup), hashCodeNullable(taskHadCandidateUser), hashCodeNullable(taskHadCandidateGroup), hashCodeNullable(withCandidateGroups), hashCodeNullable(withoutCandidateGroups), hashCodeNullable(orQueries), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricTaskInstanceQueryDto {\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    taskParentTaskId: ").append(toIndentedString(taskParentTaskId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceBusinessKey: ").append(toIndentedString(processInstanceBusinessKey)).append("\n");
    sb.append("    processInstanceBusinessKeyIn: ").append(toIndentedString(processInstanceBusinessKeyIn)).append("\n");
    sb.append("    processInstanceBusinessKeyLike: ").append(toIndentedString(processInstanceBusinessKeyLike)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseDefinitionName: ").append(toIndentedString(caseDefinitionName)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    taskNameLike: ").append(toIndentedString(taskNameLike)).append("\n");
    sb.append("    taskDescription: ").append(toIndentedString(taskDescription)).append("\n");
    sb.append("    taskDescriptionLike: ").append(toIndentedString(taskDescriptionLike)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    taskDefinitionKeyIn: ").append(toIndentedString(taskDefinitionKeyIn)).append("\n");
    sb.append("    taskDeleteReason: ").append(toIndentedString(taskDeleteReason)).append("\n");
    sb.append("    taskDeleteReasonLike: ").append(toIndentedString(taskDeleteReasonLike)).append("\n");
    sb.append("    taskAssignee: ").append(toIndentedString(taskAssignee)).append("\n");
    sb.append("    taskAssigneeLike: ").append(toIndentedString(taskAssigneeLike)).append("\n");
    sb.append("    taskOwner: ").append(toIndentedString(taskOwner)).append("\n");
    sb.append("    taskOwnerLike: ").append(toIndentedString(taskOwnerLike)).append("\n");
    sb.append("    taskPriority: ").append(toIndentedString(taskPriority)).append("\n");
    sb.append("    assigned: ").append(toIndentedString(assigned)).append("\n");
    sb.append("    unassigned: ").append(toIndentedString(unassigned)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    processFinished: ").append(toIndentedString(processFinished)).append("\n");
    sb.append("    processUnfinished: ").append(toIndentedString(processUnfinished)).append("\n");
    sb.append("    taskDueDate: ").append(toIndentedString(taskDueDate)).append("\n");
    sb.append("    taskDueDateBefore: ").append(toIndentedString(taskDueDateBefore)).append("\n");
    sb.append("    taskDueDateAfter: ").append(toIndentedString(taskDueDateAfter)).append("\n");
    sb.append("    withoutTaskDueDate: ").append(toIndentedString(withoutTaskDueDate)).append("\n");
    sb.append("    taskFollowUpDate: ").append(toIndentedString(taskFollowUpDate)).append("\n");
    sb.append("    taskFollowUpDateBefore: ").append(toIndentedString(taskFollowUpDateBefore)).append("\n");
    sb.append("    taskFollowUpDateAfter: ").append(toIndentedString(taskFollowUpDateAfter)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    taskVariables: ").append(toIndentedString(taskVariables)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    taskInvolvedUser: ").append(toIndentedString(taskInvolvedUser)).append("\n");
    sb.append("    taskInvolvedGroup: ").append(toIndentedString(taskInvolvedGroup)).append("\n");
    sb.append("    taskHadCandidateUser: ").append(toIndentedString(taskHadCandidateUser)).append("\n");
    sb.append("    taskHadCandidateGroup: ").append(toIndentedString(taskHadCandidateGroup)).append("\n");
    sb.append("    withCandidateGroups: ").append(toIndentedString(withCandidateGroups)).append("\n");
    sb.append("    withoutCandidateGroups: ").append(toIndentedString(withoutCandidateGroups)).append("\n");
    sb.append("    orQueries: ").append(toIndentedString(orQueries)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `taskId` to the URL query string
    if (getTaskId() != null) {
      try {
        joiner.add(String.format("%staskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskParentTaskId` to the URL query string
    if (getTaskParentTaskId() != null) {
      try {
        joiner.add(String.format("%staskParentTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskParentTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKey` to the URL query string
    if (getProcessInstanceBusinessKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKeyIn` to the URL query string
    if (getProcessInstanceBusinessKeyIn() != null) {
      for (int i = 0; i < getProcessInstanceBusinessKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceBusinessKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceBusinessKeyLike` to the URL query string
    if (getProcessInstanceBusinessKeyLike() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKeyLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionId` to the URL query string
    if (getCaseExecutionId() != null) {
      try {
        joiner.add(String.format("%scaseExecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionId` to the URL query string
    if (getCaseDefinitionId() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionKey` to the URL query string
    if (getCaseDefinitionKey() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionName` to the URL query string
    if (getCaseDefinitionName() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceIdIn` to the URL query string
    if (getActivityInstanceIdIn() != null) {
      for (int i = 0; i < getActivityInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `taskName` to the URL query string
    if (getTaskName() != null) {
      try {
        joiner.add(String.format("%staskName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskNameLike` to the URL query string
    if (getTaskNameLike() != null) {
      try {
        joiner.add(String.format("%staskNameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDescription` to the URL query string
    if (getTaskDescription() != null) {
      try {
        joiner.add(String.format("%staskDescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDescriptionLike` to the URL query string
    if (getTaskDescriptionLike() != null) {
      try {
        joiner.add(String.format("%staskDescriptionLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDescriptionLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKey` to the URL query string
    if (getTaskDefinitionKey() != null) {
      try {
        joiner.add(String.format("%staskDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKeyIn` to the URL query string
    if (getTaskDefinitionKeyIn() != null) {
      for (int i = 0; i < getTaskDefinitionKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%staskDefinitionKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTaskDefinitionKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `taskDeleteReason` to the URL query string
    if (getTaskDeleteReason() != null) {
      try {
        joiner.add(String.format("%staskDeleteReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDeleteReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDeleteReasonLike` to the URL query string
    if (getTaskDeleteReasonLike() != null) {
      try {
        joiner.add(String.format("%staskDeleteReasonLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDeleteReasonLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskAssignee` to the URL query string
    if (getTaskAssignee() != null) {
      try {
        joiner.add(String.format("%staskAssignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskAssigneeLike` to the URL query string
    if (getTaskAssigneeLike() != null) {
      try {
        joiner.add(String.format("%staskAssigneeLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskAssigneeLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskOwner` to the URL query string
    if (getTaskOwner() != null) {
      try {
        joiner.add(String.format("%staskOwner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskOwner()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskOwnerLike` to the URL query string
    if (getTaskOwnerLike() != null) {
      try {
        joiner.add(String.format("%staskOwnerLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskOwnerLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskPriority` to the URL query string
    if (getTaskPriority() != null) {
      try {
        joiner.add(String.format("%staskPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigned` to the URL query string
    if (getAssigned() != null) {
      try {
        joiner.add(String.format("%sassigned%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigned()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unassigned` to the URL query string
    if (getUnassigned() != null) {
      try {
        joiner.add(String.format("%sunassigned%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnassigned()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finished` to the URL query string
    if (getFinished() != null) {
      try {
        joiner.add(String.format("%sfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unfinished` to the URL query string
    if (getUnfinished() != null) {
      try {
        joiner.add(String.format("%sunfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnfinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processFinished` to the URL query string
    if (getProcessFinished() != null) {
      try {
        joiner.add(String.format("%sprocessFinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessFinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processUnfinished` to the URL query string
    if (getProcessUnfinished() != null) {
      try {
        joiner.add(String.format("%sprocessUnfinished%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessUnfinished()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDueDate` to the URL query string
    if (getTaskDueDate() != null) {
      try {
        joiner.add(String.format("%staskDueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDueDateBefore` to the URL query string
    if (getTaskDueDateBefore() != null) {
      try {
        joiner.add(String.format("%staskDueDateBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDueDateBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDueDateAfter` to the URL query string
    if (getTaskDueDateAfter() != null) {
      try {
        joiner.add(String.format("%staskDueDateAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDueDateAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutTaskDueDate` to the URL query string
    if (getWithoutTaskDueDate() != null) {
      try {
        joiner.add(String.format("%swithoutTaskDueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTaskDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskFollowUpDate` to the URL query string
    if (getTaskFollowUpDate() != null) {
      try {
        joiner.add(String.format("%staskFollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskFollowUpDateBefore` to the URL query string
    if (getTaskFollowUpDateBefore() != null) {
      try {
        joiner.add(String.format("%staskFollowUpDateBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskFollowUpDateBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskFollowUpDateAfter` to the URL query string
    if (getTaskFollowUpDateAfter() != null) {
      try {
        joiner.add(String.format("%staskFollowUpDateAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskFollowUpDateAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedBefore` to the URL query string
    if (getStartedBefore() != null) {
      try {
        joiner.add(String.format("%sstartedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startedAfter` to the URL query string
    if (getStartedAfter() != null) {
      try {
        joiner.add(String.format("%sstartedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedBefore` to the URL query string
    if (getFinishedBefore() != null) {
      try {
        joiner.add(String.format("%sfinishedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `finishedAfter` to the URL query string
    if (getFinishedAfter() != null) {
      try {
        joiner.add(String.format("%sfinishedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFinishedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskVariables` to the URL query string
    if (getTaskVariables() != null) {
      for (int i = 0; i < getTaskVariables().size(); i++) {
        if (getTaskVariables().get(i) != null) {
          joiner.add(getTaskVariables().get(i).toUrlQueryString(String.format("%staskVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `processVariables` to the URL query string
    if (getProcessVariables() != null) {
      for (int i = 0; i < getProcessVariables().size(); i++) {
        if (getProcessVariables().get(i) != null) {
          joiner.add(getProcessVariables().get(i).toUrlQueryString(String.format("%sprocessVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variableNamesIgnoreCase` to the URL query string
    if (getVariableNamesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableNamesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNamesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValuesIgnoreCase` to the URL query string
    if (getVariableValuesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableValuesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValuesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskInvolvedUser` to the URL query string
    if (getTaskInvolvedUser() != null) {
      try {
        joiner.add(String.format("%staskInvolvedUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskInvolvedUser()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskInvolvedGroup` to the URL query string
    if (getTaskInvolvedGroup() != null) {
      try {
        joiner.add(String.format("%staskInvolvedGroup%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskInvolvedGroup()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskHadCandidateUser` to the URL query string
    if (getTaskHadCandidateUser() != null) {
      try {
        joiner.add(String.format("%staskHadCandidateUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskHadCandidateUser()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskHadCandidateGroup` to the URL query string
    if (getTaskHadCandidateGroup() != null) {
      try {
        joiner.add(String.format("%staskHadCandidateGroup%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskHadCandidateGroup()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withCandidateGroups` to the URL query string
    if (getWithCandidateGroups() != null) {
      try {
        joiner.add(String.format("%swithCandidateGroups%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithCandidateGroups()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutCandidateGroups` to the URL query string
    if (getWithoutCandidateGroups() != null) {
      try {
        joiner.add(String.format("%swithoutCandidateGroups%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutCandidateGroups()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `orQueries` to the URL query string
    if (getOrQueries() != null) {
      for (int i = 0; i < getOrQueries().size(); i++) {
        if (getOrQueries().get(i) != null) {
          joiner.add(getOrQueries().get(i).toUrlQueryString(String.format("%sorQueries%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

