/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoricTaskInstanceReportResultDto
 */
@JsonPropertyOrder({
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_TASK_NAME,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_COUNT,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_PERIOD,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_PERIOD_UNIT,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_MINIMUM,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_MAXIMUM,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_AVERAGE,
  HistoricTaskInstanceReportResultDto.JSON_PROPERTY_TENANT_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricTaskInstanceReportResultDto {
  public static final String JSON_PROPERTY_TASK_NAME = "taskName";
  private JsonNullable<String> taskName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_COUNT = "count";
  private JsonNullable<Long> count = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private JsonNullable<String> processDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PERIOD = "period";
  private JsonNullable<Integer> period = JsonNullable.<Integer>undefined();

  /**
   * The unit of the given period. Possible values are &#x60;MONTH&#x60; and &#x60;QUARTER&#x60;.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   */
  public enum PeriodUnitEnum {
    MONTH("MONTH"),
    
    QUARTER("QUARTER");

    private String value;

    PeriodUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PeriodUnitEnum fromValue(String value) {
      for (PeriodUnitEnum b : PeriodUnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_PERIOD_UNIT = "periodUnit";
  private JsonNullable<PeriodUnitEnum> periodUnit = JsonNullable.<PeriodUnitEnum>undefined();

  public static final String JSON_PROPERTY_MINIMUM = "minimum";
  private JsonNullable<Long> minimum = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_MAXIMUM = "maximum";
  private JsonNullable<Long> maximum = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_AVERAGE = "average";
  private JsonNullable<Long> average = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public HistoricTaskInstanceReportResultDto() {
  }

  public HistoricTaskInstanceReportResultDto taskName(String taskName) {
    this.taskName = JsonNullable.<String>of(taskName);
    
    return this;
  }

   /**
   * The name of the task. It is only available when the &#x60;groupBy&#x60; parameter is set to &#x60;taskName&#x60;. Else the value is &#x60;null&#x60;.  **Note:** This property is only set for a historic task report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;count&#x60;.
   * @return taskName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskName() {
        return taskName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskName_JsonNullable() {
    return taskName;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_NAME)
  public void setTaskName_JsonNullable(JsonNullable<String> taskName) {
    this.taskName = taskName;
  }

  public void setTaskName(String taskName) {
    this.taskName = JsonNullable.<String>of(taskName);
  }


  public HistoricTaskInstanceReportResultDto count(Long count) {
    this.count = JsonNullable.<Long>of(count);
    
    return this;
  }

   /**
   * The number of tasks which have the given definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;count&#x60;.
   * @return count
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getCount() {
        return count.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getCount_JsonNullable() {
    return count;
  }
  
  @JsonProperty(JSON_PROPERTY_COUNT)
  public void setCount_JsonNullable(JsonNullable<Long> count) {
    this.count = count;
  }

  public void setCount(Long count) {
    this.count = JsonNullable.<Long>of(count);
  }


  public HistoricTaskInstanceReportResultDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;count&#x60;.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricTaskInstanceReportResultDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;count&#x60;.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricTaskInstanceReportResultDto processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
    
    return this;
  }

   /**
   * The name of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;count&#x60;.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionName() {
        return processDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionName_JsonNullable() {
    return processDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  public void setProcessDefinitionName_JsonNullable(JsonNullable<String> processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
  }


  public HistoricTaskInstanceReportResultDto period(Integer period) {
    this.period = JsonNullable.<Integer>of(period);
    
    return this;
  }

   /**
   * Specifies a span of time within a year. **Note:** The period must be interpreted in conjunction with the returned &#x60;periodUnit&#x60;.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   * @return period
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getPeriod() {
        return period.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getPeriod_JsonNullable() {
    return period;
  }
  
  @JsonProperty(JSON_PROPERTY_PERIOD)
  public void setPeriod_JsonNullable(JsonNullable<Integer> period) {
    this.period = period;
  }

  public void setPeriod(Integer period) {
    this.period = JsonNullable.<Integer>of(period);
  }


  public HistoricTaskInstanceReportResultDto periodUnit(PeriodUnitEnum periodUnit) {
    this.periodUnit = JsonNullable.<PeriodUnitEnum>of(periodUnit);
    
    return this;
  }

   /**
   * The unit of the given period. Possible values are &#x60;MONTH&#x60; and &#x60;QUARTER&#x60;.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   * @return periodUnit
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public PeriodUnitEnum getPeriodUnit() {
        return periodUnit.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PERIOD_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<PeriodUnitEnum> getPeriodUnit_JsonNullable() {
    return periodUnit;
  }
  
  @JsonProperty(JSON_PROPERTY_PERIOD_UNIT)
  public void setPeriodUnit_JsonNullable(JsonNullable<PeriodUnitEnum> periodUnit) {
    this.periodUnit = periodUnit;
  }

  public void setPeriodUnit(PeriodUnitEnum periodUnit) {
    this.periodUnit = JsonNullable.<PeriodUnitEnum>of(periodUnit);
  }


  public HistoricTaskInstanceReportResultDto minimum(Long minimum) {
    this.minimum = JsonNullable.<Long>of(minimum);
    
    return this;
  }

   /**
   * The smallest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   * @return minimum
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getMinimum() {
        return minimum.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MINIMUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getMinimum_JsonNullable() {
    return minimum;
  }
  
  @JsonProperty(JSON_PROPERTY_MINIMUM)
  public void setMinimum_JsonNullable(JsonNullable<Long> minimum) {
    this.minimum = minimum;
  }

  public void setMinimum(Long minimum) {
    this.minimum = JsonNullable.<Long>of(minimum);
  }


  public HistoricTaskInstanceReportResultDto maximum(Long maximum) {
    this.maximum = JsonNullable.<Long>of(maximum);
    
    return this;
  }

   /**
   * The greatest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   * @return maximum
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getMaximum() {
        return maximum.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MAXIMUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getMaximum_JsonNullable() {
    return maximum;
  }
  
  @JsonProperty(JSON_PROPERTY_MAXIMUM)
  public void setMaximum_JsonNullable(JsonNullable<Long> maximum) {
    this.maximum = maximum;
  }

  public void setMaximum(Long maximum) {
    this.maximum = JsonNullable.<Long>of(maximum);
  }


  public HistoricTaskInstanceReportResultDto average(Long average) {
    this.average = JsonNullable.<Long>of(average);
    
    return this;
  }

   /**
   * The average duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the &#x60;reportType&#x60; query parameter is &#x60;duration&#x60;.
   * @return average
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getAverage() {
        return average.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AVERAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getAverage_JsonNullable() {
    return average;
  }
  
  @JsonProperty(JSON_PROPERTY_AVERAGE)
  public void setAverage_JsonNullable(JsonNullable<Long> average) {
    this.average = average;
  }

  public void setAverage(Long average) {
    this.average = JsonNullable.<Long>of(average);
  }


  public HistoricTaskInstanceReportResultDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricTaskInstanceReportResultDto historicTaskInstanceReportResultDto = (HistoricTaskInstanceReportResultDto) o;
    return equalsNullable(this.taskName, historicTaskInstanceReportResultDto.taskName) &&
        equalsNullable(this.count, historicTaskInstanceReportResultDto.count) &&
        equalsNullable(this.processDefinitionKey, historicTaskInstanceReportResultDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionId, historicTaskInstanceReportResultDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionName, historicTaskInstanceReportResultDto.processDefinitionName) &&
        equalsNullable(this.period, historicTaskInstanceReportResultDto.period) &&
        equalsNullable(this.periodUnit, historicTaskInstanceReportResultDto.periodUnit) &&
        equalsNullable(this.minimum, historicTaskInstanceReportResultDto.minimum) &&
        equalsNullable(this.maximum, historicTaskInstanceReportResultDto.maximum) &&
        equalsNullable(this.average, historicTaskInstanceReportResultDto.average) &&
        equalsNullable(this.tenantId, historicTaskInstanceReportResultDto.tenantId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(taskName), hashCodeNullable(count), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionName), hashCodeNullable(period), hashCodeNullable(periodUnit), hashCodeNullable(minimum), hashCodeNullable(maximum), hashCodeNullable(average), hashCodeNullable(tenantId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricTaskInstanceReportResultDto {\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    periodUnit: ").append(toIndentedString(periodUnit)).append("\n");
    sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
    sb.append("    maximum: ").append(toIndentedString(maximum)).append("\n");
    sb.append("    average: ").append(toIndentedString(average)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `taskName` to the URL query string
    if (getTaskName() != null) {
      try {
        joiner.add(String.format("%staskName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `count` to the URL query string
    if (getCount() != null) {
      try {
        joiner.add(String.format("%scount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `period` to the URL query string
    if (getPeriod() != null) {
      try {
        joiner.add(String.format("%speriod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPeriod()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `periodUnit` to the URL query string
    if (getPeriodUnit() != null) {
      try {
        joiner.add(String.format("%speriodUnit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPeriodUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `minimum` to the URL query string
    if (getMinimum() != null) {
      try {
        joiner.add(String.format("%sminimum%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinimum()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maximum` to the URL query string
    if (getMaximum() != null) {
      try {
        joiner.add(String.format("%smaximum%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaximum()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `average` to the URL query string
    if (getAverage() != null) {
      try {
        joiner.add(String.format("%saverage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAverage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

