/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Historic Variable Instance instance query which defines a list of Historic Variable Instance instances
 */
@JsonPropertyOrder({
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAME,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAME_LIKE,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_VALUE,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_TYPE_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_INCLUDE_DELETED,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_EXECUTION_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_CASE_EXECUTION_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_CASE_ACTIVITY_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_TASK_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_VARIABLE_NAME_IN,
  HistoricVariableInstanceQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoricVariableInstanceQueryDto {
  public static final String JSON_PROPERTY_VARIABLE_NAME = "variableName";
  private JsonNullable<String> variableName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAME_LIKE = "variableNameLike";
  private JsonNullable<String> variableNameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLE_VALUE = "variableValue";
  private Object variableValue;

  public static final String JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  private JsonNullable<Boolean> variableNamesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  private JsonNullable<Boolean> variableValuesIgnoreCase = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_TYPE_IN = "variableTypeIn";
  private JsonNullable<List<String>> variableTypeIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_INCLUDE_DELETED = "includeDeleted";
  private JsonNullable<Boolean> includeDeleted = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
  private JsonNullable<List<String>> processInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID_IN = "executionIdIn";
  private JsonNullable<List<String>> executionIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID_IN = "caseExecutionIdIn";
  private JsonNullable<List<String>> caseExecutionIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_CASE_ACTIVITY_ID_IN = "caseActivityIdIn";
  private JsonNullable<List<String>> caseActivityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TASK_ID_IN = "taskIdIn";
  private JsonNullable<List<String>> taskIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  private JsonNullable<List<String>> activityInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAME_IN = "variableNameIn";
  private JsonNullable<List<String>> variableNameIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<HistoricVariableInstanceQueryDtoSortingInner>> sorting = JsonNullable.<List<HistoricVariableInstanceQueryDtoSortingInner>>undefined();

  public HistoricVariableInstanceQueryDto() {
  }

  public HistoricVariableInstanceQueryDto variableName(String variableName) {
    this.variableName = JsonNullable.<String>of(variableName);
    
    return this;
  }

   /**
   * Filter by variable name.
   * @return variableName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getVariableName() {
        return variableName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVariableName_JsonNullable() {
    return variableName;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME)
  public void setVariableName_JsonNullable(JsonNullable<String> variableName) {
    this.variableName = variableName;
  }

  public void setVariableName(String variableName) {
    this.variableName = JsonNullable.<String>of(variableName);
  }


  public HistoricVariableInstanceQueryDto variableNameLike(String variableNameLike) {
    this.variableNameLike = JsonNullable.<String>of(variableNameLike);
    
    return this;
  }

   /**
   * Restrict to variables with a name like the parameter.
   * @return variableNameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getVariableNameLike() {
        return variableNameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVariableNameLike_JsonNullable() {
    return variableNameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME_LIKE)
  public void setVariableNameLike_JsonNullable(JsonNullable<String> variableNameLike) {
    this.variableNameLike = variableNameLike;
  }

  public void setVariableNameLike(String variableNameLike) {
    this.variableNameLike = JsonNullable.<String>of(variableNameLike);
  }


  public HistoricVariableInstanceQueryDto variableValue(Object variableValue) {
    
    this.variableValue = variableValue;
    return this;
  }

   /**
   * Filter by variable value. May be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
   * @return variableValue
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getVariableValue() {
    return variableValue;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariableValue(Object variableValue) {
    this.variableValue = variableValue;
  }


  public HistoricVariableInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
    
    return this;
  }

   /**
   * Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableNamesIgnoreCase() {
        return variableNamesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableNamesIgnoreCase_JsonNullable() {
    return variableNamesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  public void setVariableNamesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }

  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
  }


  public HistoricVariableInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
    
    return this;
  }

   /**
   * Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableValuesIgnoreCase() {
        return variableValuesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableValuesIgnoreCase_JsonNullable() {
    return variableValuesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  public void setVariableValuesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }

  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
  }


  public HistoricVariableInstanceQueryDto variableTypeIn(List<String> variableTypeIn) {
    this.variableTypeIn = JsonNullable.<List<String>>of(variableTypeIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addVariableTypeInItem(String variableTypeInItem) {
    if (this.variableTypeIn == null || !this.variableTypeIn.isPresent()) {
      this.variableTypeIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.variableTypeIn.get().add(variableTypeInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;.
   * @return variableTypeIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getVariableTypeIn() {
        return variableTypeIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_TYPE_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getVariableTypeIn_JsonNullable() {
    return variableTypeIn;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_TYPE_IN)
  public void setVariableTypeIn_JsonNullable(JsonNullable<List<String>> variableTypeIn) {
    this.variableTypeIn = variableTypeIn;
  }

  public void setVariableTypeIn(List<String> variableTypeIn) {
    this.variableTypeIn = JsonNullable.<List<String>>of(variableTypeIn);
  }


  public HistoricVariableInstanceQueryDto includeDeleted(Boolean includeDeleted) {
    this.includeDeleted = JsonNullable.<Boolean>of(includeDeleted);
    
    return this;
  }

   /**
   * Include variables that has already been deleted during the execution.
   * @return includeDeleted
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeDeleted() {
        return includeDeleted.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeDeleted_JsonNullable() {
    return includeDeleted;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_DELETED)
  public void setIncludeDeleted_JsonNullable(JsonNullable<Boolean> includeDeleted) {
    this.includeDeleted = includeDeleted;
  }

  public void setIncludeDeleted(Boolean includeDeleted) {
    this.includeDeleted = JsonNullable.<Boolean>of(includeDeleted);
  }


  public HistoricVariableInstanceQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Filter by the process instance the variable belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public HistoricVariableInstanceQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
    if (this.processInstanceIdIn == null || !this.processInstanceIdIn.isPresent()) {
      this.processInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIdIn.get().add(processInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed  process instance ids.
   * @return processInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIdIn() {
        return processInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIdIn_JsonNullable() {
    return processInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  public void setProcessInstanceIdIn_JsonNullable(JsonNullable<List<String>> processInstanceIdIn) {
    this.processInstanceIdIn = processInstanceIdIn;
  }

  public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
  }


  public HistoricVariableInstanceQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by the process definition the variable belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public HistoricVariableInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by a key of the process definition the variable belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public HistoricVariableInstanceQueryDto executionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addExecutionIdInItem(String executionIdInItem) {
    if (this.executionIdIn == null || !this.executionIdIn.isPresent()) {
      this.executionIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.executionIdIn.get().add(executionIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and  execution ids.
   * @return executionIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getExecutionIdIn() {
        return executionIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getExecutionIdIn_JsonNullable() {
    return executionIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID_IN)
  public void setExecutionIdIn_JsonNullable(JsonNullable<List<String>> executionIdIn) {
    this.executionIdIn = executionIdIn;
  }

  public void setExecutionIdIn(List<String> executionIdIn) {
    this.executionIdIn = JsonNullable.<List<String>>of(executionIdIn);
  }


  public HistoricVariableInstanceQueryDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * Filter by the case instance the variable belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public HistoricVariableInstanceQueryDto caseExecutionIdIn(List<String> caseExecutionIdIn) {
    this.caseExecutionIdIn = JsonNullable.<List<String>>of(caseExecutionIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addCaseExecutionIdInItem(String caseExecutionIdInItem) {
    if (this.caseExecutionIdIn == null || !this.caseExecutionIdIn.isPresent()) {
      this.caseExecutionIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.caseExecutionIdIn.get().add(caseExecutionIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and  case execution ids.
   * @return caseExecutionIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getCaseExecutionIdIn() {
        return caseExecutionIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getCaseExecutionIdIn_JsonNullable() {
    return caseExecutionIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID_IN)
  public void setCaseExecutionIdIn_JsonNullable(JsonNullable<List<String>> caseExecutionIdIn) {
    this.caseExecutionIdIn = caseExecutionIdIn;
  }

  public void setCaseExecutionIdIn(List<String> caseExecutionIdIn) {
    this.caseExecutionIdIn = JsonNullable.<List<String>>of(caseExecutionIdIn);
  }


  public HistoricVariableInstanceQueryDto caseActivityIdIn(List<String> caseActivityIdIn) {
    this.caseActivityIdIn = JsonNullable.<List<String>>of(caseActivityIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addCaseActivityIdInItem(String caseActivityIdInItem) {
    if (this.caseActivityIdIn == null || !this.caseActivityIdIn.isPresent()) {
      this.caseActivityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.caseActivityIdIn.get().add(caseActivityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and  case activity ids.
   * @return caseActivityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getCaseActivityIdIn() {
        return caseActivityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getCaseActivityIdIn_JsonNullable() {
    return caseActivityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_ACTIVITY_ID_IN)
  public void setCaseActivityIdIn_JsonNullable(JsonNullable<List<String>> caseActivityIdIn) {
    this.caseActivityIdIn = caseActivityIdIn;
  }

  public void setCaseActivityIdIn(List<String> caseActivityIdIn) {
    this.caseActivityIdIn = JsonNullable.<List<String>>of(caseActivityIdIn);
  }


  public HistoricVariableInstanceQueryDto taskIdIn(List<String> taskIdIn) {
    this.taskIdIn = JsonNullable.<List<String>>of(taskIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addTaskIdInItem(String taskIdInItem) {
    if (this.taskIdIn == null || !this.taskIdIn.isPresent()) {
      this.taskIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.taskIdIn.get().add(taskIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and  task ids.
   * @return taskIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTaskIdIn() {
        return taskIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTaskIdIn_JsonNullable() {
    return taskIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID_IN)
  public void setTaskIdIn_JsonNullable(JsonNullable<List<String>> taskIdIn) {
    this.taskIdIn = taskIdIn;
  }

  public void setTaskIdIn(List<String> taskIdIn) {
    this.taskIdIn = JsonNullable.<List<String>>of(taskIdIn);
  }


  public HistoricVariableInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null || !this.activityInstanceIdIn.isPresent()) {
      this.activityInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityInstanceIdIn.get().add(activityInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and  activity instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityInstanceIdIn() {
        return activityInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityInstanceIdIn_JsonNullable() {
    return activityInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  public void setActivityInstanceIdIn_JsonNullable(JsonNullable<List<String>> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }

  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
  }


  public HistoricVariableInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public HistoricVariableInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public HistoricVariableInstanceQueryDto variableNameIn(List<String> variableNameIn) {
    this.variableNameIn = JsonNullable.<List<String>>of(variableNameIn);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addVariableNameInItem(String variableNameInItem) {
    if (this.variableNameIn == null || !this.variableNameIn.isPresent()) {
      this.variableNameIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.variableNameIn.get().add(variableNameInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include historic variable instances which belong to one of the passed  variable names.
   * @return variableNameIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getVariableNameIn() {
        return variableNameIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getVariableNameIn_JsonNullable() {
    return variableNameIn;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAME_IN)
  public void setVariableNameIn_JsonNullable(JsonNullable<List<String>> variableNameIn) {
    this.variableNameIn = variableNameIn;
  }

  public void setVariableNameIn(List<String> variableNameIn) {
    this.variableNameIn = JsonNullable.<List<String>>of(variableNameIn);
  }


  public HistoricVariableInstanceQueryDto sorting(List<HistoricVariableInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricVariableInstanceQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public HistoricVariableInstanceQueryDto addSortingItem(HistoricVariableInstanceQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<HistoricVariableInstanceQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                      an object that specifies one ordering. The position in the array                      identifies the rank of an ordering, i.e., whether it is primary, secondary,                      etc. Sorting has no effect for &#x60;count&#x60; endpoints
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<HistoricVariableInstanceQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<HistoricVariableInstanceQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<HistoricVariableInstanceQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<HistoricVariableInstanceQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<HistoricVariableInstanceQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto = (HistoricVariableInstanceQueryDto) o;
    return equalsNullable(this.variableName, historicVariableInstanceQueryDto.variableName) &&
        equalsNullable(this.variableNameLike, historicVariableInstanceQueryDto.variableNameLike) &&
        Objects.equals(this.variableValue, historicVariableInstanceQueryDto.variableValue) &&
        equalsNullable(this.variableNamesIgnoreCase, historicVariableInstanceQueryDto.variableNamesIgnoreCase) &&
        equalsNullable(this.variableValuesIgnoreCase, historicVariableInstanceQueryDto.variableValuesIgnoreCase) &&
        equalsNullable(this.variableTypeIn, historicVariableInstanceQueryDto.variableTypeIn) &&
        equalsNullable(this.includeDeleted, historicVariableInstanceQueryDto.includeDeleted) &&
        equalsNullable(this.processInstanceId, historicVariableInstanceQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIdIn, historicVariableInstanceQueryDto.processInstanceIdIn) &&
        equalsNullable(this.processDefinitionId, historicVariableInstanceQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, historicVariableInstanceQueryDto.processDefinitionKey) &&
        equalsNullable(this.executionIdIn, historicVariableInstanceQueryDto.executionIdIn) &&
        equalsNullable(this.caseInstanceId, historicVariableInstanceQueryDto.caseInstanceId) &&
        equalsNullable(this.caseExecutionIdIn, historicVariableInstanceQueryDto.caseExecutionIdIn) &&
        equalsNullable(this.caseActivityIdIn, historicVariableInstanceQueryDto.caseActivityIdIn) &&
        equalsNullable(this.taskIdIn, historicVariableInstanceQueryDto.taskIdIn) &&
        equalsNullable(this.activityInstanceIdIn, historicVariableInstanceQueryDto.activityInstanceIdIn) &&
        equalsNullable(this.tenantIdIn, historicVariableInstanceQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, historicVariableInstanceQueryDto.withoutTenantId) &&
        equalsNullable(this.variableNameIn, historicVariableInstanceQueryDto.variableNameIn) &&
        equalsNullable(this.sorting, historicVariableInstanceQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(variableName), hashCodeNullable(variableNameLike), variableValue, hashCodeNullable(variableNamesIgnoreCase), hashCodeNullable(variableValuesIgnoreCase), hashCodeNullable(variableTypeIn), hashCodeNullable(includeDeleted), hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIdIn), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(executionIdIn), hashCodeNullable(caseInstanceId), hashCodeNullable(caseExecutionIdIn), hashCodeNullable(caseActivityIdIn), hashCodeNullable(taskIdIn), hashCodeNullable(activityInstanceIdIn), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(variableNameIn), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricVariableInstanceQueryDto {\n");
    sb.append("    variableName: ").append(toIndentedString(variableName)).append("\n");
    sb.append("    variableNameLike: ").append(toIndentedString(variableNameLike)).append("\n");
    sb.append("    variableValue: ").append(toIndentedString(variableValue)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    variableTypeIn: ").append(toIndentedString(variableTypeIn)).append("\n");
    sb.append("    includeDeleted: ").append(toIndentedString(includeDeleted)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIdIn: ").append(toIndentedString(processInstanceIdIn)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    executionIdIn: ").append(toIndentedString(executionIdIn)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionIdIn: ").append(toIndentedString(caseExecutionIdIn)).append("\n");
    sb.append("    caseActivityIdIn: ").append(toIndentedString(caseActivityIdIn)).append("\n");
    sb.append("    taskIdIn: ").append(toIndentedString(taskIdIn)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    variableNameIn: ").append(toIndentedString(variableNameIn)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `variableName` to the URL query string
    if (getVariableName() != null) {
      try {
        joiner.add(String.format("%svariableName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableNameLike` to the URL query string
    if (getVariableNameLike() != null) {
      try {
        joiner.add(String.format("%svariableNameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValue` to the URL query string
    if (getVariableValue() != null) {
      try {
        joiner.add(String.format("%svariableValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableNamesIgnoreCase` to the URL query string
    if (getVariableNamesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableNamesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNamesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValuesIgnoreCase` to the URL query string
    if (getVariableValuesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableValuesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValuesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableTypeIn` to the URL query string
    if (getVariableTypeIn() != null) {
      for (int i = 0; i < getVariableTypeIn().size(); i++) {
        try {
          joiner.add(String.format("%svariableTypeIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getVariableTypeIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `includeDeleted` to the URL query string
    if (getIncludeDeleted() != null) {
      try {
        joiner.add(String.format("%sincludeDeleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeDeleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIdIn` to the URL query string
    if (getProcessInstanceIdIn() != null) {
      for (int i = 0; i < getProcessInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionIdIn` to the URL query string
    if (getExecutionIdIn() != null) {
      for (int i = 0; i < getExecutionIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sexecutionIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getExecutionIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionIdIn` to the URL query string
    if (getCaseExecutionIdIn() != null) {
      for (int i = 0; i < getCaseExecutionIdIn().size(); i++) {
        try {
          joiner.add(String.format("%scaseExecutionIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCaseExecutionIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `caseActivityIdIn` to the URL query string
    if (getCaseActivityIdIn() != null) {
      for (int i = 0; i < getCaseActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%scaseActivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCaseActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `taskIdIn` to the URL query string
    if (getTaskIdIn() != null) {
      for (int i = 0; i < getTaskIdIn().size(); i++) {
        try {
          joiner.add(String.format("%staskIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTaskIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `activityInstanceIdIn` to the URL query string
    if (getActivityInstanceIdIn() != null) {
      for (int i = 0; i < getActivityInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableNameIn` to the URL query string
    if (getVariableNameIn() != null) {
      for (int i = 0; i < getVariableNameIn().size(); i++) {
        try {
          joiner.add(String.format("%svariableNameIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getVariableNameIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

