/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * HistoryCleanupConfigurationDto
 */
@JsonPropertyOrder({
  HistoryCleanupConfigurationDto.JSON_PROPERTY_BATCH_WINDOW_START_TIME,
  HistoryCleanupConfigurationDto.JSON_PROPERTY_BATCH_WINDOW_END_TIME,
  HistoryCleanupConfigurationDto.JSON_PROPERTY_ENABLED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class HistoryCleanupConfigurationDto {
  public static final String JSON_PROPERTY_BATCH_WINDOW_START_TIME = "batchWindowStartTime";
  private JsonNullable<OffsetDateTime> batchWindowStartTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_BATCH_WINDOW_END_TIME = "batchWindowEndTime";
  private JsonNullable<OffsetDateTime> batchWindowEndTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private JsonNullable<Boolean> enabled = JsonNullable.<Boolean>undefined();

  public HistoryCleanupConfigurationDto() {
  }

  public HistoryCleanupConfigurationDto batchWindowStartTime(OffsetDateTime batchWindowStartTime) {
    this.batchWindowStartTime = JsonNullable.<OffsetDateTime>of(batchWindowStartTime);
    
    return this;
  }

   /**
   * Start time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return batchWindowStartTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getBatchWindowStartTime() {
        return batchWindowStartTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BATCH_WINDOW_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getBatchWindowStartTime_JsonNullable() {
    return batchWindowStartTime;
  }
  
  @JsonProperty(JSON_PROPERTY_BATCH_WINDOW_START_TIME)
  public void setBatchWindowStartTime_JsonNullable(JsonNullable<OffsetDateTime> batchWindowStartTime) {
    this.batchWindowStartTime = batchWindowStartTime;
  }

  public void setBatchWindowStartTime(OffsetDateTime batchWindowStartTime) {
    this.batchWindowStartTime = JsonNullable.<OffsetDateTime>of(batchWindowStartTime);
  }


  public HistoryCleanupConfigurationDto batchWindowEndTime(OffsetDateTime batchWindowEndTime) {
    this.batchWindowEndTime = JsonNullable.<OffsetDateTime>of(batchWindowEndTime);
    
    return this;
  }

   /**
   * End time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return batchWindowEndTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getBatchWindowEndTime() {
        return batchWindowEndTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BATCH_WINDOW_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getBatchWindowEndTime_JsonNullable() {
    return batchWindowEndTime;
  }
  
  @JsonProperty(JSON_PROPERTY_BATCH_WINDOW_END_TIME)
  public void setBatchWindowEndTime_JsonNullable(JsonNullable<OffsetDateTime> batchWindowEndTime) {
    this.batchWindowEndTime = batchWindowEndTime;
  }

  public void setBatchWindowEndTime(OffsetDateTime batchWindowEndTime) {
    this.batchWindowEndTime = JsonNullable.<OffsetDateTime>of(batchWindowEndTime);
  }


  public HistoryCleanupConfigurationDto enabled(Boolean enabled) {
    this.enabled = JsonNullable.<Boolean>of(enabled);
    
    return this;
  }

   /**
   * Indicates whether the engine node participates in history cleanup or not. The default is &#x60;true&#x60;. Participation can be disabled via [Process Engine Configuration](https://docs.camunda.org/manual/7.21/reference/deployment-descriptors/tags/process-engine/#history-cleanup-enabled).  For more details, see [Cleanup Execution Participation per Node](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#cleanup-execution-participation-per-node).
   * @return enabled
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getEnabled() {
        return enabled.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getEnabled_JsonNullable() {
    return enabled;
  }
  
  @JsonProperty(JSON_PROPERTY_ENABLED)
  public void setEnabled_JsonNullable(JsonNullable<Boolean> enabled) {
    this.enabled = enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = JsonNullable.<Boolean>of(enabled);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryCleanupConfigurationDto historyCleanupConfigurationDto = (HistoryCleanupConfigurationDto) o;
    return equalsNullable(this.batchWindowStartTime, historyCleanupConfigurationDto.batchWindowStartTime) &&
        equalsNullable(this.batchWindowEndTime, historyCleanupConfigurationDto.batchWindowEndTime) &&
        equalsNullable(this.enabled, historyCleanupConfigurationDto.enabled);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(batchWindowStartTime), hashCodeNullable(batchWindowEndTime), hashCodeNullable(enabled));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryCleanupConfigurationDto {\n");
    sb.append("    batchWindowStartTime: ").append(toIndentedString(batchWindowStartTime)).append("\n");
    sb.append("    batchWindowEndTime: ").append(toIndentedString(batchWindowEndTime)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `batchWindowStartTime` to the URL query string
    if (getBatchWindowStartTime() != null) {
      try {
        joiner.add(String.format("%sbatchWindowStartTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchWindowStartTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `batchWindowEndTime` to the URL query string
    if (getBatchWindowEndTime() != null) {
      try {
        joiner.add(String.format("%sbatchWindowEndTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBatchWindowEndTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `enabled` to the URL query string
    if (getEnabled() != null) {
      try {
        joiner.add(String.format("%senabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEnabled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

