/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.IdentityServiceGroupDto;
import org.camunda.community.rest.client.dto.IdentityServiceUserDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * IdentityServiceGroupInfoDto
 */
@JsonPropertyOrder({
  IdentityServiceGroupInfoDto.JSON_PROPERTY_GROUPS,
  IdentityServiceGroupInfoDto.JSON_PROPERTY_GROUP_USERS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class IdentityServiceGroupInfoDto {
  public static final String JSON_PROPERTY_GROUPS = "groups";
  private JsonNullable<List<IdentityServiceGroupDto>> groups = JsonNullable.<List<IdentityServiceGroupDto>>undefined();

  public static final String JSON_PROPERTY_GROUP_USERS = "groupUsers";
  private JsonNullable<List<IdentityServiceUserDto>> groupUsers = JsonNullable.<List<IdentityServiceUserDto>>undefined();

  public IdentityServiceGroupInfoDto() {
  }

  public IdentityServiceGroupInfoDto groups(List<IdentityServiceGroupDto> groups) {
    this.groups = JsonNullable.<List<IdentityServiceGroupDto>>of(groups);
    
    return this;
  }

  public IdentityServiceGroupInfoDto addGroupsItem(IdentityServiceGroupDto groupsItem) {
    if (this.groups == null || !this.groups.isPresent()) {
      this.groups = JsonNullable.<List<IdentityServiceGroupDto>>of(new ArrayList<>());
    }
    try {
      this.groups.get().add(groupsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of group objects.
   * @return groups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<IdentityServiceGroupDto> getGroups() {
        return groups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<IdentityServiceGroupDto>> getGroups_JsonNullable() {
    return groups;
  }
  
  @JsonProperty(JSON_PROPERTY_GROUPS)
  public void setGroups_JsonNullable(JsonNullable<List<IdentityServiceGroupDto>> groups) {
    this.groups = groups;
  }

  public void setGroups(List<IdentityServiceGroupDto> groups) {
    this.groups = JsonNullable.<List<IdentityServiceGroupDto>>of(groups);
  }


  public IdentityServiceGroupInfoDto groupUsers(List<IdentityServiceUserDto> groupUsers) {
    this.groupUsers = JsonNullable.<List<IdentityServiceUserDto>>of(groupUsers);
    
    return this;
  }

  public IdentityServiceGroupInfoDto addGroupUsersItem(IdentityServiceUserDto groupUsersItem) {
    if (this.groupUsers == null || !this.groupUsers.isPresent()) {
      this.groupUsers = JsonNullable.<List<IdentityServiceUserDto>>of(new ArrayList<>());
    }
    try {
      this.groupUsers.get().add(groupUsersItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array that contains all users that are member in one of the groups.
   * @return groupUsers
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<IdentityServiceUserDto> getGroupUsers() {
        return groupUsers.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_GROUP_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<IdentityServiceUserDto>> getGroupUsers_JsonNullable() {
    return groupUsers;
  }
  
  @JsonProperty(JSON_PROPERTY_GROUP_USERS)
  public void setGroupUsers_JsonNullable(JsonNullable<List<IdentityServiceUserDto>> groupUsers) {
    this.groupUsers = groupUsers;
  }

  public void setGroupUsers(List<IdentityServiceUserDto> groupUsers) {
    this.groupUsers = JsonNullable.<List<IdentityServiceUserDto>>of(groupUsers);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IdentityServiceGroupInfoDto identityServiceGroupInfoDto = (IdentityServiceGroupInfoDto) o;
    return equalsNullable(this.groups, identityServiceGroupInfoDto.groups) &&
        equalsNullable(this.groupUsers, identityServiceGroupInfoDto.groupUsers);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(groups), hashCodeNullable(groupUsers));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IdentityServiceGroupInfoDto {\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    groupUsers: ").append(toIndentedString(groupUsers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `groups` to the URL query string
    if (getGroups() != null) {
      for (int i = 0; i < getGroups().size(); i++) {
        if (getGroups().get(i) != null) {
          joiner.add(getGroups().get(i).toUrlQueryString(String.format("%sgroups%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `groupUsers` to the URL query string
    if (getGroupUsers() != null) {
      for (int i = 0; i < getGroupUsers().size(); i++) {
        if (getGroupUsers().get(i) != null) {
          joiner.add(getGroupUsers().get(i).toUrlQueryString(String.format("%sgroupUsers%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

