/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobConditionQueryParameterDto
 */
@JsonPropertyOrder({
  JobConditionQueryParameterDto.JSON_PROPERTY_OPERATOR,
  JobConditionQueryParameterDto.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobConditionQueryParameterDto {
  /**
   * Comparison operator to be used.
   */
  public enum OperatorEnum {
    GT("gt"),
    
    LT("lt");

    private String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_OPERATOR = "operator";
  private JsonNullable<OperatorEnum> operator = JsonNullable.<OperatorEnum>undefined();

  public static final String JSON_PROPERTY_VALUE = "value";
  private JsonNullable<OffsetDateTime> value = JsonNullable.<OffsetDateTime>undefined();

  public JobConditionQueryParameterDto() {
  }

  public JobConditionQueryParameterDto operator(OperatorEnum operator) {
    this.operator = JsonNullable.<OperatorEnum>of(operator);
    
    return this;
  }

   /**
   * Comparison operator to be used.
   * @return operator
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OperatorEnum getOperator() {
        return operator.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OperatorEnum> getOperator_JsonNullable() {
    return operator;
  }
  
  @JsonProperty(JSON_PROPERTY_OPERATOR)
  public void setOperator_JsonNullable(JsonNullable<OperatorEnum> operator) {
    this.operator = operator;
  }

  public void setOperator(OperatorEnum operator) {
    this.operator = JsonNullable.<OperatorEnum>of(operator);
  }


  public JobConditionQueryParameterDto value(OffsetDateTime value) {
    this.value = JsonNullable.<OffsetDateTime>of(value);
    
    return this;
  }

   /**
   * Date value to compare with.
   * @return value
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getValue() {
        return value.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getValue_JsonNullable() {
    return value;
  }
  
  @JsonProperty(JSON_PROPERTY_VALUE)
  public void setValue_JsonNullable(JsonNullable<OffsetDateTime> value) {
    this.value = value;
  }

  public void setValue(OffsetDateTime value) {
    this.value = JsonNullable.<OffsetDateTime>of(value);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobConditionQueryParameterDto jobConditionQueryParameterDto = (JobConditionQueryParameterDto) o;
    return equalsNullable(this.operator, jobConditionQueryParameterDto.operator) &&
        equalsNullable(this.value, jobConditionQueryParameterDto.value);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(operator), hashCodeNullable(value));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobConditionQueryParameterDto {\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `operator` to the URL query string
    if (getOperator() != null) {
      try {
        joiner.add(String.format("%soperator%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOperator()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      try {
        joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

