/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobDefinitionDto
 */
@JsonPropertyOrder({
  JobDefinitionDto.JSON_PROPERTY_ID,
  JobDefinitionDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobDefinitionDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobDefinitionDto.JSON_PROPERTY_ACTIVITY_ID,
  JobDefinitionDto.JSON_PROPERTY_JOB_TYPE,
  JobDefinitionDto.JSON_PROPERTY_JOB_CONFIGURATION,
  JobDefinitionDto.JSON_PROPERTY_OVERRIDING_JOB_PRIORITY,
  JobDefinitionDto.JSON_PROPERTY_SUSPENDED,
  JobDefinitionDto.JSON_PROPERTY_TENANT_ID,
  JobDefinitionDto.JSON_PROPERTY_DEPLOYMENT_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDefinitionDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_TYPE = "jobType";
  private JsonNullable<String> jobType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_CONFIGURATION = "jobConfiguration";
  private JsonNullable<String> jobConfiguration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OVERRIDING_JOB_PRIORITY = "overridingJobPriority";
  private JsonNullable<Long> overridingJobPriority = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEPLOYMENT_ID = "deploymentId";
  private JsonNullable<String> deploymentId = JsonNullable.<String>undefined();

  public JobDefinitionDto() {
  }

  public JobDefinitionDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the job definition.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public JobDefinitionDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition this job definition is associated with.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public JobDefinitionDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The key of the process definition this job definition is associated with.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public JobDefinitionDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * The id of the activity this job definition is associated with.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public JobDefinitionDto jobType(String jobType) {
    this.jobType = JsonNullable.<String>of(jobType);
    
    return this;
  }

   /**
   * The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.
   * @return jobType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobType() {
        return jobType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobType_JsonNullable() {
    return jobType;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_TYPE)
  public void setJobType_JsonNullable(JsonNullable<String> jobType) {
    this.jobType = jobType;
  }

  public void setJobType(String jobType) {
    this.jobType = JsonNullable.<String>of(jobType);
  }


  public JobDefinitionDto jobConfiguration(String jobConfiguration) {
    this.jobConfiguration = JsonNullable.<String>of(jobConfiguration);
    
    return this;
  }

   /**
   * The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.
   * @return jobConfiguration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobConfiguration() {
        return jobConfiguration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobConfiguration_JsonNullable() {
    return jobConfiguration;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_CONFIGURATION)
  public void setJobConfiguration_JsonNullable(JsonNullable<String> jobConfiguration) {
    this.jobConfiguration = jobConfiguration;
  }

  public void setJobConfiguration(String jobConfiguration) {
    this.jobConfiguration = JsonNullable.<String>of(jobConfiguration);
  }


  public JobDefinitionDto overridingJobPriority(Long overridingJobPriority) {
    this.overridingJobPriority = JsonNullable.<Long>of(overridingJobPriority);
    
    return this;
  }

   /**
   * The execution priority defined for jobs that are created based on this definition. May be &#x60;null&#x60; when the priority has not been overridden on the job definition level.
   * @return overridingJobPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getOverridingJobPriority() {
        return overridingJobPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OVERRIDING_JOB_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getOverridingJobPriority_JsonNullable() {
    return overridingJobPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_OVERRIDING_JOB_PRIORITY)
  public void setOverridingJobPriority_JsonNullable(JsonNullable<Long> overridingJobPriority) {
    this.overridingJobPriority = overridingJobPriority;
  }

  public void setOverridingJobPriority(Long overridingJobPriority) {
    this.overridingJobPriority = JsonNullable.<Long>of(overridingJobPriority);
  }


  public JobDefinitionDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Indicates whether this job definition is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public JobDefinitionDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The id of the tenant this job definition is associated with.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public JobDefinitionDto deploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
    
    return this;
  }

   /**
   * The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeploymentId() {
        return deploymentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeploymentId_JsonNullable() {
    return deploymentId;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  public void setDeploymentId_JsonNullable(JsonNullable<String> deploymentId) {
    this.deploymentId = deploymentId;
  }

  public void setDeploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDefinitionDto jobDefinitionDto = (JobDefinitionDto) o;
    return equalsNullable(this.id, jobDefinitionDto.id) &&
        equalsNullable(this.processDefinitionId, jobDefinitionDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, jobDefinitionDto.processDefinitionKey) &&
        equalsNullable(this.activityId, jobDefinitionDto.activityId) &&
        equalsNullable(this.jobType, jobDefinitionDto.jobType) &&
        equalsNullable(this.jobConfiguration, jobDefinitionDto.jobConfiguration) &&
        equalsNullable(this.overridingJobPriority, jobDefinitionDto.overridingJobPriority) &&
        equalsNullable(this.suspended, jobDefinitionDto.suspended) &&
        equalsNullable(this.tenantId, jobDefinitionDto.tenantId) &&
        equalsNullable(this.deploymentId, jobDefinitionDto.deploymentId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(activityId), hashCodeNullable(jobType), hashCodeNullable(jobConfiguration), hashCodeNullable(overridingJobPriority), hashCodeNullable(suspended), hashCodeNullable(tenantId), hashCodeNullable(deploymentId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDefinitionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    jobConfiguration: ").append(toIndentedString(jobConfiguration)).append("\n");
    sb.append("    overridingJobPriority: ").append(toIndentedString(overridingJobPriority)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobType` to the URL query string
    if (getJobType() != null) {
      try {
        joiner.add(String.format("%sjobType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobConfiguration` to the URL query string
    if (getJobConfiguration() != null) {
      try {
        joiner.add(String.format("%sjobConfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `overridingJobPriority` to the URL query string
    if (getOverridingJobPriority() != null) {
      try {
        joiner.add(String.format("%soverridingJobPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOverridingJobPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deploymentId` to the URL query string
    if (getDeploymentId() != null) {
      try {
        joiner.add(String.format("%sdeploymentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeploymentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

