/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobDefinitionPriorityDto
 */
@JsonPropertyOrder({
  JobDefinitionPriorityDto.JSON_PROPERTY_PRIORITY,
  JobDefinitionPriorityDto.JSON_PROPERTY_INCLUDE_JOBS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDefinitionPriorityDto {
  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Long> priority = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_INCLUDE_JOBS = "includeJobs";
  private JsonNullable<Boolean> includeJobs = JsonNullable.<Boolean>undefined();

  public JobDefinitionPriorityDto() {
  }

  public JobDefinitionPriorityDto priority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
    
    return this;
  }

   /**
   * The new execution priority number for jobs of the given definition. The definition&#39;s priority can be reset by using the value &#x60;null&#x60;. In that case, the job definition&#39;s priority no longer applies but a new job&#39;s priority is determined as specified in the process model.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Long> priority) {
    this.priority = priority;
  }

  public void setPriority(Long priority) {
    this.priority = JsonNullable.<Long>of(priority);
  }


  public JobDefinitionPriorityDto includeJobs(Boolean includeJobs) {
    this.includeJobs = JsonNullable.<Boolean>of(includeJobs);
    
    return this;
  }

   /**
   * A boolean value indicating whether existing jobs of the given definition should receive the priority as well. Default value is &#x60;false&#x60;. Can only be &#x60;true&#x60; when the __priority__ parameter is not &#x60;null&#x60;.
   * @return includeJobs
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeJobs() {
        return includeJobs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeJobs_JsonNullable() {
    return includeJobs;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS)
  public void setIncludeJobs_JsonNullable(JsonNullable<Boolean> includeJobs) {
    this.includeJobs = includeJobs;
  }

  public void setIncludeJobs(Boolean includeJobs) {
    this.includeJobs = JsonNullable.<Boolean>of(includeJobs);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDefinitionPriorityDto jobDefinitionPriorityDto = (JobDefinitionPriorityDto) o;
    return equalsNullable(this.priority, jobDefinitionPriorityDto.priority) &&
        equalsNullable(this.includeJobs, jobDefinitionPriorityDto.includeJobs);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(priority), hashCodeNullable(includeJobs));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDefinitionPriorityDto {\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    includeJobs: ").append(toIndentedString(includeJobs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `includeJobs` to the URL query string
    if (getIncludeJobs() != null) {
      try {
        joiner.add(String.format("%sincludeJobs%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeJobs()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

