/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Job definition query which defines a list of Job definitions
 */
@JsonPropertyOrder({
  JobDefinitionQueryDto.JSON_PROPERTY_JOB_DEFINITION_ID,
  JobDefinitionQueryDto.JSON_PROPERTY_ACTIVITY_ID_IN,
  JobDefinitionQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobDefinitionQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobDefinitionQueryDto.JSON_PROPERTY_JOB_TYPE,
  JobDefinitionQueryDto.JSON_PROPERTY_JOB_CONFIGURATION,
  JobDefinitionQueryDto.JSON_PROPERTY_ACTIVE,
  JobDefinitionQueryDto.JSON_PROPERTY_SUSPENDED,
  JobDefinitionQueryDto.JSON_PROPERTY_WITH_OVERRIDING_JOB_PRIORITY,
  JobDefinitionQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  JobDefinitionQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  JobDefinitionQueryDto.JSON_PROPERTY_INCLUDE_JOB_DEFINITIONS_WITHOUT_TENANT_ID,
  JobDefinitionQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDefinitionQueryDto {
  public static final String JSON_PROPERTY_JOB_DEFINITION_ID = "jobDefinitionId";
  private JsonNullable<String> jobDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID_IN = "activityIdIn";
  private JsonNullable<List<String>> activityIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_TYPE = "jobType";
  private JsonNullable<String> jobType = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_CONFIGURATION = "jobConfiguration";
  private JsonNullable<String> jobConfiguration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITH_OVERRIDING_JOB_PRIORITY = "withOverridingJobPriority";
  private JsonNullable<Boolean> withOverridingJobPriority = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INCLUDE_JOB_DEFINITIONS_WITHOUT_TENANT_ID = "includeJobDefinitionsWithoutTenantId";
  private JsonNullable<Boolean> includeJobDefinitionsWithoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<JobDefinitionQueryDtoSortingInner>> sorting = JsonNullable.<List<JobDefinitionQueryDtoSortingInner>>undefined();

  public JobDefinitionQueryDto() {
  }

  public JobDefinitionQueryDto jobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
    
    return this;
  }

   /**
   * Filter by job definition id.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionId() {
        return jobDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionId_JsonNullable() {
    return jobDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  public void setJobDefinitionId_JsonNullable(JsonNullable<String> jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }

  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
  }


  public JobDefinitionQueryDto activityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
    
    return this;
  }

  public JobDefinitionQueryDto addActivityIdInItem(String activityIdInItem) {
    if (this.activityIdIn == null || !this.activityIdIn.isPresent()) {
      this.activityIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityIdIn.get().add(activityIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include job definitions which belong to one of the passed activity ids.
   * @return activityIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityIdIn() {
        return activityIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityIdIn_JsonNullable() {
    return activityIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID_IN)
  public void setActivityIdIn_JsonNullable(JsonNullable<List<String>> activityIdIn) {
    this.activityIdIn = activityIdIn;
  }

  public void setActivityIdIn(List<String> activityIdIn) {
    this.activityIdIn = JsonNullable.<List<String>>of(activityIdIn);
  }


  public JobDefinitionQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Only include job definitions which exist for the given process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public JobDefinitionQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Only include job definitions which exist for the given process definition key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public JobDefinitionQueryDto jobType(String jobType) {
    this.jobType = JsonNullable.<String>of(jobType);
    
    return this;
  }

   /**
   * Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.
   * @return jobType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobType() {
        return jobType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobType_JsonNullable() {
    return jobType;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_TYPE)
  public void setJobType_JsonNullable(JsonNullable<String> jobType) {
    this.jobType = jobType;
  }

  public void setJobType(String jobType) {
    this.jobType = JsonNullable.<String>of(jobType);
  }


  public JobDefinitionQueryDto jobConfiguration(String jobConfiguration) {
    this.jobConfiguration = JsonNullable.<String>of(jobConfiguration);
    
    return this;
  }

   /**
   * Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration.
   * @return jobConfiguration
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobConfiguration() {
        return jobConfiguration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobConfiguration_JsonNullable() {
    return jobConfiguration;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_CONFIGURATION)
  public void setJobConfiguration_JsonNullable(JsonNullable<String> jobConfiguration) {
    this.jobConfiguration = jobConfiguration;
  }

  public void setJobConfiguration(String jobConfiguration) {
    this.jobConfiguration = JsonNullable.<String>of(jobConfiguration);
  }


  public JobDefinitionQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public JobDefinitionQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public JobDefinitionQueryDto withOverridingJobPriority(Boolean withOverridingJobPriority) {
    this.withOverridingJobPriority = JsonNullable.<Boolean>of(withOverridingJobPriority);
    
    return this;
  }

   /**
   * Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied.
   * @return withOverridingJobPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithOverridingJobPriority() {
        return withOverridingJobPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_OVERRIDING_JOB_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithOverridingJobPriority_JsonNullable() {
    return withOverridingJobPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_OVERRIDING_JOB_PRIORITY)
  public void setWithOverridingJobPriority_JsonNullable(JsonNullable<Boolean> withOverridingJobPriority) {
    this.withOverridingJobPriority = withOverridingJobPriority;
  }

  public void setWithOverridingJobPriority(Boolean withOverridingJobPriority) {
    this.withOverridingJobPriority = JsonNullable.<Boolean>of(withOverridingJobPriority);
  }


  public JobDefinitionQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public JobDefinitionQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include job definitions which belong to one of the passed tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public JobDefinitionQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public JobDefinitionQueryDto includeJobDefinitionsWithoutTenantId(Boolean includeJobDefinitionsWithoutTenantId) {
    this.includeJobDefinitionsWithoutTenantId = JsonNullable.<Boolean>of(includeJobDefinitionsWithoutTenantId);
    
    return this;
  }

   /**
   * Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeJobDefinitionsWithoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeJobDefinitionsWithoutTenantId() {
        return includeJobDefinitionsWithoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_JOB_DEFINITIONS_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeJobDefinitionsWithoutTenantId_JsonNullable() {
    return includeJobDefinitionsWithoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_JOB_DEFINITIONS_WITHOUT_TENANT_ID)
  public void setIncludeJobDefinitionsWithoutTenantId_JsonNullable(JsonNullable<Boolean> includeJobDefinitionsWithoutTenantId) {
    this.includeJobDefinitionsWithoutTenantId = includeJobDefinitionsWithoutTenantId;
  }

  public void setIncludeJobDefinitionsWithoutTenantId(Boolean includeJobDefinitionsWithoutTenantId) {
    this.includeJobDefinitionsWithoutTenantId = JsonNullable.<Boolean>of(includeJobDefinitionsWithoutTenantId);
  }


  public JobDefinitionQueryDto sorting(List<JobDefinitionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<JobDefinitionQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public JobDefinitionQueryDto addSortingItem(JobDefinitionQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<JobDefinitionQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for &#x60;count&#x60; endpoints.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<JobDefinitionQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<JobDefinitionQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<JobDefinitionQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<JobDefinitionQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<JobDefinitionQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDefinitionQueryDto jobDefinitionQueryDto = (JobDefinitionQueryDto) o;
    return equalsNullable(this.jobDefinitionId, jobDefinitionQueryDto.jobDefinitionId) &&
        equalsNullable(this.activityIdIn, jobDefinitionQueryDto.activityIdIn) &&
        equalsNullable(this.processDefinitionId, jobDefinitionQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, jobDefinitionQueryDto.processDefinitionKey) &&
        equalsNullable(this.jobType, jobDefinitionQueryDto.jobType) &&
        equalsNullable(this.jobConfiguration, jobDefinitionQueryDto.jobConfiguration) &&
        equalsNullable(this.active, jobDefinitionQueryDto.active) &&
        equalsNullable(this.suspended, jobDefinitionQueryDto.suspended) &&
        equalsNullable(this.withOverridingJobPriority, jobDefinitionQueryDto.withOverridingJobPriority) &&
        equalsNullable(this.tenantIdIn, jobDefinitionQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, jobDefinitionQueryDto.withoutTenantId) &&
        equalsNullable(this.includeJobDefinitionsWithoutTenantId, jobDefinitionQueryDto.includeJobDefinitionsWithoutTenantId) &&
        equalsNullable(this.sorting, jobDefinitionQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(jobDefinitionId), hashCodeNullable(activityIdIn), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(jobType), hashCodeNullable(jobConfiguration), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(withOverridingJobPriority), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(includeJobDefinitionsWithoutTenantId), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDefinitionQueryDto {\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    activityIdIn: ").append(toIndentedString(activityIdIn)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    jobConfiguration: ").append(toIndentedString(jobConfiguration)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    withOverridingJobPriority: ").append(toIndentedString(withOverridingJobPriority)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    includeJobDefinitionsWithoutTenantId: ").append(toIndentedString(includeJobDefinitionsWithoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `jobDefinitionId` to the URL query string
    if (getJobDefinitionId() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityIdIn` to the URL query string
    if (getActivityIdIn() != null) {
      for (int i = 0; i < getActivityIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobType` to the URL query string
    if (getJobType() != null) {
      try {
        joiner.add(String.format("%sjobType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobConfiguration` to the URL query string
    if (getJobConfiguration() != null) {
      try {
        joiner.add(String.format("%sjobConfiguration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobConfiguration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withOverridingJobPriority` to the URL query string
    if (getWithOverridingJobPriority() != null) {
      try {
        joiner.add(String.format("%swithOverridingJobPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithOverridingJobPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `includeJobDefinitionsWithoutTenantId` to the URL query string
    if (getIncludeJobDefinitionsWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%sincludeJobDefinitionsWithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeJobDefinitionsWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

