/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobDefinitionsSuspensionStateDto
 */
@JsonPropertyOrder({
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_INCLUDE_JOBS,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_EXECUTION_DATE,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_SUSPENDED,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_PROCESS_DEFINITION_TENANT_ID,
  JobDefinitionsSuspensionStateDto.JSON_PROPERTY_PROCESS_DEFINITION_WITHOUT_TENANT_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDefinitionsSuspensionStateDto {
  public static final String JSON_PROPERTY_INCLUDE_JOBS = "includeJobs";
  private JsonNullable<Boolean> includeJobs = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
  private JsonNullable<String> executionDate = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
  private JsonNullable<String> processDefinitionTenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_WITHOUT_TENANT_ID = "processDefinitionWithoutTenantId";
  private JsonNullable<Boolean> processDefinitionWithoutTenantId = JsonNullable.<Boolean>undefined();

  public JobDefinitionsSuspensionStateDto() {
  }

  public JobDefinitionsSuspensionStateDto includeJobs(Boolean includeJobs) {
    this.includeJobs = JsonNullable.<Boolean>of(includeJobs);
    
    return this;
  }

   /**
   * A &#x60;Boolean&#x60; value which indicates whether to activate or suspend also all jobs of the referenced job definitions. When the value is set to &#x60;true&#x60;, all jobs of the provided job definitions will be activated or suspended and when the value is set to &#x60;false&#x60;, the suspension state of all jobs of the provided job definitions will not be updated.
   * @return includeJobs
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeJobs() {
        return includeJobs.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeJobs_JsonNullable() {
    return includeJobs;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS)
  public void setIncludeJobs_JsonNullable(JsonNullable<Boolean> includeJobs) {
    this.includeJobs = includeJobs;
  }

  public void setIncludeJobs(Boolean includeJobs) {
    this.includeJobs = JsonNullable.<Boolean>of(includeJobs);
  }


  public JobDefinitionsSuspensionStateDto executionDate(String executionDate) {
    this.executionDate = JsonNullable.<String>of(executionDate);
    
    return this;
  }

   /**
   * The date on which the referenced job definitions will be activated or suspended. If null, the suspension state of the given job definitions is updated immediately. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM- dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executionDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionDate() {
        return executionDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionDate_JsonNullable() {
    return executionDate;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_DATE)
  public void setExecutionDate_JsonNullable(JsonNullable<String> executionDate) {
    this.executionDate = executionDate;
  }

  public void setExecutionDate(String executionDate) {
    this.executionDate = JsonNullable.<String>of(executionDate);
  }


  public JobDefinitionsSuspensionStateDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public JobDefinitionsSuspensionStateDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The process definition id of the job definitions to activate or suspend.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public JobDefinitionsSuspensionStateDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * The process definition key of the job definitions to activate or suspend.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public JobDefinitionsSuspensionStateDto processDefinitionTenantId(String processDefinitionTenantId) {
    this.processDefinitionTenantId = JsonNullable.<String>of(processDefinitionTenantId);
    
    return this;
  }

   /**
   * Only activate or suspend job definitions of a process definition which belongs to a tenant with the given id.  Note that this parameter will only be considered  in combination with &#x60;processDefinitionKey&#x60;.
   * @return processDefinitionTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionTenantId() {
        return processDefinitionTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionTenantId_JsonNullable() {
    return processDefinitionTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_TENANT_ID)
  public void setProcessDefinitionTenantId_JsonNullable(JsonNullable<String> processDefinitionTenantId) {
    this.processDefinitionTenantId = processDefinitionTenantId;
  }

  public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
    this.processDefinitionTenantId = JsonNullable.<String>of(processDefinitionTenantId);
  }


  public JobDefinitionsSuspensionStateDto processDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
    this.processDefinitionWithoutTenantId = JsonNullable.<Boolean>of(processDefinitionWithoutTenantId);
    
    return this;
  }

   /**
   * Only activate or suspend job definitions of a process definition which belongs to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.  Note that this parameter will only be considered  in combination with &#x60;processDefinitionKey&#x60;.
   * @return processDefinitionWithoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getProcessDefinitionWithoutTenantId() {
        return processDefinitionWithoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getProcessDefinitionWithoutTenantId_JsonNullable() {
    return processDefinitionWithoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_WITHOUT_TENANT_ID)
  public void setProcessDefinitionWithoutTenantId_JsonNullable(JsonNullable<Boolean> processDefinitionWithoutTenantId) {
    this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
  }

  public void setProcessDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
    this.processDefinitionWithoutTenantId = JsonNullable.<Boolean>of(processDefinitionWithoutTenantId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto = (JobDefinitionsSuspensionStateDto) o;
    return equalsNullable(this.includeJobs, jobDefinitionsSuspensionStateDto.includeJobs) &&
        equalsNullable(this.executionDate, jobDefinitionsSuspensionStateDto.executionDate) &&
        equalsNullable(this.suspended, jobDefinitionsSuspensionStateDto.suspended) &&
        equalsNullable(this.processDefinitionId, jobDefinitionsSuspensionStateDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, jobDefinitionsSuspensionStateDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionTenantId, jobDefinitionsSuspensionStateDto.processDefinitionTenantId) &&
        equalsNullable(this.processDefinitionWithoutTenantId, jobDefinitionsSuspensionStateDto.processDefinitionWithoutTenantId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(includeJobs), hashCodeNullable(executionDate), hashCodeNullable(suspended), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionTenantId), hashCodeNullable(processDefinitionWithoutTenantId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDefinitionsSuspensionStateDto {\n");
    sb.append("    includeJobs: ").append(toIndentedString(includeJobs)).append("\n");
    sb.append("    executionDate: ").append(toIndentedString(executionDate)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionTenantId: ").append(toIndentedString(processDefinitionTenantId)).append("\n");
    sb.append("    processDefinitionWithoutTenantId: ").append(toIndentedString(processDefinitionWithoutTenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `includeJobs` to the URL query string
    if (getIncludeJobs() != null) {
      try {
        joiner.add(String.format("%sincludeJobs%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeJobs()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionDate` to the URL query string
    if (getExecutionDate() != null) {
      try {
        joiner.add(String.format("%sexecutionDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionTenantId` to the URL query string
    if (getProcessDefinitionTenantId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionWithoutTenantId` to the URL query string
    if (getProcessDefinitionWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionWithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

