/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobDuedateDto
 */
@JsonPropertyOrder({
  JobDuedateDto.JSON_PROPERTY_DUEDATE,
  JobDuedateDto.JSON_PROPERTY_CASCADE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobDuedateDto {
  public static final String JSON_PROPERTY_DUEDATE = "duedate";
  private JsonNullable<OffsetDateTime> duedate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CASCADE = "cascade";
  private JsonNullable<Boolean> cascade = JsonNullable.<Boolean>undefined();

  public JobDuedateDto() {
  }

  public JobDuedateDto duedate(OffsetDateTime duedate) {
    this.duedate = JsonNullable.<OffsetDateTime>of(duedate);
    
    return this;
  }

   /**
   * The date to set when the job has the next execution.
   * @return duedate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDuedate() {
        return duedate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUEDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDuedate_JsonNullable() {
    return duedate;
  }
  
  @JsonProperty(JSON_PROPERTY_DUEDATE)
  public void setDuedate_JsonNullable(JsonNullable<OffsetDateTime> duedate) {
    this.duedate = duedate;
  }

  public void setDuedate(OffsetDateTime duedate) {
    this.duedate = JsonNullable.<OffsetDateTime>of(duedate);
  }


  public JobDuedateDto cascade(Boolean cascade) {
    this.cascade = JsonNullable.<Boolean>of(cascade);
    
    return this;
  }

   /**
   * A boolean value to indicate if modifications to the due date should cascade to subsequent jobs. (e.g. Modify the due date of a timer by +15 minutes. This flag indicates if a +15 minutes should be applied to all subsequent timers.) This flag only affects timer jobs and only works if due date is not null. Default: &#x60;false&#x60;
   * @return cascade
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCascade() {
        return cascade.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASCADE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCascade_JsonNullable() {
    return cascade;
  }
  
  @JsonProperty(JSON_PROPERTY_CASCADE)
  public void setCascade_JsonNullable(JsonNullable<Boolean> cascade) {
    this.cascade = cascade;
  }

  public void setCascade(Boolean cascade) {
    this.cascade = JsonNullable.<Boolean>of(cascade);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDuedateDto jobDuedateDto = (JobDuedateDto) o;
    return equalsNullable(this.duedate, jobDuedateDto.duedate) &&
        equalsNullable(this.cascade, jobDuedateDto.cascade);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(duedate), hashCodeNullable(cascade));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDuedateDto {\n");
    sb.append("    duedate: ").append(toIndentedString(duedate)).append("\n");
    sb.append("    cascade: ").append(toIndentedString(cascade)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `duedate` to the URL query string
    if (getDuedate() != null) {
      try {
        joiner.add(String.format("%sduedate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDuedate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cascade` to the URL query string
    if (getCascade() != null) {
      try {
        joiner.add(String.format("%scascade%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCascade()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

