/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.JobConditionQueryParameterDto;
import org.camunda.community.rest.client.dto.JobQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Job instance query which defines a list of Job instances
 */
@JsonPropertyOrder({
  JobQueryDto.JSON_PROPERTY_JOB_ID,
  JobQueryDto.JSON_PROPERTY_JOB_IDS,
  JobQueryDto.JSON_PROPERTY_JOB_DEFINITION_ID,
  JobQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  JobQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_IDS,
  JobQueryDto.JSON_PROPERTY_EXECUTION_ID,
  JobQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobQueryDto.JSON_PROPERTY_ACTIVITY_ID,
  JobQueryDto.JSON_PROPERTY_WITH_RETRIES_LEFT,
  JobQueryDto.JSON_PROPERTY_EXECUTABLE,
  JobQueryDto.JSON_PROPERTY_TIMERS,
  JobQueryDto.JSON_PROPERTY_MESSAGES,
  JobQueryDto.JSON_PROPERTY_DUE_DATES,
  JobQueryDto.JSON_PROPERTY_CREATE_TIMES,
  JobQueryDto.JSON_PROPERTY_WITH_EXCEPTION,
  JobQueryDto.JSON_PROPERTY_EXCEPTION_MESSAGE,
  JobQueryDto.JSON_PROPERTY_FAILED_ACTIVITY_ID,
  JobQueryDto.JSON_PROPERTY_NO_RETRIES_LEFT,
  JobQueryDto.JSON_PROPERTY_ACTIVE,
  JobQueryDto.JSON_PROPERTY_SUSPENDED,
  JobQueryDto.JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS,
  JobQueryDto.JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS,
  JobQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  JobQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  JobQueryDto.JSON_PROPERTY_INCLUDE_JOBS_WITHOUT_TENANT_ID,
  JobQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class JobQueryDto {
  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  private JsonNullable<String> jobId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_JOB_IDS = "jobIds";
  private JsonNullable<List<String>> jobIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_JOB_DEFINITION_ID = "jobDefinitionId";
  private JsonNullable<String> jobDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_IDS = "processInstanceIds";
  private JsonNullable<List<String>> processInstanceIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITH_RETRIES_LEFT = "withRetriesLeft";
  private JsonNullable<Boolean> withRetriesLeft = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXECUTABLE = "executable";
  private JsonNullable<Boolean> executable = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TIMERS = "timers";
  private JsonNullable<Boolean> timers = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_MESSAGES = "messages";
  private JsonNullable<Boolean> messages = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_DUE_DATES = "dueDates";
  private JsonNullable<List<JobConditionQueryParameterDto>> dueDates = JsonNullable.<List<JobConditionQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_CREATE_TIMES = "createTimes";
  private JsonNullable<List<JobConditionQueryParameterDto>> createTimes = JsonNullable.<List<JobConditionQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_WITH_EXCEPTION = "withException";
  private JsonNullable<Boolean> withException = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_EXCEPTION_MESSAGE = "exceptionMessage";
  private JsonNullable<String> exceptionMessage = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FAILED_ACTIVITY_ID = "failedActivityId";
  private JsonNullable<String> failedActivityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NO_RETRIES_LEFT = "noRetriesLeft";
  private JsonNullable<Boolean> noRetriesLeft = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
  private JsonNullable<Long> priorityLowerThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
  private JsonNullable<Long> priorityHigherThanOrEquals = JsonNullable.<Long>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INCLUDE_JOBS_WITHOUT_TENANT_ID = "includeJobsWithoutTenantId";
  private JsonNullable<Boolean> includeJobsWithoutTenantId = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<JobQueryDtoSortingInner>> sorting = JsonNullable.<List<JobQueryDtoSortingInner>>undefined();

  public JobQueryDto() {
  }

  public JobQueryDto jobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
    
    return this;
  }

   /**
   * Filter by job id.
   * @return jobId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobId() {
        return jobId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobId_JsonNullable() {
    return jobId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_ID)
  public void setJobId_JsonNullable(JsonNullable<String> jobId) {
    this.jobId = jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = JsonNullable.<String>of(jobId);
  }


  public JobQueryDto jobIds(List<String> jobIds) {
    this.jobIds = JsonNullable.<List<String>>of(jobIds);
    
    return this;
  }

  public JobQueryDto addJobIdsItem(String jobIdsItem) {
    if (this.jobIds == null || !this.jobIds.isPresent()) {
      this.jobIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.jobIds.get().add(jobIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Filter by a  list of job ids.
   * @return jobIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getJobIds() {
        return jobIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getJobIds_JsonNullable() {
    return jobIds;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_IDS)
  public void setJobIds_JsonNullable(JsonNullable<List<String>> jobIds) {
    this.jobIds = jobIds;
  }

  public void setJobIds(List<String> jobIds) {
    this.jobIds = JsonNullable.<List<String>>of(jobIds);
  }


  public JobQueryDto jobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
    
    return this;
  }

   /**
   * Only select jobs which exist for the given job definition.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getJobDefinitionId() {
        return jobDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getJobDefinitionId_JsonNullable() {
    return jobDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_DEFINITION_ID)
  public void setJobDefinitionId_JsonNullable(JsonNullable<String> jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }

  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = JsonNullable.<String>of(jobDefinitionId);
  }


  public JobQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Only select jobs which exist for the given process instance.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public JobQueryDto processInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
    
    return this;
  }

  public JobQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
    if (this.processInstanceIds == null || !this.processInstanceIds.isPresent()) {
      this.processInstanceIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIds.get().add(processInstanceIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only select jobs which exist for the given  list of process instance ids.
   * @return processInstanceIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIds() {
        return processInstanceIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIds_JsonNullable() {
    return processInstanceIds;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_IDS)
  public void setProcessInstanceIds_JsonNullable(JsonNullable<List<String>> processInstanceIds) {
    this.processInstanceIds = processInstanceIds;
  }

  public void setProcessInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = JsonNullable.<List<String>>of(processInstanceIds);
  }


  public JobQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Only select jobs which exist for the given execution.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public JobQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Filter by the id of the process definition the jobs run on.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public JobQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Filter by the key of the process definition the jobs run on.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public JobQueryDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * Only select jobs which exist for an activity with the given id.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public JobQueryDto withRetriesLeft(Boolean withRetriesLeft) {
    this.withRetriesLeft = JsonNullable.<Boolean>of(withRetriesLeft);
    
    return this;
  }

   /**
   * Only select jobs which have retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withRetriesLeft
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithRetriesLeft() {
        return withRetriesLeft.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithRetriesLeft_JsonNullable() {
    return withRetriesLeft;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_RETRIES_LEFT)
  public void setWithRetriesLeft_JsonNullable(JsonNullable<Boolean> withRetriesLeft) {
    this.withRetriesLeft = withRetriesLeft;
  }

  public void setWithRetriesLeft(Boolean withRetriesLeft) {
    this.withRetriesLeft = JsonNullable.<Boolean>of(withRetriesLeft);
  }


  public JobQueryDto executable(Boolean executable) {
    this.executable = JsonNullable.<Boolean>of(executable);
    
    return this;
  }

   /**
   * Only select jobs which are executable, i.e., retries &gt; 0 and due date is &#x60;null&#x60; or due date is in the past. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return executable
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getExecutable() {
        return executable.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getExecutable_JsonNullable() {
    return executable;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTABLE)
  public void setExecutable_JsonNullable(JsonNullable<Boolean> executable) {
    this.executable = executable;
  }

  public void setExecutable(Boolean executable) {
    this.executable = JsonNullable.<Boolean>of(executable);
  }


  public JobQueryDto timers(Boolean timers) {
    this.timers = JsonNullable.<Boolean>of(timers);
    
    return this;
  }

   /**
   * Only select jobs that are timers. Cannot be used together with &#x60;messages&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return timers
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getTimers() {
        return timers.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TIMERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getTimers_JsonNullable() {
    return timers;
  }
  
  @JsonProperty(JSON_PROPERTY_TIMERS)
  public void setTimers_JsonNullable(JsonNullable<Boolean> timers) {
    this.timers = timers;
  }

  public void setTimers(Boolean timers) {
    this.timers = JsonNullable.<Boolean>of(timers);
  }


  public JobQueryDto messages(Boolean messages) {
    this.messages = JsonNullable.<Boolean>of(messages);
    
    return this;
  }

   /**
   * Only select jobs that are messages. Cannot be used together with &#x60;timers&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return messages
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getMessages() {
        return messages.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MESSAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getMessages_JsonNullable() {
    return messages;
  }
  
  @JsonProperty(JSON_PROPERTY_MESSAGES)
  public void setMessages_JsonNullable(JsonNullable<Boolean> messages) {
    this.messages = messages;
  }

  public void setMessages(Boolean messages) {
    this.messages = JsonNullable.<Boolean>of(messages);
  }


  public JobQueryDto dueDates(List<JobConditionQueryParameterDto> dueDates) {
    this.dueDates = JsonNullable.<List<JobConditionQueryParameterDto>>of(dueDates);
    
    return this;
  }

  public JobQueryDto addDueDatesItem(JobConditionQueryParameterDto dueDatesItem) {
    if (this.dueDates == null || !this.dueDates.isPresent()) {
      this.dueDates = JsonNullable.<List<JobConditionQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.dueDates.get().add(dueDatesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only select jobs where the due date is lower or higher than the given date. 
   * @return dueDates
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<JobConditionQueryParameterDto> getDueDates() {
        return dueDates.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<JobConditionQueryParameterDto>> getDueDates_JsonNullable() {
    return dueDates;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_DATES)
  public void setDueDates_JsonNullable(JsonNullable<List<JobConditionQueryParameterDto>> dueDates) {
    this.dueDates = dueDates;
  }

  public void setDueDates(List<JobConditionQueryParameterDto> dueDates) {
    this.dueDates = JsonNullable.<List<JobConditionQueryParameterDto>>of(dueDates);
  }


  public JobQueryDto createTimes(List<JobConditionQueryParameterDto> createTimes) {
    this.createTimes = JsonNullable.<List<JobConditionQueryParameterDto>>of(createTimes);
    
    return this;
  }

  public JobQueryDto addCreateTimesItem(JobConditionQueryParameterDto createTimesItem) {
    if (this.createTimes == null || !this.createTimes.isPresent()) {
      this.createTimes = JsonNullable.<List<JobConditionQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.createTimes.get().add(createTimesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only select jobs created before or after the given date. 
   * @return createTimes
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<JobConditionQueryParameterDto> getCreateTimes() {
        return createTimes.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATE_TIMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<JobConditionQueryParameterDto>> getCreateTimes_JsonNullable() {
    return createTimes;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATE_TIMES)
  public void setCreateTimes_JsonNullable(JsonNullable<List<JobConditionQueryParameterDto>> createTimes) {
    this.createTimes = createTimes;
  }

  public void setCreateTimes(List<JobConditionQueryParameterDto> createTimes) {
    this.createTimes = JsonNullable.<List<JobConditionQueryParameterDto>>of(createTimes);
  }


  public JobQueryDto withException(Boolean withException) {
    this.withException = JsonNullable.<Boolean>of(withException);
    
    return this;
  }

   /**
   * Only select jobs that failed due to an exception. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withException
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithException() {
        return withException.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithException_JsonNullable() {
    return withException;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_EXCEPTION)
  public void setWithException_JsonNullable(JsonNullable<Boolean> withException) {
    this.withException = withException;
  }

  public void setWithException(Boolean withException) {
    this.withException = JsonNullable.<Boolean>of(withException);
  }


  public JobQueryDto exceptionMessage(String exceptionMessage) {
    this.exceptionMessage = JsonNullable.<String>of(exceptionMessage);
    
    return this;
  }

   /**
   * Only select jobs that failed due to an exception with the given message.
   * @return exceptionMessage
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExceptionMessage() {
        return exceptionMessage.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXCEPTION_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExceptionMessage_JsonNullable() {
    return exceptionMessage;
  }
  
  @JsonProperty(JSON_PROPERTY_EXCEPTION_MESSAGE)
  public void setExceptionMessage_JsonNullable(JsonNullable<String> exceptionMessage) {
    this.exceptionMessage = exceptionMessage;
  }

  public void setExceptionMessage(String exceptionMessage) {
    this.exceptionMessage = JsonNullable.<String>of(exceptionMessage);
  }


  public JobQueryDto failedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
    
    return this;
  }

   /**
   * Only select jobs that failed due to an exception at an activity with the given id.
   * @return failedActivityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFailedActivityId() {
        return failedActivityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFailedActivityId_JsonNullable() {
    return failedActivityId;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILED_ACTIVITY_ID)
  public void setFailedActivityId_JsonNullable(JsonNullable<String> failedActivityId) {
    this.failedActivityId = failedActivityId;
  }

  public void setFailedActivityId(String failedActivityId) {
    this.failedActivityId = JsonNullable.<String>of(failedActivityId);
  }


  public JobQueryDto noRetriesLeft(Boolean noRetriesLeft) {
    this.noRetriesLeft = JsonNullable.<Boolean>of(noRetriesLeft);
    
    return this;
  }

   /**
   * Only select jobs which have no retries left. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return noRetriesLeft
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getNoRetriesLeft() {
        return noRetriesLeft.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NO_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getNoRetriesLeft_JsonNullable() {
    return noRetriesLeft;
  }
  
  @JsonProperty(JSON_PROPERTY_NO_RETRIES_LEFT)
  public void setNoRetriesLeft_JsonNullable(JsonNullable<Boolean> noRetriesLeft) {
    this.noRetriesLeft = noRetriesLeft;
  }

  public void setNoRetriesLeft(Boolean noRetriesLeft) {
    this.noRetriesLeft = JsonNullable.<Boolean>of(noRetriesLeft);
  }


  public JobQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Only include active jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public JobQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Only include suspended jobs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public JobQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
    
    return this;
  }

   /**
   * Only include jobs with a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityLowerThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityLowerThanOrEquals() {
        return priorityLowerThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityLowerThanOrEquals_JsonNullable() {
    return priorityLowerThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_LOWER_THAN_OR_EQUALS)
  public void setPriorityLowerThanOrEquals_JsonNullable(JsonNullable<Long> priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
  }

  public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
    this.priorityLowerThanOrEquals = JsonNullable.<Long>of(priorityLowerThanOrEquals);
  }


  public JobQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
    
    return this;
  }

   /**
   * Only include jobs with a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value.
   * @return priorityHigherThanOrEquals
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Long getPriorityHigherThanOrEquals() {
        return priorityHigherThanOrEquals.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Long> getPriorityHigherThanOrEquals_JsonNullable() {
    return priorityHigherThanOrEquals;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY_HIGHER_THAN_OR_EQUALS)
  public void setPriorityHigherThanOrEquals_JsonNullable(JsonNullable<Long> priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
  }

  public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
    this.priorityHigherThanOrEquals = JsonNullable.<Long>of(priorityHigherThanOrEquals);
  }


  public JobQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public JobQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include jobs which belong to one of the passed  tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public JobQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include jobs which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public JobQueryDto includeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
    this.includeJobsWithoutTenantId = JsonNullable.<Boolean>of(includeJobsWithoutTenantId);
    
    return this;
  }

   /**
   * Include jobs which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeJobsWithoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeJobsWithoutTenantId() {
        return includeJobsWithoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeJobsWithoutTenantId_JsonNullable() {
    return includeJobsWithoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_JOBS_WITHOUT_TENANT_ID)
  public void setIncludeJobsWithoutTenantId_JsonNullable(JsonNullable<Boolean> includeJobsWithoutTenantId) {
    this.includeJobsWithoutTenantId = includeJobsWithoutTenantId;
  }

  public void setIncludeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
    this.includeJobsWithoutTenantId = JsonNullable.<Boolean>of(includeJobsWithoutTenantId);
  }


  public JobQueryDto sorting(List<JobQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<JobQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public JobQueryDto addSortingItem(JobQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<JobQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Does not have an effect for the &#x60;count&#x60; endpoint.
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<JobQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<JobQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<JobQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<JobQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<JobQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobQueryDto jobQueryDto = (JobQueryDto) o;
    return equalsNullable(this.jobId, jobQueryDto.jobId) &&
        equalsNullable(this.jobIds, jobQueryDto.jobIds) &&
        equalsNullable(this.jobDefinitionId, jobQueryDto.jobDefinitionId) &&
        equalsNullable(this.processInstanceId, jobQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIds, jobQueryDto.processInstanceIds) &&
        equalsNullable(this.executionId, jobQueryDto.executionId) &&
        equalsNullable(this.processDefinitionId, jobQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, jobQueryDto.processDefinitionKey) &&
        equalsNullable(this.activityId, jobQueryDto.activityId) &&
        equalsNullable(this.withRetriesLeft, jobQueryDto.withRetriesLeft) &&
        equalsNullable(this.executable, jobQueryDto.executable) &&
        equalsNullable(this.timers, jobQueryDto.timers) &&
        equalsNullable(this.messages, jobQueryDto.messages) &&
        equalsNullable(this.dueDates, jobQueryDto.dueDates) &&
        equalsNullable(this.createTimes, jobQueryDto.createTimes) &&
        equalsNullable(this.withException, jobQueryDto.withException) &&
        equalsNullable(this.exceptionMessage, jobQueryDto.exceptionMessage) &&
        equalsNullable(this.failedActivityId, jobQueryDto.failedActivityId) &&
        equalsNullable(this.noRetriesLeft, jobQueryDto.noRetriesLeft) &&
        equalsNullable(this.active, jobQueryDto.active) &&
        equalsNullable(this.suspended, jobQueryDto.suspended) &&
        equalsNullable(this.priorityLowerThanOrEquals, jobQueryDto.priorityLowerThanOrEquals) &&
        equalsNullable(this.priorityHigherThanOrEquals, jobQueryDto.priorityHigherThanOrEquals) &&
        equalsNullable(this.tenantIdIn, jobQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, jobQueryDto.withoutTenantId) &&
        equalsNullable(this.includeJobsWithoutTenantId, jobQueryDto.includeJobsWithoutTenantId) &&
        equalsNullable(this.sorting, jobQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(jobId), hashCodeNullable(jobIds), hashCodeNullable(jobDefinitionId), hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIds), hashCodeNullable(executionId), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(activityId), hashCodeNullable(withRetriesLeft), hashCodeNullable(executable), hashCodeNullable(timers), hashCodeNullable(messages), hashCodeNullable(dueDates), hashCodeNullable(createTimes), hashCodeNullable(withException), hashCodeNullable(exceptionMessage), hashCodeNullable(failedActivityId), hashCodeNullable(noRetriesLeft), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(priorityLowerThanOrEquals), hashCodeNullable(priorityHigherThanOrEquals), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(includeJobsWithoutTenantId), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobQueryDto {\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobIds: ").append(toIndentedString(jobIds)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIds: ").append(toIndentedString(processInstanceIds)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    withRetriesLeft: ").append(toIndentedString(withRetriesLeft)).append("\n");
    sb.append("    executable: ").append(toIndentedString(executable)).append("\n");
    sb.append("    timers: ").append(toIndentedString(timers)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    dueDates: ").append(toIndentedString(dueDates)).append("\n");
    sb.append("    createTimes: ").append(toIndentedString(createTimes)).append("\n");
    sb.append("    withException: ").append(toIndentedString(withException)).append("\n");
    sb.append("    exceptionMessage: ").append(toIndentedString(exceptionMessage)).append("\n");
    sb.append("    failedActivityId: ").append(toIndentedString(failedActivityId)).append("\n");
    sb.append("    noRetriesLeft: ").append(toIndentedString(noRetriesLeft)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    priorityLowerThanOrEquals: ").append(toIndentedString(priorityLowerThanOrEquals)).append("\n");
    sb.append("    priorityHigherThanOrEquals: ").append(toIndentedString(priorityHigherThanOrEquals)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    includeJobsWithoutTenantId: ").append(toIndentedString(includeJobsWithoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `jobId` to the URL query string
    if (getJobId() != null) {
      try {
        joiner.add(String.format("%sjobId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobIds` to the URL query string
    if (getJobIds() != null) {
      for (int i = 0; i < getJobIds().size(); i++) {
        try {
          joiner.add(String.format("%sjobIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getJobIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `jobDefinitionId` to the URL query string
    if (getJobDefinitionId() != null) {
      try {
        joiner.add(String.format("%sjobDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIds` to the URL query string
    if (getProcessInstanceIds() != null) {
      for (int i = 0; i < getProcessInstanceIds().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withRetriesLeft` to the URL query string
    if (getWithRetriesLeft() != null) {
      try {
        joiner.add(String.format("%swithRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executable` to the URL query string
    if (getExecutable() != null) {
      try {
        joiner.add(String.format("%sexecutable%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutable()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timers` to the URL query string
    if (getTimers() != null) {
      try {
        joiner.add(String.format("%stimers%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimers()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `messages` to the URL query string
    if (getMessages() != null) {
      try {
        joiner.add(String.format("%smessages%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessages()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueDates` to the URL query string
    if (getDueDates() != null) {
      for (int i = 0; i < getDueDates().size(); i++) {
        if (getDueDates().get(i) != null) {
          joiner.add(getDueDates().get(i).toUrlQueryString(String.format("%sdueDates%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `createTimes` to the URL query string
    if (getCreateTimes() != null) {
      for (int i = 0; i < getCreateTimes().size(); i++) {
        if (getCreateTimes().get(i) != null) {
          joiner.add(getCreateTimes().get(i).toUrlQueryString(String.format("%screateTimes%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `withException` to the URL query string
    if (getWithException() != null) {
      try {
        joiner.add(String.format("%swithException%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithException()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `exceptionMessage` to the URL query string
    if (getExceptionMessage() != null) {
      try {
        joiner.add(String.format("%sexceptionMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExceptionMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `failedActivityId` to the URL query string
    if (getFailedActivityId() != null) {
      try {
        joiner.add(String.format("%sfailedActivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFailedActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `noRetriesLeft` to the URL query string
    if (getNoRetriesLeft() != null) {
      try {
        joiner.add(String.format("%snoRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNoRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityLowerThanOrEquals` to the URL query string
    if (getPriorityLowerThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityLowerThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityLowerThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priorityHigherThanOrEquals` to the URL query string
    if (getPriorityHigherThanOrEquals() != null) {
      try {
        joiner.add(String.format("%spriorityHigherThanOrEquals%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriorityHigherThanOrEquals()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `includeJobsWithoutTenantId` to the URL query string
    if (getIncludeJobsWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%sincludeJobsWithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeJobsWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

