/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * The &#x60;processInstance&#x60; property only has a value if the resultType is set to &#x60;ProcessDefinition&#x60;. The processInstance with the properties as described in the [get single instance](https://docs.camunda.org/manual/7.21/reference/rest/process-instance/get/) method.  The &#x60;execution&#x60; property only has a value if the resultType is set to &#x60;Execution&#x60;. The execution with the properties as described in the [get single execution](https://docs.camunda.org/manual/7.21/reference/rest/execution/get/) method.
 */
@JsonPropertyOrder({
  MessageCorrelationResultWithVariableDto.JSON_PROPERTY_RESULT_TYPE,
  MessageCorrelationResultWithVariableDto.JSON_PROPERTY_PROCESS_INSTANCE,
  MessageCorrelationResultWithVariableDto.JSON_PROPERTY_EXECUTION,
  MessageCorrelationResultWithVariableDto.JSON_PROPERTY_VARIABLES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MessageCorrelationResultWithVariableDto {
  /**
   * Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  &#x60;ProcessDefinition&#x60; and otherwise &#x60;Execution&#x60;.
   */
  public enum ResultTypeEnum {
    EXECUTION("Execution"),
    
    PROCESSDEFINITION("ProcessDefinition");

    private String value;

    ResultTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResultTypeEnum fromValue(String value) {
      for (ResultTypeEnum b : ResultTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_RESULT_TYPE = "resultType";
  private JsonNullable<ResultTypeEnum> resultType = JsonNullable.<ResultTypeEnum>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE = "processInstance";
  private ProcessInstanceDto processInstance;

  public static final String JSON_PROPERTY_EXECUTION = "execution";
  private ExecutionDto execution;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public MessageCorrelationResultWithVariableDto() {
  }

  public MessageCorrelationResultWithVariableDto resultType(ResultTypeEnum resultType) {
    this.resultType = JsonNullable.<ResultTypeEnum>of(resultType);
    
    return this;
  }

   /**
   * Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  &#x60;ProcessDefinition&#x60; and otherwise &#x60;Execution&#x60;.
   * @return resultType
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public ResultTypeEnum getResultType() {
        return resultType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESULT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<ResultTypeEnum> getResultType_JsonNullable() {
    return resultType;
  }
  
  @JsonProperty(JSON_PROPERTY_RESULT_TYPE)
  public void setResultType_JsonNullable(JsonNullable<ResultTypeEnum> resultType) {
    this.resultType = resultType;
  }

  public void setResultType(ResultTypeEnum resultType) {
    this.resultType = JsonNullable.<ResultTypeEnum>of(resultType);
  }


  public MessageCorrelationResultWithVariableDto processInstance(ProcessInstanceDto processInstance) {
    
    this.processInstance = processInstance;
    return this;
  }

   /**
   * Get processInstance
   * @return processInstance
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceDto getProcessInstance() {
    return processInstance;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstance(ProcessInstanceDto processInstance) {
    this.processInstance = processInstance;
  }


  public MessageCorrelationResultWithVariableDto execution(ExecutionDto execution) {
    
    this.execution = execution;
    return this;
  }

   /**
   * Get execution
   * @return execution
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXECUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExecutionDto getExecution() {
    return execution;
  }


  @JsonProperty(JSON_PROPERTY_EXECUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExecution(ExecutionDto execution) {
    this.execution = execution;
  }


  public MessageCorrelationResultWithVariableDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public MessageCorrelationResultWithVariableDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * This property is returned if the &#x60;variablesInResultEnabled&#x60; is set to &#x60;true&#x60;. Contains a list of the process variables. 
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageCorrelationResultWithVariableDto messageCorrelationResultWithVariableDto = (MessageCorrelationResultWithVariableDto) o;
    return equalsNullable(this.resultType, messageCorrelationResultWithVariableDto.resultType) &&
        Objects.equals(this.processInstance, messageCorrelationResultWithVariableDto.processInstance) &&
        Objects.equals(this.execution, messageCorrelationResultWithVariableDto.execution) &&
        equalsNullable(this.variables, messageCorrelationResultWithVariableDto.variables);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(resultType), processInstance, execution, hashCodeNullable(variables));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageCorrelationResultWithVariableDto {\n");
    sb.append("    resultType: ").append(toIndentedString(resultType)).append("\n");
    sb.append("    processInstance: ").append(toIndentedString(processInstance)).append("\n");
    sb.append("    execution: ").append(toIndentedString(execution)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `resultType` to the URL query string
    if (getResultType() != null) {
      try {
        joiner.add(String.format("%sresultType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResultType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstance` to the URL query string
    if (getProcessInstance() != null) {
      joiner.add(getProcessInstance().toUrlQueryString(prefix + "processInstance" + suffix));
    }

    // add `execution` to the URL query string
    if (getExecution() != null) {
      joiner.add(getExecution().toUrlQueryString(prefix + "execution" + suffix));
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

