/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MigrationInstructionDto
 */
@JsonPropertyOrder({
  MigrationInstructionDto.JSON_PROPERTY_SOURCE_ACTIVITY_IDS,
  MigrationInstructionDto.JSON_PROPERTY_TARGET_ACTIVITY_IDS,
  MigrationInstructionDto.JSON_PROPERTY_UPDATE_EVENT_TRIGGER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MigrationInstructionDto {
  public static final String JSON_PROPERTY_SOURCE_ACTIVITY_IDS = "sourceActivityIds";
  private JsonNullable<List<String>> sourceActivityIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TARGET_ACTIVITY_IDS = "targetActivityIds";
  private JsonNullable<List<String>> targetActivityIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_UPDATE_EVENT_TRIGGER = "updateEventTrigger";
  private JsonNullable<Boolean> updateEventTrigger = JsonNullable.<Boolean>undefined();

  public MigrationInstructionDto() {
  }

  public MigrationInstructionDto sourceActivityIds(List<String> sourceActivityIds) {
    this.sourceActivityIds = JsonNullable.<List<String>>of(sourceActivityIds);
    
    return this;
  }

  public MigrationInstructionDto addSourceActivityIdsItem(String sourceActivityIdsItem) {
    if (this.sourceActivityIds == null || !this.sourceActivityIds.isPresent()) {
      this.sourceActivityIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.sourceActivityIds.get().add(sourceActivityIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The activity ids from the source process definition being mapped.
   * @return sourceActivityIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getSourceActivityIds() {
        return sourceActivityIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SOURCE_ACTIVITY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getSourceActivityIds_JsonNullable() {
    return sourceActivityIds;
  }
  
  @JsonProperty(JSON_PROPERTY_SOURCE_ACTIVITY_IDS)
  public void setSourceActivityIds_JsonNullable(JsonNullable<List<String>> sourceActivityIds) {
    this.sourceActivityIds = sourceActivityIds;
  }

  public void setSourceActivityIds(List<String> sourceActivityIds) {
    this.sourceActivityIds = JsonNullable.<List<String>>of(sourceActivityIds);
  }


  public MigrationInstructionDto targetActivityIds(List<String> targetActivityIds) {
    this.targetActivityIds = JsonNullable.<List<String>>of(targetActivityIds);
    
    return this;
  }

  public MigrationInstructionDto addTargetActivityIdsItem(String targetActivityIdsItem) {
    if (this.targetActivityIds == null || !this.targetActivityIds.isPresent()) {
      this.targetActivityIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.targetActivityIds.get().add(targetActivityIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The activity ids from the target process definition being mapped.
   * @return targetActivityIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTargetActivityIds() {
        return targetActivityIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TARGET_ACTIVITY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTargetActivityIds_JsonNullable() {
    return targetActivityIds;
  }
  
  @JsonProperty(JSON_PROPERTY_TARGET_ACTIVITY_IDS)
  public void setTargetActivityIds_JsonNullable(JsonNullable<List<String>> targetActivityIds) {
    this.targetActivityIds = targetActivityIds;
  }

  public void setTargetActivityIds(List<String> targetActivityIds) {
    this.targetActivityIds = JsonNullable.<List<String>>of(targetActivityIds);
  }


  public MigrationInstructionDto updateEventTrigger(Boolean updateEventTrigger) {
    this.updateEventTrigger = JsonNullable.<Boolean>of(updateEventTrigger);
    
    return this;
  }

   /**
   * Configuration flag whether event triggers defined are going to be updated during migration.
   * @return updateEventTrigger
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUpdateEventTrigger() {
        return updateEventTrigger.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATE_EVENT_TRIGGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUpdateEventTrigger_JsonNullable() {
    return updateEventTrigger;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATE_EVENT_TRIGGER)
  public void setUpdateEventTrigger_JsonNullable(JsonNullable<Boolean> updateEventTrigger) {
    this.updateEventTrigger = updateEventTrigger;
  }

  public void setUpdateEventTrigger(Boolean updateEventTrigger) {
    this.updateEventTrigger = JsonNullable.<Boolean>of(updateEventTrigger);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationInstructionDto migrationInstructionDto = (MigrationInstructionDto) o;
    return equalsNullable(this.sourceActivityIds, migrationInstructionDto.sourceActivityIds) &&
        equalsNullable(this.targetActivityIds, migrationInstructionDto.targetActivityIds) &&
        equalsNullable(this.updateEventTrigger, migrationInstructionDto.updateEventTrigger);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(sourceActivityIds), hashCodeNullable(targetActivityIds), hashCodeNullable(updateEventTrigger));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationInstructionDto {\n");
    sb.append("    sourceActivityIds: ").append(toIndentedString(sourceActivityIds)).append("\n");
    sb.append("    targetActivityIds: ").append(toIndentedString(targetActivityIds)).append("\n");
    sb.append("    updateEventTrigger: ").append(toIndentedString(updateEventTrigger)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `sourceActivityIds` to the URL query string
    if (getSourceActivityIds() != null) {
      for (int i = 0; i < getSourceActivityIds().size(); i++) {
        try {
          joiner.add(String.format("%ssourceActivityIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSourceActivityIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `targetActivityIds` to the URL query string
    if (getTargetActivityIds() != null) {
      for (int i = 0; i < getTargetActivityIds().size(); i++) {
        try {
          joiner.add(String.format("%stargetActivityIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTargetActivityIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `updateEventTrigger` to the URL query string
    if (getUpdateEventTrigger() != null) {
      try {
        joiner.add(String.format("%supdateEventTrigger%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateEventTrigger()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

