/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.MigrationInstructionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MigrationInstructionValidationReportDto
 */
@JsonPropertyOrder({
  MigrationInstructionValidationReportDto.JSON_PROPERTY_INSTRUCTION,
  MigrationInstructionValidationReportDto.JSON_PROPERTY_FAILURES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MigrationInstructionValidationReportDto {
  public static final String JSON_PROPERTY_INSTRUCTION = "instruction";
  private MigrationInstructionDto instruction;

  public static final String JSON_PROPERTY_FAILURES = "failures";
  private JsonNullable<List<String>> failures = JsonNullable.<List<String>>undefined();

  public MigrationInstructionValidationReportDto() {
  }

  public MigrationInstructionValidationReportDto instruction(MigrationInstructionDto instruction) {
    
    this.instruction = instruction;
    return this;
  }

   /**
   * Get instruction
   * @return instruction
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INSTRUCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MigrationInstructionDto getInstruction() {
    return instruction;
  }


  @JsonProperty(JSON_PROPERTY_INSTRUCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstruction(MigrationInstructionDto instruction) {
    this.instruction = instruction;
  }


  public MigrationInstructionValidationReportDto failures(List<String> failures) {
    this.failures = JsonNullable.<List<String>>of(failures);
    
    return this;
  }

  public MigrationInstructionValidationReportDto addFailuresItem(String failuresItem) {
    if (this.failures == null || !this.failures.isPresent()) {
      this.failures = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.failures.get().add(failuresItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of instruction validation report messages.
   * @return failures
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getFailures() {
        return failures.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FAILURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getFailures_JsonNullable() {
    return failures;
  }
  
  @JsonProperty(JSON_PROPERTY_FAILURES)
  public void setFailures_JsonNullable(JsonNullable<List<String>> failures) {
    this.failures = failures;
  }

  public void setFailures(List<String> failures) {
    this.failures = JsonNullable.<List<String>>of(failures);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationInstructionValidationReportDto migrationInstructionValidationReportDto = (MigrationInstructionValidationReportDto) o;
    return Objects.equals(this.instruction, migrationInstructionValidationReportDto.instruction) &&
        equalsNullable(this.failures, migrationInstructionValidationReportDto.failures);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(instruction, hashCodeNullable(failures));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationInstructionValidationReportDto {\n");
    sb.append("    instruction: ").append(toIndentedString(instruction)).append("\n");
    sb.append("    failures: ").append(toIndentedString(failures)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `instruction` to the URL query string
    if (getInstruction() != null) {
      joiner.add(getInstruction().toUrlQueryString(prefix + "instruction" + suffix));
    }

    // add `failures` to the URL query string
    if (getFailures() != null) {
      for (int i = 0; i < getFailures().size(); i++) {
        try {
          joiner.add(String.format("%sfailures%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getFailures().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

