/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MigrationPlanGenerationDto
 */
@JsonPropertyOrder({
  MigrationPlanGenerationDto.JSON_PROPERTY_SOURCE_PROCESS_DEFINITION_ID,
  MigrationPlanGenerationDto.JSON_PROPERTY_TARGET_PROCESS_DEFINITION_ID,
  MigrationPlanGenerationDto.JSON_PROPERTY_UPDATE_EVENT_TRIGGERS,
  MigrationPlanGenerationDto.JSON_PROPERTY_VARIABLES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MigrationPlanGenerationDto {
  public static final String JSON_PROPERTY_SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
  private JsonNullable<String> sourceProcessDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
  private JsonNullable<String> targetProcessDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_UPDATE_EVENT_TRIGGERS = "updateEventTriggers";
  private JsonNullable<Boolean> updateEventTriggers = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public MigrationPlanGenerationDto() {
  }

  public MigrationPlanGenerationDto sourceProcessDefinitionId(String sourceProcessDefinitionId) {
    this.sourceProcessDefinitionId = JsonNullable.<String>of(sourceProcessDefinitionId);
    
    return this;
  }

   /**
   * The id of the source process definition for the migration.
   * @return sourceProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSourceProcessDefinitionId() {
        return sourceProcessDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SOURCE_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSourceProcessDefinitionId_JsonNullable() {
    return sourceProcessDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_SOURCE_PROCESS_DEFINITION_ID)
  public void setSourceProcessDefinitionId_JsonNullable(JsonNullable<String> sourceProcessDefinitionId) {
    this.sourceProcessDefinitionId = sourceProcessDefinitionId;
  }

  public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
    this.sourceProcessDefinitionId = JsonNullable.<String>of(sourceProcessDefinitionId);
  }


  public MigrationPlanGenerationDto targetProcessDefinitionId(String targetProcessDefinitionId) {
    this.targetProcessDefinitionId = JsonNullable.<String>of(targetProcessDefinitionId);
    
    return this;
  }

   /**
   * The id of the target process definition for the migration.
   * @return targetProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTargetProcessDefinitionId() {
        return targetProcessDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TARGET_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTargetProcessDefinitionId_JsonNullable() {
    return targetProcessDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_TARGET_PROCESS_DEFINITION_ID)
  public void setTargetProcessDefinitionId_JsonNullable(JsonNullable<String> targetProcessDefinitionId) {
    this.targetProcessDefinitionId = targetProcessDefinitionId;
  }

  public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
    this.targetProcessDefinitionId = JsonNullable.<String>of(targetProcessDefinitionId);
  }


  public MigrationPlanGenerationDto updateEventTriggers(Boolean updateEventTriggers) {
    this.updateEventTriggers = JsonNullable.<Boolean>of(updateEventTriggers);
    
    return this;
  }

   /**
   * A boolean flag indicating whether instructions between events should be configured to update the event triggers.
   * @return updateEventTriggers
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUpdateEventTriggers() {
        return updateEventTriggers.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATE_EVENT_TRIGGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUpdateEventTriggers_JsonNullable() {
    return updateEventTriggers;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATE_EVENT_TRIGGERS)
  public void setUpdateEventTriggers_JsonNullable(JsonNullable<Boolean> updateEventTriggers) {
    this.updateEventTriggers = updateEventTriggers;
  }

  public void setUpdateEventTriggers(Boolean updateEventTriggers) {
    this.updateEventTriggers = JsonNullable.<Boolean>of(updateEventTriggers);
  }


  public MigrationPlanGenerationDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public MigrationPlanGenerationDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of variables which will be set into the process instances&#39; scope. Each key is a variable name and each value a JSON variable value object.
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationPlanGenerationDto migrationPlanGenerationDto = (MigrationPlanGenerationDto) o;
    return equalsNullable(this.sourceProcessDefinitionId, migrationPlanGenerationDto.sourceProcessDefinitionId) &&
        equalsNullable(this.targetProcessDefinitionId, migrationPlanGenerationDto.targetProcessDefinitionId) &&
        equalsNullable(this.updateEventTriggers, migrationPlanGenerationDto.updateEventTriggers) &&
        equalsNullable(this.variables, migrationPlanGenerationDto.variables);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(sourceProcessDefinitionId), hashCodeNullable(targetProcessDefinitionId), hashCodeNullable(updateEventTriggers), hashCodeNullable(variables));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationPlanGenerationDto {\n");
    sb.append("    sourceProcessDefinitionId: ").append(toIndentedString(sourceProcessDefinitionId)).append("\n");
    sb.append("    targetProcessDefinitionId: ").append(toIndentedString(targetProcessDefinitionId)).append("\n");
    sb.append("    updateEventTriggers: ").append(toIndentedString(updateEventTriggers)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `sourceProcessDefinitionId` to the URL query string
    if (getSourceProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%ssourceProcessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSourceProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `targetProcessDefinitionId` to the URL query string
    if (getTargetProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%stargetProcessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTargetProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateEventTriggers` to the URL query string
    if (getUpdateEventTriggers() != null) {
      try {
        joiner.add(String.format("%supdateEventTriggers%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateEventTriggers()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

