/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.MigrationInstructionValidationReportDto;
import org.camunda.community.rest.client.dto.MigrationVariableValidationReportDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MigrationPlanReportDto
 */
@JsonPropertyOrder({
  MigrationPlanReportDto.JSON_PROPERTY_INSTRUCTION_REPORTS,
  MigrationPlanReportDto.JSON_PROPERTY_VARIABLE_REPORTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class MigrationPlanReportDto {
  public static final String JSON_PROPERTY_INSTRUCTION_REPORTS = "instructionReports";
  private JsonNullable<List<MigrationInstructionValidationReportDto>> instructionReports = JsonNullable.<List<MigrationInstructionValidationReportDto>>undefined();

  public static final String JSON_PROPERTY_VARIABLE_REPORTS = "variableReports";
  private JsonNullable<Map<String, MigrationVariableValidationReportDto>> variableReports = JsonNullable.<Map<String, MigrationVariableValidationReportDto>>undefined();

  public MigrationPlanReportDto() {
  }

  public MigrationPlanReportDto instructionReports(List<MigrationInstructionValidationReportDto> instructionReports) {
    this.instructionReports = JsonNullable.<List<MigrationInstructionValidationReportDto>>of(instructionReports);
    
    return this;
  }

  public MigrationPlanReportDto addInstructionReportsItem(MigrationInstructionValidationReportDto instructionReportsItem) {
    if (this.instructionReports == null || !this.instructionReports.isPresent()) {
      this.instructionReports = JsonNullable.<List<MigrationInstructionValidationReportDto>>of(new ArrayList<>());
    }
    try {
      this.instructionReports.get().add(instructionReportsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The list of instruction validation reports. If no validation errors are detected it is an empty list.
   * @return instructionReports
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<MigrationInstructionValidationReportDto> getInstructionReports() {
        return instructionReports.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INSTRUCTION_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<MigrationInstructionValidationReportDto>> getInstructionReports_JsonNullable() {
    return instructionReports;
  }
  
  @JsonProperty(JSON_PROPERTY_INSTRUCTION_REPORTS)
  public void setInstructionReports_JsonNullable(JsonNullable<List<MigrationInstructionValidationReportDto>> instructionReports) {
    this.instructionReports = instructionReports;
  }

  public void setInstructionReports(List<MigrationInstructionValidationReportDto> instructionReports) {
    this.instructionReports = JsonNullable.<List<MigrationInstructionValidationReportDto>>of(instructionReports);
  }


  public MigrationPlanReportDto variableReports(Map<String, MigrationVariableValidationReportDto> variableReports) {
    this.variableReports = JsonNullable.<Map<String, MigrationVariableValidationReportDto>>of(variableReports);
    
    return this;
  }

  public MigrationPlanReportDto putVariableReportsItem(String key, MigrationVariableValidationReportDto variableReportsItem) {
    if (this.variableReports == null || !this.variableReports.isPresent()) {
      this.variableReports = JsonNullable.<Map<String, MigrationVariableValidationReportDto>>of(new HashMap<>());
    }
    try {
      this.variableReports.get().put(key, variableReportsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A map of variable reports. Each key is a variable name and each value a JSON object consisting of the variable&#39;s type, value, value info object and a list of failures.
   * @return variableReports
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, MigrationVariableValidationReportDto> getVariableReports() {
        return variableReports.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_REPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, MigrationVariableValidationReportDto>> getVariableReports_JsonNullable() {
    return variableReports;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_REPORTS)
  public void setVariableReports_JsonNullable(JsonNullable<Map<String, MigrationVariableValidationReportDto>> variableReports) {
    this.variableReports = variableReports;
  }

  public void setVariableReports(Map<String, MigrationVariableValidationReportDto> variableReports) {
    this.variableReports = JsonNullable.<Map<String, MigrationVariableValidationReportDto>>of(variableReports);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationPlanReportDto migrationPlanReportDto = (MigrationPlanReportDto) o;
    return equalsNullable(this.instructionReports, migrationPlanReportDto.instructionReports) &&
        equalsNullable(this.variableReports, migrationPlanReportDto.variableReports);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(instructionReports), hashCodeNullable(variableReports));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationPlanReportDto {\n");
    sb.append("    instructionReports: ").append(toIndentedString(instructionReports)).append("\n");
    sb.append("    variableReports: ").append(toIndentedString(variableReports)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `instructionReports` to the URL query string
    if (getInstructionReports() != null) {
      for (int i = 0; i < getInstructionReports().size(); i++) {
        if (getInstructionReports().get(i) != null) {
          joiner.add(getInstructionReports().get(i).toUrlQueryString(String.format("%sinstructionReports%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variableReports` to the URL query string
    if (getVariableReports() != null) {
      for (String _key : getVariableReports().keySet()) {
        if (getVariableReports().get(_key) != null) {
          joiner.add(getVariableReports().get(_key).toUrlQueryString(String.format("%svariableReports%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

