/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Describes a rule of a password policy.
 */
@JsonPropertyOrder({
  PasswordPolicyRuleDto.JSON_PROPERTY_PLACEHOLDER,
  PasswordPolicyRuleDto.JSON_PROPERTY_PARAMETER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class PasswordPolicyRuleDto {
  public static final String JSON_PROPERTY_PLACEHOLDER = "placeholder";
  private JsonNullable<String> placeholder = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PARAMETER = "parameter";
  private Map<String, String> parameter = new HashMap<>();

  public PasswordPolicyRuleDto() {
  }

  public PasswordPolicyRuleDto placeholder(String placeholder) {
    this.placeholder = JsonNullable.<String>of(placeholder);
    
    return this;
  }

   /**
   * A placeholder string that contains the name of a password policy rule.
   * @return placeholder
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getPlaceholder() {
        return placeholder.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PLACEHOLDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPlaceholder_JsonNullable() {
    return placeholder;
  }
  
  @JsonProperty(JSON_PROPERTY_PLACEHOLDER)
  public void setPlaceholder_JsonNullable(JsonNullable<String> placeholder) {
    this.placeholder = placeholder;
  }

  public void setPlaceholder(String placeholder) {
    this.placeholder = JsonNullable.<String>of(placeholder);
  }


  public PasswordPolicyRuleDto parameter(Map<String, String> parameter) {
    
    this.parameter = parameter;
    return this;
  }

  public PasswordPolicyRuleDto putParameterItem(String key, String parameterItem) {
    if (this.parameter == null) {
      this.parameter = new HashMap<>();
    }
    this.parameter.put(key, parameterItem);
    return this;
  }

   /**
   * A map that describes the characteristics of a password policy rule, such as the minimum number of digits.
   * @return parameter
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMETER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getParameter() {
    return parameter;
  }


  @JsonProperty(JSON_PROPERTY_PARAMETER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParameter(Map<String, String> parameter) {
    this.parameter = parameter;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PasswordPolicyRuleDto passwordPolicyRuleDto = (PasswordPolicyRuleDto) o;
    return equalsNullable(this.placeholder, passwordPolicyRuleDto.placeholder) &&
        Objects.equals(this.parameter, passwordPolicyRuleDto.parameter);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(placeholder), parameter);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PasswordPolicyRuleDto {\n");
    sb.append("    placeholder: ").append(toIndentedString(placeholder)).append("\n");
    sb.append("    parameter: ").append(toIndentedString(parameter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `placeholder` to the URL query string
    if (getPlaceholder() != null) {
      try {
        joiner.add(String.format("%splaceholder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPlaceholder()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parameter` to the URL query string
    if (getParameter() != null) {
      for (String _key : getParameter().keySet()) {
        try {
          joiner.add(String.format("%sparameter%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getParameter().get(_key), URLEncoder.encode(String.valueOf(getParameter().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

