/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProblemDto
 */
@JsonPropertyOrder({
  ProblemDto.JSON_PROPERTY_MESSAGE,
  ProblemDto.JSON_PROPERTY_LINE,
  ProblemDto.JSON_PROPERTY_COLUMN,
  ProblemDto.JSON_PROPERTY_MAIN_ELEMENT_ID,
  ProblemDto.JSON_PROPERTY_ELEMENT_IDS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProblemDto {
  public static final String JSON_PROPERTY_MESSAGE = "message";
  private JsonNullable<String> message = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LINE = "line";
  private JsonNullable<Integer> line = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_COLUMN = "column";
  private JsonNullable<Integer> column = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_MAIN_ELEMENT_ID = "mainElementId";
  private JsonNullable<String> mainElementId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ELEMENT_IDS = "elementIds";
  private JsonNullable<List<String>> elementIds = JsonNullable.<List<String>>undefined();

  public ProblemDto() {
  }

  public ProblemDto message(String message) {
    this.message = JsonNullable.<String>of(message);
    
    return this;
  }

   /**
   * The message of the problem.
   * @return message
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMessage() {
        return message.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMessage_JsonNullable() {
    return message;
  }
  
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  public void setMessage_JsonNullable(JsonNullable<String> message) {
    this.message = message;
  }

  public void setMessage(String message) {
    this.message = JsonNullable.<String>of(message);
  }


  public ProblemDto line(Integer line) {
    this.line = JsonNullable.<Integer>of(line);
    
    return this;
  }

   /**
   * The line where the problem occurred.
   * @return line
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getLine() {
        return line.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getLine_JsonNullable() {
    return line;
  }
  
  @JsonProperty(JSON_PROPERTY_LINE)
  public void setLine_JsonNullable(JsonNullable<Integer> line) {
    this.line = line;
  }

  public void setLine(Integer line) {
    this.line = JsonNullable.<Integer>of(line);
  }


  public ProblemDto column(Integer column) {
    this.column = JsonNullable.<Integer>of(column);
    
    return this;
  }

   /**
   * The column where the problem occurred.
   * @return column
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getColumn() {
        return column.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_COLUMN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getColumn_JsonNullable() {
    return column;
  }
  
  @JsonProperty(JSON_PROPERTY_COLUMN)
  public void setColumn_JsonNullable(JsonNullable<Integer> column) {
    this.column = column;
  }

  public void setColumn(Integer column) {
    this.column = JsonNullable.<Integer>of(column);
  }


  public ProblemDto mainElementId(String mainElementId) {
    this.mainElementId = JsonNullable.<String>of(mainElementId);
    
    return this;
  }

   /**
   * The main element id where the problem occurred.
   * @return mainElementId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getMainElementId() {
        return mainElementId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MAIN_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getMainElementId_JsonNullable() {
    return mainElementId;
  }
  
  @JsonProperty(JSON_PROPERTY_MAIN_ELEMENT_ID)
  public void setMainElementId_JsonNullable(JsonNullable<String> mainElementId) {
    this.mainElementId = mainElementId;
  }

  public void setMainElementId(String mainElementId) {
    this.mainElementId = JsonNullable.<String>of(mainElementId);
  }


  public ProblemDto elementIds(List<String> elementIds) {
    this.elementIds = JsonNullable.<List<String>>of(elementIds);
    
    return this;
  }

  public ProblemDto addElementIdsItem(String elementIdsItem) {
    if (this.elementIds == null || !this.elementIds.isPresent()) {
      this.elementIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.elementIds.get().add(elementIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of element id affected by the problem.
   * @return elementIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getElementIds() {
        return elementIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ELEMENT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getElementIds_JsonNullable() {
    return elementIds;
  }
  
  @JsonProperty(JSON_PROPERTY_ELEMENT_IDS)
  public void setElementIds_JsonNullable(JsonNullable<List<String>> elementIds) {
    this.elementIds = elementIds;
  }

  public void setElementIds(List<String> elementIds) {
    this.elementIds = JsonNullable.<List<String>>of(elementIds);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProblemDto problemDto = (ProblemDto) o;
    return equalsNullable(this.message, problemDto.message) &&
        equalsNullable(this.line, problemDto.line) &&
        equalsNullable(this.column, problemDto.column) &&
        equalsNullable(this.mainElementId, problemDto.mainElementId) &&
        equalsNullable(this.elementIds, problemDto.elementIds);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(message), hashCodeNullable(line), hashCodeNullable(column), hashCodeNullable(mainElementId), hashCodeNullable(elementIds));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProblemDto {\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    column: ").append(toIndentedString(column)).append("\n");
    sb.append("    mainElementId: ").append(toIndentedString(mainElementId)).append("\n");
    sb.append("    elementIds: ").append(toIndentedString(elementIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `message` to the URL query string
    if (getMessage() != null) {
      try {
        joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `line` to the URL query string
    if (getLine() != null) {
      try {
        joiner.add(String.format("%sline%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLine()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `column` to the URL query string
    if (getColumn() != null) {
      try {
        joiner.add(String.format("%scolumn%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getColumn()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `mainElementId` to the URL query string
    if (getMainElementId() != null) {
      try {
        joiner.add(String.format("%smainElementId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMainElementId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `elementIds` to the URL query string
    if (getElementIds() != null) {
      for (int i = 0; i < getElementIds().size(); i++) {
        try {
          joiner.add(String.format("%selementIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getElementIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

