/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessDefinitionDto
 */
@JsonPropertyOrder({
  ProcessDefinitionDto.JSON_PROPERTY_ID,
  ProcessDefinitionDto.JSON_PROPERTY_KEY,
  ProcessDefinitionDto.JSON_PROPERTY_CATEGORY,
  ProcessDefinitionDto.JSON_PROPERTY_DESCRIPTION,
  ProcessDefinitionDto.JSON_PROPERTY_NAME,
  ProcessDefinitionDto.JSON_PROPERTY_VERSION,
  ProcessDefinitionDto.JSON_PROPERTY_RESOURCE,
  ProcessDefinitionDto.JSON_PROPERTY_DEPLOYMENT_ID,
  ProcessDefinitionDto.JSON_PROPERTY_DIAGRAM,
  ProcessDefinitionDto.JSON_PROPERTY_SUSPENDED,
  ProcessDefinitionDto.JSON_PROPERTY_TENANT_ID,
  ProcessDefinitionDto.JSON_PROPERTY_VERSION_TAG,
  ProcessDefinitionDto.JSON_PROPERTY_HISTORY_TIME_TO_LIVE,
  ProcessDefinitionDto.JSON_PROPERTY_STARTABLE_IN_TASKLIST
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProcessDefinitionDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_KEY = "key";
  private JsonNullable<String> key = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CATEGORY = "category";
  private JsonNullable<String> category = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private JsonNullable<String> description = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VERSION = "version";
  private JsonNullable<Integer> version = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_RESOURCE = "resource";
  private JsonNullable<String> resource = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEPLOYMENT_ID = "deploymentId";
  private JsonNullable<String> deploymentId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DIAGRAM = "diagram";
  private JsonNullable<String> diagram = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VERSION_TAG = "versionTag";
  private JsonNullable<String> versionTag = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_HISTORY_TIME_TO_LIVE = "historyTimeToLive";
  private JsonNullable<Integer> historyTimeToLive = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_STARTABLE_IN_TASKLIST = "startableInTasklist";
  private JsonNullable<Boolean> startableInTasklist = JsonNullable.<Boolean>undefined();

  public ProcessDefinitionDto() {
  }

  public ProcessDefinitionDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the process definition
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public ProcessDefinitionDto key(String key) {
    this.key = JsonNullable.<String>of(key);
    
    return this;
  }

   /**
   * The key of the process definition, i.e., the id of the BPMN 2.0 XML process definition.
   * @return key
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getKey() {
        return key.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getKey_JsonNullable() {
    return key;
  }
  
  @JsonProperty(JSON_PROPERTY_KEY)
  public void setKey_JsonNullable(JsonNullable<String> key) {
    this.key = key;
  }

  public void setKey(String key) {
    this.key = JsonNullable.<String>of(key);
  }


  public ProcessDefinitionDto category(String category) {
    this.category = JsonNullable.<String>of(category);
    
    return this;
  }

   /**
   * The category of the process definition.
   * @return category
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCategory() {
        return category.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCategory_JsonNullable() {
    return category;
  }
  
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  public void setCategory_JsonNullable(JsonNullable<String> category) {
    this.category = category;
  }

  public void setCategory(String category) {
    this.category = JsonNullable.<String>of(category);
  }


  public ProcessDefinitionDto description(String description) {
    this.description = JsonNullable.<String>of(description);
    
    return this;
  }

   /**
   * The description of the process definition.
   * @return description
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDescription() {
        return description.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDescription_JsonNullable() {
    return description;
  }
  
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  public void setDescription_JsonNullable(JsonNullable<String> description) {
    this.description = description;
  }

  public void setDescription(String description) {
    this.description = JsonNullable.<String>of(description);
  }


  public ProcessDefinitionDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * The name of the process definition.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public ProcessDefinitionDto version(Integer version) {
    this.version = JsonNullable.<Integer>of(version);
    
    return this;
  }

   /**
   * The version of the process definition that the engine assigned to it.
   * @return version
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getVersion() {
        return version.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getVersion_JsonNullable() {
    return version;
  }
  
  @JsonProperty(JSON_PROPERTY_VERSION)
  public void setVersion_JsonNullable(JsonNullable<Integer> version) {
    this.version = version;
  }

  public void setVersion(Integer version) {
    this.version = JsonNullable.<Integer>of(version);
  }


  public ProcessDefinitionDto resource(String resource) {
    this.resource = JsonNullable.<String>of(resource);
    
    return this;
  }

   /**
   * The file name of the process definition.
   * @return resource
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getResource() {
        return resource.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getResource_JsonNullable() {
    return resource;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE)
  public void setResource_JsonNullable(JsonNullable<String> resource) {
    this.resource = resource;
  }

  public void setResource(String resource) {
    this.resource = JsonNullable.<String>of(resource);
  }


  public ProcessDefinitionDto deploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
    
    return this;
  }

   /**
   * The deployment id of the process definition.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDeploymentId() {
        return deploymentId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDeploymentId_JsonNullable() {
    return deploymentId;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPLOYMENT_ID)
  public void setDeploymentId_JsonNullable(JsonNullable<String> deploymentId) {
    this.deploymentId = deploymentId;
  }

  public void setDeploymentId(String deploymentId) {
    this.deploymentId = JsonNullable.<String>of(deploymentId);
  }


  public ProcessDefinitionDto diagram(String diagram) {
    this.diagram = JsonNullable.<String>of(diagram);
    
    return this;
  }

   /**
   * The file name of the process definition diagram, if it exists.
   * @return diagram
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDiagram() {
        return diagram.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DIAGRAM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDiagram_JsonNullable() {
    return diagram;
  }
  
  @JsonProperty(JSON_PROPERTY_DIAGRAM)
  public void setDiagram_JsonNullable(JsonNullable<String> diagram) {
    this.diagram = diagram;
  }

  public void setDiagram(String diagram) {
    this.diagram = JsonNullable.<String>of(diagram);
  }


  public ProcessDefinitionDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * A flag indicating whether the definition is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public ProcessDefinitionDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the process definition.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public ProcessDefinitionDto versionTag(String versionTag) {
    this.versionTag = JsonNullable.<String>of(versionTag);
    
    return this;
  }

   /**
   * The version tag of the process definition.
   * @return versionTag
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getVersionTag() {
        return versionTag.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVersionTag_JsonNullable() {
    return versionTag;
  }
  
  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  public void setVersionTag_JsonNullable(JsonNullable<String> versionTag) {
    this.versionTag = versionTag;
  }

  public void setVersionTag(String versionTag) {
    this.versionTag = JsonNullable.<String>of(versionTag);
  }


  public ProcessDefinitionDto historyTimeToLive(Integer historyTimeToLive) {
    this.historyTimeToLive = JsonNullable.<Integer>of(historyTimeToLive);
    
    return this;
  }

   /**
   * History time to live value of the process definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.21/user-guide/process-engine/history/#history-cleanup).
   * minimum: 0
   * @return historyTimeToLive
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getHistoryTimeToLive() {
        return historyTimeToLive.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HISTORY_TIME_TO_LIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getHistoryTimeToLive_JsonNullable() {
    return historyTimeToLive;
  }
  
  @JsonProperty(JSON_PROPERTY_HISTORY_TIME_TO_LIVE)
  public void setHistoryTimeToLive_JsonNullable(JsonNullable<Integer> historyTimeToLive) {
    this.historyTimeToLive = historyTimeToLive;
  }

  public void setHistoryTimeToLive(Integer historyTimeToLive) {
    this.historyTimeToLive = JsonNullable.<Integer>of(historyTimeToLive);
  }


  public ProcessDefinitionDto startableInTasklist(Boolean startableInTasklist) {
    this.startableInTasklist = JsonNullable.<Boolean>of(startableInTasklist);
    
    return this;
  }

   /**
   * A flag indicating whether the process definition is startable in Tasklist or not.
   * @return startableInTasklist
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getStartableInTasklist() {
        return startableInTasklist.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_STARTABLE_IN_TASKLIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getStartableInTasklist_JsonNullable() {
    return startableInTasklist;
  }
  
  @JsonProperty(JSON_PROPERTY_STARTABLE_IN_TASKLIST)
  public void setStartableInTasklist_JsonNullable(JsonNullable<Boolean> startableInTasklist) {
    this.startableInTasklist = startableInTasklist;
  }

  public void setStartableInTasklist(Boolean startableInTasklist) {
    this.startableInTasklist = JsonNullable.<Boolean>of(startableInTasklist);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessDefinitionDto processDefinitionDto = (ProcessDefinitionDto) o;
    return equalsNullable(this.id, processDefinitionDto.id) &&
        equalsNullable(this.key, processDefinitionDto.key) &&
        equalsNullable(this.category, processDefinitionDto.category) &&
        equalsNullable(this.description, processDefinitionDto.description) &&
        equalsNullable(this.name, processDefinitionDto.name) &&
        equalsNullable(this.version, processDefinitionDto.version) &&
        equalsNullable(this.resource, processDefinitionDto.resource) &&
        equalsNullable(this.deploymentId, processDefinitionDto.deploymentId) &&
        equalsNullable(this.diagram, processDefinitionDto.diagram) &&
        equalsNullable(this.suspended, processDefinitionDto.suspended) &&
        equalsNullable(this.tenantId, processDefinitionDto.tenantId) &&
        equalsNullable(this.versionTag, processDefinitionDto.versionTag) &&
        equalsNullable(this.historyTimeToLive, processDefinitionDto.historyTimeToLive) &&
        equalsNullable(this.startableInTasklist, processDefinitionDto.startableInTasklist);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(key), hashCodeNullable(category), hashCodeNullable(description), hashCodeNullable(name), hashCodeNullable(version), hashCodeNullable(resource), hashCodeNullable(deploymentId), hashCodeNullable(diagram), hashCodeNullable(suspended), hashCodeNullable(tenantId), hashCodeNullable(versionTag), hashCodeNullable(historyTimeToLive), hashCodeNullable(startableInTasklist));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessDefinitionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    diagram: ").append(toIndentedString(diagram)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    versionTag: ").append(toIndentedString(versionTag)).append("\n");
    sb.append("    historyTimeToLive: ").append(toIndentedString(historyTimeToLive)).append("\n");
    sb.append("    startableInTasklist: ").append(toIndentedString(startableInTasklist)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `key` to the URL query string
    if (getKey() != null) {
      try {
        joiner.add(String.format("%skey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `category` to the URL query string
    if (getCategory() != null) {
      try {
        joiner.add(String.format("%scategory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCategory()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resource` to the URL query string
    if (getResource() != null) {
      try {
        joiner.add(String.format("%sresource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResource()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deploymentId` to the URL query string
    if (getDeploymentId() != null) {
      try {
        joiner.add(String.format("%sdeploymentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeploymentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `diagram` to the URL query string
    if (getDiagram() != null) {
      try {
        joiner.add(String.format("%sdiagram%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDiagram()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `versionTag` to the URL query string
    if (getVersionTag() != null) {
      try {
        joiner.add(String.format("%sversionTag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersionTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `historyTimeToLive` to the URL query string
    if (getHistoryTimeToLive() != null) {
      try {
        joiner.add(String.format("%shistoryTimeToLive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHistoryTimeToLive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startableInTasklist` to the URL query string
    if (getStartableInTasklist() != null) {
      try {
        joiner.add(String.format("%sstartableInTasklist%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartableInTasklist()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

