/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationInstructionDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessInstanceModificationDto
 */
@JsonPropertyOrder({
  ProcessInstanceModificationDto.JSON_PROPERTY_SKIP_CUSTOM_LISTENERS,
  ProcessInstanceModificationDto.JSON_PROPERTY_SKIP_IO_MAPPINGS,
  ProcessInstanceModificationDto.JSON_PROPERTY_INSTRUCTIONS,
  ProcessInstanceModificationDto.JSON_PROPERTY_ANNOTATION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProcessInstanceModificationDto {
  public static final String JSON_PROPERTY_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
  private JsonNullable<Boolean> skipCustomListeners = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SKIP_IO_MAPPINGS = "skipIoMappings";
  private JsonNullable<Boolean> skipIoMappings = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
  private JsonNullable<List<ProcessInstanceModificationInstructionDto>> instructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>undefined();

  public static final String JSON_PROPERTY_ANNOTATION = "annotation";
  private JsonNullable<String> annotation = JsonNullable.<String>undefined();

  public ProcessInstanceModificationDto() {
  }

  public ProcessInstanceModificationDto skipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
    
    return this;
  }

   /**
   * Skip execution listener invocation for activities that are started or ended as part of this request.
   * @return skipCustomListeners
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipCustomListeners() {
        return skipCustomListeners.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipCustomListeners_JsonNullable() {
    return skipCustomListeners;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  public void setSkipCustomListeners_JsonNullable(JsonNullable<Boolean> skipCustomListeners) {
    this.skipCustomListeners = skipCustomListeners;
  }

  public void setSkipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
  }


  public ProcessInstanceModificationDto skipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
    
    return this;
  }

   /**
   * Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.
   * @return skipIoMappings
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipIoMappings() {
        return skipIoMappings.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipIoMappings_JsonNullable() {
    return skipIoMappings;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  public void setSkipIoMappings_JsonNullable(JsonNullable<Boolean> skipIoMappings) {
    this.skipIoMappings = skipIoMappings;
  }

  public void setSkipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
  }


  public ProcessInstanceModificationDto instructions(List<ProcessInstanceModificationInstructionDto> instructions) {
    this.instructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(instructions);
    
    return this;
  }

  public ProcessInstanceModificationDto addInstructionsItem(ProcessInstanceModificationInstructionDto instructionsItem) {
    if (this.instructions == null || !this.instructions.isPresent()) {
      this.instructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(new ArrayList<>());
    }
    try {
      this.instructions.get().add(instructionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * JSON array of modification instructions. The instructions are executed in the order they are in.
   * @return instructions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<ProcessInstanceModificationInstructionDto> getInstructions() {
        return instructions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<ProcessInstanceModificationInstructionDto>> getInstructions_JsonNullable() {
    return instructions;
  }
  
  @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
  public void setInstructions_JsonNullable(JsonNullable<List<ProcessInstanceModificationInstructionDto>> instructions) {
    this.instructions = instructions;
  }

  public void setInstructions(List<ProcessInstanceModificationInstructionDto> instructions) {
    this.instructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(instructions);
  }


  public ProcessInstanceModificationDto annotation(String annotation) {
    this.annotation = JsonNullable.<String>of(annotation);
    
    return this;
  }

   /**
   * An arbitrary text annotation set by a user for auditing reasons.
   * @return annotation
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAnnotation() {
        return annotation.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAnnotation_JsonNullable() {
    return annotation;
  }
  
  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  public void setAnnotation_JsonNullable(JsonNullable<String> annotation) {
    this.annotation = annotation;
  }

  public void setAnnotation(String annotation) {
    this.annotation = JsonNullable.<String>of(annotation);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationDto processInstanceModificationDto = (ProcessInstanceModificationDto) o;
    return equalsNullable(this.skipCustomListeners, processInstanceModificationDto.skipCustomListeners) &&
        equalsNullable(this.skipIoMappings, processInstanceModificationDto.skipIoMappings) &&
        equalsNullable(this.instructions, processInstanceModificationDto.instructions) &&
        equalsNullable(this.annotation, processInstanceModificationDto.annotation);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(skipCustomListeners), hashCodeNullable(skipIoMappings), hashCodeNullable(instructions), hashCodeNullable(annotation));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationDto {\n");
    sb.append("    skipCustomListeners: ").append(toIndentedString(skipCustomListeners)).append("\n");
    sb.append("    skipIoMappings: ").append(toIndentedString(skipIoMappings)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("    annotation: ").append(toIndentedString(annotation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `skipCustomListeners` to the URL query string
    if (getSkipCustomListeners() != null) {
      try {
        joiner.add(String.format("%sskipCustomListeners%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipCustomListeners()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `skipIoMappings` to the URL query string
    if (getSkipIoMappings() != null) {
      try {
        joiner.add(String.format("%sskipIoMappings%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipIoMappings()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `instructions` to the URL query string
    if (getInstructions() != null) {
      for (int i = 0; i < getInstructions().size(); i++) {
        if (getInstructions().get(i) != null) {
          joiner.add(getInstructions().get(i).toUrlQueryString(String.format("%sinstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `annotation` to the URL query string
    if (getAnnotation() != null) {
      try {
        joiner.add(String.format("%sannotation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAnnotation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

