/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.camunda.community.rest.client.dto.TriggerVariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessInstanceModificationInstructionDto
 */
@JsonPropertyOrder({
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_TYPE,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_VARIABLES,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_ACTIVITY_ID,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_TRANSITION_ID,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_TRANSITION_INSTANCE_ID,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_ANCESTOR_ACTIVITY_INSTANCE_ID,
  ProcessInstanceModificationInstructionDto.JSON_PROPERTY_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProcessInstanceModificationInstructionDto {
  /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   */
  public enum TypeEnum {
    CANCEL("cancel"),
    
    STARTBEFOREACTIVITY("startBeforeActivity"),
    
    STARTAFTERACTIVITY("startAfterActivity"),
    
    STARTTRANSITION("startTransition");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private TriggerVariableValueDto variables;

  public static final String JSON_PROPERTY_ACTIVITY_ID = "activityId";
  private JsonNullable<String> activityId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TRANSITION_ID = "transitionId";
  private JsonNullable<String> transitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  private JsonNullable<String> activityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TRANSITION_INSTANCE_ID = "transitionInstanceId";
  private JsonNullable<String> transitionInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ANCESTOR_ACTIVITY_INSTANCE_ID = "ancestorActivityInstanceId";
  private JsonNullable<String> ancestorActivityInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES = "cancelCurrentActiveActivityInstances";
  private JsonNullable<Boolean> cancelCurrentActiveActivityInstances = JsonNullable.<Boolean>undefined();

  public ProcessInstanceModificationInstructionDto() {
  }

  public ProcessInstanceModificationInstructionDto type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   * @return type
  **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ProcessInstanceModificationInstructionDto variables(TriggerVariableValueDto variables) {
    
    this.variables = variables;
    return this;
  }

   /**
   * Get variables
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TriggerVariableValueDto getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(TriggerVariableValueDto variables) {
    this.variables = variables;
  }


  public ProcessInstanceModificationInstructionDto activityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
    
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityId() {
        return activityId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityId_JsonNullable() {
    return activityId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_ID)
  public void setActivityId_JsonNullable(JsonNullable<String> activityId) {
    this.activityId = activityId;
  }

  public void setActivityId(String activityId) {
    this.activityId = JsonNullable.<String>of(activityId);
  }


  public ProcessInstanceModificationInstructionDto transitionId(String transitionId) {
    this.transitionId = JsonNullable.<String>of(transitionId);
    
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return transitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTransitionId() {
        return transitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TRANSITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTransitionId_JsonNullable() {
    return transitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_TRANSITION_ID)
  public void setTransitionId_JsonNullable(JsonNullable<String> transitionId) {
    this.transitionId = transitionId;
  }

  public void setTransitionId(String transitionId) {
    this.transitionId = JsonNullable.<String>of(transitionId);
  }


  public ProcessInstanceModificationInstructionDto activityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
    
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;cancel&#x60;. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.21/reference/rest/process-instance/get-activity-instances/).
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getActivityInstanceId() {
        return activityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getActivityInstanceId_JsonNullable() {
    return activityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID)
  public void setActivityInstanceId_JsonNullable(JsonNullable<String> activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }

  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = JsonNullable.<String>of(activityInstanceId);
  }


  public ProcessInstanceModificationInstructionDto transitionInstanceId(String transitionInstanceId) {
    this.transitionInstanceId = JsonNullable.<String>of(transitionInstanceId);
    
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;cancel&#x60;. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.21/reference/rest/process-instance/get-activity-instances/).
   * @return transitionInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTransitionInstanceId() {
        return transitionInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TRANSITION_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTransitionInstanceId_JsonNullable() {
    return transitionInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_TRANSITION_INSTANCE_ID)
  public void setTransitionInstanceId_JsonNullable(JsonNullable<String> transitionInstanceId) {
    this.transitionInstanceId = transitionInstanceId;
  }

  public void setTransitionInstanceId(String transitionInstanceId) {
    this.transitionInstanceId = JsonNullable.<String>of(transitionInstanceId);
  }


  public ProcessInstanceModificationInstructionDto ancestorActivityInstanceId(String ancestorActivityInstanceId) {
    this.ancestorActivityInstanceId = JsonNullable.<String>of(ancestorActivityInstanceId);
    
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, and &#x60;startTransition&#x60;. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.
   * @return ancestorActivityInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAncestorActivityInstanceId() {
        return ancestorActivityInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ANCESTOR_ACTIVITY_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAncestorActivityInstanceId_JsonNullable() {
    return ancestorActivityInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_ANCESTOR_ACTIVITY_INSTANCE_ID)
  public void setAncestorActivityInstanceId_JsonNullable(JsonNullable<String> ancestorActivityInstanceId) {
    this.ancestorActivityInstanceId = ancestorActivityInstanceId;
  }

  public void setAncestorActivityInstanceId(String ancestorActivityInstanceId) {
    this.ancestorActivityInstanceId = JsonNullable.<String>of(ancestorActivityInstanceId);
  }


  public ProcessInstanceModificationInstructionDto cancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    this.cancelCurrentActiveActivityInstances = JsonNullable.<Boolean>of(cancelCurrentActiveActivityInstances);
    
    return this;
  }

   /**
   * Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.
   * @return cancelCurrentActiveActivityInstances
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCancelCurrentActiveActivityInstances() {
        return cancelCurrentActiveActivityInstances.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCancelCurrentActiveActivityInstances_JsonNullable() {
    return cancelCurrentActiveActivityInstances;
  }
  
  @JsonProperty(JSON_PROPERTY_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES)
  public void setCancelCurrentActiveActivityInstances_JsonNullable(JsonNullable<Boolean> cancelCurrentActiveActivityInstances) {
    this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
  }

  public void setCancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    this.cancelCurrentActiveActivityInstances = JsonNullable.<Boolean>of(cancelCurrentActiveActivityInstances);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationInstructionDto processInstanceModificationInstructionDto = (ProcessInstanceModificationInstructionDto) o;
    return Objects.equals(this.type, processInstanceModificationInstructionDto.type) &&
        Objects.equals(this.variables, processInstanceModificationInstructionDto.variables) &&
        equalsNullable(this.activityId, processInstanceModificationInstructionDto.activityId) &&
        equalsNullable(this.transitionId, processInstanceModificationInstructionDto.transitionId) &&
        equalsNullable(this.activityInstanceId, processInstanceModificationInstructionDto.activityInstanceId) &&
        equalsNullable(this.transitionInstanceId, processInstanceModificationInstructionDto.transitionInstanceId) &&
        equalsNullable(this.ancestorActivityInstanceId, processInstanceModificationInstructionDto.ancestorActivityInstanceId) &&
        equalsNullable(this.cancelCurrentActiveActivityInstances, processInstanceModificationInstructionDto.cancelCurrentActiveActivityInstances);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, variables, hashCodeNullable(activityId), hashCodeNullable(transitionId), hashCodeNullable(activityInstanceId), hashCodeNullable(transitionInstanceId), hashCodeNullable(ancestorActivityInstanceId), hashCodeNullable(cancelCurrentActiveActivityInstances));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationInstructionDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    transitionId: ").append(toIndentedString(transitionId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    transitionInstanceId: ").append(toIndentedString(transitionInstanceId)).append("\n");
    sb.append("    ancestorActivityInstanceId: ").append(toIndentedString(ancestorActivityInstanceId)).append("\n");
    sb.append("    cancelCurrentActiveActivityInstances: ").append(toIndentedString(cancelCurrentActiveActivityInstances)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      joiner.add(getVariables().toUrlQueryString(prefix + "variables" + suffix));
    }

    // add `activityId` to the URL query string
    if (getActivityId() != null) {
      try {
        joiner.add(String.format("%sactivityId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `transitionId` to the URL query string
    if (getTransitionId() != null) {
      try {
        joiner.add(String.format("%stransitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTransitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceId` to the URL query string
    if (getActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sactivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `transitionInstanceId` to the URL query string
    if (getTransitionInstanceId() != null) {
      try {
        joiner.add(String.format("%stransitionInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTransitionInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ancestorActivityInstanceId` to the URL query string
    if (getAncestorActivityInstanceId() != null) {
      try {
        joiner.add(String.format("%sancestorActivityInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAncestorActivityInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cancelCurrentActiveActivityInstances` to the URL query string
    if (getCancelCurrentActiveActivityInstances() != null) {
      try {
        joiner.add(String.format("%scancelCurrentActiveActivityInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCancelCurrentActiveActivityInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

