/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.AtomLink;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessInstanceWithVariablesDto
 */
@JsonPropertyOrder({
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_ID,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_DEFINITION_ID,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_BUSINESS_KEY,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_ENDED,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_SUSPENDED,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_LINKS,
  ProcessInstanceWithVariablesDto.JSON_PROPERTY_VARIABLES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class ProcessInstanceWithVariablesDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DEFINITION_ID = "definitionId";
  private JsonNullable<String> definitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ENDED = "ended";
  private JsonNullable<Boolean> ended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LINKS = "links";
  private JsonNullable<List<AtomLink>> links = JsonNullable.<List<AtomLink>>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public ProcessInstanceWithVariablesDto() {
  }

  public ProcessInstanceWithVariablesDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The id of the process instance.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public ProcessInstanceWithVariablesDto definitionId(String definitionId) {
    this.definitionId = JsonNullable.<String>of(definitionId);
    
    return this;
  }

   /**
   * The id of the process definition that this process instance belongs to.
   * @return definitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDefinitionId() {
        return definitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDefinitionId_JsonNullable() {
    return definitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_DEFINITION_ID)
  public void setDefinitionId_JsonNullable(JsonNullable<String> definitionId) {
    this.definitionId = definitionId;
  }

  public void setDefinitionId(String definitionId) {
    this.definitionId = JsonNullable.<String>of(definitionId);
  }


  public ProcessInstanceWithVariablesDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * The business key of the process instance.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public ProcessInstanceWithVariablesDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The id of the case instance associated with the process instance.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public ProcessInstanceWithVariablesDto ended(Boolean ended) {
    this.ended = JsonNullable.<Boolean>of(ended);
    
    return this;
  }

   /**
   * A flag indicating whether the process instance has ended or not. Deprecated: will always be false!
   * @return ended
   * @deprecated
  **/
  @Deprecated
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getEnded() {
        return ended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getEnded_JsonNullable() {
    return ended;
  }
  
  @JsonProperty(JSON_PROPERTY_ENDED)
  public void setEnded_JsonNullable(JsonNullable<Boolean> ended) {
    this.ended = ended;
  }

  public void setEnded(Boolean ended) {
    this.ended = JsonNullable.<Boolean>of(ended);
  }


  public ProcessInstanceWithVariablesDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * A flag indicating whether the process instance is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public ProcessInstanceWithVariablesDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * The tenant id of the process instance.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }


  public ProcessInstanceWithVariablesDto links(List<AtomLink> links) {
    this.links = JsonNullable.<List<AtomLink>>of(links);
    
    return this;
  }

  public ProcessInstanceWithVariablesDto addLinksItem(AtomLink linksItem) {
    if (this.links == null || !this.links.isPresent()) {
      this.links = JsonNullable.<List<AtomLink>>of(new ArrayList<>());
    }
    try {
      this.links.get().add(linksItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The links associated to this resource, with &#x60;method&#x60;, &#x60;href&#x60; and &#x60;rel&#x60;.
   * @return links
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<AtomLink> getLinks() {
        return links.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<AtomLink>> getLinks_JsonNullable() {
    return links;
  }
  
  @JsonProperty(JSON_PROPERTY_LINKS)
  public void setLinks_JsonNullable(JsonNullable<List<AtomLink>> links) {
    this.links = links;
  }

  public void setLinks(List<AtomLink> links) {
    this.links = JsonNullable.<List<AtomLink>>of(links);
  }


  public ProcessInstanceWithVariablesDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public ProcessInstanceWithVariablesDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The id of the process instance.
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceWithVariablesDto processInstanceWithVariablesDto = (ProcessInstanceWithVariablesDto) o;
    return equalsNullable(this.id, processInstanceWithVariablesDto.id) &&
        equalsNullable(this.definitionId, processInstanceWithVariablesDto.definitionId) &&
        equalsNullable(this.businessKey, processInstanceWithVariablesDto.businessKey) &&
        equalsNullable(this.caseInstanceId, processInstanceWithVariablesDto.caseInstanceId) &&
        equalsNullable(this.ended, processInstanceWithVariablesDto.ended) &&
        equalsNullable(this.suspended, processInstanceWithVariablesDto.suspended) &&
        equalsNullable(this.tenantId, processInstanceWithVariablesDto.tenantId) &&
        equalsNullable(this.links, processInstanceWithVariablesDto.links) &&
        equalsNullable(this.variables, processInstanceWithVariablesDto.variables);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(definitionId), hashCodeNullable(businessKey), hashCodeNullable(caseInstanceId), hashCodeNullable(ended), hashCodeNullable(suspended), hashCodeNullable(tenantId), hashCodeNullable(links), hashCodeNullable(variables));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceWithVariablesDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    definitionId: ").append(toIndentedString(definitionId)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    ended: ").append(toIndentedString(ended)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `definitionId` to the URL query string
    if (getDefinitionId() != null) {
      try {
        joiner.add(String.format("%sdefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ended` to the URL query string
    if (getEnded() != null) {
      try {
        joiner.add(String.format("%sended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEnded()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `links` to the URL query string
    if (getLinks() != null) {
      for (int i = 0; i < getLinks().size(); i++) {
        if (getLinks().get(i) != null) {
          joiner.add(getLinks().get(i).toUrlQueryString(String.format("%slinks%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

