/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A JSON object with the following properties:
 */
@JsonPropertyOrder({
  RedeploymentDto.JSON_PROPERTY_RESOURCE_IDS,
  RedeploymentDto.JSON_PROPERTY_RESOURCE_NAMES,
  RedeploymentDto.JSON_PROPERTY_SOURCE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class RedeploymentDto {
  public static final String JSON_PROPERTY_RESOURCE_IDS = "resourceIds";
  private JsonNullable<List<String>> resourceIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_RESOURCE_NAMES = "resourceNames";
  private JsonNullable<List<String>> resourceNames = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_SOURCE = "source";
  private JsonNullable<String> source = JsonNullable.<String>undefined();

  public RedeploymentDto() {
  }

  public RedeploymentDto resourceIds(List<String> resourceIds) {
    this.resourceIds = JsonNullable.<List<String>>of(resourceIds);
    
    return this;
  }

  public RedeploymentDto addResourceIdsItem(String resourceIdsItem) {
    if (this.resourceIds == null || !this.resourceIds.isPresent()) {
      this.resourceIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.resourceIds.get().add(resourceIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of deployment resource ids to re-deploy.
   * @return resourceIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getResourceIds() {
        return resourceIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getResourceIds_JsonNullable() {
    return resourceIds;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_IDS)
  public void setResourceIds_JsonNullable(JsonNullable<List<String>> resourceIds) {
    this.resourceIds = resourceIds;
  }

  public void setResourceIds(List<String> resourceIds) {
    this.resourceIds = JsonNullable.<List<String>>of(resourceIds);
  }


  public RedeploymentDto resourceNames(List<String> resourceNames) {
    this.resourceNames = JsonNullable.<List<String>>of(resourceNames);
    
    return this;
  }

  public RedeploymentDto addResourceNamesItem(String resourceNamesItem) {
    if (this.resourceNames == null || !this.resourceNames.isPresent()) {
      this.resourceNames = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.resourceNames.get().add(resourceNamesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of deployment resource names to re-deploy.
   * @return resourceNames
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getResourceNames() {
        return resourceNames.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RESOURCE_NAMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getResourceNames_JsonNullable() {
    return resourceNames;
  }
  
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAMES)
  public void setResourceNames_JsonNullable(JsonNullable<List<String>> resourceNames) {
    this.resourceNames = resourceNames;
  }

  public void setResourceNames(List<String> resourceNames) {
    this.resourceNames = JsonNullable.<List<String>>of(resourceNames);
  }


  public RedeploymentDto source(String source) {
    this.source = JsonNullable.<String>of(source);
    
    return this;
  }

   /**
   * Sets the source of the deployment.
   * @return source
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getSource() {
        return source.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSource_JsonNullable() {
    return source;
  }
  
  @JsonProperty(JSON_PROPERTY_SOURCE)
  public void setSource_JsonNullable(JsonNullable<String> source) {
    this.source = source;
  }

  public void setSource(String source) {
    this.source = JsonNullable.<String>of(source);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedeploymentDto redeploymentDto = (RedeploymentDto) o;
    return equalsNullable(this.resourceIds, redeploymentDto.resourceIds) &&
        equalsNullable(this.resourceNames, redeploymentDto.resourceNames) &&
        equalsNullable(this.source, redeploymentDto.source);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(resourceIds), hashCodeNullable(resourceNames), hashCodeNullable(source));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedeploymentDto {\n");
    sb.append("    resourceIds: ").append(toIndentedString(resourceIds)).append("\n");
    sb.append("    resourceNames: ").append(toIndentedString(resourceNames)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `resourceIds` to the URL query string
    if (getResourceIds() != null) {
      for (int i = 0; i < getResourceIds().size(); i++) {
        try {
          joiner.add(String.format("%sresourceIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getResourceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `resourceNames` to the URL query string
    if (getResourceNames() != null) {
      for (int i = 0; i < getResourceNames().size(); i++) {
        try {
          joiner.add(String.format("%sresourceNames%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getResourceNames().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `source` to the URL query string
    if (getSource() != null) {
      try {
        joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSource()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

