/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.JobQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SetJobRetriesByProcessDto
 */
@JsonPropertyOrder({
  SetJobRetriesByProcessDto.JSON_PROPERTY_JOB_IDS,
  SetJobRetriesByProcessDto.JSON_PROPERTY_JOB_QUERY,
  SetJobRetriesByProcessDto.JSON_PROPERTY_DUE_DATE,
  SetJobRetriesByProcessDto.JSON_PROPERTY_RETRIES,
  SetJobRetriesByProcessDto.JSON_PROPERTY_PROCESS_INSTANCES,
  SetJobRetriesByProcessDto.JSON_PROPERTY_PROCESS_INSTANCE_QUERY,
  SetJobRetriesByProcessDto.JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class SetJobRetriesByProcessDto {
  public static final String JSON_PROPERTY_JOB_IDS = "jobIds";
  private JsonNullable<List<String>> jobIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_JOB_QUERY = "jobQuery";
  private JobQueryDto jobQuery;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private JsonNullable<OffsetDateTime> dueDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_RETRIES = "retries";
  private JsonNullable<Integer> retries = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCES = "processInstances";
  private JsonNullable<List<String>> processInstances = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
  private ProcessInstanceQueryDto processInstanceQuery;

  public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public SetJobRetriesByProcessDto() {
  }

  public SetJobRetriesByProcessDto jobIds(List<String> jobIds) {
    this.jobIds = JsonNullable.<List<String>>of(jobIds);
    
    return this;
  }

  public SetJobRetriesByProcessDto addJobIdsItem(String jobIdsItem) {
    if (this.jobIds == null || !this.jobIds.isPresent()) {
      this.jobIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.jobIds.get().add(jobIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of job ids to set retries for.
   * @return jobIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getJobIds() {
        return jobIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_JOB_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getJobIds_JsonNullable() {
    return jobIds;
  }
  
  @JsonProperty(JSON_PROPERTY_JOB_IDS)
  public void setJobIds_JsonNullable(JsonNullable<List<String>> jobIds) {
    this.jobIds = jobIds;
  }

  public void setJobIds(List<String> jobIds) {
    this.jobIds = JsonNullable.<List<String>>of(jobIds);
  }


  public SetJobRetriesByProcessDto jobQuery(JobQueryDto jobQuery) {
    
    this.jobQuery = jobQuery;
    return this;
  }

   /**
   * Get jobQuery
   * @return jobQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobQueryDto getJobQuery() {
    return jobQuery;
  }


  @JsonProperty(JSON_PROPERTY_JOB_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobQuery(JobQueryDto jobQuery) {
    this.jobQuery = jobQuery;
  }


  public SetJobRetriesByProcessDto dueDate(OffsetDateTime dueDate) {
    this.dueDate = JsonNullable.<OffsetDateTime>of(dueDate);
    
    return this;
  }

   /**
   * The due date to set for the job. A due date indicates when this job is ready for execution. Jobs with due dates in the past will be scheduled for execution.
   * @return dueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDueDate() {
        return dueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDueDate_JsonNullable() {
    return dueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  public void setDueDate_JsonNullable(JsonNullable<OffsetDateTime> dueDate) {
    this.dueDate = dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = JsonNullable.<OffsetDateTime>of(dueDate);
  }


  public SetJobRetriesByProcessDto retries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
    
    return this;
  }

   /**
   * The number of retries to set for the resource.  Must be &gt;&#x3D; 0. If this is 0, an incident is created and the task, or job, cannot be fetched, or acquired anymore unless the retries are increased again. Can not be null.
   * @return retries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getRetries() {
        return retries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getRetries_JsonNullable() {
    return retries;
  }
  
  @JsonProperty(JSON_PROPERTY_RETRIES)
  public void setRetries_JsonNullable(JsonNullable<Integer> retries) {
    this.retries = retries;
  }

  public void setRetries(Integer retries) {
    this.retries = JsonNullable.<Integer>of(retries);
  }


  public SetJobRetriesByProcessDto processInstances(List<String> processInstances) {
    this.processInstances = JsonNullable.<List<String>>of(processInstances);
    
    return this;
  }

  public SetJobRetriesByProcessDto addProcessInstancesItem(String processInstancesItem) {
    if (this.processInstances == null || !this.processInstances.isPresent()) {
      this.processInstances = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstances.get().add(processInstancesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A list of process instance ids to fetch jobs, for which retries will be set.
   * @return processInstances
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstances() {
        return processInstances.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstances_JsonNullable() {
    return processInstances;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCES)
  public void setProcessInstances_JsonNullable(JsonNullable<List<String>> processInstances) {
    this.processInstances = processInstances;
  }

  public void setProcessInstances(List<String> processInstances) {
    this.processInstances = JsonNullable.<List<String>>of(processInstances);
  }


  public SetJobRetriesByProcessDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    
    this.processInstanceQuery = processInstanceQuery;
    return this;
  }

   /**
   * Get processInstanceQuery
   * @return processInstanceQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceQueryDto getProcessInstanceQuery() {
    return processInstanceQuery;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
    this.processInstanceQuery = processInstanceQuery;
  }


  public SetJobRetriesByProcessDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetJobRetriesByProcessDto setJobRetriesByProcessDto = (SetJobRetriesByProcessDto) o;
    return equalsNullable(this.jobIds, setJobRetriesByProcessDto.jobIds) &&
        Objects.equals(this.jobQuery, setJobRetriesByProcessDto.jobQuery) &&
        equalsNullable(this.dueDate, setJobRetriesByProcessDto.dueDate) &&
        equalsNullable(this.retries, setJobRetriesByProcessDto.retries) &&
        equalsNullable(this.processInstances, setJobRetriesByProcessDto.processInstances) &&
        Objects.equals(this.processInstanceQuery, setJobRetriesByProcessDto.processInstanceQuery) &&
        Objects.equals(this.historicProcessInstanceQuery, setJobRetriesByProcessDto.historicProcessInstanceQuery);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(jobIds), jobQuery, hashCodeNullable(dueDate), hashCodeNullable(retries), hashCodeNullable(processInstances), processInstanceQuery, historicProcessInstanceQuery);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetJobRetriesByProcessDto {\n");
    sb.append("    jobIds: ").append(toIndentedString(jobIds)).append("\n");
    sb.append("    jobQuery: ").append(toIndentedString(jobQuery)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    processInstances: ").append(toIndentedString(processInstances)).append("\n");
    sb.append("    processInstanceQuery: ").append(toIndentedString(processInstanceQuery)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `jobIds` to the URL query string
    if (getJobIds() != null) {
      for (int i = 0; i < getJobIds().size(); i++) {
        try {
          joiner.add(String.format("%sjobIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getJobIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `jobQuery` to the URL query string
    if (getJobQuery() != null) {
      joiner.add(getJobQuery().toUrlQueryString(prefix + "jobQuery" + suffix));
    }

    // add `dueDate` to the URL query string
    if (getDueDate() != null) {
      try {
        joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      try {
        joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstances` to the URL query string
    if (getProcessInstances() != null) {
      for (int i = 0; i < getProcessInstances().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstances%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstances().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceQuery` to the URL query string
    if (getProcessInstanceQuery() != null) {
      joiner.add(getProcessInstanceQuery().toUrlQueryString(prefix + "processInstanceQuery" + suffix));
    }

    // add `historicProcessInstanceQuery` to the URL query string
    if (getHistoricProcessInstanceQuery() != null) {
      joiner.add(getHistoricProcessInstanceQuery().toUrlQueryString(prefix + "historicProcessInstanceQuery" + suffix));
    }

    return joiner.toString();
  }

}

