/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SetRemovalTimeToHistoricProcessInstancesDto
 */
@JsonPropertyOrder({
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_ABSOLUTE_REMOVAL_TIME,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_CLEARED_REMOVAL_TIME,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_CALCULATED_REMOVAL_TIME,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_IDS,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_HIERARCHICAL,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_UPDATE_IN_CHUNKS,
  SetRemovalTimeToHistoricProcessInstancesDto.JSON_PROPERTY_UPDATE_CHUNK_SIZE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class SetRemovalTimeToHistoricProcessInstancesDto {
  public static final String JSON_PROPERTY_ABSOLUTE_REMOVAL_TIME = "absoluteRemovalTime";
  private JsonNullable<OffsetDateTime> absoluteRemovalTime = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CLEARED_REMOVAL_TIME = "clearedRemovalTime";
  private JsonNullable<Boolean> clearedRemovalTime = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_CALCULATED_REMOVAL_TIME = "calculatedRemovalTime";
  private JsonNullable<Boolean> calculatedRemovalTime = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_IDS = "historicProcessInstanceIds";
  private JsonNullable<List<String>> historicProcessInstanceIds = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public static final String JSON_PROPERTY_HIERARCHICAL = "hierarchical";
  private JsonNullable<Boolean> hierarchical = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UPDATE_IN_CHUNKS = "updateInChunks";
  private JsonNullable<Boolean> updateInChunks = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_UPDATE_CHUNK_SIZE = "updateChunkSize";
  private JsonNullable<Integer> updateChunkSize = JsonNullable.<Integer>undefined();

  public SetRemovalTimeToHistoricProcessInstancesDto() {
  }

  public SetRemovalTimeToHistoricProcessInstancesDto absoluteRemovalTime(OffsetDateTime absoluteRemovalTime) {
    this.absoluteRemovalTime = JsonNullable.<OffsetDateTime>of(absoluteRemovalTime);
    
    return this;
  }

   /**
   * The date for which the instances shall be removed. Value may not be &#x60;null&#x60;.  **Note:** Cannot be set in conjunction with &#x60;clearedRemovalTime&#x60; or &#x60;calculatedRemovalTime&#x60;.
   * @return absoluteRemovalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getAbsoluteRemovalTime() {
        return absoluteRemovalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ABSOLUTE_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getAbsoluteRemovalTime_JsonNullable() {
    return absoluteRemovalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_ABSOLUTE_REMOVAL_TIME)
  public void setAbsoluteRemovalTime_JsonNullable(JsonNullable<OffsetDateTime> absoluteRemovalTime) {
    this.absoluteRemovalTime = absoluteRemovalTime;
  }

  public void setAbsoluteRemovalTime(OffsetDateTime absoluteRemovalTime) {
    this.absoluteRemovalTime = JsonNullable.<OffsetDateTime>of(absoluteRemovalTime);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto clearedRemovalTime(Boolean clearedRemovalTime) {
    this.clearedRemovalTime = JsonNullable.<Boolean>of(clearedRemovalTime);
    
    return this;
  }

   /**
   * Sets the removal time to &#x60;null&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.  **Note:** Cannot be set in conjunction with &#x60;absoluteRemovalTime&#x60; or &#x60;calculatedRemovalTime&#x60;.
   * @return clearedRemovalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getClearedRemovalTime() {
        return clearedRemovalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CLEARED_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getClearedRemovalTime_JsonNullable() {
    return clearedRemovalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_CLEARED_REMOVAL_TIME)
  public void setClearedRemovalTime_JsonNullable(JsonNullable<Boolean> clearedRemovalTime) {
    this.clearedRemovalTime = clearedRemovalTime;
  }

  public void setClearedRemovalTime(Boolean clearedRemovalTime) {
    this.clearedRemovalTime = JsonNullable.<Boolean>of(clearedRemovalTime);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto calculatedRemovalTime(Boolean calculatedRemovalTime) {
    this.calculatedRemovalTime = JsonNullable.<Boolean>of(calculatedRemovalTime);
    
    return this;
  }

   /**
   * The removal time is calculated based on the engine&#39;s configuration settings. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.  **Note:** Cannot be set in conjunction with &#x60;absoluteRemovalTime&#x60; or &#x60;clearedRemovalTime&#x60;.
   * @return calculatedRemovalTime
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getCalculatedRemovalTime() {
        return calculatedRemovalTime.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CALCULATED_REMOVAL_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getCalculatedRemovalTime_JsonNullable() {
    return calculatedRemovalTime;
  }
  
  @JsonProperty(JSON_PROPERTY_CALCULATED_REMOVAL_TIME)
  public void setCalculatedRemovalTime_JsonNullable(JsonNullable<Boolean> calculatedRemovalTime) {
    this.calculatedRemovalTime = calculatedRemovalTime;
  }

  public void setCalculatedRemovalTime(Boolean calculatedRemovalTime) {
    this.calculatedRemovalTime = JsonNullable.<Boolean>of(calculatedRemovalTime);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceIds(List<String> historicProcessInstanceIds) {
    this.historicProcessInstanceIds = JsonNullable.<List<String>>of(historicProcessInstanceIds);
    
    return this;
  }

  public SetRemovalTimeToHistoricProcessInstancesDto addHistoricProcessInstanceIdsItem(String historicProcessInstanceIdsItem) {
    if (this.historicProcessInstanceIds == null || !this.historicProcessInstanceIds.isPresent()) {
      this.historicProcessInstanceIds = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.historicProcessInstanceIds.get().add(historicProcessInstanceIdsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The id of the process instance.
   * @return historicProcessInstanceIds
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getHistoricProcessInstanceIds() {
        return historicProcessInstanceIds.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getHistoricProcessInstanceIds_JsonNullable() {
    return historicProcessInstanceIds;
  }
  
  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_IDS)
  public void setHistoricProcessInstanceIds_JsonNullable(JsonNullable<List<String>> historicProcessInstanceIds) {
    this.historicProcessInstanceIds = historicProcessInstanceIds;
  }

  public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
    this.historicProcessInstanceIds = JsonNullable.<List<String>>of(historicProcessInstanceIds);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  @JsonProperty(JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto hierarchical(Boolean hierarchical) {
    this.hierarchical = JsonNullable.<Boolean>of(hierarchical);
    
    return this;
  }

   /**
   * Sets the removal time to all historic process instances in the hierarchy. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return hierarchical
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getHierarchical() {
        return hierarchical.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_HIERARCHICAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getHierarchical_JsonNullable() {
    return hierarchical;
  }
  
  @JsonProperty(JSON_PROPERTY_HIERARCHICAL)
  public void setHierarchical_JsonNullable(JsonNullable<Boolean> hierarchical) {
    this.hierarchical = hierarchical;
  }

  public void setHierarchical(Boolean hierarchical) {
    this.hierarchical = JsonNullable.<Boolean>of(hierarchical);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto updateInChunks(Boolean updateInChunks) {
    this.updateInChunks = JsonNullable.<Boolean>of(updateInChunks);
    
    return this;
  }

   /**
   * Handles removal time updates in chunks, taking into account the defined size in &#x60;removalTimeUpdateChunkSize&#x60; in the process engine configuration. The size of the  chunks can also be overridden per call with the &#x60;updateChunkSize&#x60; parameter. Enabling this option can lead to multiple executions of the resulting jobs, preventing the database transaction from timing out by limiting the number of rows to update. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return updateInChunks
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUpdateInChunks() {
        return updateInChunks.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATE_IN_CHUNKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUpdateInChunks_JsonNullable() {
    return updateInChunks;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATE_IN_CHUNKS)
  public void setUpdateInChunks_JsonNullable(JsonNullable<Boolean> updateInChunks) {
    this.updateInChunks = updateInChunks;
  }

  public void setUpdateInChunks(Boolean updateInChunks) {
    this.updateInChunks = JsonNullable.<Boolean>of(updateInChunks);
  }


  public SetRemovalTimeToHistoricProcessInstancesDto updateChunkSize(Integer updateChunkSize) {
    this.updateChunkSize = JsonNullable.<Integer>of(updateChunkSize);
    
    return this;
  }

   /**
   * Defines the size of the chunks in which removal time updates are processed. The value must be a positive integer between &#x60;1&#x60; and &#x60;500&#x60;. This only has an  effect if &#x60;updateInChunks&#x60; is set to &#x60;true&#x60;. If undefined, the operation uses the  &#x60;removalTimeUpdateChunkSize&#x60; defined in the process engine configuration.
   * @return updateChunkSize
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getUpdateChunkSize() {
        return updateChunkSize.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATE_CHUNK_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getUpdateChunkSize_JsonNullable() {
    return updateChunkSize;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATE_CHUNK_SIZE)
  public void setUpdateChunkSize_JsonNullable(JsonNullable<Integer> updateChunkSize) {
    this.updateChunkSize = updateChunkSize;
  }

  public void setUpdateChunkSize(Integer updateChunkSize) {
    this.updateChunkSize = JsonNullable.<Integer>of(updateChunkSize);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto = (SetRemovalTimeToHistoricProcessInstancesDto) o;
    return equalsNullable(this.absoluteRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.absoluteRemovalTime) &&
        equalsNullable(this.clearedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.clearedRemovalTime) &&
        equalsNullable(this.calculatedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.calculatedRemovalTime) &&
        equalsNullable(this.historicProcessInstanceIds, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceIds) &&
        Objects.equals(this.historicProcessInstanceQuery, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceQuery) &&
        equalsNullable(this.hierarchical, setRemovalTimeToHistoricProcessInstancesDto.hierarchical) &&
        equalsNullable(this.updateInChunks, setRemovalTimeToHistoricProcessInstancesDto.updateInChunks) &&
        equalsNullable(this.updateChunkSize, setRemovalTimeToHistoricProcessInstancesDto.updateChunkSize);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(absoluteRemovalTime), hashCodeNullable(clearedRemovalTime), hashCodeNullable(calculatedRemovalTime), hashCodeNullable(historicProcessInstanceIds), historicProcessInstanceQuery, hashCodeNullable(hierarchical), hashCodeNullable(updateInChunks), hashCodeNullable(updateChunkSize));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetRemovalTimeToHistoricProcessInstancesDto {\n");
    sb.append("    absoluteRemovalTime: ").append(toIndentedString(absoluteRemovalTime)).append("\n");
    sb.append("    clearedRemovalTime: ").append(toIndentedString(clearedRemovalTime)).append("\n");
    sb.append("    calculatedRemovalTime: ").append(toIndentedString(calculatedRemovalTime)).append("\n");
    sb.append("    historicProcessInstanceIds: ").append(toIndentedString(historicProcessInstanceIds)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("    hierarchical: ").append(toIndentedString(hierarchical)).append("\n");
    sb.append("    updateInChunks: ").append(toIndentedString(updateInChunks)).append("\n");
    sb.append("    updateChunkSize: ").append(toIndentedString(updateChunkSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `absoluteRemovalTime` to the URL query string
    if (getAbsoluteRemovalTime() != null) {
      try {
        joiner.add(String.format("%sabsoluteRemovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAbsoluteRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `clearedRemovalTime` to the URL query string
    if (getClearedRemovalTime() != null) {
      try {
        joiner.add(String.format("%sclearedRemovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getClearedRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `calculatedRemovalTime` to the URL query string
    if (getCalculatedRemovalTime() != null) {
      try {
        joiner.add(String.format("%scalculatedRemovalTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCalculatedRemovalTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `historicProcessInstanceIds` to the URL query string
    if (getHistoricProcessInstanceIds() != null) {
      for (int i = 0; i < getHistoricProcessInstanceIds().size(); i++) {
        try {
          joiner.add(String.format("%shistoricProcessInstanceIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getHistoricProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `historicProcessInstanceQuery` to the URL query string
    if (getHistoricProcessInstanceQuery() != null) {
      joiner.add(getHistoricProcessInstanceQuery().toUrlQueryString(prefix + "historicProcessInstanceQuery" + suffix));
    }

    // add `hierarchical` to the URL query string
    if (getHierarchical() != null) {
      try {
        joiner.add(String.format("%shierarchical%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHierarchical()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateInChunks` to the URL query string
    if (getUpdateInChunks() != null) {
      try {
        joiner.add(String.format("%supdateInChunks%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateInChunks()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateChunkSize` to the URL query string
    if (getUpdateChunkSize() != null) {
      try {
        joiner.add(String.format("%supdateChunkSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateChunkSize()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

