/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationInstructionDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * StartProcessInstanceDto
 */
@JsonPropertyOrder({
  StartProcessInstanceDto.JSON_PROPERTY_BUSINESS_KEY,
  StartProcessInstanceDto.JSON_PROPERTY_VARIABLES,
  StartProcessInstanceDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  StartProcessInstanceDto.JSON_PROPERTY_START_INSTRUCTIONS,
  StartProcessInstanceDto.JSON_PROPERTY_SKIP_CUSTOM_LISTENERS,
  StartProcessInstanceDto.JSON_PROPERTY_SKIP_IO_MAPPINGS,
  StartProcessInstanceDto.JSON_PROPERTY_WITH_VARIABLES_IN_RETURN
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class StartProcessInstanceDto {
  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_START_INSTRUCTIONS = "startInstructions";
  private JsonNullable<List<ProcessInstanceModificationInstructionDto>> startInstructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>undefined();

  public static final String JSON_PROPERTY_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
  private JsonNullable<Boolean> skipCustomListeners = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_SKIP_IO_MAPPINGS = "skipIoMappings";
  private JsonNullable<Boolean> skipIoMappings = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_WITH_VARIABLES_IN_RETURN = "withVariablesInReturn";
  private JsonNullable<Boolean> withVariablesInReturn = JsonNullable.<Boolean>undefined();

  public StartProcessInstanceDto() {
  }

  public StartProcessInstanceDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * The business key of the process instance.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }


  public StartProcessInstanceDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public StartProcessInstanceDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * 
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }


  public StartProcessInstanceDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The case instance id the process instance is to be initialized with.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public StartProcessInstanceDto startInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
    this.startInstructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(startInstructions);
    
    return this;
  }

  public StartProcessInstanceDto addStartInstructionsItem(ProcessInstanceModificationInstructionDto startInstructionsItem) {
    if (this.startInstructions == null || !this.startInstructions.isPresent()) {
      this.startInstructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(new ArrayList<>());
    }
    try {
      this.startInstructions.get().add(startInstructionsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.
   * @return startInstructions
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<ProcessInstanceModificationInstructionDto> getStartInstructions() {
        return startInstructions.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_START_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<ProcessInstanceModificationInstructionDto>> getStartInstructions_JsonNullable() {
    return startInstructions;
  }
  
  @JsonProperty(JSON_PROPERTY_START_INSTRUCTIONS)
  public void setStartInstructions_JsonNullable(JsonNullable<List<ProcessInstanceModificationInstructionDto>> startInstructions) {
    this.startInstructions = startInstructions;
  }

  public void setStartInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
    this.startInstructions = JsonNullable.<List<ProcessInstanceModificationInstructionDto>>of(startInstructions);
  }


  public StartProcessInstanceDto skipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
    
    return this;
  }

   /**
   * Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the &#x60;startInstructions&#x60; property.
   * @return skipCustomListeners
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipCustomListeners() {
        return skipCustomListeners.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipCustomListeners_JsonNullable() {
    return skipCustomListeners;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_CUSTOM_LISTENERS)
  public void setSkipCustomListeners_JsonNullable(JsonNullable<Boolean> skipCustomListeners) {
    this.skipCustomListeners = skipCustomListeners;
  }

  public void setSkipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = JsonNullable.<Boolean>of(skipCustomListeners);
  }


  public StartProcessInstanceDto skipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
    
    return this;
  }

   /**
   * Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.21/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the &#x60;startInstructions&#x60; property.
   * @return skipIoMappings
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSkipIoMappings() {
        return skipIoMappings.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSkipIoMappings_JsonNullable() {
    return skipIoMappings;
  }
  
  @JsonProperty(JSON_PROPERTY_SKIP_IO_MAPPINGS)
  public void setSkipIoMappings_JsonNullable(JsonNullable<Boolean> skipIoMappings) {
    this.skipIoMappings = skipIoMappings;
  }

  public void setSkipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = JsonNullable.<Boolean>of(skipIoMappings);
  }


  public StartProcessInstanceDto withVariablesInReturn(Boolean withVariablesInReturn) {
    this.withVariablesInReturn = JsonNullable.<Boolean>of(withVariablesInReturn);
    
    return this;
  }

   /**
   * Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: &#x60;false&#x60;
   * @return withVariablesInReturn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithVariablesInReturn() {
        return withVariablesInReturn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_VARIABLES_IN_RETURN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithVariablesInReturn_JsonNullable() {
    return withVariablesInReturn;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_VARIABLES_IN_RETURN)
  public void setWithVariablesInReturn_JsonNullable(JsonNullable<Boolean> withVariablesInReturn) {
    this.withVariablesInReturn = withVariablesInReturn;
  }

  public void setWithVariablesInReturn(Boolean withVariablesInReturn) {
    this.withVariablesInReturn = JsonNullable.<Boolean>of(withVariablesInReturn);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StartProcessInstanceDto startProcessInstanceDto = (StartProcessInstanceDto) o;
    return equalsNullable(this.businessKey, startProcessInstanceDto.businessKey) &&
        equalsNullable(this.variables, startProcessInstanceDto.variables) &&
        equalsNullable(this.caseInstanceId, startProcessInstanceDto.caseInstanceId) &&
        equalsNullable(this.startInstructions, startProcessInstanceDto.startInstructions) &&
        equalsNullable(this.skipCustomListeners, startProcessInstanceDto.skipCustomListeners) &&
        equalsNullable(this.skipIoMappings, startProcessInstanceDto.skipIoMappings) &&
        equalsNullable(this.withVariablesInReturn, startProcessInstanceDto.withVariablesInReturn);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(businessKey), hashCodeNullable(variables), hashCodeNullable(caseInstanceId), hashCodeNullable(startInstructions), hashCodeNullable(skipCustomListeners), hashCodeNullable(skipIoMappings), hashCodeNullable(withVariablesInReturn));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StartProcessInstanceDto {\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    startInstructions: ").append(toIndentedString(startInstructions)).append("\n");
    sb.append("    skipCustomListeners: ").append(toIndentedString(skipCustomListeners)).append("\n");
    sb.append("    skipIoMappings: ").append(toIndentedString(skipIoMappings)).append("\n");
    sb.append("    withVariablesInReturn: ").append(toIndentedString(withVariablesInReturn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startInstructions` to the URL query string
    if (getStartInstructions() != null) {
      for (int i = 0; i < getStartInstructions().size(); i++) {
        if (getStartInstructions().get(i) != null) {
          joiner.add(getStartInstructions().get(i).toUrlQueryString(String.format("%sstartInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `skipCustomListeners` to the URL query string
    if (getSkipCustomListeners() != null) {
      try {
        joiner.add(String.format("%sskipCustomListeners%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipCustomListeners()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `skipIoMappings` to the URL query string
    if (getSkipIoMappings() != null) {
      try {
        joiner.add(String.format("%sskipIoMappings%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSkipIoMappings()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withVariablesInReturn` to the URL query string
    if (getWithVariablesInReturn() != null) {
      try {
        joiner.add(String.format("%swithVariablesInReturn%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithVariablesInReturn()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

