/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * StartProcessInstanceFormDto
 */
@JsonPropertyOrder({
  StartProcessInstanceFormDto.JSON_PROPERTY_VARIABLES,
  StartProcessInstanceFormDto.JSON_PROPERTY_BUSINESS_KEY
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class StartProcessInstanceFormDto {
  public static final String JSON_PROPERTY_VARIABLES = "variables";
  private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.<Map<String, VariableValueDto>>undefined();

  public static final String JSON_PROPERTY_BUSINESS_KEY = "businessKey";
  private JsonNullable<String> businessKey = JsonNullable.<String>undefined();

  public StartProcessInstanceFormDto() {
  }

  public StartProcessInstanceFormDto variables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
    
    return this;
  }

  public StartProcessInstanceFormDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null || !this.variables.isPresent()) {
      this.variables = JsonNullable.<Map<String, VariableValueDto>>of(new HashMap<>());
    }
    try {
      this.variables.get().put(key, variablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * 
   * @return variables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Map<String, VariableValueDto> getVariables() {
        return variables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
    return variables;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
    this.variables = variables;
  }

  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = JsonNullable.<Map<String, VariableValueDto>>of(variables);
  }


  public StartProcessInstanceFormDto businessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
    
    return this;
  }

   /**
   * The business key the process instance is to be initialized with. The business key uniquely identifies the process instance in the context of the given process definition.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getBusinessKey() {
        return businessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBusinessKey_JsonNullable() {
    return businessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_BUSINESS_KEY)
  public void setBusinessKey_JsonNullable(JsonNullable<String> businessKey) {
    this.businessKey = businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = JsonNullable.<String>of(businessKey);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StartProcessInstanceFormDto startProcessInstanceFormDto = (StartProcessInstanceFormDto) o;
    return equalsNullable(this.variables, startProcessInstanceFormDto.variables) &&
        equalsNullable(this.businessKey, startProcessInstanceFormDto.businessKey);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(variables), hashCodeNullable(businessKey));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StartProcessInstanceFormDto {\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        if (getVariables().get(_key) != null) {
          joiner.add(getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `businessKey` to the URL query string
    if (getBusinessKey() != null) {
      try {
        joiner.add(String.format("%sbusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

