/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.camunda.community.rest.client.dto.CamundaFormRef;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * TaskDto
 */
@JsonPropertyOrder({
  TaskDto.JSON_PROPERTY_ID,
  TaskDto.JSON_PROPERTY_NAME,
  TaskDto.JSON_PROPERTY_ASSIGNEE,
  TaskDto.JSON_PROPERTY_OWNER,
  TaskDto.JSON_PROPERTY_CREATED,
  TaskDto.JSON_PROPERTY_LAST_UPDATED,
  TaskDto.JSON_PROPERTY_DUE,
  TaskDto.JSON_PROPERTY_FOLLOW_UP,
  TaskDto.JSON_PROPERTY_DELEGATION_STATE,
  TaskDto.JSON_PROPERTY_DESCRIPTION,
  TaskDto.JSON_PROPERTY_EXECUTION_ID,
  TaskDto.JSON_PROPERTY_PARENT_TASK_ID,
  TaskDto.JSON_PROPERTY_PRIORITY,
  TaskDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  TaskDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  TaskDto.JSON_PROPERTY_CASE_EXECUTION_ID,
  TaskDto.JSON_PROPERTY_CASE_DEFINITION_ID,
  TaskDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  TaskDto.JSON_PROPERTY_TASK_DEFINITION_KEY,
  TaskDto.JSON_PROPERTY_SUSPENDED,
  TaskDto.JSON_PROPERTY_FORM_KEY,
  TaskDto.JSON_PROPERTY_CAMUNDA_FORM_REF,
  TaskDto.JSON_PROPERTY_TENANT_ID
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TaskDto {
  public static final String JSON_PROPERTY_ID = "id";
  private JsonNullable<String> id = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private JsonNullable<String> assignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OWNER = "owner";
  private JsonNullable<String> owner = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATED = "created";
  private JsonNullable<OffsetDateTime> created = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
  private JsonNullable<OffsetDateTime> lastUpdated = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DUE = "due";
  private JsonNullable<OffsetDateTime> due = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP = "followUp";
  private JsonNullable<OffsetDateTime> followUp = JsonNullable.<OffsetDateTime>undefined();

  /**
   * The task&#39;s delegation state. Possible values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   */
  public enum DelegationStateEnum {
    PENDING("PENDING"),
    
    RESOLVED("RESOLVED");

    private String value;

    DelegationStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DelegationStateEnum fromValue(String value) {
      for (DelegationStateEnum b : DelegationStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_DELEGATION_STATE = "delegationState";
  private JsonNullable<DelegationStateEnum> delegationState = JsonNullable.<DelegationStateEnum>undefined();

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private JsonNullable<String> description = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PARENT_TASK_ID = "parentTaskId";
  private JsonNullable<String> parentTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Integer> priority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID = "caseExecutionId";
  private JsonNullable<String> caseExecutionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_ID = "caseDefinitionId";
  private JsonNullable<String> caseDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY = "taskDefinitionKey";
  private JsonNullable<String> taskDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>undefined();

  public static final String JSON_PROPERTY_FORM_KEY = "formKey";
  private JsonNullable<String> formKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CAMUNDA_FORM_REF = "camundaFormRef";
  private CamundaFormRef camundaFormRef;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  private JsonNullable<String> tenantId = JsonNullable.<String>undefined();

  public TaskDto() {
  }

  public TaskDto id(String id) {
    this.id = JsonNullable.<String>of(id);
    
    return this;
  }

   /**
   * The task id.
   * @return id
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getId() {
        return id.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getId_JsonNullable() {
    return id;
  }
  
  @JsonProperty(JSON_PROPERTY_ID)
  public void setId_JsonNullable(JsonNullable<String> id) {
    this.id = id;
  }

  public void setId(String id) {
    this.id = JsonNullable.<String>of(id);
  }


  public TaskDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * The task name.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public TaskDto assignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
    
    return this;
  }

   /**
   * The assignee&#39;s id.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssignee() {
        return assignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssignee_JsonNullable() {
    return assignee;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  public void setAssignee_JsonNullable(JsonNullable<String> assignee) {
    this.assignee = assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
  }


  public TaskDto owner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
    
    return this;
  }

   /**
   * The owner&#39;s id.
   * @return owner
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getOwner() {
        return owner.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOwner_JsonNullable() {
    return owner;
  }
  
  @JsonProperty(JSON_PROPERTY_OWNER)
  public void setOwner_JsonNullable(JsonNullable<String> owner) {
    this.owner = owner;
  }

  public void setOwner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
  }


  public TaskDto created(OffsetDateTime created) {
    this.created = JsonNullable.<OffsetDateTime>of(created);
    
    return this;
  }

   /**
   * The date the task was created on. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return created
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreated() {
        return created.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreated_JsonNullable() {
    return created;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED)
  public void setCreated_JsonNullable(JsonNullable<OffsetDateTime> created) {
    this.created = created;
  }

  public void setCreated(OffsetDateTime created) {
    this.created = JsonNullable.<OffsetDateTime>of(created);
  }


  public TaskDto lastUpdated(OffsetDateTime lastUpdated) {
    this.lastUpdated = JsonNullable.<OffsetDateTime>of(lastUpdated);
    
    return this;
  }

   /**
   * The date the task was last updated. Every action that fires a [task update event](https://docs.camunda.org/manual/7.21/user-guide/process-engine/delegation-code/#task-listener-event-lifecycle) will update this property. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return lastUpdated
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getLastUpdated() {
        return lastUpdated.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getLastUpdated_JsonNullable() {
    return lastUpdated;
  }
  
  @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  public void setLastUpdated_JsonNullable(JsonNullable<OffsetDateTime> lastUpdated) {
    this.lastUpdated = lastUpdated;
  }

  public void setLastUpdated(OffsetDateTime lastUpdated) {
    this.lastUpdated = JsonNullable.<OffsetDateTime>of(lastUpdated);
  }


  public TaskDto due(OffsetDateTime due) {
    this.due = JsonNullable.<OffsetDateTime>of(due);
    
    return this;
  }

   /**
   * The task&#39;s due date. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return due
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDue() {
        return due.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDue_JsonNullable() {
    return due;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE)
  public void setDue_JsonNullable(JsonNullable<OffsetDateTime> due) {
    this.due = due;
  }

  public void setDue(OffsetDateTime due) {
    this.due = JsonNullable.<OffsetDateTime>of(due);
  }


  public TaskDto followUp(OffsetDateTime followUp) {
    this.followUp = JsonNullable.<OffsetDateTime>of(followUp);
    
    return this;
  }

   /**
   * The follow-up date for the task. [Default format](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return followUp
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFollowUp() {
        return followUp.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFollowUp_JsonNullable() {
    return followUp;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP)
  public void setFollowUp_JsonNullable(JsonNullable<OffsetDateTime> followUp) {
    this.followUp = followUp;
  }

  public void setFollowUp(OffsetDateTime followUp) {
    this.followUp = JsonNullable.<OffsetDateTime>of(followUp);
  }


  public TaskDto delegationState(DelegationStateEnum delegationState) {
    this.delegationState = JsonNullable.<DelegationStateEnum>of(delegationState);
    
    return this;
  }

   /**
   * The task&#39;s delegation state. Possible values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   * @return delegationState
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public DelegationStateEnum getDelegationState() {
        return delegationState.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELEGATION_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<DelegationStateEnum> getDelegationState_JsonNullable() {
    return delegationState;
  }
  
  @JsonProperty(JSON_PROPERTY_DELEGATION_STATE)
  public void setDelegationState_JsonNullable(JsonNullable<DelegationStateEnum> delegationState) {
    this.delegationState = delegationState;
  }

  public void setDelegationState(DelegationStateEnum delegationState) {
    this.delegationState = JsonNullable.<DelegationStateEnum>of(delegationState);
  }


  public TaskDto description(String description) {
    this.description = JsonNullable.<String>of(description);
    
    return this;
  }

   /**
   * The task&#39;s description.
   * @return description
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDescription() {
        return description.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDescription_JsonNullable() {
    return description;
  }
  
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  public void setDescription_JsonNullable(JsonNullable<String> description) {
    this.description = description;
  }

  public void setDescription(String description) {
    this.description = JsonNullable.<String>of(description);
  }


  public TaskDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * The id of the execution the task belongs to.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public TaskDto parentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
    
    return this;
  }

   /**
   * The id the parent task, if this task is a subtask.
   * @return parentTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getParentTaskId() {
        return parentTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getParentTaskId_JsonNullable() {
    return parentTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  public void setParentTaskId_JsonNullable(JsonNullable<String> parentTaskId) {
    this.parentTaskId = parentTaskId;
  }

  public void setParentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
  }


  public TaskDto priority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
    
    return this;
  }

   /**
   * The task&#39;s priority.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Integer> priority) {
    this.priority = priority;
  }

  public void setPriority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
  }


  public TaskDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * The id of the process definition the task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public TaskDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * The id of the process instance the task belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public TaskDto caseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
    
    return this;
  }

   /**
   * The id of the case execution the task belongs to.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseExecutionId() {
        return caseExecutionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseExecutionId_JsonNullable() {
    return caseExecutionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  public void setCaseExecutionId_JsonNullable(JsonNullable<String> caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }

  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
  }


  public TaskDto caseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
    
    return this;
  }

   /**
   * The id of the case definition the task belongs to.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionId() {
        return caseDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionId_JsonNullable() {
    return caseDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  public void setCaseDefinitionId_JsonNullable(JsonNullable<String> caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }

  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
  }


  public TaskDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * The id of the case instance the task belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public TaskDto taskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
    
    return this;
  }

   /**
   * The task&#39;s key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDefinitionKey() {
        return taskDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDefinitionKey_JsonNullable() {
    return taskDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  public void setTaskDefinitionKey_JsonNullable(JsonNullable<String> taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }

  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
  }


  public TaskDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Whether the task belongs to a process instance that is suspended.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public TaskDto formKey(String formKey) {
    this.formKey = JsonNullable.<String>of(formKey);
    
    return this;
  }

   /**
   * If not &#x60;null&#x60;, the form key for the task.
   * @return formKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFormKey() {
        return formKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFormKey_JsonNullable() {
    return formKey;
  }
  
  @JsonProperty(JSON_PROPERTY_FORM_KEY)
  public void setFormKey_JsonNullable(JsonNullable<String> formKey) {
    this.formKey = formKey;
  }

  public void setFormKey(String formKey) {
    this.formKey = JsonNullable.<String>of(formKey);
  }


  public TaskDto camundaFormRef(CamundaFormRef camundaFormRef) {
    
    this.camundaFormRef = camundaFormRef;
    return this;
  }

   /**
   * Get camundaFormRef
   * @return camundaFormRef
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMUNDA_FORM_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CamundaFormRef getCamundaFormRef() {
    return camundaFormRef;
  }


  @JsonProperty(JSON_PROPERTY_CAMUNDA_FORM_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCamundaFormRef(CamundaFormRef camundaFormRef) {
    this.camundaFormRef = camundaFormRef;
  }


  public TaskDto tenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
    
    return this;
  }

   /**
   * If not &#x60;null&#x60;, the tenant id of the task.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTenantId() {
        return tenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTenantId_JsonNullable() {
    return tenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  public void setTenantId_JsonNullable(JsonNullable<String> tenantId) {
    this.tenantId = tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = JsonNullable.<String>of(tenantId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskDto taskDto = (TaskDto) o;
    return equalsNullable(this.id, taskDto.id) &&
        equalsNullable(this.name, taskDto.name) &&
        equalsNullable(this.assignee, taskDto.assignee) &&
        equalsNullable(this.owner, taskDto.owner) &&
        equalsNullable(this.created, taskDto.created) &&
        equalsNullable(this.lastUpdated, taskDto.lastUpdated) &&
        equalsNullable(this.due, taskDto.due) &&
        equalsNullable(this.followUp, taskDto.followUp) &&
        equalsNullable(this.delegationState, taskDto.delegationState) &&
        equalsNullable(this.description, taskDto.description) &&
        equalsNullable(this.executionId, taskDto.executionId) &&
        equalsNullable(this.parentTaskId, taskDto.parentTaskId) &&
        equalsNullable(this.priority, taskDto.priority) &&
        equalsNullable(this.processDefinitionId, taskDto.processDefinitionId) &&
        equalsNullable(this.processInstanceId, taskDto.processInstanceId) &&
        equalsNullable(this.caseExecutionId, taskDto.caseExecutionId) &&
        equalsNullable(this.caseDefinitionId, taskDto.caseDefinitionId) &&
        equalsNullable(this.caseInstanceId, taskDto.caseInstanceId) &&
        equalsNullable(this.taskDefinitionKey, taskDto.taskDefinitionKey) &&
        equalsNullable(this.suspended, taskDto.suspended) &&
        equalsNullable(this.formKey, taskDto.formKey) &&
        Objects.equals(this.camundaFormRef, taskDto.camundaFormRef) &&
        equalsNullable(this.tenantId, taskDto.tenantId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(id), hashCodeNullable(name), hashCodeNullable(assignee), hashCodeNullable(owner), hashCodeNullable(created), hashCodeNullable(lastUpdated), hashCodeNullable(due), hashCodeNullable(followUp), hashCodeNullable(delegationState), hashCodeNullable(description), hashCodeNullable(executionId), hashCodeNullable(parentTaskId), hashCodeNullable(priority), hashCodeNullable(processDefinitionId), hashCodeNullable(processInstanceId), hashCodeNullable(caseExecutionId), hashCodeNullable(caseDefinitionId), hashCodeNullable(caseInstanceId), hashCodeNullable(taskDefinitionKey), hashCodeNullable(suspended), hashCodeNullable(formKey), camundaFormRef, hashCodeNullable(tenantId));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
    sb.append("    due: ").append(toIndentedString(due)).append("\n");
    sb.append("    followUp: ").append(toIndentedString(followUp)).append("\n");
    sb.append("    delegationState: ").append(toIndentedString(delegationState)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    parentTaskId: ").append(toIndentedString(parentTaskId)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    camundaFormRef: ").append(toIndentedString(camundaFormRef)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `owner` to the URL query string
    if (getOwner() != null) {
      try {
        joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwner()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `created` to the URL query string
    if (getCreated() != null) {
      try {
        joiner.add(String.format("%screated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreated()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `lastUpdated` to the URL query string
    if (getLastUpdated() != null) {
      try {
        joiner.add(String.format("%slastUpdated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLastUpdated()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `due` to the URL query string
    if (getDue() != null) {
      try {
        joiner.add(String.format("%sdue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUp` to the URL query string
    if (getFollowUp() != null) {
      try {
        joiner.add(String.format("%sfollowUp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUp()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `delegationState` to the URL query string
    if (getDelegationState() != null) {
      try {
        joiner.add(String.format("%sdelegationState%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDelegationState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentTaskId` to the URL query string
    if (getParentTaskId() != null) {
      try {
        joiner.add(String.format("%sparentTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionId` to the URL query string
    if (getCaseExecutionId() != null) {
      try {
        joiner.add(String.format("%scaseExecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionId` to the URL query string
    if (getCaseDefinitionId() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKey` to the URL query string
    if (getTaskDefinitionKey() != null) {
      try {
        joiner.add(String.format("%staskDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `formKey` to the URL query string
    if (getFormKey() != null) {
      try {
        joiner.add(String.format("%sformKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFormKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `camundaFormRef` to the URL query string
    if (getCamundaFormRef() != null) {
      joiner.add(getCamundaFormRef().toUrlQueryString(prefix + "camundaFormRef" + suffix));
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

