/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.21.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.community.rest.client.dto.TaskQueryDtoSortingInner;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * A Task query which defines a group of Tasks.
 */
@JsonPropertyOrder({
  TaskQueryDto.JSON_PROPERTY_TASK_ID,
  TaskQueryDto.JSON_PROPERTY_TASK_ID_IN,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_ID_IN,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE,
  TaskQueryDto.JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  TaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  TaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN,
  TaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  TaskQueryDto.JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE,
  TaskQueryDto.JSON_PROPERTY_EXECUTION_ID,
  TaskQueryDto.JSON_PROPERTY_CASE_INSTANCE_ID,
  TaskQueryDto.JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY,
  TaskQueryDto.JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY_LIKE,
  TaskQueryDto.JSON_PROPERTY_CASE_DEFINITION_ID,
  TaskQueryDto.JSON_PROPERTY_CASE_DEFINITION_KEY,
  TaskQueryDto.JSON_PROPERTY_CASE_DEFINITION_NAME,
  TaskQueryDto.JSON_PROPERTY_CASE_DEFINITION_NAME_LIKE,
  TaskQueryDto.JSON_PROPERTY_CASE_EXECUTION_ID,
  TaskQueryDto.JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN,
  TaskQueryDto.JSON_PROPERTY_TENANT_ID_IN,
  TaskQueryDto.JSON_PROPERTY_WITHOUT_TENANT_ID,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE_LIKE,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE_LIKE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE_IN,
  TaskQueryDto.JSON_PROPERTY_ASSIGNEE_NOT_IN,
  TaskQueryDto.JSON_PROPERTY_OWNER,
  TaskQueryDto.JSON_PROPERTY_OWNER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_GROUP,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_GROUP_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_USER,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_USER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_INCLUDE_ASSIGNED_TASKS,
  TaskQueryDto.JSON_PROPERTY_INVOLVED_USER,
  TaskQueryDto.JSON_PROPERTY_INVOLVED_USER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_ASSIGNED,
  TaskQueryDto.JSON_PROPERTY_UNASSIGNED,
  TaskQueryDto.JSON_PROPERTY_TASK_DEFINITION_KEY,
  TaskQueryDto.JSON_PROPERTY_TASK_DEFINITION_KEY_IN,
  TaskQueryDto.JSON_PROPERTY_TASK_DEFINITION_KEY_LIKE,
  TaskQueryDto.JSON_PROPERTY_NAME,
  TaskQueryDto.JSON_PROPERTY_NAME_NOT_EQUAL,
  TaskQueryDto.JSON_PROPERTY_NAME_LIKE,
  TaskQueryDto.JSON_PROPERTY_NAME_NOT_LIKE,
  TaskQueryDto.JSON_PROPERTY_DESCRIPTION,
  TaskQueryDto.JSON_PROPERTY_DESCRIPTION_LIKE,
  TaskQueryDto.JSON_PROPERTY_PRIORITY,
  TaskQueryDto.JSON_PROPERTY_MAX_PRIORITY,
  TaskQueryDto.JSON_PROPERTY_MIN_PRIORITY,
  TaskQueryDto.JSON_PROPERTY_DUE_DATE,
  TaskQueryDto.JSON_PROPERTY_DUE_DATE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_DUE_AFTER,
  TaskQueryDto.JSON_PROPERTY_DUE_AFTER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_DUE_BEFORE,
  TaskQueryDto.JSON_PROPERTY_DUE_BEFORE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_WITHOUT_DUE_DATE,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_DATE,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_DATE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_AFTER,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_AFTER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_BEFORE,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_BEFORE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT,
  TaskQueryDto.JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_CREATED_ON,
  TaskQueryDto.JSON_PROPERTY_CREATED_ON_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_CREATED_AFTER,
  TaskQueryDto.JSON_PROPERTY_CREATED_AFTER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_CREATED_BEFORE,
  TaskQueryDto.JSON_PROPERTY_CREATED_BEFORE_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_UPDATED_AFTER,
  TaskQueryDto.JSON_PROPERTY_UPDATED_AFTER_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_DELEGATION_STATE,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_GROUPS,
  TaskQueryDto.JSON_PROPERTY_CANDIDATE_GROUPS_EXPRESSION,
  TaskQueryDto.JSON_PROPERTY_WITH_CANDIDATE_GROUPS,
  TaskQueryDto.JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS,
  TaskQueryDto.JSON_PROPERTY_WITH_CANDIDATE_USERS,
  TaskQueryDto.JSON_PROPERTY_WITHOUT_CANDIDATE_USERS,
  TaskQueryDto.JSON_PROPERTY_ACTIVE,
  TaskQueryDto.JSON_PROPERTY_SUSPENDED,
  TaskQueryDto.JSON_PROPERTY_TASK_VARIABLES,
  TaskQueryDto.JSON_PROPERTY_PROCESS_VARIABLES,
  TaskQueryDto.JSON_PROPERTY_CASE_INSTANCE_VARIABLES,
  TaskQueryDto.JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE,
  TaskQueryDto.JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE,
  TaskQueryDto.JSON_PROPERTY_PARENT_TASK_ID,
  TaskQueryDto.JSON_PROPERTY_OR_QUERIES,
  TaskQueryDto.JSON_PROPERTY_SORTING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-04T13:43:01.451833574Z[Etc/UTC]")
public class TaskQueryDto {
  public static final String JSON_PROPERTY_TASK_ID = "taskId";
  private JsonNullable<String> taskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_ID_IN = "taskIdIn";
  private JsonNullable<List<String>> taskIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID = "processInstanceId";
  private JsonNullable<String> processInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
  private JsonNullable<List<String>> processInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
  private JsonNullable<String> processInstanceBusinessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_EXPRESSION = "processInstanceBusinessKeyExpression";
  private JsonNullable<String> processInstanceBusinessKeyExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
  private JsonNullable<List<String>> processInstanceBusinessKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
  private JsonNullable<String> processInstanceBusinessKeyLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE_EXPRESSION = "processInstanceBusinessKeyLikeExpression";
  private JsonNullable<String> processInstanceBusinessKeyLikeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  private JsonNullable<String> processDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private JsonNullable<String> processDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
  private JsonNullable<List<String>> processDefinitionKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  private JsonNullable<String> processDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE = "processDefinitionNameLike";
  private JsonNullable<String> processDefinitionNameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EXECUTION_ID = "executionId";
  private JsonNullable<String> executionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_ID = "caseInstanceId";
  private JsonNullable<String> caseInstanceId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY = "caseInstanceBusinessKey";
  private JsonNullable<String> caseInstanceBusinessKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY_LIKE = "caseInstanceBusinessKeyLike";
  private JsonNullable<String> caseInstanceBusinessKeyLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_ID = "caseDefinitionId";
  private JsonNullable<String> caseDefinitionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_KEY = "caseDefinitionKey";
  private JsonNullable<String> caseDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_NAME = "caseDefinitionName";
  private JsonNullable<String> caseDefinitionName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_DEFINITION_NAME_LIKE = "caseDefinitionNameLike";
  private JsonNullable<String> caseDefinitionNameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CASE_EXECUTION_ID = "caseExecutionId";
  private JsonNullable<String> caseExecutionId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  private JsonNullable<List<String>> activityInstanceIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TENANT_ID_IN = "tenantIdIn";
  private JsonNullable<List<String>> tenantIdIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_WITHOUT_TENANT_ID = "withoutTenantId";
  private JsonNullable<Boolean> withoutTenantId = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private JsonNullable<String> assignee = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE_EXPRESSION = "assigneeExpression";
  private JsonNullable<String> assigneeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE_LIKE = "assigneeLike";
  private JsonNullable<String> assigneeLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE_LIKE_EXPRESSION = "assigneeLikeExpression";
  private JsonNullable<String> assigneeLikeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE_IN = "assigneeIn";
  private JsonNullable<List<String>> assigneeIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_ASSIGNEE_NOT_IN = "assigneeNotIn";
  private JsonNullable<List<String>> assigneeNotIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_OWNER = "owner";
  private JsonNullable<String> owner = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OWNER_EXPRESSION = "ownerExpression";
  private JsonNullable<String> ownerExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_GROUP = "candidateGroup";
  private JsonNullable<String> candidateGroup = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_GROUP_EXPRESSION = "candidateGroupExpression";
  private JsonNullable<String> candidateGroupExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_USER = "candidateUser";
  private JsonNullable<String> candidateUser = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_USER_EXPRESSION = "candidateUserExpression";
  private JsonNullable<String> candidateUserExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INCLUDE_ASSIGNED_TASKS = "includeAssignedTasks";
  private JsonNullable<Boolean> includeAssignedTasks = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_INVOLVED_USER = "involvedUser";
  private JsonNullable<String> involvedUser = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_INVOLVED_USER_EXPRESSION = "involvedUserExpression";
  private JsonNullable<String> involvedUserExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ASSIGNED = "assigned";
  private JsonNullable<Boolean> assigned = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_UNASSIGNED = "unassigned";
  private JsonNullable<Boolean> unassigned = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY = "taskDefinitionKey";
  private JsonNullable<String> taskDefinitionKey = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY_IN = "taskDefinitionKeyIn";
  private JsonNullable<List<String>> taskDefinitionKeyIn = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_TASK_DEFINITION_KEY_LIKE = "taskDefinitionKeyLike";
  private JsonNullable<String> taskDefinitionKeyLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME = "name";
  private JsonNullable<String> name = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME_NOT_EQUAL = "nameNotEqual";
  private JsonNullable<String> nameNotEqual = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME_LIKE = "nameLike";
  private JsonNullable<String> nameLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_NAME_NOT_LIKE = "nameNotLike";
  private JsonNullable<String> nameNotLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private JsonNullable<String> description = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DESCRIPTION_LIKE = "descriptionLike";
  private JsonNullable<String> descriptionLike = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private JsonNullable<Integer> priority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_MAX_PRIORITY = "maxPriority";
  private JsonNullable<Integer> maxPriority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_MIN_PRIORITY = "minPriority";
  private JsonNullable<Integer> minPriority = JsonNullable.<Integer>undefined();

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private JsonNullable<OffsetDateTime> dueDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DUE_DATE_EXPRESSION = "dueDateExpression";
  private JsonNullable<String> dueDateExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DUE_AFTER = "dueAfter";
  private JsonNullable<OffsetDateTime> dueAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DUE_AFTER_EXPRESSION = "dueAfterExpression";
  private JsonNullable<String> dueAfterExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_DUE_BEFORE = "dueBefore";
  private JsonNullable<OffsetDateTime> dueBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_DUE_BEFORE_EXPRESSION = "dueBeforeExpression";
  private JsonNullable<String> dueBeforeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITHOUT_DUE_DATE = "withoutDueDate";
  private JsonNullable<Boolean> withoutDueDate = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  private JsonNullable<OffsetDateTime> followUpDate = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE_EXPRESSION = "followUpDateExpression";
  private JsonNullable<String> followUpDateExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_AFTER = "followUpAfter";
  private JsonNullable<OffsetDateTime> followUpAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_AFTER_EXPRESSION = "followUpAfterExpression";
  private JsonNullable<String> followUpAfterExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_BEFORE = "followUpBefore";
  private JsonNullable<String> followUpBefore = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_BEFORE_EXPRESSION = "followUpBeforeExpression";
  private JsonNullable<String> followUpBeforeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT = "followUpBeforeOrNotExistent";
  private JsonNullable<OffsetDateTime> followUpBeforeOrNotExistent = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT_EXPRESSION = "followUpBeforeOrNotExistentExpression";
  private JsonNullable<String> followUpBeforeOrNotExistentExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATED_ON = "createdOn";
  private JsonNullable<OffsetDateTime> createdOn = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CREATED_ON_EXPRESSION = "createdOnExpression";
  private JsonNullable<String> createdOnExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATED_AFTER = "createdAfter";
  private JsonNullable<OffsetDateTime> createdAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CREATED_AFTER_EXPRESSION = "createdAfterExpression";
  private JsonNullable<String> createdAfterExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_CREATED_BEFORE = "createdBefore";
  private JsonNullable<OffsetDateTime> createdBefore = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_CREATED_BEFORE_EXPRESSION = "createdBeforeExpression";
  private JsonNullable<String> createdBeforeExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_UPDATED_AFTER = "updatedAfter";
  private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_UPDATED_AFTER_EXPRESSION = "updatedAfterExpression";
  private JsonNullable<String> updatedAfterExpression = JsonNullable.<String>undefined();

  /**
   * Restrict to tasks that are in the given delegation state. Valid values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   */
  public enum DelegationStateEnum {
    PENDING("PENDING"),
    
    RESOLVED("RESOLVED");

    private String value;

    DelegationStateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DelegationStateEnum fromValue(String value) {
      for (DelegationStateEnum b : DelegationStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }
  }

  public static final String JSON_PROPERTY_DELEGATION_STATE = "delegationState";
  private JsonNullable<DelegationStateEnum> delegationState = JsonNullable.<DelegationStateEnum>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
  private JsonNullable<List<String>> candidateGroups = JsonNullable.<List<String>>undefined();

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS_EXPRESSION = "candidateGroupsExpression";
  private JsonNullable<String> candidateGroupsExpression = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_WITH_CANDIDATE_GROUPS = "withCandidateGroups";
  private JsonNullable<Boolean> withCandidateGroups = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS = "withoutCandidateGroups";
  private JsonNullable<Boolean> withoutCandidateGroups = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_WITH_CANDIDATE_USERS = "withCandidateUsers";
  private JsonNullable<Boolean> withCandidateUsers = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_WITHOUT_CANDIDATE_USERS = "withoutCandidateUsers";
  private JsonNullable<Boolean> withoutCandidateUsers = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private JsonNullable<Boolean> active = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_SUSPENDED = "suspended";
  private JsonNullable<Boolean> suspended = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_TASK_VARIABLES = "taskVariables";
  private JsonNullable<List<VariableQueryParameterDto>> taskVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_PROCESS_VARIABLES = "processVariables";
  private JsonNullable<List<VariableQueryParameterDto>> processVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_CASE_INSTANCE_VARIABLES = "caseInstanceVariables";
  private JsonNullable<List<VariableQueryParameterDto>> caseInstanceVariables = JsonNullable.<List<VariableQueryParameterDto>>undefined();

  public static final String JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  private JsonNullable<Boolean> variableNamesIgnoreCase = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  private JsonNullable<Boolean> variableValuesIgnoreCase = JsonNullable.<Boolean>of(false);

  public static final String JSON_PROPERTY_PARENT_TASK_ID = "parentTaskId";
  private JsonNullable<String> parentTaskId = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_OR_QUERIES = "orQueries";
  private JsonNullable<List<TaskQueryDto>> orQueries = JsonNullable.<List<TaskQueryDto>>undefined();

  public static final String JSON_PROPERTY_SORTING = "sorting";
  private JsonNullable<List<TaskQueryDtoSortingInner>> sorting = JsonNullable.<List<TaskQueryDtoSortingInner>>undefined();

  public TaskQueryDto() {
  }

  public TaskQueryDto taskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
    
    return this;
  }

   /**
   * Restrict to task with the given id.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskId() {
        return taskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskId_JsonNullable() {
    return taskId;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID)
  public void setTaskId_JsonNullable(JsonNullable<String> taskId) {
    this.taskId = taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = JsonNullable.<String>of(taskId);
  }


  public TaskQueryDto taskIdIn(List<String> taskIdIn) {
    this.taskIdIn = JsonNullable.<List<String>>of(taskIdIn);
    
    return this;
  }

  public TaskQueryDto addTaskIdInItem(String taskIdInItem) {
    if (this.taskIdIn == null || !this.taskIdIn.isPresent()) {
      this.taskIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.taskIdIn.get().add(taskIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks with any of the given ids.
   * @return taskIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTaskIdIn() {
        return taskIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTaskIdIn_JsonNullable() {
    return taskIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_ID_IN)
  public void setTaskIdIn_JsonNullable(JsonNullable<List<String>> taskIdIn) {
    this.taskIdIn = taskIdIn;
  }

  public void setTaskIdIn(List<String> taskIdIn) {
    this.taskIdIn = JsonNullable.<List<String>>of(taskIdIn);
  }


  public TaskQueryDto processInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to process instances with the given id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceId() {
        return processInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceId_JsonNullable() {
    return processInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID)
  public void setProcessInstanceId_JsonNullable(JsonNullable<String> processInstanceId) {
    this.processInstanceId = processInstanceId;
  }

  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = JsonNullable.<String>of(processInstanceId);
  }


  public TaskQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
    
    return this;
  }

  public TaskQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
    if (this.processInstanceIdIn == null || !this.processInstanceIdIn.isPresent()) {
      this.processInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceIdIn.get().add(processInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that belong to process instances with the given ids.
   * @return processInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceIdIn() {
        return processInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceIdIn_JsonNullable() {
    return processInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_ID_IN)
  public void setProcessInstanceIdIn_JsonNullable(JsonNullable<List<String>> processInstanceIdIn) {
    this.processInstanceIdIn = processInstanceIdIn;
  }

  public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
    this.processInstanceIdIn = JsonNullable.<List<String>>of(processInstanceIdIn);
  }


  public TaskQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to process instances with the given business key.
   * @return processInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKey() {
        return processInstanceBusinessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKey_JsonNullable() {
    return processInstanceBusinessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY)
  public void setProcessInstanceBusinessKey_JsonNullable(JsonNullable<String> processInstanceBusinessKey) {
    this.processInstanceBusinessKey = processInstanceBusinessKey;
  }

  public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = JsonNullable.<String>of(processInstanceBusinessKey);
  }


  public TaskQueryDto processInstanceBusinessKeyExpression(String processInstanceBusinessKeyExpression) {
    this.processInstanceBusinessKeyExpression = JsonNullable.<String>of(processInstanceBusinessKeyExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
   * @return processInstanceBusinessKeyExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKeyExpression() {
        return processInstanceBusinessKeyExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKeyExpression_JsonNullable() {
    return processInstanceBusinessKeyExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_EXPRESSION)
  public void setProcessInstanceBusinessKeyExpression_JsonNullable(JsonNullable<String> processInstanceBusinessKeyExpression) {
    this.processInstanceBusinessKeyExpression = processInstanceBusinessKeyExpression;
  }

  public void setProcessInstanceBusinessKeyExpression(String processInstanceBusinessKeyExpression) {
    this.processInstanceBusinessKeyExpression = JsonNullable.<String>of(processInstanceBusinessKeyExpression);
  }


  public TaskQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
    
    return this;
  }

  public TaskQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
    if (this.processInstanceBusinessKeyIn == null || !this.processInstanceBusinessKeyIn.isPresent()) {
      this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processInstanceBusinessKeyIn.get().add(processInstanceBusinessKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.
   * @return processInstanceBusinessKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessInstanceBusinessKeyIn() {
        return processInstanceBusinessKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessInstanceBusinessKeyIn_JsonNullable() {
    return processInstanceBusinessKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  public void setProcessInstanceBusinessKeyIn_JsonNullable(JsonNullable<List<String>> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
  }

  public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = JsonNullable.<List<String>>of(processInstanceBusinessKeyIn);
  }


  public TaskQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a process instance business key that has the parameter  value as a substring.
   * @return processInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKeyLike() {
        return processInstanceBusinessKeyLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKeyLike_JsonNullable() {
    return processInstanceBusinessKeyLike;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  public void setProcessInstanceBusinessKeyLike_JsonNullable(JsonNullable<String> processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
  }

  public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = JsonNullable.<String>of(processInstanceBusinessKeyLike);
  }


  public TaskQueryDto processInstanceBusinessKeyLikeExpression(String processInstanceBusinessKeyLikeExpression) {
    this.processInstanceBusinessKeyLikeExpression = JsonNullable.<String>of(processInstanceBusinessKeyLikeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return processInstanceBusinessKeyLikeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessInstanceBusinessKeyLikeExpression() {
        return processInstanceBusinessKeyLikeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessInstanceBusinessKeyLikeExpression_JsonNullable() {
    return processInstanceBusinessKeyLikeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_BUSINESS_KEY_LIKE_EXPRESSION)
  public void setProcessInstanceBusinessKeyLikeExpression_JsonNullable(JsonNullable<String> processInstanceBusinessKeyLikeExpression) {
    this.processInstanceBusinessKeyLikeExpression = processInstanceBusinessKeyLikeExpression;
  }

  public void setProcessInstanceBusinessKeyLikeExpression(String processInstanceBusinessKeyLikeExpression) {
    this.processInstanceBusinessKeyLikeExpression = JsonNullable.<String>of(processInstanceBusinessKeyLikeExpression);
  }


  public TaskQueryDto processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionId() {
        return processDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionId_JsonNullable() {
    return processDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  public void setProcessDefinitionId_JsonNullable(JsonNullable<String> processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = JsonNullable.<String>of(processDefinitionId);
  }


  public TaskQueryDto processDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionKey() {
        return processDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionKey_JsonNullable() {
    return processDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  public void setProcessDefinitionKey_JsonNullable(JsonNullable<String> processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = JsonNullable.<String>of(processDefinitionKey);
  }


  public TaskQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = JsonNullable.<List<String>>of(processDefinitionKeyIn);
    
    return this;
  }

  public TaskQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
    if (this.processDefinitionKeyIn == null || !this.processDefinitionKeyIn.isPresent()) {
      this.processDefinitionKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.processDefinitionKeyIn.get().add(processDefinitionKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.
   * @return processDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getProcessDefinitionKeyIn() {
        return processDefinitionKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getProcessDefinitionKeyIn_JsonNullable() {
    return processDefinitionKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY_IN)
  public void setProcessDefinitionKeyIn_JsonNullable(JsonNullable<List<String>> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = processDefinitionKeyIn;
  }

  public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = JsonNullable.<List<String>>of(processDefinitionKeyIn);
  }


  public TaskQueryDto processDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given name.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionName() {
        return processDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionName_JsonNullable() {
    return processDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  public void setProcessDefinitionName_JsonNullable(JsonNullable<String> processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = JsonNullable.<String>of(processDefinitionName);
  }


  public TaskQueryDto processDefinitionNameLike(String processDefinitionNameLike) {
    this.processDefinitionNameLike = JsonNullable.<String>of(processDefinitionNameLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a process definition name that has the parameter value as  a substring.
   * @return processDefinitionNameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getProcessDefinitionNameLike() {
        return processDefinitionNameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getProcessDefinitionNameLike_JsonNullable() {
    return processDefinitionNameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME_LIKE)
  public void setProcessDefinitionNameLike_JsonNullable(JsonNullable<String> processDefinitionNameLike) {
    this.processDefinitionNameLike = processDefinitionNameLike;
  }

  public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
    this.processDefinitionNameLike = JsonNullable.<String>of(processDefinitionNameLike);
  }


  public TaskQueryDto executionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to an execution with the given id.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getExecutionId() {
        return executionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getExecutionId_JsonNullable() {
    return executionId;
  }
  
  @JsonProperty(JSON_PROPERTY_EXECUTION_ID)
  public void setExecutionId_JsonNullable(JsonNullable<String> executionId) {
    this.executionId = executionId;
  }

  public void setExecutionId(String executionId) {
    this.executionId = JsonNullable.<String>of(executionId);
  }


  public TaskQueryDto caseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to case instances with the given id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceId() {
        return caseInstanceId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceId_JsonNullable() {
    return caseInstanceId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_ID)
  public void setCaseInstanceId_JsonNullable(JsonNullable<String> caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }

  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = JsonNullable.<String>of(caseInstanceId);
  }


  public TaskQueryDto caseInstanceBusinessKey(String caseInstanceBusinessKey) {
    this.caseInstanceBusinessKey = JsonNullable.<String>of(caseInstanceBusinessKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to case instances with the given business key.
   * @return caseInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceBusinessKey() {
        return caseInstanceBusinessKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceBusinessKey_JsonNullable() {
    return caseInstanceBusinessKey;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY)
  public void setCaseInstanceBusinessKey_JsonNullable(JsonNullable<String> caseInstanceBusinessKey) {
    this.caseInstanceBusinessKey = caseInstanceBusinessKey;
  }

  public void setCaseInstanceBusinessKey(String caseInstanceBusinessKey) {
    this.caseInstanceBusinessKey = JsonNullable.<String>of(caseInstanceBusinessKey);
  }


  public TaskQueryDto caseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
    this.caseInstanceBusinessKeyLike = JsonNullable.<String>of(caseInstanceBusinessKeyLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a case instance business key that has the parameter value  as a substring.
   * @return caseInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseInstanceBusinessKeyLike() {
        return caseInstanceBusinessKeyLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseInstanceBusinessKeyLike_JsonNullable() {
    return caseInstanceBusinessKeyLike;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_BUSINESS_KEY_LIKE)
  public void setCaseInstanceBusinessKeyLike_JsonNullable(JsonNullable<String> caseInstanceBusinessKeyLike) {
    this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
  }

  public void setCaseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
    this.caseInstanceBusinessKeyLike = JsonNullable.<String>of(caseInstanceBusinessKeyLike);
  }


  public TaskQueryDto caseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given id.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionId() {
        return caseDefinitionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionId_JsonNullable() {
    return caseDefinitionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_ID)
  public void setCaseDefinitionId_JsonNullable(JsonNullable<String> caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }

  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = JsonNullable.<String>of(caseDefinitionId);
  }


  public TaskQueryDto caseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given key.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionKey() {
        return caseDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionKey_JsonNullable() {
    return caseDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_KEY)
  public void setCaseDefinitionKey_JsonNullable(JsonNullable<String> caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }

  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = JsonNullable.<String>of(caseDefinitionKey);
  }


  public TaskQueryDto caseDefinitionName(String caseDefinitionName) {
    this.caseDefinitionName = JsonNullable.<String>of(caseDefinitionName);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given name.
   * @return caseDefinitionName
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionName() {
        return caseDefinitionName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionName_JsonNullable() {
    return caseDefinitionName;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME)
  public void setCaseDefinitionName_JsonNullable(JsonNullable<String> caseDefinitionName) {
    this.caseDefinitionName = caseDefinitionName;
  }

  public void setCaseDefinitionName(String caseDefinitionName) {
    this.caseDefinitionName = JsonNullable.<String>of(caseDefinitionName);
  }


  public TaskQueryDto caseDefinitionNameLike(String caseDefinitionNameLike) {
    this.caseDefinitionNameLike = JsonNullable.<String>of(caseDefinitionNameLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a case definition name that has the parameter value as a  substring.
   * @return caseDefinitionNameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseDefinitionNameLike() {
        return caseDefinitionNameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseDefinitionNameLike_JsonNullable() {
    return caseDefinitionNameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_DEFINITION_NAME_LIKE)
  public void setCaseDefinitionNameLike_JsonNullable(JsonNullable<String> caseDefinitionNameLike) {
    this.caseDefinitionNameLike = caseDefinitionNameLike;
  }

  public void setCaseDefinitionNameLike(String caseDefinitionNameLike) {
    this.caseDefinitionNameLike = JsonNullable.<String>of(caseDefinitionNameLike);
  }


  public TaskQueryDto caseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
    
    return this;
  }

   /**
   * Restrict to tasks that belong to a case execution with the given id.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCaseExecutionId() {
        return caseExecutionId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCaseExecutionId_JsonNullable() {
    return caseExecutionId;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_EXECUTION_ID)
  public void setCaseExecutionId_JsonNullable(JsonNullable<String> caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }

  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = JsonNullable.<String>of(caseExecutionId);
  }


  public TaskQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
    
    return this;
  }

  public TaskQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null || !this.activityInstanceIdIn.isPresent()) {
      this.activityInstanceIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.activityInstanceIdIn.get().add(activityInstanceIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks which belong to one of the passed and comma-separated activity  instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getActivityInstanceIdIn() {
        return activityInstanceIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getActivityInstanceIdIn_JsonNullable() {
    return activityInstanceIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVITY_INSTANCE_ID_IN)
  public void setActivityInstanceIdIn_JsonNullable(JsonNullable<List<String>> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }

  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = JsonNullable.<List<String>>of(activityInstanceIdIn);
  }


  public TaskQueryDto tenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
    
    return this;
  }

  public TaskQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null || !this.tenantIdIn.isPresent()) {
      this.tenantIdIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.tenantIdIn.get().add(tenantIdInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks which belong to one of the passed and comma-separated  tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTenantIdIn() {
        return tenantIdIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTenantIdIn_JsonNullable() {
    return tenantIdIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TENANT_ID_IN)
  public void setTenantIdIn_JsonNullable(JsonNullable<List<String>> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }

  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = JsonNullable.<List<String>>of(tenantIdIn);
  }


  public TaskQueryDto withoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
    
    return this;
  }

   /**
   * Only include tasks which belong to no tenant. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutTenantId() {
        return withoutTenantId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutTenantId_JsonNullable() {
    return withoutTenantId;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_TENANT_ID)
  public void setWithoutTenantId_JsonNullable(JsonNullable<Boolean> withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }

  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = JsonNullable.<Boolean>of(withoutTenantId);
  }


  public TaskQueryDto assignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
    
    return this;
  }

   /**
   * Restrict to tasks that the given user is assigned to.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssignee() {
        return assignee.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssignee_JsonNullable() {
    return assignee;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  public void setAssignee_JsonNullable(JsonNullable<String> assignee) {
    this.assignee = assignee;
  }

  public void setAssignee(String assignee) {
    this.assignee = JsonNullable.<String>of(assignee);
  }


  public TaskQueryDto assigneeExpression(String assigneeExpression) {
    this.assigneeExpression = JsonNullable.<String>of(assigneeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that the user described by the given expression is assigned to. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return assigneeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssigneeExpression() {
        return assigneeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssigneeExpression_JsonNullable() {
    return assigneeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE_EXPRESSION)
  public void setAssigneeExpression_JsonNullable(JsonNullable<String> assigneeExpression) {
    this.assigneeExpression = assigneeExpression;
  }

  public void setAssigneeExpression(String assigneeExpression) {
    this.assigneeExpression = JsonNullable.<String>of(assigneeExpression);
  }


  public TaskQueryDto assigneeLike(String assigneeLike) {
    this.assigneeLike = JsonNullable.<String>of(assigneeLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have an assignee that has the parameter  value as a substring.
   * @return assigneeLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssigneeLike() {
        return assigneeLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssigneeLike_JsonNullable() {
    return assigneeLike;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE_LIKE)
  public void setAssigneeLike_JsonNullable(JsonNullable<String> assigneeLike) {
    this.assigneeLike = assigneeLike;
  }

  public void setAssigneeLike(String assigneeLike) {
    this.assigneeLike = JsonNullable.<String>of(assigneeLike);
  }


  public TaskQueryDto assigneeLikeExpression(String assigneeLikeExpression) {
    this.assigneeLikeExpression = JsonNullable.<String>of(assigneeLikeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return assigneeLikeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getAssigneeLikeExpression() {
        return assigneeLikeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE_LIKE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAssigneeLikeExpression_JsonNullable() {
    return assigneeLikeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE_LIKE_EXPRESSION)
  public void setAssigneeLikeExpression_JsonNullable(JsonNullable<String> assigneeLikeExpression) {
    this.assigneeLikeExpression = assigneeLikeExpression;
  }

  public void setAssigneeLikeExpression(String assigneeLikeExpression) {
    this.assigneeLikeExpression = JsonNullable.<String>of(assigneeLikeExpression);
  }


  public TaskQueryDto assigneeIn(List<String> assigneeIn) {
    this.assigneeIn = JsonNullable.<List<String>>of(assigneeIn);
    
    return this;
  }

  public TaskQueryDto addAssigneeInItem(String assigneeInItem) {
    if (this.assigneeIn == null || !this.assigneeIn.isPresent()) {
      this.assigneeIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.assigneeIn.get().add(assigneeInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks which are assigned to one of the passed and comma-separated user ids.
   * @return assigneeIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getAssigneeIn() {
        return assigneeIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getAssigneeIn_JsonNullable() {
    return assigneeIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE_IN)
  public void setAssigneeIn_JsonNullable(JsonNullable<List<String>> assigneeIn) {
    this.assigneeIn = assigneeIn;
  }

  public void setAssigneeIn(List<String> assigneeIn) {
    this.assigneeIn = JsonNullable.<List<String>>of(assigneeIn);
  }


  public TaskQueryDto assigneeNotIn(List<String> assigneeNotIn) {
    this.assigneeNotIn = JsonNullable.<List<String>>of(assigneeNotIn);
    
    return this;
  }

  public TaskQueryDto addAssigneeNotInItem(String assigneeNotInItem) {
    if (this.assigneeNotIn == null || !this.assigneeNotIn.isPresent()) {
      this.assigneeNotIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.assigneeNotIn.get().add(assigneeNotInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Only include tasks which are not assigned to one of the passed and comma-separated user ids.
   * @return assigneeNotIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getAssigneeNotIn() {
        return assigneeNotIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNEE_NOT_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getAssigneeNotIn_JsonNullable() {
    return assigneeNotIn;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNEE_NOT_IN)
  public void setAssigneeNotIn_JsonNullable(JsonNullable<List<String>> assigneeNotIn) {
    this.assigneeNotIn = assigneeNotIn;
  }

  public void setAssigneeNotIn(List<String> assigneeNotIn) {
    this.assigneeNotIn = JsonNullable.<List<String>>of(assigneeNotIn);
  }


  public TaskQueryDto owner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
    
    return this;
  }

   /**
   * Restrict to tasks that the given user owns.
   * @return owner
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getOwner() {
        return owner.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOwner_JsonNullable() {
    return owner;
  }
  
  @JsonProperty(JSON_PROPERTY_OWNER)
  public void setOwner_JsonNullable(JsonNullable<String> owner) {
    this.owner = owner;
  }

  public void setOwner(String owner) {
    this.owner = JsonNullable.<String>of(owner);
  }


  public TaskQueryDto ownerExpression(String ownerExpression) {
    this.ownerExpression = JsonNullable.<String>of(ownerExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return ownerExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getOwnerExpression() {
        return ownerExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OWNER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getOwnerExpression_JsonNullable() {
    return ownerExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_OWNER_EXPRESSION)
  public void setOwnerExpression_JsonNullable(JsonNullable<String> ownerExpression) {
    this.ownerExpression = ownerExpression;
  }

  public void setOwnerExpression(String ownerExpression) {
    this.ownerExpression = JsonNullable.<String>of(ownerExpression);
  }


  public TaskQueryDto candidateGroup(String candidateGroup) {
    this.candidateGroup = JsonNullable.<String>of(candidateGroup);
    
    return this;
  }

   /**
   * Only include tasks that are offered to the given group.
   * @return candidateGroup
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCandidateGroup() {
        return candidateGroup.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCandidateGroup_JsonNullable() {
    return candidateGroup;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP)
  public void setCandidateGroup_JsonNullable(JsonNullable<String> candidateGroup) {
    this.candidateGroup = candidateGroup;
  }

  public void setCandidateGroup(String candidateGroup) {
    this.candidateGroup = JsonNullable.<String>of(candidateGroup);
  }


  public TaskQueryDto candidateGroupExpression(String candidateGroupExpression) {
    this.candidateGroupExpression = JsonNullable.<String>of(candidateGroupExpression);
    
    return this;
  }

   /**
   * Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return candidateGroupExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCandidateGroupExpression() {
        return candidateGroupExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCandidateGroupExpression_JsonNullable() {
    return candidateGroupExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP_EXPRESSION)
  public void setCandidateGroupExpression_JsonNullable(JsonNullable<String> candidateGroupExpression) {
    this.candidateGroupExpression = candidateGroupExpression;
  }

  public void setCandidateGroupExpression(String candidateGroupExpression) {
    this.candidateGroupExpression = JsonNullable.<String>of(candidateGroupExpression);
  }


  public TaskQueryDto candidateUser(String candidateUser) {
    this.candidateUser = JsonNullable.<String>of(candidateUser);
    
    return this;
  }

   /**
   * Only include tasks that are offered to the given user or to one of his groups.
   * @return candidateUser
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCandidateUser() {
        return candidateUser.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCandidateUser_JsonNullable() {
    return candidateUser;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER)
  public void setCandidateUser_JsonNullable(JsonNullable<String> candidateUser) {
    this.candidateUser = candidateUser;
  }

  public void setCandidateUser(String candidateUser) {
    this.candidateUser = JsonNullable.<String>of(candidateUser);
  }


  public TaskQueryDto candidateUserExpression(String candidateUserExpression) {
    this.candidateUserExpression = JsonNullable.<String>of(candidateUserExpression);
    
    return this;
  }

   /**
   * Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.
   * @return candidateUserExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCandidateUserExpression() {
        return candidateUserExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCandidateUserExpression_JsonNullable() {
    return candidateUserExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER_EXPRESSION)
  public void setCandidateUserExpression_JsonNullable(JsonNullable<String> candidateUserExpression) {
    this.candidateUserExpression = candidateUserExpression;
  }

  public void setCandidateUserExpression(String candidateUserExpression) {
    this.candidateUserExpression = JsonNullable.<String>of(candidateUserExpression);
  }


  public TaskQueryDto includeAssignedTasks(Boolean includeAssignedTasks) {
    this.includeAssignedTasks = JsonNullable.<Boolean>of(includeAssignedTasks);
    
    return this;
  }

   /**
   * Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).
   * @return includeAssignedTasks
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getIncludeAssignedTasks() {
        return includeAssignedTasks.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INCLUDE_ASSIGNED_TASKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getIncludeAssignedTasks_JsonNullable() {
    return includeAssignedTasks;
  }
  
  @JsonProperty(JSON_PROPERTY_INCLUDE_ASSIGNED_TASKS)
  public void setIncludeAssignedTasks_JsonNullable(JsonNullable<Boolean> includeAssignedTasks) {
    this.includeAssignedTasks = includeAssignedTasks;
  }

  public void setIncludeAssignedTasks(Boolean includeAssignedTasks) {
    this.includeAssignedTasks = JsonNullable.<Boolean>of(includeAssignedTasks);
  }


  public TaskQueryDto involvedUser(String involvedUser) {
    this.involvedUser = JsonNullable.<String>of(involvedUser);
    
    return this;
  }

   /**
   * Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).
   * @return involvedUser
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getInvolvedUser() {
        return involvedUser.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INVOLVED_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getInvolvedUser_JsonNullable() {
    return involvedUser;
  }
  
  @JsonProperty(JSON_PROPERTY_INVOLVED_USER)
  public void setInvolvedUser_JsonNullable(JsonNullable<String> involvedUser) {
    this.involvedUser = involvedUser;
  }

  public void setInvolvedUser(String involvedUser) {
    this.involvedUser = JsonNullable.<String>of(involvedUser);
  }


  public TaskQueryDto involvedUserExpression(String involvedUserExpression) {
    this.involvedUserExpression = JsonNullable.<String>of(involvedUserExpression);
    
    return this;
  }

   /**
   * Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.
   * @return involvedUserExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getInvolvedUserExpression() {
        return involvedUserExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_INVOLVED_USER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getInvolvedUserExpression_JsonNullable() {
    return involvedUserExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_INVOLVED_USER_EXPRESSION)
  public void setInvolvedUserExpression_JsonNullable(JsonNullable<String> involvedUserExpression) {
    this.involvedUserExpression = involvedUserExpression;
  }

  public void setInvolvedUserExpression(String involvedUserExpression) {
    this.involvedUserExpression = JsonNullable.<String>of(involvedUserExpression);
  }


  public TaskQueryDto assigned(Boolean assigned) {
    this.assigned = JsonNullable.<Boolean>of(assigned);
    
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned.
   * @return assigned
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getAssigned() {
        return assigned.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getAssigned_JsonNullable() {
    return assigned;
  }
  
  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  public void setAssigned_JsonNullable(JsonNullable<Boolean> assigned) {
    this.assigned = assigned;
  }

  public void setAssigned(Boolean assigned) {
    this.assigned = JsonNullable.<Boolean>of(assigned);
  }


  public TaskQueryDto unassigned(Boolean unassigned) {
    this.unassigned = JsonNullable.<Boolean>of(unassigned);
    
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned.
   * @return unassigned
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getUnassigned() {
        return unassigned.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UNASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getUnassigned_JsonNullable() {
    return unassigned;
  }
  
  @JsonProperty(JSON_PROPERTY_UNASSIGNED)
  public void setUnassigned_JsonNullable(JsonNullable<Boolean> unassigned) {
    this.unassigned = unassigned;
  }

  public void setUnassigned(Boolean unassigned) {
    this.unassigned = JsonNullable.<Boolean>of(unassigned);
  }


  public TaskQueryDto taskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDefinitionKey() {
        return taskDefinitionKey.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDefinitionKey_JsonNullable() {
    return taskDefinitionKey;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY)
  public void setTaskDefinitionKey_JsonNullable(JsonNullable<String> taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }

  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = JsonNullable.<String>of(taskDefinitionKey);
  }


  public TaskQueryDto taskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(taskDefinitionKeyIn);
    
    return this;
  }

  public TaskQueryDto addTaskDefinitionKeyInItem(String taskDefinitionKeyInItem) {
    if (this.taskDefinitionKeyIn == null || !this.taskDefinitionKeyIn.isPresent()) {
      this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.taskDefinitionKeyIn.get().add(taskDefinitionKeyInItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.
   * @return taskDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getTaskDefinitionKeyIn() {
        return taskDefinitionKeyIn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_IN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getTaskDefinitionKeyIn_JsonNullable() {
    return taskDefinitionKeyIn;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_IN)
  public void setTaskDefinitionKeyIn_JsonNullable(JsonNullable<List<String>> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = taskDefinitionKeyIn;
  }

  public void setTaskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = JsonNullable.<List<String>>of(taskDefinitionKeyIn);
  }


  public TaskQueryDto taskDefinitionKeyLike(String taskDefinitionKeyLike) {
    this.taskDefinitionKeyLike = JsonNullable.<String>of(taskDefinitionKeyLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a key that has the parameter value as a substring.
   * @return taskDefinitionKeyLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getTaskDefinitionKeyLike() {
        return taskDefinitionKeyLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaskDefinitionKeyLike_JsonNullable() {
    return taskDefinitionKeyLike;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_KEY_LIKE)
  public void setTaskDefinitionKeyLike_JsonNullable(JsonNullable<String> taskDefinitionKeyLike) {
    this.taskDefinitionKeyLike = taskDefinitionKeyLike;
  }

  public void setTaskDefinitionKeyLike(String taskDefinitionKeyLike) {
    this.taskDefinitionKeyLike = JsonNullable.<String>of(taskDefinitionKeyLike);
  }


  public TaskQueryDto name(String name) {
    this.name = JsonNullable.<String>of(name);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given name.
   * @return name
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getName() {
        return name.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getName_JsonNullable() {
    return name;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME)
  public void setName_JsonNullable(JsonNullable<String> name) {
    this.name = name;
  }

  public void setName(String name) {
    this.name = JsonNullable.<String>of(name);
  }


  public TaskQueryDto nameNotEqual(String nameNotEqual) {
    this.nameNotEqual = JsonNullable.<String>of(nameNotEqual);
    
    return this;
  }

   /**
   * Restrict to tasks that do not have the given name.
   * @return nameNotEqual
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getNameNotEqual() {
        return nameNotEqual.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME_NOT_EQUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNameNotEqual_JsonNullable() {
    return nameNotEqual;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME_NOT_EQUAL)
  public void setNameNotEqual_JsonNullable(JsonNullable<String> nameNotEqual) {
    this.nameNotEqual = nameNotEqual;
  }

  public void setNameNotEqual(String nameNotEqual) {
    this.nameNotEqual = JsonNullable.<String>of(nameNotEqual);
  }


  public TaskQueryDto nameLike(String nameLike) {
    this.nameLike = JsonNullable.<String>of(nameLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a name with the given parameter value as substring.
   * @return nameLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getNameLike() {
        return nameLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNameLike_JsonNullable() {
    return nameLike;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME_LIKE)
  public void setNameLike_JsonNullable(JsonNullable<String> nameLike) {
    this.nameLike = nameLike;
  }

  public void setNameLike(String nameLike) {
    this.nameLike = JsonNullable.<String>of(nameLike);
  }


  public TaskQueryDto nameNotLike(String nameNotLike) {
    this.nameNotLike = JsonNullable.<String>of(nameNotLike);
    
    return this;
  }

   /**
   * Restrict to tasks that do not have a name with the given parameter value as substring.
   * @return nameNotLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getNameNotLike() {
        return nameNotLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_NAME_NOT_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getNameNotLike_JsonNullable() {
    return nameNotLike;
  }
  
  @JsonProperty(JSON_PROPERTY_NAME_NOT_LIKE)
  public void setNameNotLike_JsonNullable(JsonNullable<String> nameNotLike) {
    this.nameNotLike = nameNotLike;
  }

  public void setNameNotLike(String nameNotLike) {
    this.nameNotLike = JsonNullable.<String>of(nameNotLike);
  }


  public TaskQueryDto description(String description) {
    this.description = JsonNullable.<String>of(description);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given description.
   * @return description
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDescription() {
        return description.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDescription_JsonNullable() {
    return description;
  }
  
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  public void setDescription_JsonNullable(JsonNullable<String> description) {
    this.description = description;
  }

  public void setDescription(String description) {
    this.description = JsonNullable.<String>of(description);
  }


  public TaskQueryDto descriptionLike(String descriptionLike) {
    this.descriptionLike = JsonNullable.<String>of(descriptionLike);
    
    return this;
  }

   /**
   * Restrict to tasks that have a description that has the parameter value as a substring.
   * @return descriptionLike
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDescriptionLike() {
        return descriptionLike.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DESCRIPTION_LIKE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDescriptionLike_JsonNullable() {
    return descriptionLike;
  }
  
  @JsonProperty(JSON_PROPERTY_DESCRIPTION_LIKE)
  public void setDescriptionLike_JsonNullable(JsonNullable<String> descriptionLike) {
    this.descriptionLike = descriptionLike;
  }

  public void setDescriptionLike(String descriptionLike) {
    this.descriptionLike = JsonNullable.<String>of(descriptionLike);
  }


  public TaskQueryDto priority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
    
    return this;
  }

   /**
   * Restrict to tasks that have the given priority.
   * @return priority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getPriority() {
        return priority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getPriority_JsonNullable() {
    return priority;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  public void setPriority_JsonNullable(JsonNullable<Integer> priority) {
    this.priority = priority;
  }

  public void setPriority(Integer priority) {
    this.priority = JsonNullable.<Integer>of(priority);
  }


  public TaskQueryDto maxPriority(Integer maxPriority) {
    this.maxPriority = JsonNullable.<Integer>of(maxPriority);
    
    return this;
  }

   /**
   * Restrict to tasks that have a lower or equal priority.
   * @return maxPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getMaxPriority() {
        return maxPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MAX_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getMaxPriority_JsonNullable() {
    return maxPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_MAX_PRIORITY)
  public void setMaxPriority_JsonNullable(JsonNullable<Integer> maxPriority) {
    this.maxPriority = maxPriority;
  }

  public void setMaxPriority(Integer maxPriority) {
    this.maxPriority = JsonNullable.<Integer>of(maxPriority);
  }


  public TaskQueryDto minPriority(Integer minPriority) {
    this.minPriority = JsonNullable.<Integer>of(minPriority);
    
    return this;
  }

   /**
   * Restrict to tasks that have a higher or equal priority.
   * @return minPriority
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Integer getMinPriority() {
        return minPriority.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MIN_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getMinPriority_JsonNullable() {
    return minPriority;
  }
  
  @JsonProperty(JSON_PROPERTY_MIN_PRIORITY)
  public void setMinPriority_JsonNullable(JsonNullable<Integer> minPriority) {
    this.minPriority = minPriority;
  }

  public void setMinPriority(Integer minPriority) {
    this.minPriority = JsonNullable.<Integer>of(minPriority);
  }


  public TaskQueryDto dueDate(OffsetDateTime dueDate) {
    this.dueDate = JsonNullable.<OffsetDateTime>of(dueDate);
    
    return this;
  }

   /**
   * Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.546+0200&#x60;.
   * @return dueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDueDate() {
        return dueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDueDate_JsonNullable() {
    return dueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  public void setDueDate_JsonNullable(JsonNullable<OffsetDateTime> dueDate) {
    this.dueDate = dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = JsonNullable.<OffsetDateTime>of(dueDate);
  }


  public TaskQueryDto dueDateExpression(String dueDateExpression) {
    this.dueDateExpression = JsonNullable.<String>of(dueDateExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that are due on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return dueDateExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDueDateExpression() {
        return dueDateExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_DATE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDueDateExpression_JsonNullable() {
    return dueDateExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_DATE_EXPRESSION)
  public void setDueDateExpression_JsonNullable(JsonNullable<String> dueDateExpression) {
    this.dueDateExpression = dueDateExpression;
  }

  public void setDueDateExpression(String dueDateExpression) {
    this.dueDateExpression = JsonNullable.<String>of(dueDateExpression);
  }


  public TaskQueryDto dueAfter(OffsetDateTime dueAfter) {
    this.dueAfter = JsonNullable.<OffsetDateTime>of(dueAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.435+0200&#x60;.
   * @return dueAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDueAfter() {
        return dueAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDueAfter_JsonNullable() {
    return dueAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_AFTER)
  public void setDueAfter_JsonNullable(JsonNullable<OffsetDateTime> dueAfter) {
    this.dueAfter = dueAfter;
  }

  public void setDueAfter(OffsetDateTime dueAfter) {
    this.dueAfter = JsonNullable.<OffsetDateTime>of(dueAfter);
  }


  public TaskQueryDto dueAfterExpression(String dueAfterExpression) {
    this.dueAfterExpression = JsonNullable.<String>of(dueAfterExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return dueAfterExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDueAfterExpression() {
        return dueAfterExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_AFTER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDueAfterExpression_JsonNullable() {
    return dueAfterExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_AFTER_EXPRESSION)
  public void setDueAfterExpression_JsonNullable(JsonNullable<String> dueAfterExpression) {
    this.dueAfterExpression = dueAfterExpression;
  }

  public void setDueAfterExpression(String dueAfterExpression) {
    this.dueAfterExpression = JsonNullable.<String>of(dueAfterExpression);
  }


  public TaskQueryDto dueBefore(OffsetDateTime dueBefore) {
    this.dueBefore = JsonNullable.<OffsetDateTime>of(dueBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.243+0200&#x60;.
   * @return dueBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDueBefore() {
        return dueBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDueBefore_JsonNullable() {
    return dueBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_BEFORE)
  public void setDueBefore_JsonNullable(JsonNullable<OffsetDateTime> dueBefore) {
    this.dueBefore = dueBefore;
  }

  public void setDueBefore(OffsetDateTime dueBefore) {
    this.dueBefore = JsonNullable.<OffsetDateTime>of(dueBefore);
  }


  public TaskQueryDto dueBeforeExpression(String dueBeforeExpression) {
    this.dueBeforeExpression = JsonNullable.<String>of(dueBeforeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return dueBeforeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getDueBeforeExpression() {
        return dueBeforeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DUE_BEFORE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDueBeforeExpression_JsonNullable() {
    return dueBeforeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_DUE_BEFORE_EXPRESSION)
  public void setDueBeforeExpression_JsonNullable(JsonNullable<String> dueBeforeExpression) {
    this.dueBeforeExpression = dueBeforeExpression;
  }

  public void setDueBeforeExpression(String dueBeforeExpression) {
    this.dueBeforeExpression = JsonNullable.<String>of(dueBeforeExpression);
  }


  public TaskQueryDto withoutDueDate(Boolean withoutDueDate) {
    this.withoutDueDate = JsonNullable.<Boolean>of(withoutDueDate);
    
    return this;
  }

   /**
   * Only include tasks which have no due date. Value may only be &#x60;true&#x60;,  as &#x60;false&#x60; is the default behavior.
   * @return withoutDueDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutDueDate() {
        return withoutDueDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutDueDate_JsonNullable() {
    return withoutDueDate;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_DUE_DATE)
  public void setWithoutDueDate_JsonNullable(JsonNullable<Boolean> withoutDueDate) {
    this.withoutDueDate = withoutDueDate;
  }

  public void setWithoutDueDate(Boolean withoutDueDate) {
    this.withoutDueDate = JsonNullable.<Boolean>of(withoutDueDate);
  }


  public TaskQueryDto followUpDate(OffsetDateTime followUpDate) {
    this.followUpDate = JsonNullable.<OffsetDateTime>of(followUpDate);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.342+0200&#x60;.
   * @return followUpDate
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFollowUpDate() {
        return followUpDate.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFollowUpDate_JsonNullable() {
    return followUpDate;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  public void setFollowUpDate_JsonNullable(JsonNullable<OffsetDateTime> followUpDate) {
    this.followUpDate = followUpDate;
  }

  public void setFollowUpDate(OffsetDateTime followUpDate) {
    this.followUpDate = JsonNullable.<OffsetDateTime>of(followUpDate);
  }


  public TaskQueryDto followUpDateExpression(String followUpDateExpression) {
    this.followUpDateExpression = JsonNullable.<String>of(followUpDateExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return followUpDateExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFollowUpDateExpression() {
        return followUpDateExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFollowUpDateExpression_JsonNullable() {
    return followUpDateExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE_EXPRESSION)
  public void setFollowUpDateExpression_JsonNullable(JsonNullable<String> followUpDateExpression) {
    this.followUpDateExpression = followUpDateExpression;
  }

  public void setFollowUpDateExpression(String followUpDateExpression) {
    this.followUpDateExpression = JsonNullable.<String>of(followUpDateExpression);
  }


  public TaskQueryDto followUpAfter(OffsetDateTime followUpAfter) {
    this.followUpAfter = JsonNullable.<OffsetDateTime>of(followUpAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.542+0200&#x60;.
   * @return followUpAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFollowUpAfter() {
        return followUpAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFollowUpAfter_JsonNullable() {
    return followUpAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_AFTER)
  public void setFollowUpAfter_JsonNullable(JsonNullable<OffsetDateTime> followUpAfter) {
    this.followUpAfter = followUpAfter;
  }

  public void setFollowUpAfter(OffsetDateTime followUpAfter) {
    this.followUpAfter = JsonNullable.<OffsetDateTime>of(followUpAfter);
  }


  public TaskQueryDto followUpAfterExpression(String followUpAfterExpression) {
    this.followUpAfterExpression = JsonNullable.<String>of(followUpAfterExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return followUpAfterExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFollowUpAfterExpression() {
        return followUpAfterExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_AFTER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFollowUpAfterExpression_JsonNullable() {
    return followUpAfterExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_AFTER_EXPRESSION)
  public void setFollowUpAfterExpression_JsonNullable(JsonNullable<String> followUpAfterExpression) {
    this.followUpAfterExpression = followUpAfterExpression;
  }

  public void setFollowUpAfterExpression(String followUpAfterExpression) {
    this.followUpAfterExpression = JsonNullable.<String>of(followUpAfterExpression);
  }


  public TaskQueryDto followUpBefore(String followUpBefore) {
    this.followUpBefore = JsonNullable.<String>of(followUpBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.234+0200&#x60;.
   * @return followUpBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFollowUpBefore() {
        return followUpBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFollowUpBefore_JsonNullable() {
    return followUpBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE)
  public void setFollowUpBefore_JsonNullable(JsonNullable<String> followUpBefore) {
    this.followUpBefore = followUpBefore;
  }

  public void setFollowUpBefore(String followUpBefore) {
    this.followUpBefore = JsonNullable.<String>of(followUpBefore);
  }


  public TaskQueryDto followUpBeforeExpression(String followUpBeforeExpression) {
    this.followUpBeforeExpression = JsonNullable.<String>of(followUpBeforeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return followUpBeforeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFollowUpBeforeExpression() {
        return followUpBeforeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFollowUpBeforeExpression_JsonNullable() {
    return followUpBeforeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_EXPRESSION)
  public void setFollowUpBeforeExpression_JsonNullable(JsonNullable<String> followUpBeforeExpression) {
    this.followUpBeforeExpression = followUpBeforeExpression;
  }

  public void setFollowUpBeforeExpression(String followUpBeforeExpression) {
    this.followUpBeforeExpression = JsonNullable.<String>of(followUpBeforeExpression);
  }


  public TaskQueryDto followUpBeforeOrNotExistent(OffsetDateTime followUpBeforeOrNotExistent) {
    this.followUpBeforeOrNotExistent = JsonNullable.<OffsetDateTime>of(followUpBeforeOrNotExistent);
    
    return this;
  }

   /**
   * Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.432+0200&#x60;. The typical use case is to query all &#x60;active&#x60; tasks for a user for a given date.
   * @return followUpBeforeOrNotExistent
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getFollowUpBeforeOrNotExistent() {
        return followUpBeforeOrNotExistent.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getFollowUpBeforeOrNotExistent_JsonNullable() {
    return followUpBeforeOrNotExistent;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT)
  public void setFollowUpBeforeOrNotExistent_JsonNullable(JsonNullable<OffsetDateTime> followUpBeforeOrNotExistent) {
    this.followUpBeforeOrNotExistent = followUpBeforeOrNotExistent;
  }

  public void setFollowUpBeforeOrNotExistent(OffsetDateTime followUpBeforeOrNotExistent) {
    this.followUpBeforeOrNotExistent = JsonNullable.<OffsetDateTime>of(followUpBeforeOrNotExistent);
  }


  public TaskQueryDto followUpBeforeOrNotExistentExpression(String followUpBeforeOrNotExistentExpression) {
    this.followUpBeforeOrNotExistentExpression = JsonNullable.<String>of(followUpBeforeOrNotExistentExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return followUpBeforeOrNotExistentExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getFollowUpBeforeOrNotExistentExpression() {
        return followUpBeforeOrNotExistentExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFollowUpBeforeOrNotExistentExpression_JsonNullable() {
    return followUpBeforeOrNotExistentExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT_EXPRESSION)
  public void setFollowUpBeforeOrNotExistentExpression_JsonNullable(JsonNullable<String> followUpBeforeOrNotExistentExpression) {
    this.followUpBeforeOrNotExistentExpression = followUpBeforeOrNotExistentExpression;
  }

  public void setFollowUpBeforeOrNotExistentExpression(String followUpBeforeOrNotExistentExpression) {
    this.followUpBeforeOrNotExistentExpression = JsonNullable.<String>of(followUpBeforeOrNotExistentExpression);
  }


  public TaskQueryDto createdOn(OffsetDateTime createdOn) {
    this.createdOn = JsonNullable.<OffsetDateTime>of(createdOn);
    
    return this;
  }

   /**
   * Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.324+0200&#x60;.
   * @return createdOn
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreatedOn() {
        return createdOn.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreatedOn_JsonNullable() {
    return createdOn;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_ON)
  public void setCreatedOn_JsonNullable(JsonNullable<OffsetDateTime> createdOn) {
    this.createdOn = createdOn;
  }

  public void setCreatedOn(OffsetDateTime createdOn) {
    this.createdOn = JsonNullable.<OffsetDateTime>of(createdOn);
  }


  public TaskQueryDto createdOnExpression(String createdOnExpression) {
    this.createdOnExpression = JsonNullable.<String>of(createdOnExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return createdOnExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCreatedOnExpression() {
        return createdOnExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_ON_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCreatedOnExpression_JsonNullable() {
    return createdOnExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_ON_EXPRESSION)
  public void setCreatedOnExpression_JsonNullable(JsonNullable<String> createdOnExpression) {
    this.createdOnExpression = createdOnExpression;
  }

  public void setCreatedOnExpression(String createdOnExpression) {
    this.createdOnExpression = JsonNullable.<String>of(createdOnExpression);
  }


  public TaskQueryDto createdAfter(OffsetDateTime createdAfter) {
    this.createdAfter = JsonNullable.<OffsetDateTime>of(createdAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.342+0200&#x60;.
   * @return createdAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreatedAfter() {
        return createdAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreatedAfter_JsonNullable() {
    return createdAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_AFTER)
  public void setCreatedAfter_JsonNullable(JsonNullable<OffsetDateTime> createdAfter) {
    this.createdAfter = createdAfter;
  }

  public void setCreatedAfter(OffsetDateTime createdAfter) {
    this.createdAfter = JsonNullable.<OffsetDateTime>of(createdAfter);
  }


  public TaskQueryDto createdAfterExpression(String createdAfterExpression) {
    this.createdAfterExpression = JsonNullable.<String>of(createdAfterExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return createdAfterExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCreatedAfterExpression() {
        return createdAfterExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_AFTER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCreatedAfterExpression_JsonNullable() {
    return createdAfterExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_AFTER_EXPRESSION)
  public void setCreatedAfterExpression_JsonNullable(JsonNullable<String> createdAfterExpression) {
    this.createdAfterExpression = createdAfterExpression;
  }

  public void setCreatedAfterExpression(String createdAfterExpression) {
    this.createdAfterExpression = JsonNullable.<String>of(createdAfterExpression);
  }


  public TaskQueryDto createdBefore(OffsetDateTime createdBefore) {
    this.createdBefore = JsonNullable.<OffsetDateTime>of(createdBefore);
    
    return this;
  }

   /**
   * Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.332+0200&#x60;.
   * @return createdBefore
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getCreatedBefore() {
        return createdBefore.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getCreatedBefore_JsonNullable() {
    return createdBefore;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_BEFORE)
  public void setCreatedBefore_JsonNullable(JsonNullable<OffsetDateTime> createdBefore) {
    this.createdBefore = createdBefore;
  }

  public void setCreatedBefore(OffsetDateTime createdBefore) {
    this.createdBefore = JsonNullable.<OffsetDateTime>of(createdBefore);
  }


  public TaskQueryDto createdBeforeExpression(String createdBeforeExpression) {
    this.createdBeforeExpression = JsonNullable.<String>of(createdBeforeExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return createdBeforeExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCreatedBeforeExpression() {
        return createdBeforeExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CREATED_BEFORE_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCreatedBeforeExpression_JsonNullable() {
    return createdBeforeExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CREATED_BEFORE_EXPRESSION)
  public void setCreatedBeforeExpression_JsonNullable(JsonNullable<String> createdBeforeExpression) {
    this.createdBeforeExpression = createdBeforeExpression;
  }

  public void setCreatedBeforeExpression(String createdBeforeExpression) {
    this.createdBeforeExpression = JsonNullable.<String>of(createdBeforeExpression);
  }


  public TaskQueryDto updatedAfter(OffsetDateTime updatedAfter) {
    this.updatedAfter = JsonNullable.<OffsetDateTime>of(updatedAfter);
    
    return this;
  }

   /**
   * Restrict to tasks that were updated after the given date. Every action that fires  a [task update event](https://docs.camunda.org/manual/7.21/user-guide/process-engine/delegation-code/#task-listener-event-lifecycle) is considered as updating the task. By [default](https://docs.camunda.org/manual/7.21/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.332+0200&#x60;.
   * @return updatedAfter
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getUpdatedAfter() {
        return updatedAfter.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATED_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getUpdatedAfter_JsonNullable() {
    return updatedAfter;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATED_AFTER)
  public void setUpdatedAfter_JsonNullable(JsonNullable<OffsetDateTime> updatedAfter) {
    this.updatedAfter = updatedAfter;
  }

  public void setUpdatedAfter(OffsetDateTime updatedAfter) {
    this.updatedAfter = JsonNullable.<OffsetDateTime>of(updatedAfter);
  }


  public TaskQueryDto updatedAfterExpression(String updatedAfterExpression) {
    this.updatedAfterExpression = JsonNullable.<String>of(updatedAfterExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that were updated after the date described by the given expression. Every action that fires  a [task update event](https://docs.camunda.org/manual/7.21/user-guide/process-engine/delegation-code/#task-listener-event-lifecycle) is considered as updating the task. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a &#x60;java.util.Date&#x60; or &#x60;org.joda.time.DateTime&#x60; object.
   * @return updatedAfterExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getUpdatedAfterExpression() {
        return updatedAfterExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_UPDATED_AFTER_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getUpdatedAfterExpression_JsonNullable() {
    return updatedAfterExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_UPDATED_AFTER_EXPRESSION)
  public void setUpdatedAfterExpression_JsonNullable(JsonNullable<String> updatedAfterExpression) {
    this.updatedAfterExpression = updatedAfterExpression;
  }

  public void setUpdatedAfterExpression(String updatedAfterExpression) {
    this.updatedAfterExpression = JsonNullable.<String>of(updatedAfterExpression);
  }


  public TaskQueryDto delegationState(DelegationStateEnum delegationState) {
    this.delegationState = JsonNullable.<DelegationStateEnum>of(delegationState);
    
    return this;
  }

   /**
   * Restrict to tasks that are in the given delegation state. Valid values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   * @return delegationState
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public DelegationStateEnum getDelegationState() {
        return delegationState.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELEGATION_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<DelegationStateEnum> getDelegationState_JsonNullable() {
    return delegationState;
  }
  
  @JsonProperty(JSON_PROPERTY_DELEGATION_STATE)
  public void setDelegationState_JsonNullable(JsonNullable<DelegationStateEnum> delegationState) {
    this.delegationState = delegationState;
  }

  public void setDelegationState(DelegationStateEnum delegationState) {
    this.delegationState = JsonNullable.<DelegationStateEnum>of(delegationState);
  }


  public TaskQueryDto candidateGroups(List<String> candidateGroups) {
    this.candidateGroups = JsonNullable.<List<String>>of(candidateGroups);
    
    return this;
  }

  public TaskQueryDto addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null || !this.candidateGroups.isPresent()) {
      this.candidateGroups = JsonNullable.<List<String>>of(new ArrayList<>());
    }
    try {
      this.candidateGroups.get().add(candidateGroupsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example &#x60;developers,support,sales&#x60;.
   * @return candidateGroups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<String> getCandidateGroups() {
        return candidateGroups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<String>> getCandidateGroups_JsonNullable() {
    return candidateGroups;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  public void setCandidateGroups_JsonNullable(JsonNullable<List<String>> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public void setCandidateGroups(List<String> candidateGroups) {
    this.candidateGroups = JsonNullable.<List<String>>of(candidateGroups);
  }


  public TaskQueryDto candidateGroupsExpression(String candidateGroupsExpression) {
    this.candidateGroupsExpression = JsonNullable.<String>of(candidateGroupsExpression);
    
    return this;
  }

   /**
   * Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to &#x60;java.util.List&#x60; of Strings.
   * @return candidateGroupsExpression
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getCandidateGroupsExpression() {
        return candidateGroupsExpression.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS_EXPRESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getCandidateGroupsExpression_JsonNullable() {
    return candidateGroupsExpression;
  }
  
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS_EXPRESSION)
  public void setCandidateGroupsExpression_JsonNullable(JsonNullable<String> candidateGroupsExpression) {
    this.candidateGroupsExpression = candidateGroupsExpression;
  }

  public void setCandidateGroupsExpression(String candidateGroupsExpression) {
    this.candidateGroupsExpression = JsonNullable.<String>of(candidateGroupsExpression);
  }


  public TaskQueryDto withCandidateGroups(Boolean withCandidateGroups) {
    this.withCandidateGroups = JsonNullable.<Boolean>of(withCandidateGroups);
    
    return this;
  }

   /**
   * Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withCandidateGroups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithCandidateGroups() {
        return withCandidateGroups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithCandidateGroups_JsonNullable() {
    return withCandidateGroups;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_GROUPS)
  public void setWithCandidateGroups_JsonNullable(JsonNullable<Boolean> withCandidateGroups) {
    this.withCandidateGroups = withCandidateGroups;
  }

  public void setWithCandidateGroups(Boolean withCandidateGroups) {
    this.withCandidateGroups = JsonNullable.<Boolean>of(withCandidateGroups);
  }


  public TaskQueryDto withoutCandidateGroups(Boolean withoutCandidateGroups) {
    this.withoutCandidateGroups = JsonNullable.<Boolean>of(withoutCandidateGroups);
    
    return this;
  }

   /**
   * Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutCandidateGroups
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutCandidateGroups() {
        return withoutCandidateGroups.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutCandidateGroups_JsonNullable() {
    return withoutCandidateGroups;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_GROUPS)
  public void setWithoutCandidateGroups_JsonNullable(JsonNullable<Boolean> withoutCandidateGroups) {
    this.withoutCandidateGroups = withoutCandidateGroups;
  }

  public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
    this.withoutCandidateGroups = JsonNullable.<Boolean>of(withoutCandidateGroups);
  }


  public TaskQueryDto withCandidateUsers(Boolean withCandidateUsers) {
    this.withCandidateUsers = JsonNullable.<Boolean>of(withCandidateUsers);
    
    return this;
  }

   /**
   * Only include tasks which have a candidate user. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withCandidateUsers
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithCandidateUsers() {
        return withCandidateUsers.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithCandidateUsers_JsonNullable() {
    return withCandidateUsers;
  }
  
  @JsonProperty(JSON_PROPERTY_WITH_CANDIDATE_USERS)
  public void setWithCandidateUsers_JsonNullable(JsonNullable<Boolean> withCandidateUsers) {
    this.withCandidateUsers = withCandidateUsers;
  }

  public void setWithCandidateUsers(Boolean withCandidateUsers) {
    this.withCandidateUsers = JsonNullable.<Boolean>of(withCandidateUsers);
  }


  public TaskQueryDto withoutCandidateUsers(Boolean withoutCandidateUsers) {
    this.withoutCandidateUsers = JsonNullable.<Boolean>of(withoutCandidateUsers);
    
    return this;
  }

   /**
   * Only include tasks which have no candidate users. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutCandidateUsers
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getWithoutCandidateUsers() {
        return withoutCandidateUsers.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getWithoutCandidateUsers_JsonNullable() {
    return withoutCandidateUsers;
  }
  
  @JsonProperty(JSON_PROPERTY_WITHOUT_CANDIDATE_USERS)
  public void setWithoutCandidateUsers_JsonNullable(JsonNullable<Boolean> withoutCandidateUsers) {
    this.withoutCandidateUsers = withoutCandidateUsers;
  }

  public void setWithoutCandidateUsers(Boolean withoutCandidateUsers) {
    this.withoutCandidateUsers = JsonNullable.<Boolean>of(withoutCandidateUsers);
  }


  public TaskQueryDto active(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
    
    return this;
  }

   /**
   * Only include active tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return active
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getActive() {
        return active.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getActive_JsonNullable() {
    return active;
  }
  
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  public void setActive_JsonNullable(JsonNullable<Boolean> active) {
    this.active = active;
  }

  public void setActive(Boolean active) {
    this.active = JsonNullable.<Boolean>of(active);
  }


  public TaskQueryDto suspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
    
    return this;
  }

   /**
   * Only include suspended tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getSuspended() {
        return suspended.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getSuspended_JsonNullable() {
    return suspended;
  }
  
  @JsonProperty(JSON_PROPERTY_SUSPENDED)
  public void setSuspended_JsonNullable(JsonNullable<Boolean> suspended) {
    this.suspended = suspended;
  }

  public void setSuspended(Boolean suspended) {
    this.suspended = JsonNullable.<Boolean>of(suspended);
  }


  public TaskQueryDto taskVariables(List<VariableQueryParameterDto> taskVariables) {
    this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(taskVariables);
    
    return this;
  }

  public TaskQueryDto addTaskVariablesItem(VariableQueryParameterDto taskVariablesItem) {
    if (this.taskVariables == null || !this.taskVariables.isPresent()) {
      this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.taskVariables.get().add(taskVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array to only include tasks that have variables with certain values. The array consists of JSON objects with three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be of type &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return taskVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getTaskVariables() {
        return taskVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getTaskVariables_JsonNullable() {
    return taskVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  public void setTaskVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> taskVariables) {
    this.taskVariables = taskVariables;
  }

  public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
    this.taskVariables = JsonNullable.<List<VariableQueryParameterDto>>of(taskVariables);
  }


  public TaskQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
    
    return this;
  }

  public TaskQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
    if (this.processVariables == null || !this.processVariables.isPresent()) {
      this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.processVariables.get().add(processVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array to only include tasks that belong to a process instance with variables with certain values. The array consists of JSON objects with three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be of type &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;; &#x60;notLike&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getProcessVariables() {
        return processVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getProcessVariables_JsonNullable() {
    return processVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_PROCESS_VARIABLES)
  public void setProcessVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> processVariables) {
    this.processVariables = processVariables;
  }

  public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = JsonNullable.<List<VariableQueryParameterDto>>of(processVariables);
  }


  public TaskQueryDto caseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
    this.caseInstanceVariables = JsonNullable.<List<VariableQueryParameterDto>>of(caseInstanceVariables);
    
    return this;
  }

  public TaskQueryDto addCaseInstanceVariablesItem(VariableQueryParameterDto caseInstanceVariablesItem) {
    if (this.caseInstanceVariables == null || !this.caseInstanceVariables.isPresent()) {
      this.caseInstanceVariables = JsonNullable.<List<VariableQueryParameterDto>>of(new ArrayList<>());
    }
    try {
      this.caseInstanceVariables.get().add(caseInstanceVariablesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array to only include tasks that belong to a case instance with variables with certain values. The array consists of JSON objects with three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. &#x60;value&#x60; may be of type &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid &#x60;operator&#x60; values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return caseInstanceVariables
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<VariableQueryParameterDto> getCaseInstanceVariables() {
        return caseInstanceVariables.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<VariableQueryParameterDto>> getCaseInstanceVariables_JsonNullable() {
    return caseInstanceVariables;
  }
  
  @JsonProperty(JSON_PROPERTY_CASE_INSTANCE_VARIABLES)
  public void setCaseInstanceVariables_JsonNullable(JsonNullable<List<VariableQueryParameterDto>> caseInstanceVariables) {
    this.caseInstanceVariables = caseInstanceVariables;
  }

  public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
    this.caseInstanceVariables = JsonNullable.<List<VariableQueryParameterDto>>of(caseInstanceVariables);
  }


  public TaskQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable names in this query case-insensitively. If set &#x60;variableName&#x60; and &#x60;variablename&#x60; are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableNamesIgnoreCase() {
        return variableNamesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableNamesIgnoreCase_JsonNullable() {
    return variableNamesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_NAMES_IGNORE_CASE)
  public void setVariableNamesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }

  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = JsonNullable.<Boolean>of(variableNamesIgnoreCase);
  }


  public TaskQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
    
    return this;
  }

   /**
   * Match all variable values in this query case-insensitively. If set &#x60;variableValue&#x60; and &#x60;variablevalue&#x60; are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public Boolean getVariableValuesIgnoreCase() {
        return variableValuesIgnoreCase.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Boolean> getVariableValuesIgnoreCase_JsonNullable() {
    return variableValuesIgnoreCase;
  }
  
  @JsonProperty(JSON_PROPERTY_VARIABLE_VALUES_IGNORE_CASE)
  public void setVariableValuesIgnoreCase_JsonNullable(JsonNullable<Boolean> variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }

  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = JsonNullable.<Boolean>of(variableValuesIgnoreCase);
  }


  public TaskQueryDto parentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
    
    return this;
  }

   /**
   * Restrict query to all tasks that are sub tasks of the given task. Takes a task id.
   * @return parentTaskId
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public String getParentTaskId() {
        return parentTaskId.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getParentTaskId_JsonNullable() {
    return parentTaskId;
  }
  
  @JsonProperty(JSON_PROPERTY_PARENT_TASK_ID)
  public void setParentTaskId_JsonNullable(JsonNullable<String> parentTaskId) {
    this.parentTaskId = parentTaskId;
  }

  public void setParentTaskId(String parentTaskId) {
    this.parentTaskId = JsonNullable.<String>of(parentTaskId);
  }


  public TaskQueryDto orQueries(List<TaskQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<TaskQueryDto>>of(orQueries);
    
    return this;
  }

  public TaskQueryDto addOrQueriesItem(TaskQueryDto orQueriesItem) {
    if (this.orQueries == null || !this.orQueries.isPresent()) {
      this.orQueries = JsonNullable.<List<TaskQueryDto>>of(new ArrayList<>());
    }
    try {
      this.orQueries.get().add(orQueriesItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * A JSON array of nested task queries with OR semantics. A task matches a nested query if it fulfills *at least one* of the query&#39;s predicates. With multiple nested queries, a task must fulfill at least one predicate of *each* query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task query properties can be used except for: &#x60;sorting&#x60;, &#x60;withCandidateGroups&#x60;, &#x60;withoutCandidateGroups&#x60;, &#x60;withCandidateUsers&#x60;, &#x60;withoutCandidateUsers&#x60;  See the [User guide](https://docs.camunda.org/manual/7.21/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.
   * @return orQueries
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<TaskQueryDto> getOrQueries() {
        return orQueries.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<TaskQueryDto>> getOrQueries_JsonNullable() {
    return orQueries;
  }
  
  @JsonProperty(JSON_PROPERTY_OR_QUERIES)
  public void setOrQueries_JsonNullable(JsonNullable<List<TaskQueryDto>> orQueries) {
    this.orQueries = orQueries;
  }

  public void setOrQueries(List<TaskQueryDto> orQueries) {
    this.orQueries = JsonNullable.<List<TaskQueryDto>>of(orQueries);
  }


  public TaskQueryDto sorting(List<TaskQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<TaskQueryDtoSortingInner>>of(sorting);
    
    return this;
  }

  public TaskQueryDto addSortingItem(TaskQueryDtoSortingInner sortingItem) {
    if (this.sorting == null || !this.sorting.isPresent()) {
      this.sorting = JsonNullable.<List<TaskQueryDtoSortingInner>>of(new ArrayList<>());
    }
    try {
      this.sorting.get().add(sortingItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @JsonIgnore

  public List<TaskQueryDtoSortingInner> getSorting() {
        return sorting.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SORTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<TaskQueryDtoSortingInner>> getSorting_JsonNullable() {
    return sorting;
  }
  
  @JsonProperty(JSON_PROPERTY_SORTING)
  public void setSorting_JsonNullable(JsonNullable<List<TaskQueryDtoSortingInner>> sorting) {
    this.sorting = sorting;
  }

  public void setSorting(List<TaskQueryDtoSortingInner> sorting) {
    this.sorting = JsonNullable.<List<TaskQueryDtoSortingInner>>of(sorting);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskQueryDto taskQueryDto = (TaskQueryDto) o;
    return equalsNullable(this.taskId, taskQueryDto.taskId) &&
        equalsNullable(this.taskIdIn, taskQueryDto.taskIdIn) &&
        equalsNullable(this.processInstanceId, taskQueryDto.processInstanceId) &&
        equalsNullable(this.processInstanceIdIn, taskQueryDto.processInstanceIdIn) &&
        equalsNullable(this.processInstanceBusinessKey, taskQueryDto.processInstanceBusinessKey) &&
        equalsNullable(this.processInstanceBusinessKeyExpression, taskQueryDto.processInstanceBusinessKeyExpression) &&
        equalsNullable(this.processInstanceBusinessKeyIn, taskQueryDto.processInstanceBusinessKeyIn) &&
        equalsNullable(this.processInstanceBusinessKeyLike, taskQueryDto.processInstanceBusinessKeyLike) &&
        equalsNullable(this.processInstanceBusinessKeyLikeExpression, taskQueryDto.processInstanceBusinessKeyLikeExpression) &&
        equalsNullable(this.processDefinitionId, taskQueryDto.processDefinitionId) &&
        equalsNullable(this.processDefinitionKey, taskQueryDto.processDefinitionKey) &&
        equalsNullable(this.processDefinitionKeyIn, taskQueryDto.processDefinitionKeyIn) &&
        equalsNullable(this.processDefinitionName, taskQueryDto.processDefinitionName) &&
        equalsNullable(this.processDefinitionNameLike, taskQueryDto.processDefinitionNameLike) &&
        equalsNullable(this.executionId, taskQueryDto.executionId) &&
        equalsNullable(this.caseInstanceId, taskQueryDto.caseInstanceId) &&
        equalsNullable(this.caseInstanceBusinessKey, taskQueryDto.caseInstanceBusinessKey) &&
        equalsNullable(this.caseInstanceBusinessKeyLike, taskQueryDto.caseInstanceBusinessKeyLike) &&
        equalsNullable(this.caseDefinitionId, taskQueryDto.caseDefinitionId) &&
        equalsNullable(this.caseDefinitionKey, taskQueryDto.caseDefinitionKey) &&
        equalsNullable(this.caseDefinitionName, taskQueryDto.caseDefinitionName) &&
        equalsNullable(this.caseDefinitionNameLike, taskQueryDto.caseDefinitionNameLike) &&
        equalsNullable(this.caseExecutionId, taskQueryDto.caseExecutionId) &&
        equalsNullable(this.activityInstanceIdIn, taskQueryDto.activityInstanceIdIn) &&
        equalsNullable(this.tenantIdIn, taskQueryDto.tenantIdIn) &&
        equalsNullable(this.withoutTenantId, taskQueryDto.withoutTenantId) &&
        equalsNullable(this.assignee, taskQueryDto.assignee) &&
        equalsNullable(this.assigneeExpression, taskQueryDto.assigneeExpression) &&
        equalsNullable(this.assigneeLike, taskQueryDto.assigneeLike) &&
        equalsNullable(this.assigneeLikeExpression, taskQueryDto.assigneeLikeExpression) &&
        equalsNullable(this.assigneeIn, taskQueryDto.assigneeIn) &&
        equalsNullable(this.assigneeNotIn, taskQueryDto.assigneeNotIn) &&
        equalsNullable(this.owner, taskQueryDto.owner) &&
        equalsNullable(this.ownerExpression, taskQueryDto.ownerExpression) &&
        equalsNullable(this.candidateGroup, taskQueryDto.candidateGroup) &&
        equalsNullable(this.candidateGroupExpression, taskQueryDto.candidateGroupExpression) &&
        equalsNullable(this.candidateUser, taskQueryDto.candidateUser) &&
        equalsNullable(this.candidateUserExpression, taskQueryDto.candidateUserExpression) &&
        equalsNullable(this.includeAssignedTasks, taskQueryDto.includeAssignedTasks) &&
        equalsNullable(this.involvedUser, taskQueryDto.involvedUser) &&
        equalsNullable(this.involvedUserExpression, taskQueryDto.involvedUserExpression) &&
        equalsNullable(this.assigned, taskQueryDto.assigned) &&
        equalsNullable(this.unassigned, taskQueryDto.unassigned) &&
        equalsNullable(this.taskDefinitionKey, taskQueryDto.taskDefinitionKey) &&
        equalsNullable(this.taskDefinitionKeyIn, taskQueryDto.taskDefinitionKeyIn) &&
        equalsNullable(this.taskDefinitionKeyLike, taskQueryDto.taskDefinitionKeyLike) &&
        equalsNullable(this.name, taskQueryDto.name) &&
        equalsNullable(this.nameNotEqual, taskQueryDto.nameNotEqual) &&
        equalsNullable(this.nameLike, taskQueryDto.nameLike) &&
        equalsNullable(this.nameNotLike, taskQueryDto.nameNotLike) &&
        equalsNullable(this.description, taskQueryDto.description) &&
        equalsNullable(this.descriptionLike, taskQueryDto.descriptionLike) &&
        equalsNullable(this.priority, taskQueryDto.priority) &&
        equalsNullable(this.maxPriority, taskQueryDto.maxPriority) &&
        equalsNullable(this.minPriority, taskQueryDto.minPriority) &&
        equalsNullable(this.dueDate, taskQueryDto.dueDate) &&
        equalsNullable(this.dueDateExpression, taskQueryDto.dueDateExpression) &&
        equalsNullable(this.dueAfter, taskQueryDto.dueAfter) &&
        equalsNullable(this.dueAfterExpression, taskQueryDto.dueAfterExpression) &&
        equalsNullable(this.dueBefore, taskQueryDto.dueBefore) &&
        equalsNullable(this.dueBeforeExpression, taskQueryDto.dueBeforeExpression) &&
        equalsNullable(this.withoutDueDate, taskQueryDto.withoutDueDate) &&
        equalsNullable(this.followUpDate, taskQueryDto.followUpDate) &&
        equalsNullable(this.followUpDateExpression, taskQueryDto.followUpDateExpression) &&
        equalsNullable(this.followUpAfter, taskQueryDto.followUpAfter) &&
        equalsNullable(this.followUpAfterExpression, taskQueryDto.followUpAfterExpression) &&
        equalsNullable(this.followUpBefore, taskQueryDto.followUpBefore) &&
        equalsNullable(this.followUpBeforeExpression, taskQueryDto.followUpBeforeExpression) &&
        equalsNullable(this.followUpBeforeOrNotExistent, taskQueryDto.followUpBeforeOrNotExistent) &&
        equalsNullable(this.followUpBeforeOrNotExistentExpression, taskQueryDto.followUpBeforeOrNotExistentExpression) &&
        equalsNullable(this.createdOn, taskQueryDto.createdOn) &&
        equalsNullable(this.createdOnExpression, taskQueryDto.createdOnExpression) &&
        equalsNullable(this.createdAfter, taskQueryDto.createdAfter) &&
        equalsNullable(this.createdAfterExpression, taskQueryDto.createdAfterExpression) &&
        equalsNullable(this.createdBefore, taskQueryDto.createdBefore) &&
        equalsNullable(this.createdBeforeExpression, taskQueryDto.createdBeforeExpression) &&
        equalsNullable(this.updatedAfter, taskQueryDto.updatedAfter) &&
        equalsNullable(this.updatedAfterExpression, taskQueryDto.updatedAfterExpression) &&
        equalsNullable(this.delegationState, taskQueryDto.delegationState) &&
        equalsNullable(this.candidateGroups, taskQueryDto.candidateGroups) &&
        equalsNullable(this.candidateGroupsExpression, taskQueryDto.candidateGroupsExpression) &&
        equalsNullable(this.withCandidateGroups, taskQueryDto.withCandidateGroups) &&
        equalsNullable(this.withoutCandidateGroups, taskQueryDto.withoutCandidateGroups) &&
        equalsNullable(this.withCandidateUsers, taskQueryDto.withCandidateUsers) &&
        equalsNullable(this.withoutCandidateUsers, taskQueryDto.withoutCandidateUsers) &&
        equalsNullable(this.active, taskQueryDto.active) &&
        equalsNullable(this.suspended, taskQueryDto.suspended) &&
        equalsNullable(this.taskVariables, taskQueryDto.taskVariables) &&
        equalsNullable(this.processVariables, taskQueryDto.processVariables) &&
        equalsNullable(this.caseInstanceVariables, taskQueryDto.caseInstanceVariables) &&
        equalsNullable(this.variableNamesIgnoreCase, taskQueryDto.variableNamesIgnoreCase) &&
        equalsNullable(this.variableValuesIgnoreCase, taskQueryDto.variableValuesIgnoreCase) &&
        equalsNullable(this.parentTaskId, taskQueryDto.parentTaskId) &&
        equalsNullable(this.orQueries, taskQueryDto.orQueries) &&
        equalsNullable(this.sorting, taskQueryDto.sorting);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(taskId), hashCodeNullable(taskIdIn), hashCodeNullable(processInstanceId), hashCodeNullable(processInstanceIdIn), hashCodeNullable(processInstanceBusinessKey), hashCodeNullable(processInstanceBusinessKeyExpression), hashCodeNullable(processInstanceBusinessKeyIn), hashCodeNullable(processInstanceBusinessKeyLike), hashCodeNullable(processInstanceBusinessKeyLikeExpression), hashCodeNullable(processDefinitionId), hashCodeNullable(processDefinitionKey), hashCodeNullable(processDefinitionKeyIn), hashCodeNullable(processDefinitionName), hashCodeNullable(processDefinitionNameLike), hashCodeNullable(executionId), hashCodeNullable(caseInstanceId), hashCodeNullable(caseInstanceBusinessKey), hashCodeNullable(caseInstanceBusinessKeyLike), hashCodeNullable(caseDefinitionId), hashCodeNullable(caseDefinitionKey), hashCodeNullable(caseDefinitionName), hashCodeNullable(caseDefinitionNameLike), hashCodeNullable(caseExecutionId), hashCodeNullable(activityInstanceIdIn), hashCodeNullable(tenantIdIn), hashCodeNullable(withoutTenantId), hashCodeNullable(assignee), hashCodeNullable(assigneeExpression), hashCodeNullable(assigneeLike), hashCodeNullable(assigneeLikeExpression), hashCodeNullable(assigneeIn), hashCodeNullable(assigneeNotIn), hashCodeNullable(owner), hashCodeNullable(ownerExpression), hashCodeNullable(candidateGroup), hashCodeNullable(candidateGroupExpression), hashCodeNullable(candidateUser), hashCodeNullable(candidateUserExpression), hashCodeNullable(includeAssignedTasks), hashCodeNullable(involvedUser), hashCodeNullable(involvedUserExpression), hashCodeNullable(assigned), hashCodeNullable(unassigned), hashCodeNullable(taskDefinitionKey), hashCodeNullable(taskDefinitionKeyIn), hashCodeNullable(taskDefinitionKeyLike), hashCodeNullable(name), hashCodeNullable(nameNotEqual), hashCodeNullable(nameLike), hashCodeNullable(nameNotLike), hashCodeNullable(description), hashCodeNullable(descriptionLike), hashCodeNullable(priority), hashCodeNullable(maxPriority), hashCodeNullable(minPriority), hashCodeNullable(dueDate), hashCodeNullable(dueDateExpression), hashCodeNullable(dueAfter), hashCodeNullable(dueAfterExpression), hashCodeNullable(dueBefore), hashCodeNullable(dueBeforeExpression), hashCodeNullable(withoutDueDate), hashCodeNullable(followUpDate), hashCodeNullable(followUpDateExpression), hashCodeNullable(followUpAfter), hashCodeNullable(followUpAfterExpression), hashCodeNullable(followUpBefore), hashCodeNullable(followUpBeforeExpression), hashCodeNullable(followUpBeforeOrNotExistent), hashCodeNullable(followUpBeforeOrNotExistentExpression), hashCodeNullable(createdOn), hashCodeNullable(createdOnExpression), hashCodeNullable(createdAfter), hashCodeNullable(createdAfterExpression), hashCodeNullable(createdBefore), hashCodeNullable(createdBeforeExpression), hashCodeNullable(updatedAfter), hashCodeNullable(updatedAfterExpression), hashCodeNullable(delegationState), hashCodeNullable(candidateGroups), hashCodeNullable(candidateGroupsExpression), hashCodeNullable(withCandidateGroups), hashCodeNullable(withoutCandidateGroups), hashCodeNullable(withCandidateUsers), hashCodeNullable(withoutCandidateUsers), hashCodeNullable(active), hashCodeNullable(suspended), hashCodeNullable(taskVariables), hashCodeNullable(processVariables), hashCodeNullable(caseInstanceVariables), hashCodeNullable(variableNamesIgnoreCase), hashCodeNullable(variableValuesIgnoreCase), hashCodeNullable(parentTaskId), hashCodeNullable(orQueries), hashCodeNullable(sorting));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskQueryDto {\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    taskIdIn: ").append(toIndentedString(taskIdIn)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIdIn: ").append(toIndentedString(processInstanceIdIn)).append("\n");
    sb.append("    processInstanceBusinessKey: ").append(toIndentedString(processInstanceBusinessKey)).append("\n");
    sb.append("    processInstanceBusinessKeyExpression: ").append(toIndentedString(processInstanceBusinessKeyExpression)).append("\n");
    sb.append("    processInstanceBusinessKeyIn: ").append(toIndentedString(processInstanceBusinessKeyIn)).append("\n");
    sb.append("    processInstanceBusinessKeyLike: ").append(toIndentedString(processInstanceBusinessKeyLike)).append("\n");
    sb.append("    processInstanceBusinessKeyLikeExpression: ").append(toIndentedString(processInstanceBusinessKeyLikeExpression)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionKeyIn: ").append(toIndentedString(processDefinitionKeyIn)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionNameLike: ").append(toIndentedString(processDefinitionNameLike)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseInstanceBusinessKey: ").append(toIndentedString(caseInstanceBusinessKey)).append("\n");
    sb.append("    caseInstanceBusinessKeyLike: ").append(toIndentedString(caseInstanceBusinessKeyLike)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseDefinitionName: ").append(toIndentedString(caseDefinitionName)).append("\n");
    sb.append("    caseDefinitionNameLike: ").append(toIndentedString(caseDefinitionNameLike)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    assigneeExpression: ").append(toIndentedString(assigneeExpression)).append("\n");
    sb.append("    assigneeLike: ").append(toIndentedString(assigneeLike)).append("\n");
    sb.append("    assigneeLikeExpression: ").append(toIndentedString(assigneeLikeExpression)).append("\n");
    sb.append("    assigneeIn: ").append(toIndentedString(assigneeIn)).append("\n");
    sb.append("    assigneeNotIn: ").append(toIndentedString(assigneeNotIn)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    ownerExpression: ").append(toIndentedString(ownerExpression)).append("\n");
    sb.append("    candidateGroup: ").append(toIndentedString(candidateGroup)).append("\n");
    sb.append("    candidateGroupExpression: ").append(toIndentedString(candidateGroupExpression)).append("\n");
    sb.append("    candidateUser: ").append(toIndentedString(candidateUser)).append("\n");
    sb.append("    candidateUserExpression: ").append(toIndentedString(candidateUserExpression)).append("\n");
    sb.append("    includeAssignedTasks: ").append(toIndentedString(includeAssignedTasks)).append("\n");
    sb.append("    involvedUser: ").append(toIndentedString(involvedUser)).append("\n");
    sb.append("    involvedUserExpression: ").append(toIndentedString(involvedUserExpression)).append("\n");
    sb.append("    assigned: ").append(toIndentedString(assigned)).append("\n");
    sb.append("    unassigned: ").append(toIndentedString(unassigned)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    taskDefinitionKeyIn: ").append(toIndentedString(taskDefinitionKeyIn)).append("\n");
    sb.append("    taskDefinitionKeyLike: ").append(toIndentedString(taskDefinitionKeyLike)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nameNotEqual: ").append(toIndentedString(nameNotEqual)).append("\n");
    sb.append("    nameLike: ").append(toIndentedString(nameLike)).append("\n");
    sb.append("    nameNotLike: ").append(toIndentedString(nameNotLike)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    descriptionLike: ").append(toIndentedString(descriptionLike)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    maxPriority: ").append(toIndentedString(maxPriority)).append("\n");
    sb.append("    minPriority: ").append(toIndentedString(minPriority)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    dueDateExpression: ").append(toIndentedString(dueDateExpression)).append("\n");
    sb.append("    dueAfter: ").append(toIndentedString(dueAfter)).append("\n");
    sb.append("    dueAfterExpression: ").append(toIndentedString(dueAfterExpression)).append("\n");
    sb.append("    dueBefore: ").append(toIndentedString(dueBefore)).append("\n");
    sb.append("    dueBeforeExpression: ").append(toIndentedString(dueBeforeExpression)).append("\n");
    sb.append("    withoutDueDate: ").append(toIndentedString(withoutDueDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    followUpDateExpression: ").append(toIndentedString(followUpDateExpression)).append("\n");
    sb.append("    followUpAfter: ").append(toIndentedString(followUpAfter)).append("\n");
    sb.append("    followUpAfterExpression: ").append(toIndentedString(followUpAfterExpression)).append("\n");
    sb.append("    followUpBefore: ").append(toIndentedString(followUpBefore)).append("\n");
    sb.append("    followUpBeforeExpression: ").append(toIndentedString(followUpBeforeExpression)).append("\n");
    sb.append("    followUpBeforeOrNotExistent: ").append(toIndentedString(followUpBeforeOrNotExistent)).append("\n");
    sb.append("    followUpBeforeOrNotExistentExpression: ").append(toIndentedString(followUpBeforeOrNotExistentExpression)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    createdOnExpression: ").append(toIndentedString(createdOnExpression)).append("\n");
    sb.append("    createdAfter: ").append(toIndentedString(createdAfter)).append("\n");
    sb.append("    createdAfterExpression: ").append(toIndentedString(createdAfterExpression)).append("\n");
    sb.append("    createdBefore: ").append(toIndentedString(createdBefore)).append("\n");
    sb.append("    createdBeforeExpression: ").append(toIndentedString(createdBeforeExpression)).append("\n");
    sb.append("    updatedAfter: ").append(toIndentedString(updatedAfter)).append("\n");
    sb.append("    updatedAfterExpression: ").append(toIndentedString(updatedAfterExpression)).append("\n");
    sb.append("    delegationState: ").append(toIndentedString(delegationState)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    candidateGroupsExpression: ").append(toIndentedString(candidateGroupsExpression)).append("\n");
    sb.append("    withCandidateGroups: ").append(toIndentedString(withCandidateGroups)).append("\n");
    sb.append("    withoutCandidateGroups: ").append(toIndentedString(withoutCandidateGroups)).append("\n");
    sb.append("    withCandidateUsers: ").append(toIndentedString(withCandidateUsers)).append("\n");
    sb.append("    withoutCandidateUsers: ").append(toIndentedString(withoutCandidateUsers)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    taskVariables: ").append(toIndentedString(taskVariables)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    caseInstanceVariables: ").append(toIndentedString(caseInstanceVariables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    parentTaskId: ").append(toIndentedString(parentTaskId)).append("\n");
    sb.append("    orQueries: ").append(toIndentedString(orQueries)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `taskId` to the URL query string
    if (getTaskId() != null) {
      try {
        joiner.add(String.format("%staskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskIdIn` to the URL query string
    if (getTaskIdIn() != null) {
      for (int i = 0; i < getTaskIdIn().size(); i++) {
        try {
          joiner.add(String.format("%staskIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTaskIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceId` to the URL query string
    if (getProcessInstanceId() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceIdIn` to the URL query string
    if (getProcessInstanceIdIn() != null) {
      for (int i = 0; i < getProcessInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceBusinessKey` to the URL query string
    if (getProcessInstanceBusinessKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKeyExpression` to the URL query string
    if (getProcessInstanceBusinessKeyExpression() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKeyExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKeyIn` to the URL query string
    if (getProcessInstanceBusinessKeyIn() != null) {
      for (int i = 0; i < getProcessInstanceBusinessKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessInstanceBusinessKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processInstanceBusinessKeyLike` to the URL query string
    if (getProcessInstanceBusinessKeyLike() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKeyLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceBusinessKeyLikeExpression` to the URL query string
    if (getProcessInstanceBusinessKeyLikeExpression() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceBusinessKeyLikeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceBusinessKeyLikeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKeyIn` to the URL query string
    if (getProcessDefinitionKeyIn() != null) {
      for (int i = 0; i < getProcessDefinitionKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%sprocessDefinitionKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getProcessDefinitionKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionNameLike` to the URL query string
    if (getProcessDefinitionNameLike() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionNameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `executionId` to the URL query string
    if (getExecutionId() != null) {
      try {
        joiner.add(String.format("%sexecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceId` to the URL query string
    if (getCaseInstanceId() != null) {
      try {
        joiner.add(String.format("%scaseInstanceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceBusinessKey` to the URL query string
    if (getCaseInstanceBusinessKey() != null) {
      try {
        joiner.add(String.format("%scaseInstanceBusinessKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceBusinessKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseInstanceBusinessKeyLike` to the URL query string
    if (getCaseInstanceBusinessKeyLike() != null) {
      try {
        joiner.add(String.format("%scaseInstanceBusinessKeyLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseInstanceBusinessKeyLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionId` to the URL query string
    if (getCaseDefinitionId() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionKey` to the URL query string
    if (getCaseDefinitionKey() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionName` to the URL query string
    if (getCaseDefinitionName() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseDefinitionNameLike` to the URL query string
    if (getCaseDefinitionNameLike() != null) {
      try {
        joiner.add(String.format("%scaseDefinitionNameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseDefinitionNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `caseExecutionId` to the URL query string
    if (getCaseExecutionId() != null) {
      try {
        joiner.add(String.format("%scaseExecutionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCaseExecutionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activityInstanceIdIn` to the URL query string
    if (getActivityInstanceIdIn() != null) {
      for (int i = 0; i < getActivityInstanceIdIn().size(); i++) {
        try {
          joiner.add(String.format("%sactivityInstanceIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getActivityInstanceIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantIdIn` to the URL query string
    if (getTenantIdIn() != null) {
      for (int i = 0; i < getTenantIdIn().size(); i++) {
        try {
          joiner.add(String.format("%stenantIdIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIdIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `withoutTenantId` to the URL query string
    if (getWithoutTenantId() != null) {
      try {
        joiner.add(String.format("%swithoutTenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigneeExpression` to the URL query string
    if (getAssigneeExpression() != null) {
      try {
        joiner.add(String.format("%sassigneeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigneeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigneeLike` to the URL query string
    if (getAssigneeLike() != null) {
      try {
        joiner.add(String.format("%sassigneeLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigneeLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigneeLikeExpression` to the URL query string
    if (getAssigneeLikeExpression() != null) {
      try {
        joiner.add(String.format("%sassigneeLikeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigneeLikeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigneeIn` to the URL query string
    if (getAssigneeIn() != null) {
      for (int i = 0; i < getAssigneeIn().size(); i++) {
        try {
          joiner.add(String.format("%sassigneeIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getAssigneeIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `assigneeNotIn` to the URL query string
    if (getAssigneeNotIn() != null) {
      for (int i = 0; i < getAssigneeNotIn().size(); i++) {
        try {
          joiner.add(String.format("%sassigneeNotIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getAssigneeNotIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `owner` to the URL query string
    if (getOwner() != null) {
      try {
        joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwner()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ownerExpression` to the URL query string
    if (getOwnerExpression() != null) {
      try {
        joiner.add(String.format("%sownerExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwnerExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateGroup` to the URL query string
    if (getCandidateGroup() != null) {
      try {
        joiner.add(String.format("%scandidateGroup%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateGroup()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateGroupExpression` to the URL query string
    if (getCandidateGroupExpression() != null) {
      try {
        joiner.add(String.format("%scandidateGroupExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateGroupExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateUser` to the URL query string
    if (getCandidateUser() != null) {
      try {
        joiner.add(String.format("%scandidateUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateUser()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateUserExpression` to the URL query string
    if (getCandidateUserExpression() != null) {
      try {
        joiner.add(String.format("%scandidateUserExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateUserExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `includeAssignedTasks` to the URL query string
    if (getIncludeAssignedTasks() != null) {
      try {
        joiner.add(String.format("%sincludeAssignedTasks%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncludeAssignedTasks()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `involvedUser` to the URL query string
    if (getInvolvedUser() != null) {
      try {
        joiner.add(String.format("%sinvolvedUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInvolvedUser()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `involvedUserExpression` to the URL query string
    if (getInvolvedUserExpression() != null) {
      try {
        joiner.add(String.format("%sinvolvedUserExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInvolvedUserExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigned` to the URL query string
    if (getAssigned() != null) {
      try {
        joiner.add(String.format("%sassigned%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigned()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unassigned` to the URL query string
    if (getUnassigned() != null) {
      try {
        joiner.add(String.format("%sunassigned%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnassigned()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKey` to the URL query string
    if (getTaskDefinitionKey() != null) {
      try {
        joiner.add(String.format("%staskDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskDefinitionKeyIn` to the URL query string
    if (getTaskDefinitionKeyIn() != null) {
      for (int i = 0; i < getTaskDefinitionKeyIn().size(); i++) {
        try {
          joiner.add(String.format("%staskDefinitionKeyIn%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTaskDefinitionKeyIn().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `taskDefinitionKeyLike` to the URL query string
    if (getTaskDefinitionKeyLike() != null) {
      try {
        joiner.add(String.format("%staskDefinitionKeyLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionKeyLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `nameNotEqual` to the URL query string
    if (getNameNotEqual() != null) {
      try {
        joiner.add(String.format("%snameNotEqual%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNameNotEqual()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `nameLike` to the URL query string
    if (getNameLike() != null) {
      try {
        joiner.add(String.format("%snameLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNameLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `nameNotLike` to the URL query string
    if (getNameNotLike() != null) {
      try {
        joiner.add(String.format("%snameNotLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNameNotLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `descriptionLike` to the URL query string
    if (getDescriptionLike() != null) {
      try {
        joiner.add(String.format("%sdescriptionLike%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescriptionLike()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      try {
        joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxPriority` to the URL query string
    if (getMaxPriority() != null) {
      try {
        joiner.add(String.format("%smaxPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `minPriority` to the URL query string
    if (getMinPriority() != null) {
      try {
        joiner.add(String.format("%sminPriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinPriority()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueDate` to the URL query string
    if (getDueDate() != null) {
      try {
        joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueDateExpression` to the URL query string
    if (getDueDateExpression() != null) {
      try {
        joiner.add(String.format("%sdueDateExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueDateExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueAfter` to the URL query string
    if (getDueAfter() != null) {
      try {
        joiner.add(String.format("%sdueAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueAfterExpression` to the URL query string
    if (getDueAfterExpression() != null) {
      try {
        joiner.add(String.format("%sdueAfterExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueAfterExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueBefore` to the URL query string
    if (getDueBefore() != null) {
      try {
        joiner.add(String.format("%sdueBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueBeforeExpression` to the URL query string
    if (getDueBeforeExpression() != null) {
      try {
        joiner.add(String.format("%sdueBeforeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueBeforeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutDueDate` to the URL query string
    if (getWithoutDueDate() != null) {
      try {
        joiner.add(String.format("%swithoutDueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutDueDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpDate` to the URL query string
    if (getFollowUpDate() != null) {
      try {
        joiner.add(String.format("%sfollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpDateExpression` to the URL query string
    if (getFollowUpDateExpression() != null) {
      try {
        joiner.add(String.format("%sfollowUpDateExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpDateExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpAfter` to the URL query string
    if (getFollowUpAfter() != null) {
      try {
        joiner.add(String.format("%sfollowUpAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpAfterExpression` to the URL query string
    if (getFollowUpAfterExpression() != null) {
      try {
        joiner.add(String.format("%sfollowUpAfterExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpAfterExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpBefore` to the URL query string
    if (getFollowUpBefore() != null) {
      try {
        joiner.add(String.format("%sfollowUpBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpBeforeExpression` to the URL query string
    if (getFollowUpBeforeExpression() != null) {
      try {
        joiner.add(String.format("%sfollowUpBeforeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpBeforeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpBeforeOrNotExistent` to the URL query string
    if (getFollowUpBeforeOrNotExistent() != null) {
      try {
        joiner.add(String.format("%sfollowUpBeforeOrNotExistent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpBeforeOrNotExistent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpBeforeOrNotExistentExpression` to the URL query string
    if (getFollowUpBeforeOrNotExistentExpression() != null) {
      try {
        joiner.add(String.format("%sfollowUpBeforeOrNotExistentExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFollowUpBeforeOrNotExistentExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdOn` to the URL query string
    if (getCreatedOn() != null) {
      try {
        joiner.add(String.format("%screatedOn%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedOn()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdOnExpression` to the URL query string
    if (getCreatedOnExpression() != null) {
      try {
        joiner.add(String.format("%screatedOnExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedOnExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAfter` to the URL query string
    if (getCreatedAfter() != null) {
      try {
        joiner.add(String.format("%screatedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAfterExpression` to the URL query string
    if (getCreatedAfterExpression() != null) {
      try {
        joiner.add(String.format("%screatedAfterExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAfterExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdBefore` to the URL query string
    if (getCreatedBefore() != null) {
      try {
        joiner.add(String.format("%screatedBefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdBeforeExpression` to the URL query string
    if (getCreatedBeforeExpression() != null) {
      try {
        joiner.add(String.format("%screatedBeforeExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedBeforeExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAfter` to the URL query string
    if (getUpdatedAfter() != null) {
      try {
        joiner.add(String.format("%supdatedAfter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAfterExpression` to the URL query string
    if (getUpdatedAfterExpression() != null) {
      try {
        joiner.add(String.format("%supdatedAfterExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAfterExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `delegationState` to the URL query string
    if (getDelegationState() != null) {
      try {
        joiner.add(String.format("%sdelegationState%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDelegationState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateGroups` to the URL query string
    if (getCandidateGroups() != null) {
      for (int i = 0; i < getCandidateGroups().size(); i++) {
        try {
          joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `candidateGroupsExpression` to the URL query string
    if (getCandidateGroupsExpression() != null) {
      try {
        joiner.add(String.format("%scandidateGroupsExpression%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateGroupsExpression()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withCandidateGroups` to the URL query string
    if (getWithCandidateGroups() != null) {
      try {
        joiner.add(String.format("%swithCandidateGroups%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithCandidateGroups()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutCandidateGroups` to the URL query string
    if (getWithoutCandidateGroups() != null) {
      try {
        joiner.add(String.format("%swithoutCandidateGroups%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutCandidateGroups()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withCandidateUsers` to the URL query string
    if (getWithCandidateUsers() != null) {
      try {
        joiner.add(String.format("%swithCandidateUsers%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithCandidateUsers()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `withoutCandidateUsers` to the URL query string
    if (getWithoutCandidateUsers() != null) {
      try {
        joiner.add(String.format("%swithoutCandidateUsers%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWithoutCandidateUsers()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `active` to the URL query string
    if (getActive() != null) {
      try {
        joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `suspended` to the URL query string
    if (getSuspended() != null) {
      try {
        joiner.add(String.format("%ssuspended%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSuspended()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskVariables` to the URL query string
    if (getTaskVariables() != null) {
      for (int i = 0; i < getTaskVariables().size(); i++) {
        if (getTaskVariables().get(i) != null) {
          joiner.add(getTaskVariables().get(i).toUrlQueryString(String.format("%staskVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `processVariables` to the URL query string
    if (getProcessVariables() != null) {
      for (int i = 0; i < getProcessVariables().size(); i++) {
        if (getProcessVariables().get(i) != null) {
          joiner.add(getProcessVariables().get(i).toUrlQueryString(String.format("%sprocessVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `caseInstanceVariables` to the URL query string
    if (getCaseInstanceVariables() != null) {
      for (int i = 0; i < getCaseInstanceVariables().size(); i++) {
        if (getCaseInstanceVariables().get(i) != null) {
          joiner.add(getCaseInstanceVariables().get(i).toUrlQueryString(String.format("%scaseInstanceVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `variableNamesIgnoreCase` to the URL query string
    if (getVariableNamesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableNamesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableNamesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variableValuesIgnoreCase` to the URL query string
    if (getVariableValuesIgnoreCase() != null) {
      try {
        joiner.add(String.format("%svariableValuesIgnoreCase%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVariableValuesIgnoreCase()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `parentTaskId` to the URL query string
    if (getParentTaskId() != null) {
      try {
        joiner.add(String.format("%sparentTaskId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentTaskId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `orQueries` to the URL query string
    if (getOrQueries() != null) {
      for (int i = 0; i < getOrQueries().size(); i++) {
        if (getOrQueries().get(i) != null) {
          joiner.add(getOrQueries().get(i).toUrlQueryString(String.format("%sorQueries%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `sorting` to the URL query string
    if (getSorting() != null) {
      for (int i = 0; i < getSorting().size(); i++) {
        if (getSorting().get(i) != null) {
          joiner.add(getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

